/*
	MergeTypes.h
*/

#ifndef __MERGETYPES__
#define __MERGETYPES__

#include "max.h"
#include "misc/llist.h"
#include "ConflictDlg.h"

// Material Flags
#define MATFLAG_NOMERGE				0x0001	// The material should not be merged (delete it)
#define MATFLAG_MERGEMULTI			0x0002  // The material should be merged into a multi sub-object
#define MATFLAG_MERGEMULTIMASTER	0x0004	// The material is the main node in a multi sub-object
#define MATFLAG_PROCESSED           0x0008	// Flag to indicate that this material has been processed

// Node Flags
#define NODEFLAG_NOMERGE    0x0001	// The node should not be merged (delete it)


// Structs
struct MatEntry
{
	CStr name;						// Name of this material (matches MAX without RENAME_PREFIX)
	Mtl* mtl;						// Pointer to the actual MAX mtl in the scene
	int  id;						// The material ID of this material
	int  flags;						// Used for tagging the material (on duplicate occurances)
	MatEntry* parent;				// Points to the parents material entry
	LinkList<MatEntry> submtls;		// List of sub materials under this one
	ResolveMode submode;			// If this is a MERGEMULTIMASTER then this Resolve mode is applied
									// to all of its submtls

	MatEntry()
	{
		mtl     = NULL;
		id      = 0;
		flags   = 0;
		parent  = NULL;
		submode = RESOLVE_UNDEFINED;
	}

	bool operator==(MatEntry& me)
	{
		if (name==me.name)
			return true;

		return false;
	}
};

struct NodeEntry
{
	CStr   name;					// Name of this node (matches MAX without RENAME_PREFIX)
	INode* node;					// Pointer to the actual MAX node in the scene
	ULONG  id;						// The ID of the node (needed to verify node existence)
	int    flags;					// Used for tagging the node (on duplicate occurances)

	NodeEntry()
	{
		node  = NULL;
		flags = 0;
	}

	bool operator==(NodeEntry& ne)
	{
		if (name==ne.name)
			return true;

		return false;
	}
};

#endif
