/*
	Merge.h
	A Utility plugin for performing better merges of materials and geom
*/

#ifndef __MERGEUTIL__
#define __MERGEUTIL__

#include "max.h"
#include "iparamb2.h"
#include "utilapi.h"
#include "MergeTypes.h"

#define vMERGETOOL_CLASS_ID   Class_ID(0x7bc60edb, 0x42dc2d87)

ClassDesc2* GetMergeToolDesc();

// External Dialogs
class MergeDlg;
class MatMergeList;
class NodeMergeList;
class ColorListBox;
class ScriptSelect;
class SliderNum;

class MergeTool: public UtilityObj
{
	Interface* ip;				// MAX Interface pointer
	IUtil*     iu;				// Utility object interface pointer

	int            nodeProg;
	int            numNodes;

	HWND		   hRollup;			// The rollup window
	MergeDlg*	   dlg;
	MatMergeList*  matListDlg;			// The material merge list dialog
	NodeMergeList* nodeListDlg;			// The node merge list dialog

	LinkList<MatEntry> matDB;			// Material database
	LinkList<NodeEntry> nodeDB;			// Node database

	LinkList<MatEntry> matDBmerge;		// Merged Material database
	LinkList<NodeEntry> nodeDBmerge;	// Merged Node database

	static int CALLBACK DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void SceneRenamePre(INode* root);	// Renames all the objects in the scene for preprocessing
	void SceneRenamePost(INode* root);	// Renames all the objects in the scene back to their intended values

	void MtlRenamePre();				// Renames all materials in the scene for preprocessing
	void MtlRenamePost();				// Renames all materials in the scene back to their intended values

	void BuildMtlMergeDB();
	void BuildMtlMergeDB(LinkList<NodeEntry>* list);
	void BuildSceneMergeDB();

	void GetAllNodes(INodeTab& nodes, INode* root);
	void GetAllNodes(INodeTab& nodes);

	void GetSelSetNodes(INodeTab& nodes);

	void DeleteAllMergedNodes();
	void DeleteAllMergedMtls();

	void ClearMatLibTest();

	int  NodeSceneCount(INode* root);

	bool NodeExists(INode* node,INode* root=NULL);
	bool MtlInScene(Mtl* mtl,INode* root=NULL);

	Mtl* FindMtl(char* name, INode* root=NULL);

	void GetNodeEntryNodes(LinkList<NodeEntry>* list,INodeTab& nodes);

public:
	MergeTool();
	~MergeTool();

	void BeginEditParams(Interface *ip,IUtil *iu);
	void EndEditParams(Interface *ip,IUtil *iu);
	void SelectionSetChanged(Interface *ip,IUtil *iu);
	void DeleteThis() { delete this; }
	void SetStartupParam(TSTR param) {}

	void ChooseFile();
	void DoMerge();
};

class MergeToolClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading) { return new MergeTool(); }
	const TCHAR *	ClassName() {return _T("NeverSoft Merge Tool"); }
	SClass_ID		SuperClassID() {return UTILITY_CLASS_ID;}
	Class_ID 		ClassID() {return vMERGETOOL_CLASS_ID;}
	const TCHAR* 	Category() {return _T("MergeTool");}
	const TCHAR*	InternalName() { return _T("MergeTool"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }			// returns owning module handle	
};

#endif
