/*
	FlagReassigner.h
	A utility plugin to store and reassign face channel data
*/

#ifndef __FLAGREASSIGNER__
#define __FLAGREASSIGNER__

#include "max.h"
#include "utilapi.h"
#include "iparamb2.h"
#include "FaceFlags/FaceFlags.h"
#include "FaceFlags/CASFlags.h"

#define vFLAGREASSIGNER_CLASS_ID   Class_ID(0x75af35dc, 0xf48051a)

class FlagReassigner: public UtilityObj
{
	Interface*		  ip;				// The main MAX interface pointer for the utility
	IUtil*			  iu;				// The utility interface pointer
	HWND			  hwndRollup;		// The rollup page being added

	FaceFlagsData	  fdata;			// Array of Face Flag data for each selected node
	CASFaceFlagsData  fdataCAS;			// Array of CAS Face Flag data for each selected node
	MtlID*			  mtlIDs;			// Array of mtlID lists for each selected node

	int               numSel;			// Number of selected nodes
	int               numFaces;			// Number of faces

	static BOOL CALLBACK DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void ClearData();
	void StoreFlagData();
	void ApplyFlagData();
	void SaveFlagData(INode* node);
	void LoadFlagData(INode* node);
	void DeleteFlagData(INode* node);

	void DebugFaces();

public:
	FlagReassigner();
	~FlagReassigner();

	virtual void BeginEditParams(Interface *ip,IUtil *iu);
	virtual void EndEditParams(Interface *ip,IUtil *iu);
	virtual void SelectionSetChanged(Interface *ip,IUtil *iu);
	virtual void DeleteThis() { delete this; }
};

class FlagReassignerClassDesc: public ClassDesc2 {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading) { return new FlagReassigner(); }
	const TCHAR *	ClassName() {return _T("NeverSoft Flag Reassignment Tool"); }
	SClass_ID		SuperClassID() {return UTILITY_CLASS_ID;}
	Class_ID 		ClassID() {return vFLAGREASSIGNER_CLASS_ID;}
	const TCHAR* 	Category() {return _T("FlagReassigner");}
	const TCHAR*	InternalName() { return _T("FlagReassigner"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }				// returns owning module handle	
};

#endif
