#ifndef __FACEFLAGS_H__
#define __FACEFLAGS_H__

#include "IDataChannel.h"
#include "ifacedatamgr.h"

#define vFACE_FLAGS_CHANNEL_ID	Class_ID(0x499a314b, 0x503c1e10)

typedef	__int64	FlagType;

enum
{
	mFD_SKATABLE			= 0x00000001,
	mFD_NOT_SKATABLE		= 0x00000002,
	mFD_WALL_RIDABLE		= 0x00000004,
	mFD_VERT				= 0x00000008,
	mFD_NON_COLLIDABLE		= 0x00000010,
	mFD_DECAL				= 0x00000020,
	mFD_TRIGGER				= 0x00000040,
	mFD_CAMERA_COLLIDABLE	= 0x00000080,
	mFD_NO_SKATER_SHADOW	= 0x00000100,
	mFD_SKATER_SHADOW		= 0x00000200,
	mFD_NO_SKATER_SHADOW_WALL=0x00000400,
	mFD_UNDER_OK			= 0x00000800,
	mFD_INVISIBLE			= 0x00001000,
	mFD_CASFACEFLAGSEXIST   = 0x00002000,	// To be backward compat with non - CAS Face flag versions
											// since versioning data isn't being exported
	mFD_PASS_1_DISABLED     = 0x00004000,	// Set only if pass 1 is turned off (so it defaults on for everything)
	mFD_PASS_2_ENABLED      = 0x00008000,
	mFD_PASS_3_ENABLED      = 0x00010000,
	mFD_PASS_4_ENABLED      = 0x00020000,
	mFD_RENDER_SEPARATE		= 0x00040000,
};

class FaceFlagsData : public IFaceDataChannel  
{
	public:
		// Our Storage Container

		Tab<FlagType> m_data;
		FaceFlagsData( ) 
		{ 
		};

		~FaceFlagsData( ) 
		{
		};
		
		// From IFaceDataChannel
		virtual BOOL FacesCreated( ULONG at, ULONG num ) ;
		BOOL FacesClonedAndAppended( BitArray& set ) ;
		BOOL FacesDeleted( BitArray& set ) ;
		BOOL FacesDeleted( ULONG from, ULONG num ) ;
		void AllFacesDeleted() ;
		BOOL FaceCopied( ULONG from, ULONG to ) ;
		BOOL FaceInterpolated( ULONG numSrc, ULONG* srcFaces,float* coeff, ULONG targetFace ); 


		IFaceDataChannel* CreateChannel( ) ;
		IFaceDataChannel* CloneChannel( ) ;
		BOOL AppendChannel( const IFaceDataChannel* fromChan ) ;

		//from IDataChannel
		
		Class_ID DataChannelID()const { return vFACE_FLAGS_CHANNEL_ID; }; 
		ULONG Count() const { return m_data.Count(); };

		void DeleteThis(){delete this;}; 

		// Simple data access
		BOOL GetValue( ULONG at, FlagType& val ) const;
		BOOL GetValue( BitArray& set, FlagType& mask, FlagType& diff );
		void SetValue( ULONG at, const FlagType& val );
		void SetValue( BitArray& set, const FlagType& val );
};

bool ValidFlagConfiguration( FlagType mask );

extern	Tab<FlagType> g_deleted_face_data;

#endif // __FACEFLAGS_H__