#ifndef __EXPORT_TEXTUREEXPORTER_H__
#define __EXPORT_TEXTUREEXPORTER_H__

#include <next.h>

class NxTexture;

class ITextureExporter
{
public:
	virtual	void	Reset( void ) = 0;
	virtual	bool	AddTexture( Texmap* map, int flags, unsigned long checksum_array[vNUM_PLATFORMS] ) = 0;
	virtual bool	LoadTextureData( void ) = 0;
	virtual bool	SaveTextureDictionary( char* dict_path, char* usg_path ) = 0;
	virtual bool    VerifyTexturePaths( char* path ) = 0;
	virtual NxTexture*	GetTextureByChecksum( unsigned long checksum ) = 0;		

	bool			m_WarnedAboutDupeMaterials;
	CStr            m_LastWarnedMatName;
};

ITextureExporter* GetTextureExporter( void );

#endif // __EXPORT_TEXTUREEXPORTER_H__