#include <next.h>
#include <appdata.h>
#include <Export/ExportOptions.h>
#include <Export/ModelExportOptions.h>

static INT_PTR CALLBACK ModelExportOptionsDlgProc(
		HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static ModelOptionsDlg *dlg = NULL;
	char   buf[256];

	switch(msg) 
	{
		case WM_INITDIALOG:
		{
			ModelExportOptions options;
			ICustEdit* model_name_ctrl;
			ICustEdit* model_dir_ctrl;
			
			dlg = (ModelOptionsDlg*) lParam;

			GetModelExportOptions( &options );		

			model_name_ctrl = GetICustEdit( GetDlgItem( hWnd, IDC_MODEL_NAME ));
			model_dir_ctrl  = GetICustEdit( GetDlgItem( hWnd, IDC_MODEL_DIR ));
			model_name_ctrl->SetText( options.m_ModelName );
			model_dir_ctrl->SetText( options.m_ModelDir );
			ReleaseICustEdit( model_name_ctrl );			
			ReleaseICustEdit( model_dir_ctrl );

			if( options.m_Optimized )
			{
				SendDlgItemMessage( hWnd, IDC_OPTIMIZE_GEOMETRY, BM_SETCHECK, BST_CHECKED, 0 );
			}			

			if( options.m_ExportQN )
			{
				SendDlgItemMessage( hWnd, IDC_EXPORTQN, BM_SETCHECK, BST_CHECKED, 0 );
			}

			if( options.m_DirWarn )
			{
				SendDlgItemMessage( hWnd, IDC_DIRWARN, BM_SETCHECK, BST_CHECKED, 0 );
			}

			if( options.m_ExportToSceneDir )
			{
				SendDlgItemMessage( hWnd, IDC_DUMPTOSCENE, BM_SETCHECK, BST_CHECKED, 0 );
			}

			if( options.m_IncSkelData )
			{
				SendDlgItemMessage( hWnd, IDC_INCSKELETON, BM_SETCHECK, BST_CHECKED, 0 );
			}

			if( options.m_FlipVerts )
			{
				SendDlgItemMessage( hWnd, IDC_FLIPVERTS, BM_SETCHECK, BST_CHECKED, 0 );
			}

			switch( options.m_ExportMode )
			{
			case ModelExportOptions::vEXPORT_ALL:
				// RETURN EXPORT OPTS: Check
				break;

			case ModelExportOptions::vEXPORT_VISIBLE:

				break;

			case ModelExportOptions::vEXPORT_SELECTION:

				break;

			case ModelExportOptions::vEXPORT_GROUP:

				break;
			}

			if (options.m_IncSkelData)
				EnableWindow(GetDlgItem(hWnd,IDC_FLIPVERTS),TRUE);
			else
				EnableWindow(GetDlgItem(hWnd,IDC_FLIPVERTS),FALSE);

			ShowWindow( hWnd, SW_SHOW );
			break;
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam)) 
			{
				case IDC_INCSKELETON:
					if (IsDlgButtonChecked(hWnd,IDC_INCSKELETON)==BST_CHECKED)
						EnableWindow(GetDlgItem(hWnd,IDC_FLIPVERTS),TRUE);
					else
						EnableWindow(GetDlgItem(hWnd,IDC_FLIPVERTS),FALSE);
					return TRUE;

				case IDOK:
				{
					ModelExportOptions options;
					ICustEdit* model_name_ctrl;
					ICustEdit* model_dir_ctrl;

					model_name_ctrl = GetICustEdit( GetDlgItem( hWnd, IDC_MODEL_NAME ));
					model_name_ctrl->GetText( buf, 255 );
					options.m_ModelName = buf;
					model_dir_ctrl = GetICustEdit( GetDlgItem( hWnd, IDC_MODEL_DIR ));
					model_dir_ctrl->GetText( buf, 255 );
					options.m_ModelDir = buf;
					ReleaseICustEdit( model_name_ctrl );
					ReleaseICustEdit( model_dir_ctrl );

					options.m_Optimized        = SendDlgItemMessage( hWnd, IDC_OPTIMIZE_GEOMETRY, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_ExportQN         = SendDlgItemMessage( hWnd, IDC_EXPORTQN, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_DirWarn          = SendDlgItemMessage( hWnd, IDC_DIRWARN, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_ExportToSceneDir = SendDlgItemMessage( hWnd, IDC_DUMPTOSCENE, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_IncSkelData      = SendDlgItemMessage( hWnd, IDC_INCSKELETON, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_FlipVerts        = SendDlgItemMessage( hWnd, IDC_FLIPVERTS, BM_GETCHECK, 0, 0 ) == BST_CHECKED;

					SetModelExportOptions( &options );
					DestroyModelOptionsDialog();
					break;
				}
				case IDCANCEL:
				{					
					DestroyModelOptionsDialog();
					break;
				}				
				default:
					break;
			}
			break;
		}		
		default:
			return FALSE;
	}
	return TRUE;
}

void	ModelOptionsDlg::Show( void )
{
	m_wnd = CreateDialogParam(
		hInstance,
		MAKEINTRESOURCE(IDD_MODEL_EXPORT_OPTIONS),
		gInterface->GetMAXHWnd(),
		ModelExportOptionsDlgProc,
		(LPARAM)this);	
	TSTR title = "Model Options";
	SetWindowText( m_wnd, title );
	gInterface->RegisterDlgWnd( m_wnd );
}

void	ModelOptionsDlg::Hide( void )
{
	gInterface->UnRegisterDlgWnd( m_wnd );
	DestroyWindow( m_wnd );	
}

void GetModelExportOptions( ModelExportOptions* options )
{
	char* options_data;
	ReferenceTarget *scene = gInterface->GetScenePointer();
	AppDataChunk* pad = scene->GetAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_MODEL_EXPORT_OPTIONS_ID );

	// Return the export options if they exist
	if( pad && pad->data )
	{
		int version;

		options_data = (char *) pad->data;
		version = *options_data;
		//if( version != ModelExportOptions::vVERSION_NUMBER )
		if ( version < 0x0002)
		{
			// for now, don't be backward compatible. This will force the dialog
			// to use the default values
			scene->RemoveAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_MODEL_EXPORT_OPTIONS_ID );			
		}
		else
		{
			char model_name[ModelExportOptions::vMAX_LENGTH_MODEL_NAME];
			char model_dir[ModelExportOptions::vMAX_LENGTH_DIR_NAME];
			
			memcpy( &options->m_Version, options_data, sizeof( int ));
			options_data += sizeof( int );
			memcpy( &options->m_Optimized, options_data, sizeof( bool ));
			options_data += sizeof( bool );
			memcpy( model_name, options_data, ModelExportOptions::vMAX_LENGTH_MODEL_NAME );
			options_data += ModelExportOptions::vMAX_LENGTH_MODEL_NAME;
			options->m_ModelName = model_name;
			memcpy( &options->m_ExportQN, options_data, sizeof( bool ));
			options_data += sizeof( bool );
			
			if (version >= 0x0003)
			{
				memcpy( &options->m_DirWarn, options_data, sizeof( bool ));
				options_data += sizeof( bool );
			}

			if (version >= 0x0004)
			{
				memcpy( &options->m_ExportToSceneDir, options_data, sizeof( bool ));
				options_data += sizeof( bool );
			}

			if (version >= 0x0005)
			{
				memcpy( model_dir, options_data, ModelExportOptions::vMAX_LENGTH_DIR_NAME );
				options_data += ModelExportOptions::vMAX_LENGTH_DIR_NAME;
				options->m_ModelDir = model_dir;
			}

			if (version >= 0x0006)
			{
				memcpy( &options->m_IncSkelData, options_data, sizeof( bool ));
				options_data += sizeof( bool );
			}

			if (version >= 0x0007)
			{
				memcpy( &options->m_FlipVerts, options_data, sizeof( bool ));
				options_data += sizeof( bool );
			}
		}
	}	
}

void SetModelExportOptions( ModelExportOptions* options )
{
	char model_name[ModelExportOptions::vMAX_LENGTH_MODEL_NAME];
	char model_dir[ModelExportOptions::vMAX_LENGTH_DIR_NAME];
	char* options_data;	
	AppDataChunk* pad;
	ReferenceTarget *scene;
	int version;

	assert( options );

	scene = gInterface->GetScenePointer();	
	pad = scene->GetAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_MODEL_EXPORT_OPTIONS_ID );

	if( pad )
	{
		// Old version needs thrown out first, since we require more space
		scene->RemoveAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_MODEL_EXPORT_OPTIONS_ID );

		options_data = (char*) pad->data;
	}

	// Yikes!  MAX uses a different memory manager must use malloc  aml
	//options_data = new char[GetSizeModelExportOptions()];
	options_data = (char*)malloc(GetSizeModelExportOptions());
	scene->AddAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_MODEL_EXPORT_OPTIONS_ID, 
		GetSizeModelExportOptions(), (void*) options_data );	

	version = ModelExportOptions::vVERSION_NUMBER;
	memcpy( options_data, &version, sizeof( int ));
	options_data += sizeof( int );
	memcpy( options_data, &options->m_Optimized, sizeof( bool ));
	options_data += sizeof( bool );
	strcpy( model_name, options->m_ModelName );
	memcpy( options_data, model_name, ModelExportOptions::vMAX_LENGTH_MODEL_NAME );
	options_data += ModelExportOptions::vMAX_LENGTH_MODEL_NAME;	
	memcpy( options_data, &options->m_ExportQN, sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_DirWarn, sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_ExportToSceneDir, sizeof( bool ));
	options_data += sizeof( bool );
	strcpy( model_dir, options->m_ModelDir );
	memcpy( options_data, model_dir, ModelExportOptions::vMAX_LENGTH_DIR_NAME );
	options_data += ModelExportOptions::vMAX_LENGTH_DIR_NAME;
	memcpy( options_data, &options->m_IncSkelData,sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_FlipVerts,sizeof( bool ));
	options_data += sizeof( bool );
}

int	GetSizeModelExportOptions( void )
{
	int size;

	size = 0;
	
	size += sizeof( int );	//	int		m_Version;
	size += sizeof( bool );	//	bool	m_Optimized;
	size += ModelExportOptions::vMAX_LENGTH_MODEL_NAME;	//	TSTR	m_ModelName;
	size += sizeof( bool );	//  bool    m_ExportQN
	size += sizeof( bool ); //  bool    m_DirWarn
	size += sizeof( bool ); //  bool    m_ExportToSceneDir
	size += ModelExportOptions::vMAX_LENGTH_DIR_NAME;	//  TSTR    m_ModelDir;
	size += sizeof( bool ); //  bool    m_IncSkelData
	size += sizeof( bool ); //  bool    m_FlipVerts

	return size;
}

ModelExportOptions::ModelExportOptions( void )
{
	m_Optimized        = true;	
	m_ModelName        = "default";
	m_ExportQN         = true;
	m_DirWarn          = true;
	m_ExportToSceneDir = false;
	m_ModelDir         = "";
	m_IncSkelData      = false;
	m_FlipVerts        = false;
}
