/*
	GenExport.h
	Generalized Animatable Exporter
	1-28-01
*/

#ifndef __GENEXPORTER__
#define __GENEXPORTER__

#include "max.h"
#include "tab.h"
#include "../PropEdit/ParseFuncs.h"

enum KeyType
{
	KEYTYPE_UNDEFINED,
	KEYTYPE_TCB,			// ITCBKey
	KEYTYPE_TCBFLOAT,		// ITCBFloatKey
	KEYTYPE_TCBPOINT3,		// ITCBPoint3Key
	KEYTYPE_TCBROT,			// ITCBRotKey
	KEYTYPE_TCBSCALE,		// ITCBScaleKey
	KEYTYPE_BEZFLOAT,		// IBezFloatKey
	KEYTYPE_BEZPOINT3,		// IBezPoint3Key
	KEYTYPE_BEZQUAT,	    // IBezQuatKey
	KEYTYPE_BEZSCALE,		// IBezScaleKey
	KEYTYPE_LINEARFLOAT,	// ILinFloatKey
	KEYTYPE_LINEARPOINT3,	// ILinPoint3Key
	KEYTYPE_LINEARROT,		// ILinRotKey
	KEYTYPE_LINEARSCALE,	// ILinScaleKey
};

enum ContType
{
	CONTTYPE_UNDEFINED,
	CONTTYPE_FLOAT,
	CONTTYPE_POINT3,
	CONTTYPE_POSITION,
	CONTTYPE_ROTATION,
	CONTTYPE_SCALE,
	CONTTYPE_TRANSFORM,
};

struct SearchKey
{
	// FORMAT: Ex: Transform/Position/Percent|Transform/Position/Bank Amount|Transform/Position/Smoothness

	Class_ID cid;			// The class we're scanning for export information from
	int      fps;			// Rate at which the data should be sampled (0 for actual keys)
	CStr animStr;			// A string containing the keyframed data we want extracted thru animatable interface
	CStr parmStr;			// A string containing the info to extract via the parameter block (unimplemented)

	ContType  conttype;  	// Type of control determines what type of keys to extract

	void AddExportAnim(CStr str);				// Adds an animatable export property
	int  NumProps();							// Returns the number of properties that are to be exported
	int  NumSubProps(int Index);				// Returns the number of subproperties to traverse for the given property
	CStr GetProp(int Index);					// Returns the property export path for given property index
	CStr GetSubProp(int Index,int SubIndex);	// Gets the specific subproperty for the given prop index/subprop index
};

enum InterpMode
{
	INTERP_LINEAR,
	INTERP_CUBIC,
	INTERP_QUAD,
};

template<class T>
struct GenKey
{
	float time;
	T     key;
};

struct KeySequence
{
	float time;
	void* keys;
};

struct ExportData
{
	int 				    ID;			// ID identifying the animation sequence in regards to the search key
	int					    numKeys;	// The number of MAX keyframes within this sequence
	ContType		        type;		// The type of key represented
	Tab< GenKey< void* > >  keys;		// Key framed data array  (ex. GenKey< type >

	ExportData()
	{
		ID=0;
		numKeys=0;
		type=CONTTYPE_UNDEFINED;
	}

	~ExportData();
};

struct ExportInfo
{
	INode*                node;			// The node we're exporting information from
	Tab<ExportData>       exportList;	// List of all the animation sequences that were exported
};

class GenExporter
{
	Interface* ip;
	Tab<SearchKey>  searchKeys;		// This contains a list of data to export
	Tab<ExportInfo> exportDB;

	bool ExportKeys(ExportInfo& expData,Object* obj,SearchKey& searchKey);
	void ExportNode(INode* node);
	void* MakeKey(ContType type);

	Animatable* FindAnimatable(Animatable* anim,CStr name);
	Control*    GetPBlockCont(Animatable* anim,CStr name);
	Control*    FindAnimCont(Animatable* anim,CStr name);
	void*       FindAnimProp(Animatable* anim,CStr name);

public:
	GenExporter(Interface* ip);//,Tab<ExportData>* ExpData);
	~GenExporter();

	void ClearSearchKeys();
	void ClearExportData();
	void AddSearchKey(SearchKey& skey);
	void GetKeyframes(Class_ID cid,char* keystr);
	bool GetPBlockVal(Animatable* anim,CStr name);

	Tab<ExportInfo>* Export();
};

template<class T>
bool GetKeyFrames(Interface* ip,Tab< GenKey<T> >* keys,SearchKey& skey);

#endif
