#ifndef __EXPORT_EXPORT_H__
#define __EXPORT_EXPORT_H__

#include <next.h>
#include <FaceFlags/FaceFlags.h>
#include <FaceFlags/CASFlags.h>
#include <fstream.h>

#define vVIEWER_APP_NAME		"skate4.elf"

#define	vTEX_GROUP_SIZE_CEILING	( 256 * 1024 )	// For now, texture groups should be no more than
												// 256k
#define vTRANS_TEX_GROUP_OFFSET	100				// Group id's for transparent texture groups
												// will be offset by this much
#define vSKY_TEX_GROUP_OFFSET	1000			// Sky group ids will be offset by 1000

#define vMAX_MATERIAL_PASSES	4

#define vMAX_WIBBLE_SEQUENCES	8

enum ExportType
{
	vQUICK_VIEW,	
	vQUICK_EXPORT,
	vRESET_AND_RELOAD,
	vSCRIPT_EXPORT,
	vCAM_EXPORT,		// aml
	vQUICK_UPDATE,
	vQUICK_UPDATE_NOTEX,
	vQUICK_VIEW_NOTEX,
	vRESET_AND_RELOAD_NOTEX,
	vQUICK_EXPORT_NOTEX,
	vOBJECT_EXPORT,
	vCAM_EXPORT_NOSCRIPTS,
	vSCRIPT_EXPORT_NOCAMS,
};

#define	vADC_ON		0
#define	vADC_OFF	0x00008000

#define vPSMCT32	0
#define vPSMCT24	1
#define vPSMCT16	2
#define vPSMT8		19
#define vPSMT4		20

enum
{
	// VERSION HISTORY
	// v5 texture width/height is saved out to file   aml

	vTEXTURE_VERSION_NUMBER	=	0x0005,
};


class Exporter
{
public:

	virtual bool	IsExportable( INode* node );	
	virtual	bool	SaveMaterials( fstream& file, class GeoDatabase* db );

	virtual bool	DoExport( ExportType type ) = 0;
	virtual bool	Save( void ) = 0;	

protected:

	ExportType			m_export_type;
};

class NxVertex
{
public:
	NxVertex( void );

	enum
	{
		vVERSION_NUMBER			=	0x0001,
		//vMAX_WEIGHTS_PER_VERTEX	=	6,
		vMAX_WEIGHTS_PER_VERTEX	=	4,
	};

	bool operator==( NxVertex& vertex );

	Point3	m_Pos;
	Point3	m_Normal;
	UVVert	m_TexCoord[vMAX_MATERIAL_PASSES];
	AColor	m_Color;
	int		m_WibbleIndex;
	int		m_WibbleOffset;
	int		m_Pass;
	int		m_FaceIndex;	// Used when remapping/optimizing vertex set	
	bool	m_Weighted;
	int		m_NumWeights;
	int		m_WeightedIndex[vMAX_WEIGHTS_PER_VERTEX];
	float	m_Weight[vMAX_WEIGHTS_PER_VERTEX];
};

class NxFace
{
public:
				NxFace( void );

	int			m_Vertex[3];	// Index into vert list
	Point3		m_Normal;
	unsigned long	m_MatChecksum;	// Checksum of material
	FlagType	m_FaceFlags;	
	int			m_Index;
	int			m_Pass;
	CASFlagType m_CASFaceFlags;
};

class NxMesh;

class NxLODLevel
{
public:
	enum
	{
		vVERSION_NUMBER =  0x0001
	};

				   NxLODLevel( void );

	float		   m_Distance;
	unsigned long  m_ObjectCRC;
};

class NxObject
{
public:
	enum
	{
		mTEXTURED			=	0x00000001,
		mCOLORED			=	0x00000002,
		mNORMALS			=	0x00000004,
		mINVISIBLE			=	0x00000008,		
		mSKINNED			=	0x00000010,
		mDYNAMIC			=	0x00000020,
		mOCCLUDER		    =   0x00000040,
		mHASCASREMOVEFLAGS  =   0x00000080,
		mPASS_BIT_1			=	0x00000100,
		mPASS_BIT_2			=	0x00000200,
		mNO_SHADOW			=	0x00000400,
		mVCWIBBLE			=	0x00000800,
		mRENDER_SEPARATE	=	0x00001000,		// Def'd in SceneConv
		mHASKBIAS           =   0x00002000,	
		mNO_SHADOW_WALL     =   0x00004000,		// From SceneConv
		mHASLODINFO			=   0x00008000,		// True if LOD info fields are included  aml
		mSKELETALMODEL      =   0x00010000,		// Model that contains skeletal info for procedural animation  aml  (Only valid in model export)

		mHASVERSIONINFO     =   0x80000000,		// Version info wasn't saved in original,  if included load version
												// field
	};

	// LOD Flags
	enum
	{
		mMASTER = 0x0001,					// This is the main instance of the object containing the LOD level info
		mSLAVE  = 0x0002,					// This object is an LOD level for the given Master object
	};

	enum
	{
		// Revision 5 starts version 1
		vVERSION_NUMBER	=	0x0001
	};

	NxObject( void );
	~NxObject( void );

	void			OptimizeVertList( void );
	void			Dump( void );	

	int				m_NumFaces;	
	NxFace*			m_Faces;
	int				m_NumVerts;
	NxVertex*		m_Verts;
	TSTR			m_Name;
	Box3			m_BoundingBox;
	int				m_Flags;	
	int				m_NumUVSets;
	unsigned long	m_SkeletonChecksum;
	int             m_CASRemoveFlags;
	float           m_KBias;				// New in r3, do not read if no mHASKBIAS flag set
	int             m_ParentMatrixIndex;	// Index into matrix array for transform of this object
											// if it's a modal that uses skeletal animation

	// LOD info ///////
	unsigned int    m_LODVersion;			// load only with mHASLODINFO      aml	
	int             m_LODFlags;				// load only with mHASLODINFO      aml
	
	struct LODMaster
	{
		int           m_NumLODLevels;		// load only with mHASLODINFO  aml
		NxLODLevel*   m_LODLevels;			// load only with mHASLODINFO  aml
	};

	struct LODSlave
	{
		unsigned long m_masterCRC;			// load only with mHASLODINFO  aml
	};

	union
	{
		LODMaster   m_LODMaster;
		LODSlave    m_LODSlave;
	};
	//////////

	unsigned int    m_Version;				// load only with mHASVERSIONINFO  aml (This is the object version)
	
	// Relative info
	int             m_ParentCRC;			// v1
	int             m_NumChildren;			// v1
	unsigned long*  m_ChildCRCs;			// v1
};

typedef enum
{
	vMAPPING_EXPLICIT,
	vMAPPING_ENVIRONMENT,
} MappingMode;

typedef enum
{
	vFILTERING_NEAREST,
	vFILTERING_LINEAR,
	vFILTERING_NEAREST_MIPMAP_NEAREST,
	vFILTERING_NEAREST_MIPMAP_LINEAR,
	vFILTERING_LINEAR_MIPMAP_NEAREST,
	vFILTERING_LINEAR_MIPMAP_LINEAR
} FilteringMode;    

class NxMaterialPass
{
public:
	enum
	{
		COLOR_LOCKED = 0x0001,
		UNLIT        = 0x0002,
	};
	
					NxMaterialPass( void );
	
	unsigned long	m_TexChecksum[vNUM_PLATFORMS];
	int				m_BlendMode;
	int				m_FixedAlpha;
	MappingMode		m_MappingMode;		// Explicit or procedural (eg. environment-mapping)	
	FilteringMode	m_MinFilteringMode;	// Point/Bi-linear
	FilteringMode	m_MagFilteringMode;	// Point/Bi-linear/Tri-linear
	bool			m_UVWibbleEnabled;		
	float			m_UVel;
	float			m_VVel;	
	float			m_UAmplitude;
	float			m_VAmplitude;
	float			m_UPhase;
	float			m_VPhase;
	float			m_UFrequency;
	float			m_VFrequency;
	AColor			m_Color;
	AColor			m_Ambient;
	AColor			m_Diffuse;
	AColor			m_Specular;
	float			m_MipMapK;	
	int				m_AddressModeU;
	int				m_AddressModeV;
	bool            m_HasColor;			// aml
	unsigned long   m_Flags;			// aml
};


class WibbleKeyframe
{
public:
	AColor	m_Color;
	int		m_Time;
};

class VCWibbleSequence
{
public:
	int				m_NumFrames;
	WibbleKeyframe	*m_WibbleFrames;
};

class NxMaterial
{
public:
	
	enum
	{
		mUV_WIBBLE		= 0x0001,
		mVC_WIBBLE		= 0x0002,
		mTEXTURED		= 0x0004,
		mENVIRONMENT	= 0x0008,
		mDECAL			= 0x0010,
		mSMOOTH			= 0x0020,
		mTRANSPARENT	= 0x0040,
		mONE_SIDED		= 0x0080,
		mINVISIBLE		= 0x0100,
		mTWO_SIDED      = 0x0200,		// aml
	};

	enum
	{
		vADDRESS_MODE_REPEAT,
		vADDRESS_MODE_CLAMP,
	};	

	enum
	{
		vCUTOFF_NOUPDATE,
		vCUTOFF_UPDATEFRAMEBUFFER,
	};

	// VERSION HISTORY
	// v3 for non active colors  aml
	// v4 for m_Sorted and m_DrawOrder
	// v5 for m_CutoffFunc
	// v6 for m_TwoSided
	// v7 expanded m_Name to 256 bytes (it appears as though we were getting some buffer overruns)
	// v8 Added m_grassify
	// v9 Added m_grassHeight, m_grassLayers
	// v10 Added m_Flags to NxMaterialPass

	enum
	{
		vVERSION_NUMBER	=	0x000A,		
	};

					NxMaterial( void );

	bool			operator == ( NxMaterial& material );
	
	unsigned long	GetCRC( void );

	char            m_Name[256];	// up'd from 64 bytes (buffer overruns) aml
	Mtl*			m_MaxMtl;
	unsigned long	m_Checksum;
	bool			m_Transparent;	
	int				m_NumPasses;
	int				m_AlphaCutoff;
	int				m_Terrain;
	bool			m_WarnedAlready;
	bool			m_OneSided;
	bool            m_TwoSided;
	bool			m_Invisible;
	float			m_DrawOrder;
	bool			m_Sorted;
	int             m_CutoffFunc;	
	bool            m_grassify;
	float           m_grassHeight;
	int             m_grassLayers;
	int				m_NumWibbleSequences;
	VCWibbleSequence m_WibbleSequences[vMAX_WIBBLE_SEQUENCES];

	NxMaterialPass	m_Passes[vMAX_MATERIAL_PASSES];
};

class NxMeshGroup
{
public:
	NxMeshGroup( void );

	int				m_TextureGroup;
	Tab< NxMesh* >	m_MeshList;
};

// Linked list of vertex normals
class VNormal 
{
public:
	Point3 norm;
	DWORD smooth;
	VNormal *next;
	BOOL init;

	VNormal() {smooth=0;next=NULL;init=FALSE;norm=Point3(0,0,0);}
	VNormal(Point3 &n,DWORD s) {next=NULL;init=TRUE;norm=n;smooth=s;}
	~VNormal() {delete next;}
	void AddNormal(Point3 &n,DWORD s);
	Point3 &GetNormal(DWORD s);
	void Normalize();
};

class GeoDatabase
{
	bool                bWarnedDiffuse;			// True if user was warned of exporting a 2nd+ pass diffuse texture

	void                UpdateFaceUVs( INode* node, NxObject* object );
	bool                GetExtents(INode* node, Matrix3 tm, Point3& min, Point3& max);
	int                 TranslateCASRemovalFlags(char* str);
	FlagType            AdjustPassFlag( Mtl* mtl, Mesh* mesh, int index);
	void                RemapPass(int* passList, FlagType origFlags, FlagType& newFlags, FlagType testFlag, int ID);

public:						
	enum
	{
		LOCAL_COORDS = 0x0001,
		SKEL_EXPORT  = 0x0002,
		FLIP_VERTS   = 0x0004,
		OFFSET_PIVOT = 0x0008,
	};

						GeoDatabase( void );
						~GeoDatabase( void );

	unsigned long		AddMaterial( Mtl* material, bool& env_mapped, char* preText="" );	
	NxMaterial*			GetMaterialByChecksum( unsigned long checksum );
	//NxObject*			CreateObjectFromNode( INode* node, float scale = 1.0f, bool bLocalCoords=false, bool bNoWSM=false );
	NxObject*			CreateObjectFromNode( INode* node, float scale = 1.0f, ULONG flags=0);

	Tab< NxMaterial >	m_Materials;	
	Tab< NxObject* >	m_Objects;
	bool				m_Skinned;
	bool				m_DynamicallyLit;
};


Mtl*	GetSubMaterial( Mtl* base_mtl, int mtl_id );

#endif // __EXPORT_EXPORT_H__