/*
	AnimOptionsDlg.h
	1-7-01
*/

#ifndef ANIMOPTIONSDLG_H
#define ANIMOPTIONSDLG_H

#include "AnimExporter.h"
#include "../UI/MSWindow.h"
#include "../UI/ProgressBar.h"
#include "../UI/ListView.h"
#include "../UI/PropList.h"
#include "AnimTol.h"

#define ANIMOPTDATA_VER      0x0003
#define ANIMOPTDATA_STRSIZE  80

struct AnimOptionData
{
	WORD  version;
	char  modelname[ANIMOPTDATA_STRSIZE];
	char  suffixname[ANIMOPTDATA_STRSIZE];
	bool  bExportQN;							// True if a .QN file that loads the animations should be output
	bool  bUseCompression;						// Use animation compression
	bool  bOutputDebug;							// Output debug information
	bool  bCompressDoubles;						// Compress linear anims to one key
	char  dirname[ANIMOPTDATA_STRSIZE];			// Directory name that animations should be saved to
	char  skeletonName[ANIMOPTDATA_STRSIZE];	// Name of the skeleton that should be used with each animation
	bool  bCompressTime;						// True if time should be given as animation frame number
	bool  bRotateRoot;							// True if the root bone should be rotated by 90 degrees
};

struct AnimListData
{
	TolData        toldata;
	CStr           animName;
	int            start;
	int            end;
	float          rotTol;
	float          tranTol;
	int            fileSize;
	bool           active;

	AnimListData()
	{
		fileSize=start=end=0;
		tranTol=rotTol=0.0f;
		active=true;
	}
};

class AnimOptions2Dlg: public MSDlgWindow
{
	HWND            hwndParent;
	AnimOptionData  animoptdata;

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

public:
	AnimOptions2Dlg(HINSTANCE hInstance,HWND hwndParent);
	~AnimOptions2Dlg();

	void UpdateOptions();
	void SetOptions(AnimOptionData* data);
	void SetOptions();

	inline AnimOptionData GetOptions() { return animoptdata; }
};

class AnimOptionsDlg: public MSDlgWindow, public AnimExporter
{
	enum AnrSaveMode
	{
		ANRNO,
		ANRYES,
		ANRCANCEL,
	};

	AnimOptionData animopt;		// Animation options

	Interface*   ip;
	ListView*    listview;		// The main ListView control at top
	bool         bLockUpdate;	// Prevents ListBox updates on edit changes if true
	HCURSOR      cursorStd;		// Standard cursor
	HCURSOR      cursorMove;	// Hand cursor displayed when performing drag operation
	bool         bDrag;			// True if user is in the middle of dragging contents in ListView
	FILE*        fpExport;		// Export file stream
	int          start,end;		// Start and end of current animation
	float        fCompress;		// Compression setting for current animation's rotation
	float        fTCompress;	// Compression setting for current animation's translations
	float*       fTolerances;	

	CStr         anrfile;		// The last anr file that was loaded into the editor
	bool         bUpdated;		// True if a modification was made to the anr file since it was loaded

	ProgressBar* progBar;		// Progress bar for animation export
	
	AnimOptions2Dlg* optionsDlg;// Extended animation export options dialog

	ICustEdit* IEditRot;		// Rotation Tolerance edit box
	ICustEdit* IEditTran;		// Translation Tolerance edit box

	ICustEdit* IEditEnd;		// End frame edit box
	ICustEdit* IEditStart;		// Start frame edit box
	ICustEdit* IEditAnim;		// Animation name edit box

	ISpinnerControl* ISpinRot;	// Rotation Tolerance Spinner control
	ISpinnerControl* ISpinTran;	// Translation Tolerance Spinner control

	ISpinnerControl* ISpinEnd;	// Spinner for the end animation box
	ISpinnerControl* ISpinStart;// Spinner for the start animation box

	PropList*        pTolList;		// Compression tolerance list per bone (rotations)
	PropList*        pTolListTran;	// Compression tolerance list per bone for translations

	AnimTolFile      TolFile;		// The animation tolerance config file (stores presets)
	AnimSubTolFile   SubTolFile;	// The animation sub tolerance config file (stores per item preset list)

	//LinkList< TolData > TolDB;		// Tolerance database
	LinkList< AnimListData > TolDB;

	// UI functions
	void SliderUpdate(float val,int pos);
	void NewAnimation();
	void RemoveSelection();
	bool ExportRange(char* filename=NULL);
	bool ImportRange(char* filename=NULL);
	void AssignTime(const int ctrlID);

	void UpdateName();
	void UpdateStart();
	void UpdateEnd();

	void UpdateLabelEdit(NMLVDISPINFO* dispinfo);

	void EnableUI(bool bActive);

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void SelChange(LPNMLISTVIEW item);
	void GoToAnim();			// Causes MAX to go to the currently selected animation

	void MoveItems(int index);	// Moves list items as a result of Drag/Drop

	// Export functions
	  void Export();
	  bool ExportNodes(INode* root);

	INode* GetRootEx(INode* node);
	bool   VerifyRoot();

	int CountNodesEx(INode* node);

	static void CancelCB(void* pData);

	int    GetFileSize(char* Filename);

	void   FindAnim();				// Finds the current animation in the animation list

	// Per bone Tolerance Stuff
	int lastTolID;
	int lastTolIDTran;

	static void TolFocusCB(PropList* plist,int id, void* pData);
	static void TolFocusTranCB(PropList* plist,int id, void* pData);

	static void TolChangeCB(PropList* plist,void* pData);
	static void TolChangeTranCB(PropList* plist,void* pData);

	bool   LoadTolerances();
	bool   SaveTolerances();
	void   UpdateTolerances();

	void   SetPresetTol();
	void   SetManualTol();
	void   SetPresetTolTran();
	void   SetManualTolTran();

	void   AddBones(INode* node);	// Adds the bones (nodes) in the scene to the bone select combo box
	void   AddBone();
	bool   AddBone(INode* node,bool bNoBuild=false);
	void   RemoveBone();
	void   AddAllBones();
	void   RemoveAllBones();

	void   UpdatePresetSel();
	void   BuildSubPresetList(ListData* ldata);

	CStr   GetValueViaName(LinkList<CStr>* list,CStr name);

	void   ToggleActive();
	void   FieldSort(int item);

	void   UpdateOtherTolerances();	// Updates tolerances for all selected animations

	static Sort(DWORD dw1,DWORD dw2,ListView* pList,void* pData);

	AnrSaveMode MaybeSaveAnr();			// Prompt user to save the anr if appropriate

	void   BuildPS2File(CStr Filename);

public:
	AnimOptionsDlg(HINSTANCE hInstance,HWND hwndParent,Interface* ip);
	~AnimOptionsDlg();

	void SaveToScene();			// Saves options into the MAX file
	bool LoadFromScene();		// Loads options from MAX file
};

#endif
