typedef unsigned char Uint8;
typedef unsigned short Uint16;
typedef unsigned long Uint32;
typedef char Sint8;
typedef short Sint16;
typedef long Sint32;

struct RGBA
{
	Uint8 r, g, b, a;
};

// This structure holds the raw data read in from the source BMP and information
// about its dimensions
struct BMPInfo
{
	Uint16 w, h;
	Uint16 bpp;
	int numColors;
	int byteWidth;
	int byteWidthPadded;

	RGBA *pColorTab;
	int transparentColor;

	Uint8 *pData;
};

// Holds character information. Is used internally and not outputted to file.
struct Character 
{
	Sint16 x, y;
	Sint16 w, h;
	Sint16 baseline;
	Sint16 byteW;

	Sint16 ascii;
};

// A table of these structures is outputted into the texture data
// section of the FNT file
struct OutCharInfo
{
	// pixel offsets
	Uint16 x, y, w, h;
};

// a table of these is outputted at the beginning of the FNT file, before the texture data section
struct ExtraCharInfo
{
	Sint16 baseline;
	Sint16 ascii;
};

// Holds info about the texture data section (mainly) of the FNT file, but is
// not itself outputted
struct OutInfo
{
	Uint16 w, h;
	Uint16 usedH;
	Uint16 byteW;
	// must be 32 bit int, not 16!!
	int size;

	Uint8			*pData;
	OutCharInfo		*pChar;
	ExtraCharInfo	*pExtra;
};



