//****************************************************************************
//* MODULE:         Tools/LibMaker
//* FILENAME:       libmaker.cpp
//* OWNER:          Gary Jesdanun
//* CREATION DATE:  1/29/2003
//****************************************************************************

#define __USE_OLD_STREAMS__

#include "LibMaker.h"

#include <fstream.h>

#include "Utility.h"
#include "VirtualFile.h"

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

CLibMaker::CLibMaker()
{
	m_numFiles = 0;
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

CLibMaker::~CLibMaker()
{
	delete_files();
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

bool CLibMaker::AddFile( const char* pFullPathName, uint32 fileNameChecksum, uint32 fileExtensionChecksum )
{
	printf( "pFullPathName = %s\n", pFullPathName );

	fstream instream( pFullPathName, ios::in | ios::nocreate | ios::binary );
	if ( !instream.is_open() )
	{
		// skip if the file doesn't exist...
		return false;

		printf( "Couldn't open %s\n", pFullPathName );
		exit(1);
	}

	if ( m_numFiles > vMAX_FILES )
	{
		printf( "Couldn't add %s.  Too many files in list!\n", pFullPathName );
		instream.close();
		exit(1);
	}

	printf( "Adding %s to LIB\n", pFullPathName );
		
	SFileInfo* pFileInfo = &m_fileList[m_numFiles];	

	pFileInfo->fileName = fileNameChecksum;
	pFileInfo->extName = fileExtensionChecksum;
	strcpy( pFileInfo->debugName, pFullPathName );

	instream.seekp( 0, ios::end );
	pFileInfo->fileSize = instream.tellp();
	instream.seekp( 0, ios::beg );
	pFileInfo->pDataBuf = new char[pFileInfo->fileSize];
	instream.read( (char*)pFileInfo->pDataBuf, pFileInfo->fileSize );
	instream.close();
	pFileInfo->patchAddress = 0xDEADDEAD;
	pFileInfo->patchOffset = 0xFACEFACE;
	m_numFiles++;

	return true;
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

void CLibMaker::delete_files()
{
	for ( int i = 0; i < m_numFiles; i++ )
	{
		SFileInfo* pFileInfo = &m_fileList[i];
		delete[] pFileInfo->pDataBuf;
		pFileInfo->pDataBuf = NULL;
	}

	m_numFiles = 0;
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

bool CLibMaker::OutputFiles( IoUtils::CVirtualOutputFile* pOutputFile, bool reverseByteOrder )
{
	int versionNum = 1;
	pOutputFile->Write( (const char*)&versionNum, sizeof(int), reverseByteOrder );

	pOutputFile->Write( (const char*)&m_numFiles, sizeof(int), reverseByteOrder );

	int i;

	for ( i = 0; i < m_numFiles; i++ )
	{
		// FILE OFFSET
		// FILE SIZE
		// CHECKSUM OF FILENAME, MINUS EXTENSION
		// CHECKSUM OF EXTENSION

		SFileInfo* pFileInfo = &m_fileList[i];
		pFileInfo->patchAddress = pOutputFile->TellPos();
		int dummyOffset = 0;
		pOutputFile->Write( (const char*)&dummyOffset, sizeof( int ), reverseByteOrder );
		pOutputFile->Write( (const char*)&pFileInfo->fileSize, sizeof( int ), reverseByteOrder );
		pOutputFile->Write( (const char*)&pFileInfo->fileName, sizeof( int ), reverseByteOrder );
		pOutputFile->Write( (const char*)&pFileInfo->extName, sizeof( int ), reverseByteOrder );
	}

	for ( i = 0; i < m_numFiles; i++ )
	{
		SFileInfo* pFileInfo = &m_fileList[i];
		pFileInfo->patchOffset = pOutputFile->TellPos();

		// write out file data
		printf( "Writing out %d bytes for file %d: %s\n", pFileInfo->fileSize, i, pFileInfo->debugName );
		pOutputFile->Write( (const char*)pFileInfo->pDataBuf, pFileInfo->fileSize ); 
	
		// pad it, if necessary
		if ( pOutputFile->TellPos() & 0x3 )
		{
			char dummy;
			int pad_size = pOutputFile->TellPos() & 0x3;
			printf( "Writing out %d bytes for padding\n", pad_size );
			pOutputFile->Write( (const char*)&dummy, 4 - pad_size );
		}
	}
	
	streampos end_pos = pOutputFile->TellPos();

	// patch the headers
	for ( i = 0; i < m_numFiles; i++ )
	{
		SFileInfo* pFileInfo = &m_fileList[i];
		pOutputFile->SeekPos( pFileInfo->patchAddress );
		pOutputFile->Write( (const char*)&pFileInfo->patchOffset, sizeof( int ), reverseByteOrder );
	}

	pOutputFile->SeekPos( end_pos );

	return true;
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/