/*
	WorldStructs.h
	Structures related to managing world DB that are shared with
	or need to maintain compatibility with other components (i.e. Plugin and Sceneconv)

	WARNING! THESE STRUCTURES MUST BE KEPT IN SYNC WITH THE PLUGIN

	aml - 9-29-03
*/

#ifndef __WORLDSTRUCTS__
#define __WORLDSTRUCTS__

#define vMAX_MATERIAL_PASSES 4
#define vNAME_MAX            256

typedef	__int64	FlagType;
typedef __int64 CASFlagType;

struct Point3
{
	float x,y,z;
};

typedef Point3 Vector;
typedef Point3 UVVert;

struct UVCoord
{
	float u,v;
};

struct TVFace
{
	unsigned long t[3];	// Indicies into vert table
};

class	NxBoundingBox	// From SceneConv.h
{
public:
	void Init();
	void Set(const float min[3], const float max[3]);
    void AddPoint(const float point[3]);

	float	m_Min[3];
	float	m_Max[3];
};

class	NxSphere
{
public:
	float	m_Center[3];
	float	m_Radius;
};

struct UVChannel
{
	UVVert* verts;		// Vertex list for the channel
	TVFace* faces;		// Face list for the channel

	int     nVerts;		// Number of verts in this copied channel
	int     nFaces;		// Number of faces in this copied channel

	inline void setVerts(int num)
	{
		verts = new UVVert[num];
		nVerts = num;
	}

	inline void setFaces(int num)
	{
		faces  = new TVFace[num];
		nFaces = num;
	}

	UVChannel()
	{
		verts  = NULL;
		faces  = NULL;
		nVerts = 0;
		nFaces = 0;
	}

	~UVChannel()
	{
		if (verts)
			delete [] verts;

		if (faces)
			delete [] faces;
	}
};

class NxFace
{
public:
	enum
	{
		mFD_SKATABLE			  = 0x00000001,
		mFD_NOT_SKATABLE		  = 0x00000002,
		mFD_WALL_RIDABLE		  = 0x00000004,
		mFD_VERT				  = 0x00000008,
		mFD_NON_COLLIDABLE		  = 0x00000010,
		mFD_DECAL				  = 0x00000020,
		mFD_TRIGGER			      = 0x00000040,
		mFD_NON_CAMERA_COLLIDABLE = 0x00000080,
		//mFD_CAMERA_COLLIDABLE	= 0x00000080,
		mFD_NO_SKATER_SHADOW	  = 0x00000100,
		mFD_SKATER_SHADOW		  = 0x00000200,
		mFD_NO_SKATER_SHADOW_WALL = 0x00000400,
		mFD_UNDER_OK			  = 0x00000800,
		mFD_INVISIBLE			  = 0x00001000,
		mFD_CASFACEFLAGSEXIST     = 0x00002000,
		mFD_PASS_1_DISABLED       = 0x00004000,	// Set only if pass 1 is turned off (so it defaults on for everything)
		mFD_PASS_2_ENABLED        = 0x00008000,
		mFD_PASS_3_ENABLED        = 0x00010000,
		mFD_PASS_4_ENABLED        = 0x00020000,
		mFD_RENDER_SEPARATE		  = 0x00040000,
		mFD_LIGHTMAPPED           = 0x00080000,
		mFD_NON_WALL_RIDABLE	  = 0x00100000,
		//mFD_NON_CAMERA_COLLIDABLE = 0x00200000,
		mFD_EXPORT_COLLISION	  = 0x00400000,
	};


				NxFace( void );

	// new
	int			  m_PassFlags;

	int			  m_Vertex[3];			// Index into vert list
	Point3		  m_Normal;
	unsigned long m_MatChecksum;		// Checksum of material
	FlagType	  m_FaceFlags;	
	FlagType	  m_MinFaceFlags;	
	int			  m_Index;
	int			  m_Pass;
	CASFlagType   m_CASFaceFlags;
	unsigned long m_LightmapChecksum;	// Obj v2: Checksum of lightmap                 [aml 9-24-02]
	UVCoord       m_LightmapUV[3];		// Obj v2: Texture UV coordinates for lightmap  [aml 9-24-02]
};

class NxVertex
{
public:
	NxVertex( void );

	enum
	{
		vVERSION_NUMBER			=	0x0001,
		//vMAX_WEIGHTS_PER_VERTEX	=	6,
		vMAX_WEIGHTS_PER_VERTEX	=	4,
		vMAX_USED_WEIGHTS_PER_VERTEX	=	3,
	};

	bool operator==( NxVertex& vertex );

	Point3	m_Pos;
	Point3	m_Normal;
	UVVert	m_TexCoord[vMAX_MATERIAL_PASSES];
	float	m_Color[4];
	int		m_WibbleIndex;
	int		m_WibbleOffset;
	int		m_Pass;
	int		m_FaceIndex;	// Used when remapping/optimizing vertex set	
	bool	m_Weighted;
	int		m_NumWeights;
	int		m_WeightedIndex[vMAX_WEIGHTS_PER_VERTEX];
	float	m_Weight[vMAX_WEIGHTS_PER_VERTEX];

	// THIS IS NOT EXPORTED!
	int     m_MaxVert;		// Index of the MAX mesh vert index for this NxVertex
};

class	NxCASData
{
public:
	unsigned long	m_Mask;
	unsigned long	m_Data;
	unsigned long	m_Data1;
};

class NxLODLevel
{
public:
	enum
	{
		vVERSION_NUMBER =  0x0001
	};

				   NxLODLevel( void );

	float		   m_Distance;
	unsigned long  m_ObjectCRC;
};

struct NxLODFace
{
	int v[3];	// Index into vert list for each vertex in face
};

struct NxLODInfo
{
	NxLODFace* faces;
	int        numFaces;
	float      distance;		// User defined distance for this LOD level NxObject::HASLODDISTS must be set

	NxLODInfo()
	{
		faces    = NULL;
		numFaces = 0;
	}

	~NxLODInfo()
	{
		if (faces)
			delete [] faces;
	}
};

class NxObject
{
public:
	enum
	{
		vMAXCASDATA = 8192	
	};

	enum
	{
		mTEXTURED			=	0x00000001,
		mCOLORED			=	0x00000002,
		mNORMALS			=	0x00000004,
		mINVISIBLE			=	0x00000008,	
		mSKINNED			=	0x00000010,
		mDYNAMIC			=	0x00000020,
		mOCCLUDER		    =   0x00000040,
		mHASCASREMOVEFLAGS  =   0x00000080,
		mPASS_BIT_1			=	0x00000100,
		mPASS_BIT_2			=	0x00000200,
		mNO_SHADOW			=	0x00000400,
		mVCWIBBLE			=	0x00000800,
		mRENDER_SEPARATE	=	0x00001000,		// Def'd in SceneConv
		mHASKBIAS           =   0x00002000,	
		mNO_SHADOW_WALL     =   0x00004000,		// From SceneConv
		mHASLODINFO			=   0x00008000,		// True if LOD info fields are included  aml
		mSKELETALMODEL      =   0x00010000,		// Model that contains skeletal info for procedural animation  aml  (Only valid in model export)
		mUNLIT				=	0x00020000,
		mCOLOR_LOCKED		=	0x00040000,
		mGRASS				=	0x00080000,
		mHASINTLODINFO		=   0x00100000,		// True if this object contains its LOD data internally
		mSHADOWVOLUME       =   0x00200000,		// True if the object is flagged in PE as a shadow volume
		mHAS4WEIGHTS        =   0x00400000,		// Skinned model uses 4 weights per vert
		mBILLBOARD          =   0x00800000,	
		mSS_NORMALS			=	0x01000000,		// Has normals solely for the purpose of determining which side should be rendered in a single-sided mesh
		mPASS_BIT_3			=	0x02000000,		// Extra pass bits for z-push (SceneConv only)
		mPASS_BIT_4			=	0x04000000,		// (SceneConv only)
		mWATER				=	0x08000000,		// is a water material (SceneConv only)
		mABSENTINNETGAMES   =   0x10000000,		// Flaged if the object has AbsentInNetGames checked
		mHASLODDISTS        =   0x20000000,		// Object contains distances used
		mHASVERSIONINFO     =   0x80000000,		// Version info wasn't saved in original,  if included load version
												// field
	};

	// LOD Flags
	enum
	{
		mMASTER = 0x0001,					// This is the main instance of the object containing the LOD level info
		mSLAVE  = 0x0002,					// This object is an LOD level for the given Master object
	};

	enum
	{
		// Revision 5 starts version 1
		//vVERSION_NUMBER	=	0x0001
		//vVERSION_NUMBER   =   0x0002		// v2 contains lightmap info per face
		//vVERSION_NUMBER   =  0x0003			// v3 contains internal LOD data
		vVERSION_NUMBER   =  0x0004			// v4 contains single_sided flags
	};

	NxObject( void );
	~NxObject( void );

	void			OptimizeVertList( void );
	void			Dump( void );	
	void			FileDump( char* filename );

	// new
	int             m_Checksum;
	NxCASData*		mp_CASData;
	int				m_NumCASData;
	NxSphere		m_BoundingSphere;
	NxVertex*       m_OriginalVerts;

	int				m_NumFaces;	
	NxFace*			m_Faces;
	int				m_NumVerts;
	NxVertex*		m_Verts;
	char			m_Name[vNAME_MAX];
	NxBoundingBox	m_BoundingBox;
	int				m_Flags;	
	int				m_NumUVSets;
	unsigned long	m_SkeletonChecksum;
	int             m_CASRemoveFlags;
	float           m_KBias;				// New in r3, do not read if no mHASKBIAS flag set
	int             m_ParentMatrixIndex;	// Index into matrix array for transform of this object
											// if it's a modal that uses skeletal animation

	// THESE ARE NOT EXPORTED! //////
	int             m_NumMaxVerts;			// Number of vert references in lookup table
	int*            m_MaxVerts;				// The MaxVert member contains lookup data that matches
											// a MAX mesh vertex index to our expanded vert indexes (nVerts * 3)
	
	int             m_NumUVChannels;		// Number of UV channels for multitexture
	UVChannel*      m_UVChannels;			// These are UV sets per channel that have been transformed by
	                                        // the multi-res modifier progressively.  Since MR can only update
	                                        // 1 UV channel at a time.  If set these should override when getting
											// UV data from the mesh
	/////////////////////////////////

	// LOD info ///////
	unsigned int    m_LODVersion;			// load only with mHASLODINFO      aml	
	int             m_LODFlags;				// load only with mHASLODINFO      aml
	
	struct LODMaster
	{
		int           m_NumLODLevels;		// load only with mHASLODINFO  aml
		NxLODLevel*   m_LODLevels;			// load only with mHASLODINFO  aml
	};

	struct LODSlave
	{
		unsigned long m_masterCRC;			// load only with mHASLODINFO  aml
	};

	union
	{
		LODMaster   m_LODMaster;
		LODSlave    m_LODSlave;
	};
	//////////

	unsigned int    m_Version;				// load only with mHASVERSIONINFO  aml (This is the object version)
	
	// Relative info
	int             m_ParentCRC;			// v1
	int             m_NumChildren;			// v1
	unsigned long*  m_ChildCRCs;			// v1

	int             m_LODLevels;
	NxLODInfo*      m_LODinfo;

	// Billboard data
	enum BillboardType
	{
		BBT_NOT_BILLBOARD,
		BBT_SCREEN_ALIGNED,
		BBT_AXIAL_ALIGNED,
	};
	
	BillboardType   m_BillboardType;
	float           m_BillboardOrigin[3];
	float           m_PivotPos[3];
	float           m_PivotAxis[3];
};

#endif
