/*
	NxTexture.h
	Class for managing textures in standard game TEX format
*/

#ifndef __NXTEXTURE__
#define __NXTEXTURE__

#define	vINVALID_CHECKSUM	0xFFFFFFFF
#define vNO_GROUP			-1

class NxTexture
{
public:
	enum
	{
		v32_BIT,
		v24_BIT,
		v16_BIT,
		v8_BIT,
		v4_BIT,		
		v8_BIT_GRAY,
		v4_BIT_GRAY
	};

	enum
	{
		vMAX_MIP_LEVELS = 10,
		vMAX_NAME_LENGTH = 256,
		vMIN_MIP_WIDTH = 4,
		vMIN_MIP_HEIGHT = 4,
	};

	enum
	{
		vADDRESS_MODE_REPEAT,
		vADDRESS_MODE_CLAMP,
	};

	enum
	{
		mFORCE_BYTE_PER_COMPONENT		=	0x0001,
		mCHANGE_FULLY_TRANSPARENT_COLOR	=	0x0002,
		mAUTO_GENERATE_MIPMAPS			=	0x0004,
		mTRANSPARENT					=	0x0008,
		mOPAQUE							=	0x0010,
		mCOMPRESS_NGC					=	0x0020,
		mCOMPRESS_XBOX					=	0x0040,
		mINVISIBLE						=	0x0080,		// Not meant to be rendered. 		
	};	

	enum
	{
		vGROUP_PASS_1,
		vGROUP_PASS_2,
		vGROUP_PASS_3,
		vGROUP_PASS_4,
		vGROUP_TRANSPARENT_1,
		vGROUP_TRANSPARENT_2,
		vGROUP_TRANSPARENT_3,
		vGROUP_TRANSPARENT_4,
		vNUM_GROUP_TYPES
	};

	NxTexture( void );
	~NxTexture( void );

	bool	IsPaletted( void );
	int		GetTotalDataSize( void );

	// Useful (though somewhat specific) conversion functions.
	bool	ConvertTo32BitPixelFormat( void );
	bool	Convert32BitRGBAPixelFormatTo32BitBGRAPixelFormat( void );

	bool	Convert4BitPixelFormatTo8BitPixelFormat( void );
	bool	Convert16BitPaletteFormatTo32BitPaletteFormat( void );
	bool	Convert24BitPaletteFormatTo32BitPaletteFormat( void );
	bool	Convert32BitRGBAPaletteFormatTo32BitBGRAPaletteFormat( void );

	int	m_PixelFormat;
	int	m_PaletteFormat;

	int	m_Width[vMAX_MIP_LEVELS];
	int	m_Height[vMAX_MIP_LEVELS];

	int m_Bpp;
	int m_PaletteBpp;
	
	int	m_TotalPaletteDataSize;
	int	m_TotalTexelDataSize;
	int	m_TexelDataSize[vMAX_MIP_LEVELS];

	char*	m_TexelData[vMAX_MIP_LEVELS];
	char*	m_PaletteData;

	int m_NumPaletteEntries;
	
	int	m_MipLevels;

	int	m_Flags;	
	int m_PlatFlags;

	char m_Name[vMAX_NAME_LENGTH];
	
	unsigned long m_Checksum;	

	float	m_LastDrawOrder;
	int m_LastGroupIndex;
	int m_LastGroupId;
	int	m_GroupFlags;

	bool m_AlreadyExported;
};

#endif
