/*
	NxMaterial.h
	From Export.h in Plugin
*/

#ifndef __NXMATERIAL__
#define __NXMATERIAL__

#include "llist.h"

#define vNUM_PLATFORMS              3
#define vMAX_NUM_ANIMATED_FRAMES	200
#define vMAX_WIBBLE_SEQUENCES	    8
#define vMAX_MATERIAL_PASSES        4

#define vNUM_TERRAIN_TYPES 60

enum
{
	vBASE_OPAQUE_MATERIAL_DRAW_ID					= 0,	
	vBASE_ORDERED_TRANSPARENT_MATERIAL_DRAW_ID		= 1000,	
};

typedef enum
{
	vBLEND_MODE_DIFFUSE,				// ( 0 - 0 ) * 0 + Src
	vBLEND_MODE_ADD,					// ( Src - 0 ) * Src + Dst
	vBLEND_MODE_ADD_FIXED,				// ( Src - 0 ) * Fixed + Dst
	vBLEND_MODE_SUBTRACT,				// ( 0 - Src ) * Src + Dst
	vBLEND_MODE_SUB_FIXED,				// ( 0 - Src ) * Fixed + Dst
	vBLEND_MODE_BLEND,					// ( Src - Dst ) * Src + Dst	
	vBLEND_MODE_BLEND_FIXED,			// ( Src - Dst ) * Fixed + Dst	
	vBLEND_MODE_MODULATE,				// ( Dst - 0 ) * Src + 0
	vBLEND_MODE_MODULATE_FIXED,			// ( Dst - 0 ) * Fixed + 0	
	vBLEND_MODE_BRIGHTEN,				// ( Dst - 0 ) * Src + Dst
	vBLEND_MODE_BRIGHTEN_FIXED,			// ( Dst - 0 ) * Fixed + Dst	
	vBLEND_MODE_GLOSS_MAP,				// Src/Dst/Fixed are ignored in implementation
	vBLEND_MODE_BLEND_PREVIOUS_MASK,	// ( Src - Dst ) * Dst + Dst
	vBLEND_MODE_BLEND_INVERSE_PREVIOUS_MASK,	// ( Dst - Src ) * Dst + Src
	vBLEND_MODE_ADD_PREVIOUS_ALPHA,		// ???? ( Src - Dst )  * Src + Src ????

	vNUM_BLEND_MODES
} BlendModes; 

enum
{
	vPARAM_COLOR_SRC,
	vPARAM_COLOR_DST,
	vPARAM_COLOR_ZERO,
	vPARAM_COLOR_RESERVED,
	vPARAM_COLOR_FIXED = vPARAM_COLOR_ZERO,
};

typedef enum
{
	TEX_FORCE_32_BIT		= 0x0002,
	TEX_CHANGE_TRANS_COLOR	= 0x0004,
} TextureForceModes;

enum CutoffFunc
{
	CUTOFF_FUNC_NO_UPDATE,
	CUTOFF_FUNC_UPDATE_FRAMEBUFFER,
};

typedef enum
{
	vMAPPING_EXPLICIT,
	vMAPPING_ENVIRONMENT,
} MappingMode;

typedef enum
{
	vFILTERING_NEAREST,
	vFILTERING_LINEAR,
	vFILTERING_NEAREST_MIPMAP_NEAREST,
	vFILTERING_NEAREST_MIPMAP_LINEAR,
	vFILTERING_LINEAR_MIPMAP_NEAREST,
	vFILTERING_LINEAR_MIPMAP_LINEAR
} FilteringMode;    

class NxAnimatedTextureKeyframe
{
public:
	NxAnimatedTextureKeyframe( void );

	unsigned int	m_Time;
	unsigned long	m_TexChecksum[vNUM_PLATFORMS];
};

class NxAnimatedTexture
{
public:
	enum
	{
		vLOOP,
		vPING_PONG,
	};
	NxAnimatedTexture( void );
	~NxAnimatedTexture( void );

	int	m_NumKeyframes;
	int	m_Period;
	int m_Iterations;
	int m_LoopType;
	int m_Phase;
	NxAnimatedTextureKeyframe m_Keyframes[vMAX_NUM_ANIMATED_FRAMES];
};

class WibbleKeyframe
{
public:
	float	m_Color[4];		// RGBA
	int		m_Time;
};

class VCWibbleSequence
{
public:
	int				m_NumFrames;
	int				m_Index;
	int				m_Offset;
	int				m_Phase;
	WibbleKeyframe	*m_WibbleFrames;
};

class NxMaterialPass
{
public:
	enum
	{
		COLOR_LOCKED		= 0x0001,
		UNLIT				= 0x0002,
		IGNORE_VERTEX_ALPHA	= 0x0004,
		//  UNUSED! Fill up this slot next  //INVERT_VERTEX_ALPHA	= 0x0008,
		ANIMATED_TEXTURE	= 0x0010,
	};
	
					NxMaterialPass( void );

	unsigned long	m_TexChecksum[vNUM_PLATFORMS];
	int				m_BlendMode;
	int				m_FixedAlpha;
	MappingMode		m_MappingMode;		// Explicit or procedural (eg. environment-mapping)	
	FilteringMode	m_MinFilteringMode;	// Point/Bi-linear
	FilteringMode	m_MagFilteringMode;	// Point/Bi-linear/Tri-linear
	bool			m_UVWibbleEnabled;		
	float			m_UVel;
	float			m_VVel;	
	float			m_UAmplitude;
	float			m_VAmplitude;
	float			m_UPhase;
	float			m_VPhase;
	float			m_UFrequency;
	float			m_VFrequency;
	float			m_EnvTileU;
	float			m_EnvTileV;
	float			m_Color[4];		// RGBA
	float			m_Ambient[4];	// RGBA
	float			m_Diffuse[4];	// RGBA
	float			m_Specular[4];	// RGBA
	float			m_MipMapK;	
	int				m_AddressModeU;
	int				m_AddressModeV;
	bool            m_HasColor;			// aml
	unsigned long   m_Flags;			// aml	
	NxAnimatedTexture	m_AnimatedTexture;
};

class NxMaterial
{
public:
	
	enum
	{
		mUV_WIBBLE		= 0x0001,
		mVC_WIBBLE		= 0x0002,
		mTEXTURED		= 0x0004,
		mENVIRONMENT	= 0x0008,
		mDECAL			= 0x0010,
		mSMOOTH			= 0x0020,
		mTRANSPARENT	= 0x0040,
		mONE_SIDED		= 0x0080,
		mINVISIBLE		= 0x0100,
		mTWO_SIDED      = 0x0200,		// aml
		mSPECULAR		= 0x0400,		// aml
		mANIMATED_TEX   = 0x0800,
		mNEWFORMATCRC   = 0x1000,		// aml
	};

	enum
	{
		mGROUP_PASS_1			= 0x0001,
		mGROUP_PASS_2			= 0x0002,
		mGROUP_PASS_3			= 0x0004,
		mGROUP_PASS_4			= 0x0008,
		mGROUP_TRANSPARENT		= 0x0010

	};

	enum
	{
		vADDRESS_MODE_REPEAT,
		vADDRESS_MODE_CLAMP,
	};	

	enum
	{
		vCUTOFF_NOUPDATE,
		vCUTOFF_UPDATEFRAMEBUFFER,
	};

	// VERSION HISTORY
	// v3 for non active colors  aml
	// v4 for m_Sorted and m_DrawOrder
	// v5 for m_CutoffFunc
	// v6 for m_TwoSided
	// v7 expanded m_Name to 256 bytes (it appears as though we were getting some buffer overruns)
	// v8 Added m_grassify
	// v9 Added m_grassHeight, m_grassLayers
	// v0xA Added m_Flags to NxMaterialPass
	// v0xB Added m_EnvTileU & V to NxMaterialPass
	// v0xC Moved m_Flags to the beginning of the pass, since data that follows is dependent on it
	// v0xD Added BasePass
	// v0xE Added water material property
	// v0xF Added new non case-sensitive format CRC

	enum
	{
		vVERSION_NUMBER	=	0x000F,
	};

					 NxMaterial( void );

	bool			 operator == ( NxMaterial& material );
	
	unsigned long	 GetCRC( void );
	unsigned long    GetNewCRC( void );	// New format CRC (case-insensitive)

	char             m_Name[256];	// up'd from 64 bytes (buffer overruns) aml
	//Mtl*			 m_MaxMtl;
	unsigned long	 m_Checksum;
	unsigned long    m_NewChecksum;	// ver 0x000F
	bool			 m_Transparent;	
	int				 m_NumPasses;
	int				 m_AlphaCutoff;
	int				 m_Terrain;
	bool			 m_WarnedAlready;
	bool			 m_OneSided;
	bool             m_TwoSided;
	bool			 m_Invisible;
	float			 m_DrawOrder;
	int				 m_BasePass;
	bool			 m_Sorted;
	int              m_CutoffFunc;	
	bool			 m_water;
	bool             m_grassify;
	float            m_grassHeight;
	int              m_grassLayers;
	int				 m_NumWibbleSequences;
	
	VCWibbleSequence m_WibbleSequences[vMAX_WIBBLE_SEQUENCES];

	NxMaterialPass   m_Passes[vMAX_MATERIAL_PASSES];
	bool             m_UseSpecular;
	float            m_SpecularPower;
	float            m_SpecularColor[3];	// RGB
};

#endif
