/*
	NxMaterial.cpp
	From Export.h in Plugin
*/

#include "stdafx.h"
#include "NxMaterial.h"
#include "GenCRC.h"
#include <stdio.h>

NxMaterial::NxMaterial( void )
{
	sprintf( m_Name, "default" );	
	//m_MaxMtl = NULL;
	m_Checksum = 0;
	m_Transparent = false;
	m_BasePass = 1;
	m_OneSided = false;
	m_TwoSided = false;
	m_Invisible = false;
	m_Terrain = 0;
	m_NumPasses = 1;
	m_WarnedAlready = false;
	m_AlphaCutoff = 1;
	m_DrawOrder = 0;
	m_Sorted = false;
	m_NumWibbleSequences = 0;	
	m_water = false;
	m_grassify = false;
	m_grassHeight = 0;
	m_grassLayers = 0;
	m_SpecularPower = 0.0f;
	m_SpecularColor[0] = 1.0f;	// R
	m_SpecularColor[1] = 1.0f;	// G
	m_SpecularColor[2] = 1.0f;	// B
}

bool	NxMaterial::operator == ( NxMaterial& material )
{
	return ( m_Checksum == material.m_Checksum );
}

unsigned long	NxMaterial::GetNewCRC( void )
{
	return( GenerateCRC( m_Name) );
}

unsigned long	NxMaterial::GetCRC( void )
{
	/*int i;
	char data[128];
	char* ch;	

	ch = data;

	for( i = 0; i < m_NumPasses; i++ )
	{
		memcpy( ch, &m_Passes[i].m_TexChecksum, sizeof( unsigned long ));
		ch += sizeof( unsigned long );
		memcpy( ch, &m_Passes[i].m_BlendMode, sizeof( int ));
		ch += sizeof( int );
		memcpy( ch, &m_Passes[i].m_FixedAlpha, sizeof( int ));
		ch += sizeof( int );
		memcpy( ch, &m_Passes[i].m_MappingMode, sizeof( int ));
		ch += sizeof( int );
		memcpy( ch, &m_Passes[i].m_MinFilteringMode, sizeof( int ));
		ch += sizeof( int );
		memcpy( ch, &m_Passes[i].m_MagFilteringMode, sizeof( int ));
		ch += sizeof( int );
		if( m_Passes[i].m_UVWibbleEnabled )
		{
			memcpy( ch, &m_Passes[i].m_UVel, sizeof( float ));
			ch += sizeof( float );
			memcpy( ch, &m_Passes[i].m_VVel, sizeof( float ));
			ch += sizeof( float );
			memcpy( ch, &m_Passes[i].m_UAmplitude, sizeof( float ));
			ch += sizeof( float );
			memcpy( ch, &m_Passes[i].m_VAmplitude, sizeof( float ));
			ch += sizeof( float );
			memcpy( ch, &m_Passes[i].m_UPhase, sizeof( float ));
			ch += sizeof( float );
			memcpy( ch, &m_Passes[i].m_VPhase, sizeof( float ));
			ch += sizeof( float );
			memcpy( ch, &m_Passes[i].m_UFrequency, sizeof( float ));
			ch += sizeof( float );
			memcpy( ch, &m_Passes[i].m_VFrequency, sizeof( float ));
			ch += sizeof( float );		
		}
		else
		{
			float pad;

			pad = 0;
			memcpy( ch, &pad, sizeof( float ));
			ch += sizeof( float );
			memcpy( ch, &pad, sizeof( float ));
			ch += sizeof( float );
			memcpy( ch, &pad, sizeof( float ));
			ch += sizeof( float );
			memcpy( ch, &pad, sizeof( float ));
			ch += sizeof( float );
			memcpy( ch, &pad, sizeof( float ));
			ch += sizeof( float );
			memcpy( ch, &pad, sizeof( float ));
			ch += sizeof( float );
			memcpy( ch, &pad, sizeof( float ));
			ch += sizeof( float );
			memcpy( ch, &pad, sizeof( float ));
			ch += sizeof( float );
		}

		memcpy( ch, &m_Passes[i].m_MipMapK, sizeof( float ));
		ch += sizeof( float );
		memcpy( ch, &m_Passes[i].m_MipMapL, sizeof( float ));
		ch += sizeof( float );
	}

	return( GenerateCRC( data, (int) ch - (int) data ));
	*/

	return ( GenerateCRC( m_Name, (int)strlen( m_Name )));
	//return GenerateCRC( m_Name );
}

// NxMaterialPass
NxMaterialPass::NxMaterialPass( void )
{
	memset( this, 0, sizeof( NxMaterialPass ));

	m_BlendMode = vBLEND_MODE_DIFFUSE;
	m_MappingMode = vMAPPING_EXPLICIT;
	m_MagFilteringMode = vFILTERING_LINEAR;
	m_MinFilteringMode = vFILTERING_LINEAR;
	m_UVWibbleEnabled = false;
	m_UVel = 0.0f;
	m_VVel = 0.0f;
	m_UAmplitude = 0.0f;
	m_VAmplitude = 0.0f;
	m_UPhase = 0.0f;
	m_VPhase = 0.0f;
	m_UFrequency = 0.0f;
	m_VFrequency = 0.0f;
	m_EnvTileU = 3.0f;
	m_EnvTileV = 3.0f;
	
	m_Color[0] = 0.5f;	// R
	m_Color[1] = 0.5f;	// G
	m_Color[2] = 0.5f;	// B
	m_Color[3] = 0.5f;	// A

	m_Ambient[0] = 0.5f;	// R
	m_Ambient[1] = 0.5f;	// G
	m_Ambient[2] = 0.5f;	// B
	m_Ambient[3] = 0.5f;	// A

	m_Diffuse[0] = 0.5f;	// R
	m_Diffuse[1] = 0.5f;	// G
	m_Diffuse[2] = 0.5f;	// B
	m_Diffuse[3] = 0.5f;	// A
	
	m_Specular[0] = 0.5f;	// R
	m_Specular[1] = 0.5f;	// G
	m_Specular[2] = 0.5f;	// B
	m_Specular[3] = 0.5f;	// A

	m_MipMapK = -8.0f;	
	m_Flags = 0;
}

// NxAnimatedTextureKeyframe
NxAnimatedTextureKeyframe::NxAnimatedTextureKeyframe( void )
{
	int i;

	m_Time = 0;
	for( i = 0; i < vNUM_PLATFORMS; i++ )
	{
		m_TexChecksum[i] = 0;
	}
}

// NxAnimatedTexture
NxAnimatedTexture::NxAnimatedTexture( void )
{
	m_NumKeyframes = 0;
	m_Period = 0;
	m_Iterations = 0;
	m_LoopType = vLOOP;
}

NxAnimatedTexture::~NxAnimatedTexture( void )
{
}
