/**********************************************************************
 *<
	FILE: gport2.h

	DESCRIPTION: Enhancement of gport

	CREATED BY: Chloe Mignot

	HISTORY:

 *>	Copyright (c) 2005, All Rights Reserved.
 **********************************************************************/

#ifndef __GPORT2__H
#define __GPORT2__H

#include "gport.h"

//! \brief This class adds extends GPort interface.
/*! Two methods are added :
 \li setColorCorrectedState : when set to TRUE, the color picker will be affected by color correction,
 when set to FALSE, the color picker will not be affected by color correction.
 \li getColorCorrectedState : returns TRUE if the color picker is set to be affected by color correction,returns FALSE otherwise.
*/
class GPort2 : public GPort
{
public:

	//!GPort2 constructor.
	GPort2(){mIsColorCorrected = FALSE;}

	//! This method returns the current color correction state of the color picker.
	//! \return - The method returns TRUE if the color picker is set to be affected by color correction , and returns FALSE otherwise.
	BOOL getColorCorrectedState(){return mIsColorCorrected;}

	//! This method sets the current color correction state of the color picker to a new value.
	//! This does NOT affect the current color correction mode.
	//! \param[in] isCorrected - When set to TRUE, the color picker will be affected by color correction , when set to FALSE , the color picker will not be affected by color correction.
	void setColorCorrectedState(BOOL isCorrected){mIsColorCorrected = isCorrected; }

private:
	//! Flag for color correction managing of the color picker
	BOOL mIsColorCorrected;
};

extern CoreExport GPort2* GetGPort2();

#endif