#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <process.h>
#include <time.h>
#include <fstream.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "c:\skate3\code\sk3\scripting\tokens.h"

void Assert(int condition, char *pMessage, ...)
{
	char pad[128];
	
	if (condition) return;
	
	va_list args;
	
	va_start( args, pMessage );
	vsprintf( pad, pMessage, args);
	va_end( args );

	printf("ERROR: ");
	printf( pad );
	printf("\n");
	exit(1);
}

typedef unsigned char uint8;
typedef unsigned int uint32;

struct S4Bytes
{
    union
    {
        uint32 Checksum;
        int i;
        float f;
    };
};

#define MAXDIRBUFCHARS 256
char FirstFileName[MAXDIRBUFCHARS+1];
char SecondFileName[MAXDIRBUFCHARS+1];

// Gets a 4 bytes from pLong, which may not be long word aligned.
static S4Bytes Get4Bytes(uint8 *pLong)
{
    S4Bytes FourBytes;
    FourBytes.i=(pLong[0])|(pLong[1]<<8)|(pLong[2]<<16)|(pLong[3]<<24);
    return FourBytes;
}

// Returns a pointer to after whatever token pToken is pointing to.        
static uint8 *SkipToken(uint8 *pToken)
{
    switch (*pToken)
    {
        case ESCRIPTTOKEN_ENDOFFILE:
            Assert(0,"Tried to skip past EndOfFile token");
            break;
	    case ESCRIPTTOKEN_ENDOFLINE:
        case ESCRIPTTOKEN_EQUALS:
        case ESCRIPTTOKEN_DOT:
        case ESCRIPTTOKEN_COMMA:
        case ESCRIPTTOKEN_MINUS:
        case ESCRIPTTOKEN_ADD:
        case ESCRIPTTOKEN_DIVIDE:
        case ESCRIPTTOKEN_MULTIPLY:
        case ESCRIPTTOKEN_OPENPARENTH:
        case ESCRIPTTOKEN_CLOSEPARENTH:
        case ESCRIPTTOKEN_SAMEAS:
        case ESCRIPTTOKEN_LESSTHAN:
        case ESCRIPTTOKEN_LESSTHANEQUAL:
        case ESCRIPTTOKEN_GREATERTHAN:
        case ESCRIPTTOKEN_GREATERTHANEQUAL:
        case ESCRIPTTOKEN_STARTSTRUCT:
        case ESCRIPTTOKEN_STARTARRAY:
        case ESCRIPTTOKEN_ENDSTRUCT:
        case ESCRIPTTOKEN_ENDARRAY:
        case ESCRIPTTOKEN_KEYWORD_BEGIN:
        case ESCRIPTTOKEN_KEYWORD_BREAK:
        case ESCRIPTTOKEN_KEYWORD_SCRIPT:
        case ESCRIPTTOKEN_KEYWORD_ENDSCRIPT:
        case ESCRIPTTOKEN_KEYWORD_IF:
        case ESCRIPTTOKEN_KEYWORD_ELSE:
        case ESCRIPTTOKEN_KEYWORD_ELSEIF:
        case ESCRIPTTOKEN_KEYWORD_ENDIF:
        case ESCRIPTTOKEN_KEYWORD_RETURN:
		case ESCRIPTTOKEN_KEYWORD_ALLARGS:
		case ESCRIPTTOKEN_ARG:
            ++pToken;
            break;
        case ESCRIPTTOKEN_KEYWORD_REPEAT:
            ++pToken;
            break;
        case ESCRIPTTOKEN_NAME:
        case ESCRIPTTOKEN_INTEGER:
        case ESCRIPTTOKEN_HEXINTEGER:
        case ESCRIPTTOKEN_FLOAT:
	    case ESCRIPTTOKEN_ENDOFLINENUMBER:
			pToken+=5;
            break;
        case ESCRIPTTOKEN_VECTOR:
            pToken+=13;
            break;
        case ESCRIPTTOKEN_PAIR:
            pToken+=9;
            break;
	    case ESCRIPTTOKEN_STRING:
        case ESCRIPTTOKEN_LOCALSTRING:
            ++pToken;
            pToken+=Get4Bytes((uint8*)pToken).i;
            pToken+=4;
            break;
		case ESCRIPTTOKEN_CHECKSUM_NAME: 
			// Skip over the token and checksum.
			pToken+=5;
			// Skip over the string.
			while (*pToken)
			{
				++pToken;
			}
			// Skip over the terminator.
			++pToken;	
			break;			
        case ESCRIPTTOKEN_KEYWORD_RANDOM:
        case ESCRIPTTOKEN_KEYWORD_RANDOM2:
            ++pToken;
            pToken+=4*(*(uint32*)pToken);
            pToken+=4;
			break;
        case ESCRIPTTOKEN_JUMP:
            pToken+=5;
            break;
        case ESCRIPTTOKEN_OR:
        case ESCRIPTTOKEN_AND:
        case ESCRIPTTOKEN_XOR:
        case ESCRIPTTOKEN_SHIFT_LEFT:
        case ESCRIPTTOKEN_SHIFT_RIGHT:
        case ESCRIPTTOKEN_KEYWORD_RANDOM_RANGE:
        case ESCRIPTTOKEN_KEYWORD_RANDOM_RANGE2:
			++pToken;
            break;
        default:
            Assert(0,"Unrecognized script token %d sent to SkipToken()",*pToken);
            break;
    }
    return pToken;
}

bool TestExistence(char *filename)
{
	struct stat testStatBuf;
	int returnCode;
	
	// see if DFF exists, and output its name if so
	returnCode = stat(filename, &testStatBuf);
	return (returnCode != -1);
}

char firstfiles[2048][2048];
int firstfilecount = 0;

char secondfiles[2048][2048];
int secondfilecount = 0;

bool in_file( char*, int );

void add_to_list( char* filename, int i )
{
	for ( uint32 j = 0; j < strlen(filename); j++ )
	{
		if ( filename[j] == '\\' )
		{
			filename[j] = '/';
		}
	}

	if ( i == 0 )
	{
		if ( in_file( filename, 0 ) )
			 return;
		
		if ( firstfilecount < 2048 )
		{
			strcpy( firstfiles[firstfilecount++], filename );
//			printf( "Added %s to firstfiles %d\n", filename, firstfilecount);
		}
		else
		{
			Assert( 0, "Too many items in list" );
		}
	}
	else
	{
		if ( in_file( filename, 1 ) )
			return;
		
		if ( secondfilecount < 2048 )
		{
			strcpy( secondfiles[secondfilecount++], filename );
//			printf( "Added %s to secondfiles %d\n", filename, secondfilecount);		
		}
		else
		{
			Assert( 0, "Too many items in list" );
		}
	}
}

bool in_file( char* filename, int j )
{
	if ( j == 0 )
	{
		for ( int i = 0; i < firstfilecount; i++ )
		{
			if ( !stricmp( filename, firstfiles[i] ) )
			{
				return true;
			}
		}
		return false;
	}
	else
	{
		for ( int i = 0; i < secondfilecount; i++ )
		{
			if ( !stricmp( filename, secondfiles[i] ) )
			{
				return true;
			}
		}
		return false;
	}
}

int main(int argc, char* argv[])
{
	if (argc < 3)
	{
		printf("\n");
		printf("FindExtraFiles.exe, %s %s\n",__DATE__,__TIME__);
		printf("Parameter 1: full path name of first file of TXT file, incl. extension\n");
		printf("Parameter 2: full path name of second file of TXT file, incl. extension\n");
		exit(1);
	}

	Assert(argc == 3,"Too many arguments.");

	strcpy(FirstFileName, argv[1]);
	strcpy(SecondFileName, argv[2]);
	
	printf("FIRST: %s\n", FirstFileName);
	printf("SECOND: %s\n", SecondFileName);

	fstream first(FirstFileName, ios::in | ios::nocreate);
	if (!first)
		Assert(0, "couldn't open file %s\n", FirstFileName);

	while ( !first.eof() )
	{
		char msg[2048];
		first >> msg;
		add_to_list( msg, 0 );
	}

	fstream second(SecondFileName, ios::in | ios::nocreate);
	if (!second)
		Assert(0, "couldn't open file %s\n", SecondFileName);
	
	while ( !second.eof() )
	{
		char msg[2048];
		second >> msg;
		add_to_list( msg, 1 );
	}

	for ( int i = 0; i < firstfilecount; i++ )
	{
		if ( !in_file( firstfiles[i], 1 ) )
		{
			printf( "WARNING:  %s exists but is not used.\n", firstfiles[i], FirstFileName, SecondFileName );
		}
	}

	for ( i = 0; i < secondfilecount; i++ )
	{
		if ( !in_file( secondfiles[i], 0 ) )
		{
			printf( "WARNING:  %s used but doesn't exist.\n", secondfiles[i], FirstFileName, SecondFileName );
		}
	}

	return 0;
}
