/*
	ListView.h
	Management class for ListView controls

	1-7-01
*/

#ifndef LISTVIEW_H
#define LISTVIEW_H

#include <windows.h>
#include <commctrl.h>

class ListView
{
	HWND hwnd;		// The ListView window
	int  numCol;	// Number of columns in the ListView control
	int  numItems;	// Number of items in the ListView control

	int  curCol;	// The current column we're adding to
	int  curRow;	// The current row we're adding to

public:
	ListView(HWND hwnd);
	~ListView();

	bool  AddColumn(char* colName,int colWidth=100);
	int   AddItem(char* name,int rowIndex=-1);
	void  GetItem(int index,char* name,int size,int subitem=0);
	int   AddSubItem(char* name,int colIndex=-1,int rowIndex=-1);
	void  DeleteItem(int index);
	int   GetSel();
	int   GetSelCount();
	int   GetCount();
	int   GetNextItem(int lastindex,char* name,int size);
	void  Clear();

	void  SetItemData(int index,DWORD val);
	DWORD GetItemData(int index);

	int  HitTest(int x,int y);		// Retrieves the index at given client position

	void Select(int index);			// Selects an item
	bool IsSelected(int index);		// Retrieves item selection
};

#endif
