/*
	ListView.h
	Management class for ListView controls

	1-7-01
*/

#include "ListView.h"

ListView::ListView(HWND hwnd)
{
	this->hwnd=hwnd;

	numCol=0;
	numItems=0;
	curCol=0;
	curRow=0;

	// Send notification when the user clicks on an item
	ListView_SetExtendedListViewStyle(hwnd,LVS_EX_FULLROWSELECT|LVS_EX_HEADERDRAGDROP);
	//ListView_SetExtendedListViewStyle(hwnd,LVS_EX_ONECLICKACTIVATE);
}

ListView::~ListView()
{

}

bool ListView::AddColumn(char* colName,int colWidth)
{
	LVCOLUMN col;
	ZeroMemory(&col,sizeof(LVCOLUMN));
	col.mask=LVCF_TEXT|LVCF_WIDTH;
	col.cx  =colWidth;
	col.pszText=colName;
	col.cchTextMax=strlen(colName);

	if (ListView_InsertColumn(hwnd,numCol,&col)!=-1)
	{
		//ListView_SetColumnWidth(hwnd,numCol,LVSCW_AUTOSIZE_USEHEADER);
		//ListView_SetColumnWidth(hwnd,numCol,100);
		numCol++;
		return true;
	}

	return false;
}

int ListView::AddItem(char* name,int rowIndex)
{
	LVITEM item;
	ZeroMemory(&item,sizeof(LVITEM));
	item.mask=LVIF_TEXT|LVIF_PARAM;		// Param included to clear field
	item.pszText=name;
	item.cchTextMax=strlen(name);

	if (rowIndex==-1)
		rowIndex=numItems;

	item.iItem=rowIndex;

	curRow=ListView_InsertItem(hwnd,&item);
	curCol=1;
	numItems++;
	return curRow;
}

int ListView::AddSubItem(char* name,int colIndex,int rowIndex)
{
	LVITEM item;
	ZeroMemory(&item,sizeof(LVITEM));
	item.mask=LVIF_TEXT;	
	item.pszText=name;
	item.cchTextMax=strlen(name);

	if (rowIndex==-1)
		rowIndex=curRow;

	if (colIndex==-1)
		colIndex=curCol;

	item.iItem=rowIndex;
	item.iSubItem=colIndex;

	if (ListView_SetItem(hwnd,&item))
	{
		curCol=colIndex+1;
		return colIndex;
	}

	return -1;
}

int ListView::GetSel()
{
	return ListView_GetSelectionMark(hwnd);
}

void ListView::DeleteItem(int index)
{
	ListView_DeleteItem(hwnd,index);
}

void ListView::GetItem(int index,char* name,int size,int subitem)
{
	LVITEM item;

	ZeroMemory(&item,sizeof(LVITEM));
	item.mask=LVIF_TEXT;
	item.pszText=name;
	item.cchTextMax=size;
	item.iItem=index;
	item.iSubItem=subitem;

	ListView_GetItem(hwnd,&item);
}

int ListView::GetCount()
{
	return ListView_GetItemCount(hwnd);
}

int ListView::GetSelCount()
{
	return ListView_GetSelectedCount(hwnd);
}

bool ListView::IsSelected(int index)
{
	LVITEM item;
	ZeroMemory(&item,sizeof(LVITEM));
	item.mask=LVIF_STATE;
	item.iItem=index;
	item.state=0;
	item.stateMask=LVIS_SELECTED;

	ListView_GetItem(hwnd,&item);

	if (item.state & LVIS_SELECTED)
		return true;

	return false;
}

void ListView::Select(int index)
{
	ListView_SetItemState(hwnd,index,LVIS_SELECTED,LVIS_SELECTED);
}

int ListView::GetNextItem(int lastindex,char* name,int size)
{
	int index=ListView_GetNextItem(hwnd,lastindex,LVNI_SELECTED);

	if (index==-1)
		return -1;

	if (name)
		GetItem(index,name,size);

	return index;
}

void ListView::Clear()
{
	ListView_DeleteAllItems(hwnd);
}

int ListView::HitTest(int x,int y)
{
	LVHITTESTINFO htinfo;
	ZeroMemory(&htinfo,sizeof(LVHITTESTINFO));
	htinfo.pt.x=x;
	htinfo.pt.y=y;

	ListView_HitTest(hwnd,&htinfo);
	
	if (htinfo.flags==LVHT_ONITEMICON  ||
		htinfo.flags==LVHT_ONITEMLABEL ||
		htinfo.flags==LVHT_ONITEMSTATEICON)
	{
		return htinfo.iItem;
	}

	return -1;
}

void ListView::SetItemData(int index,DWORD val)
{
	LVITEM item;
	ZeroMemory(&item,sizeof(LVITEM));
	item.mask=LVIF_PARAM;
	item.iItem=index;
	item.lParam=(LPARAM)val;

	ListView_SetItem(hwnd,&item);
}

DWORD ListView::GetItemData(int index)
{
	LVITEM item;

	ZeroMemory(&item,sizeof(LVITEM));
	item.mask=LVIF_PARAM;
	item.iItem=index;

	ListView_GetItem(hwnd,&item);

	return item.lParam;
}
