#ifndef _UTILS_H_
#define _UTILS_H_

// Header files:
// -------------
#include <ngdev.h>
#include <ngos\netif.h>
#include <ngmdm.h>


// Macro definitions:
// ------------------
#define MAX_COUNTRY_INIT_STR		8
#define MAX_MODEM_FLAGS_STR			13
#define MAX_USER_INIT_STR				51
#define MAX_USERNAME_STR				49
#define MAX_PASSWORD_STR				17
#define MAX_DIAL_STR						137
#define MAX_HOST_STR						33
#define MAX_AC_SERV_STR					33


// Enumerated types:
// -----------------
enum {	// Indices into the connection speed string array...
	DCLAN_NOT_CONNECTED = 0,
	DCLAN_10MBPS_HALF,
	DCLAN_10MBPS_FULL,
	DCLAN_100MBPS_HALF,
	DCLAN_100MBPS_FULL,
	DCLAN_UNKNOWN,
};


// Function prototypes:
// --------------------
int		InitModemScript(NGmdmscript *);
int		SetupDialParams(int, char *, int);
int		SetupLoginParams(NGifnet *, int);
int		ConfigStaticDCLan(NGifnet *, Uint32);

#ifdef TR_USE_DHCP
void	ResetDhcpOptions(void);
void	AddDhcpOption(int, int, void *);
int   GetDhcpOption(int, void **);
int		ShutdownDhcp(NGifnet *, NGuint *);
#endif	// TR_USE_DHCP

void	InitDns(char *, NGuint, NGuint, NGuint, NGuint);
int		StoreModemConnectSpeed(void);
int		StoreSerialBaudRate(void);
int		GetDCLanConnectSpeed(void);
int		ResetExtModem(void);
int		ResetIntModem(int, int);
void	SetupSerialPort(void);

#endif	// _UTILS_H_