#ifndef _STATES_H_
#define _STATES_H_

// Enumerated types:
// -----------------
enum {	// Modem script states...
	TR_DIAL_SCR_CONNECTED				= 0x100,													// Modem connected (arbitrary value).
	TR_DIAL_SCR_ERR_NO_CARRIER	= TR_STATUS_ERR_SCR_NO_CARRIER,		// No carrier signal detected.
	TR_DIAL_SCR_ERR_NO_ANSWER		= TR_STATUS_ERR_SCR_NO_ANSWER,		// No answer from remote end.
	TR_DIAL_SCR_ERR_NO_DIALTONE	= TR_STATUS_ERR_SCR_NO_DIALTONE,	// No dial tone detected.
	TR_DIAL_SCR_ERR_LINE_BUSY		= TR_STATUS_ERR_SCR_LINE_BUSY,		// Line is busy (engaged?).
	TR_RAS_SCR_CONNECTED				= 0x200,													// RAS serial connected (arbitrary value).
};

enum {	// Current dial attempt...
	TR_DIAL_NONE = -1,
	TR_DIAL_PRIMARY,
	TR_DIAL_BACKUP1,
	TR_DIAL_BACKUP2,
};


// Public function prototypes:
// ---------------------------
void	StartDev(void);
void	StatePollDev(void);
int		StartPpp(void);
void	StatePollPpp(void);
void	StateResetDevice(void);
void	SetStackState(int);
void  SetDisconnectStatus(int);


// Global structure:
// -----------------
typedef struct trDialInfo {
	NetworkInfo3	*net_info;	// Pointer to the global network info initially passed in by application.
	int						attempt;		// Status of current dial attempt (TR_DIAL_XXX).
} TR_DIAL_INFO;

#endif	// _STATES_H_