#include <stdio.h>
#include "../pt.h"
#include "../../ghttp/ghttp.h"



#ifdef UNDER_CE
void RetailOutputA(char *tszErr, ...);
#define printf RetailOutputA
#endif

#define MRPANTS_UID       100001

#define GMTEST_PID        21
#define GMTEST_VID_0      "gmtest Alpha 0.01"
#define GMTEST_VID_1      "gmtest Alpha 0.02"
#define GMTEST_VID_2      "gmtest Beta 1"
#define GMTEST_VID_3      "gmtest Beta 2"
#define GMTEST_VID_4      "gmtest 1.0"
#define GMTEST_VID_5      "gmtest 1.1"
#define GMTEST_VID_6      "gmtest 2.0"

const char * BoolToString
(
	PTBool b
)
{
	if(b)
		return "Yes";
	return "No";
}

void PatchCallback
(
	PTBool available,
	PTBool mandatory,
	const char * versionName,
	int fileID,
	const char * downloadURL,
	void * param
)
{
	printf("available = %s\n", BoolToString(available));
	if(!available)
		return;
	printf("mandatory = %s\n", BoolToString(mandatory));
	printf("versionName = %s\n", versionName);
	printf("fileID = %d\n", fileID);
	printf("downloadURL = %s\n", downloadURL);
}

void FilePlanetInfoCallback
(
	int fileID,
	PTBool found,
	const char * description,
	const char * size,
	int numMirrors,
	const char ** mirrorNames,
	const char ** mirrorURLs,
	void * param
)
{
	int i;

	printf("fileID = %d\n", fileID);
	printf("found = %s\n", BoolToString(found));
	if(!found)
		return;
	printf("description = %s\n", description);
	printf("size = %s\n", size);
	printf("numMirrors = %d\n", numMirrors);
	for(i = 0 ; i < numMirrors ; i++)
	{
		printf("%2d: %s\n", i + 1, mirrorNames[i]);
		printf("    %s\n", mirrorURLs[i]);
	}
}

int main
(
	int argc,
	char ** argv
)
{
	if(!ptTrackUsage(MRPANTS_UID, GMTEST_PID, GMTEST_VID_1, 0, PTFalse))
		printf("Failed to track usage\n");

	if(!ptCheckForPatch(GMTEST_PID, GMTEST_VID_0, 0, PatchCallback, PTFalse, NULL))
		printf("Failed to check for patch\n");

	if(!ptLookupFilePlanetInfo(666, FilePlanetInfoCallback, PTFalse, NULL))
		printf("Failed to lookup file planet info\n");

	while(1)
	{
		ghttpThink();
		msleep(1);
	}

	return 0;
}