var GAMEID = 706;

var debug = new ActiveXObject("Statsmaster.DebugLog");
var it = new ActiveXObject("Statsmaster.IndexedTable");
var st = new ActiveXObject("Statsmaster.StringTable");
var fileSystem = new ActiveXObject("Scripting.FileSystemObject");
var WinHttpReq = new ActiveXObject("WinHttp.WinHttpRequest.5");
var plookup = new ActiveXObject("Statsmaster.PlayerInfoLookup");
var pastGames = new ActiveXObject("Statsmaster.PastGameResults");

var LOG_SUCCESS       = 0;
var LOG_ERROR         = 1;
var LOG_WARNING       = 2;
var LOG_INFORMATION   = 4;

var CAT_GENERAL				= 0
// Column enumeration
var COL_NUM_GAMES     		= 0;
var COL_RATING				= 1;
var COL_RATING_NICK			= 2;
var COL_BEST_SCORE			= 3;

// These column numbers are relative to the gametype column offsets above
var COL_HIGH_SCORE  		= 0;	
var COL_HIGH_COMBO  		= 1;
var COL_HIGH_SCORE_NICK		= 2;
var COL_HIGH_COMBO_NICK		= 3;

// Best day score columns
var COL_DAY_HIGH_SCORE 		= 0;	
var COL_DAY_HIGH_COMBO 		= 1;
var COL_DAY_HIGH_NICK		= 2;
var COL_DAY_HIGH_SCORE_LEVEL= 3;
var COL_DAY_HIGH_COMBO_LEVEL= 4;

//				 Load_NJ	 Load_NY	 Load_FL	 Load_SD	 Load_HI	 Load_VC	Load_SJ	   Load_RU	   Load_SE	   Load_VN	  Load_HN	  Load_SC2	 
var map_crcs = [ 0xf6c822d4, 0x7276630a, 0xd7720de9, 0xee1c63cf, 0x399bd4e8, 0xd0f0229, 0x9a44ec8, 0x9db7727c, 0x991b5359, 0x73be7e94, 0xa7ff414b, 0x8ca30405];
//					  nettrickattack	netgraffiti netscorechallenge	netcombomambo	netslap		netking		netgoalattack netctf	  netfirefight
var gametype_crcs = [ 0x30c2ffa3,		0x5e2ea50c, 0x1498240a, 		0xc50affd0,		0xf9d5d933, 0x6ef8fda0, 0xec200eaa,   0x6c5ff266, 0xbff33600 ];


function ClearProcessedResults()
{
	var games = pastGames.SearchPastResults(GAMEID, "processed = 1", 512, 0);
	var game;
	
	for( game = games.lbound() ; game < games.ubound() ; game++ )
	{
        result = games.getItem( game );
		
		var stage = result.GetProcessedStage();

		var textout = "Stage: " + stage + "\n";

		result.SetProcessedStage( 0 );
		pastGames.SavePastResults( result );
	}

	debug.LogString(GAMEID, LOG_INFORMATION, "Cleared processed flag");
}

function ClearTables()
{
	var row, rows, i;

	rows = it.GetRows( GAMEID, CAT_GENERAL, "c2", "c2", 500, 0 );
	for( row = rows.lbound(); row < rows.ubound(); row++ )
	{
		var name_idx;

		name_idx = rows.getItem( row );
		if( name_idx > 0 )
		{
			st.DelString( name_idx );
		}
	}
	it.DeleteCatagoryRows( GAMEID, CAT_GENERAL );

	for( i = 0; i < map_crcs.length; i++ )
	{
		cat = i + 1;
		rows = it.GetRows( GAMEID, cat, "c2, c3", "c2", 500, 0 );
		for(row = rows.lbound(2) ; row <= rows.ubound(2) ; row++)
		{
			idx = rows.getItem( 0, row );
			if( idx > 0 )
			{
				st.DelString( idx );
			}
			idx = rows.getItem( 1, row );
			if( idx > 0 )
			{
				st.DelString( idx );
			}
		}

		it.DeleteCatagoryRows( GAMEID, cat );
	}

	var day, day_cat;
	var date = new Date();
	var ms = date.getTime();

	day = (((( ms / 1000 ) / 60 ) / 60 ) / 24 );	// number of days since January 1, 1970
	day_cat = day;
	/*for( i = day_cat; i >= ( day_cat - 7 ); i-- )
	{
		rows = it.GetRows( GAMEID, day_cat, "c2", "c2", 500, 0 );
		for(row = rows.lbound() ; row <= rows.ubound() ; row++)
		{
			var str_idx;

			str_idx = rows.getItem( row );
			if( str_idx > 0 )
			{
				st.DelString( str_idx );
			}
		}
	}*/
	it.DeleteCatagoryRows( GAMEID, day_cat );

	debug.LogString(GAMEID, LOG_INFORMATION, "Cleared all categories");
}

function ClearHighScores()
{
	var i, day, day_cat;
	var date = new Date();
	var ms = date.getTime();
	var pid, row, index, name, score, count;

	debug.LogString(GAMEID, LOG_INFORMATION, "Clearing high scores...");

	day = Math.floor((((( ms / 1000 ) / 60 ) / 60 ) / 24 ));	// number of days since January 1, 1970
	day_cat = day;
	count = it.GetRowCountWhere( GAMEID, "catagoryid = " + CAT_GENERAL + " AND c0 > 0" );
	var rows = it.GetRows2( GAMEID, "profileid", "", "catagoryid = " + CAT_GENERAL + " AND c0 > 0", count, 0 );
	for( row = rows.lbound(2) ; row <= rows.ubound(2) ; row++)
	{
		pid = rows.getItem( 0, row );

		it.SetIntValue(GAMEID, pid, CAT_GENERAL, COL_BEST_SCORE, 0);
		
		for( i = day_cat; i >= ( day_cat - 7 ); i-- )
		{
			debug.LogString(GAMEID, LOG_INFORMATION, "Clearing scores for day " + i );

			it.SetIntValue(GAMEID, pid, i, COL_DAY_HIGH_SCORE, 0 );
			it.SetIntValue(GAMEID, pid, i, COL_DAY_HIGH_COMBO, 0 );
		}

		for( i = 0; i < map_crcs.length; i++ )
		{
			it.SetIntValue( GAMEID, pid, i + 1, COL_HIGH_COMBO, 0 );
			it.SetIntValue( GAMEID, pid, i + 1, COL_HIGH_SCORE, 0 );
		}
	}
	
	debug.LogString(GAMEID, LOG_INFORMATION, "...done" );
}

function ClearWeeklyHighScores()
{
	var i, day, day_cat;
	var date = new Date();
	var ms = date.getTime();
	
	debug.LogString(GAMEID, LOG_INFORMATION, "Clearing weekly high scores...");

	day = Math.floor((((( ms / 1000 ) / 60 ) / 60 ) / 24 ));	// number of days since January 1, 1970
	day_cat = day;
	for( i = day_cat; i >= ( day_cat - 7 ); i-- )
	{
		debug.LogString(GAMEID, LOG_INFORMATION, "Clearing scores for day " + i );

		it.DeleteCatagoryRows( GAMEID, i );
	}
	
	debug.LogString(GAMEID, LOG_INFORMATION, "...done" );
}
