/******
cengtest.c
GameSpy C Engine SDK
  
Copyright 1999-2001 GameSpy Industries, Inc

18002 Skypark Circle
Irvine, California 92614
949.798.4200 (Tel)
949.798.4299 (Fax)
devsupport@gamespy.com

******

 Please see the GameSpy C Engine SDK documentation for more 
 information

******/
#include "goaceng.h"
#include <stdio.h>
#include <string.h>
#if !defined(UNDER_CE) && !defined(__KATANA__)
#include <assert.h>
#else
#define assert(a)
#endif

#ifdef _WIN32_WCE
void RetailOutputA(char *tszErr, ...);
#define printf RetailOutputA
#endif

#ifdef __KATANA__
void NUMsg(char *in_format, ...);
#define printf NUMsg
	#ifdef KGTRN_PLANET_WEB
	#define NUM_SIMUL_QUERIES 10
	#else
	#define NUM_SIMUL_QUERIES 4
	#endif
#else
#define NUM_SIMUL_QUERIES 10
#endif


void ListCallBack1(GServerList serverlist, int msg, void *instance, void *param1, void *param2)
{
	GServer server;
	if (msg == LIST_PROGRESS)
	{
		server = (GServer)param1;
		printf("%s:%d [%d] %s %d/%d %s\n",ServerGetAddress(server),ServerGetQueryPort(server), ServerGetPing(server),ServerGetStringValue(server, "hostname","(NONE)"), ServerGetIntValue(server,"numplayers",0), ServerGetIntValue(server,"maxplayers",0), ServerGetStringValue(server,"mapname","(NO MAP)"));
	} else
	{
		printf("%d %d\n",msg,ServerListState(serverlist));
	}

}

void ListCallBackGroups(GServerList serverlist, int msg, void *instance, void *param1, void *param2)
{
	GServer server;
	if (msg == LIST_PROGRESS)
	{
		server = (GServer)param1;
		printf("[%d] %s %d/%d %d p on %d s\n",ServerGetIntValue(server,"groupid",0),ServerGetStringValue(server, "hostname","(NONE)"), ServerGetIntValue(server,"numwaiting",0), ServerGetIntValue(server,"maxwaiting",0), ServerGetIntValue(server,"numplayers",0), ServerGetIntValue(server,"numservers",0));
	} else
	{
		printf("%d %d\n",msg,ServerListState(serverlist));
	}

}


void sampleKeyEnumFn(char *key, char *value, void *instance)
{
	printf("\t%s: %s\n",key, value);

}

void ListCallBack2(GServerList serverlist, int msg, void *instance, void *param1, void *param2)
{
	GServer server;
	if (msg == LIST_PROGRESS)
	{
		server = (GServer)param1;
		printf("%s:%d| \n",ServerGetAddress(server),ServerGetQueryPort(server));
		ServerEnumKeys(server, sampleKeyEnumFn, NULL);
		printf("\n");
	}

}


void PrintServerList(GServerList sl)
{
	GServer server;
	int i;

	for (i = 0; i < ServerListCount(sl) ; i++)
	{
		server = ServerListGetServer(sl, i);
		assert(server != NULL);
		printf("%s:%d [%d] %s %d/%d %s\n",ServerGetAddress(server),ServerGetQueryPort(server), ServerGetPing(server),ServerGetStringValue(server, "hostname","(NONE)"), ServerGetIntValue(server,"numplayers",0), ServerGetIntValue(server,"maxplayers",0), ServerGetStringValue(server,"mapname","(NO MAP)"));
	}
	printf("\n\n\n");

}

#if defined(__KATANA__) || defined(__mips64)
int test_main(int argc, char **argp)
#else
int main(int argc, char **argp)
#endif
{

	GServerList sl;
	GError ret;

	sl = ServerListNew("ut","gmtest","HA6zkS",NUM_SIMUL_QUERIES,ListCallBack1,GCALLBACK_FUNCTION,NULL);
	
	ret = ServerListUpdate2(sl,0,NULL,qt_status);

	//sl = ServerListNew("daikatana","gmtest","HA6zkS",NUM_SIMUL_QUERIES,ListCallBackGroups,GCALLBACK_FUNCTION,NULL);
	//ServerListUpdate2(sl,0,NULL,qt_grouprooms);

	
	//ServerListLANUpdate(sl,0,5555, 5559,1);
	//ServerListUpdate2(sl,0,"gametype='CTFGame' and numplayers > 0", qt_info);

/*	PrintServerList(sl);
	ServerListSort(sl,1, "ping",cm_int);
	PrintServerList(sl);
	ServerListSort(sl,0, "ping",cm_int);
	PrintServerList(sl);
	ServerListSort(sl,1, "hostname",cm_stricase);
	PrintServerList(sl);
	ServerListSort(sl,0, "hostname",cm_stricase);
	PrintServerList(sl);
*/
	printf("ret: %d, %s\n",ret,ServerListErrorDesc(sl,ret));
	ServerListFree(sl);

	return 0;
}
