/* SCE CONFIDENTIAL
 "PlayStation 2" Programmer Tool Runtime Library Release 2.5
 */
/* 
 *      Netcnf Interface Library
 *
 *                         Version 1.2
 *                         Shift-JIS
 *
 *      Copyright (C) 2002 Sony Computer Entertainment Inc.
 *                        All Rights Reserved.
 *
 *                         netcnfif.h
 *
 *       Version        Date            Design      Log
 *  --------------------------------------------------------------------
 *       1.1            2002.01.28      tetsu       First version
 *       1.2            2002.02.10      tetsu       Add SCE_NETCNFIF_CHECK_ADDITIONAL_AT
 *                                                  Add sceNETCNFIF_TOO_LONG_STR
 */

#ifndef __netcnfif_common_h_
#define __netcnfif_common_h_

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Sifrpc p */
#define SCE_NETCNFIF_SSIZE     (4096)       /* Mf[^obt@̃TCY */
#define SCE_NETCNFIF_INTERFACE (0x80001101) /* NGXgʎq */

/* Sifrpc T[rX֐pԍ */
#define SCE_NETCNFIF_GET_COUNT           (0)   /* lbg[Nݒt@C̐擾 */
#define SCE_NETCNFIF_GET_LIST            (1)   /* lbg[Nݒt@C̃Xg擾 */
#define SCE_NETCNFIF_LOAD_ENTRY          (2)   /* lbg[Nݒt@C̓e擾 */
#define SCE_NETCNFIF_ADD_ENTRY           (3)   /* lbg[Nݒt@C̒ǉ */
#define SCE_NETCNFIF_EDIT_ENTRY          (4)   /* lbg[Nݒt@C̕ҏW */
#define SCE_NETCNFIF_DELETE_ENTRY        (5)   /* lbg[Nݒt@C̍폜 */
#define SCE_NETCNFIF_SET_LATEST_ENTRY    (6)   /* lbg[Nݒt@C̃XgҏW */
#define SCE_NETCNFIF_DELETE_ALL          (7)   /* Ȃ̃lbg[Nݒt@C폜 */
#define SCE_NETCNFIF_CHECK_CAPACITY      (8)   /* foCX̎ceʂ`FbN */
#define SCE_NETCNFIF_CHECK_ADDITIONAL_AT (9)   /* ǉ AT R}h`FbN */
#define SCE_NETCNFIF_GET_ADDR            (100) /* IOP ̎M̈(sceNetcnfifData)̃AhX擾 */
#define SCE_NETCNFIF_ALLOC_WORKAREA      (101) /* IOP ̃[NGAm */
#define SCE_NETCNFIF_FREE_WORKAREA       (102) /* IOP ̃[NGA */
#define SCE_NETCNFIF_SET_ENV             (103) /* IOP  sceNetCnfEnv ̈ sceNetcnfifData ̓eݒ */

/* G[R[h(-18 ܂ł netcnf.irx Ɠ) */
#define sceNETCNFIF_NG               (-1)   /* ̑̃G[ */
#define sceNETCNFIF_ALLOC_ERROR      (-2)   /* ̊mۂɎs */
#define sceNETCNFIF_OPEN_ERROR       (-3)   /* t@CJȂ */
#define sceNETCNFIF_READ_ERROR       (-4)   /* ǂݍ݂Ɏs */
#define sceNETCNFIF_WRITE_ERROR      (-5)   /* ݂Ɏs */
#define sceNETCNFIF_SEEK_ERROR       (-6)   /* t@CTCY擾Ɏs */
#define sceNETCNFIF_REMOVE_ERROR     (-7)   /* 폜Ɏs */
#define sceNETCNFIF_ENTRY_NOT_FOUND  (-8)   /* ݒ肪Ȃ */
#define sceNETCNFIF_INVALID_FNAME    (-9)   /* ݒǗt@C̃pXs */
#define sceNETCNFIF_INVALID_TYPE     (-10)  /* Ȃ̃lbg[Nݒt@C̎ނs */
#define sceNETCNFIF_INVALID_USR_NAME (-11)  /* ݒ薼s */
#define sceNETCNFIF_TOO_MANY_ENTRIES (-12)  /* ݒ萔ő吔ɒBĂ */
#define sceNETCNFIF_ID_ERROR         (-13)  /* ID 擾łȂ */
#define sceNETCNFIF_SYNTAX_ERROR     (-14)  /* ݒes */
#define sceNETCNFIF_MAGIC_ERROR      (-15)  /*  "PlayStation 2" ŕۑꂽݒ */
#define sceNETCNFIF_CAPACITY_ERROR   (-16)  /* foCX̎ceʂȂ */
#define sceNETCNFIF_UNKNOWN_DEVICE   (-17)  /* m̃foCXw肳Ă */
#define sceNETCNFIF_IO_ERROR         (-18)  /* IO G[ */
#define sceNETCNFIF_TOO_LONG_STR     (-19)  /* w肳ꂽ񂪒 */
#define sceNETCNFIF_NO_DATA          (-100) /* f[^ݒ肳ĂȂ */

/* Netcnf Interface ɕKvȃf[^ */
typedef struct sceNetcnfifArg{
    int data;               /* ̑̈/̑̕Ԃl */
    int f_no_decode;        /* no_decode tO */
    int type;               /* Ȃ̃lbg[Nݒt@C̎ */
    int addr;               /* EE ̎M̈̃AhX/IOP AhX̕Ԃl */
    char fname[256];        /* ݒǗt@C̃pX/ǉ AT R}h */
    char usr_name[256];     /* ݒ薼 */
    char new_usr_name[256]; /* Vݒ薼 */
} sceNetcnfifArg_t;

enum
{
    sceNetcnfifArg_f_no_decode_off, /* f_no_decode ݒ肵Ȃ */
    sceNetcnfifArg_f_no_decode_on   /* f_no_decode ݒ肷 */
};

enum
{
    sceNetcnfifArg_type_net, /* gݍ킹 */
    sceNetcnfifArg_type_ifc, /* ڑvoC_ݒ */
    sceNetcnfifArg_type_dev  /* ڑ@ݒ */
};

/* Ȃ̃lbg[Nݒt@C̃Xg */
typedef struct sceNetcnfifList{
    int type;           /* Ȃ̃lbg[Nݒt@C̎ */
    int stat;           /* t@CXe[^X */
    char sys_name[256]; /* t@C */
    char usr_name[256]; /* ݒ薼 */
    int p0[14];         /* \̈0 */
} sceNetcnfifList_t __attribute__((aligned(64)));

/* Ȃ̃lbg[Nݒt@Cɕۑf[^ */
typedef struct sceNetcnfifData{
    char attach_ifc[256];      /* ڑvoC_ݒt@C(net) */
    char attach_dev[256];      /* ڑ@ݒt@C(net) */
    char dhcp_host_name[256];  /* DHCPpzXg(ifc) */
    char address[256];         /* IPAhX(ifc) */
    char netmask[256];         /* lbg}XN(ifc) */
    char gateway[256];         /* ftHg[^(ifc) */
    char dns1_address[256];    /* vC}DNS(ifc) */
    char dns2_address[256];    /* ZJ_DNS(ifc) */
    char phone_numbers1[256];  /* ڑdbԍ1(ifc) */
    char phone_numbers2[256];  /* ڑdbԍ2(ifc) */
    char phone_numbers3[256];  /* ڑdbԍ3(ifc) */
    char auth_name[256];       /* [UID(ifc) */
    char auth_key[256];        /* pX[h(ifc) */
    char peer_name[256];       /* ڑ̔Fؖ(ifc) */
    char vendor[256];          /* x_(dev) */
    char product[256];         /* v_Ng(dev) */
    char chat_additional[256]; /* ǉATR}h(dev) */
    char outside_number[256];  /* OMԍݒ(ԍݒ蕔)(dev) */
    char outside_delay[256];   /* OMԍݒ(xݒ蕔)(dev) */
    int ifc_type;              /* foCXC̎(ifc) */
    int mtu;                   /* MTU̐ݒ(ifc) */
    int ifc_idle_timeout;      /* ؒfݒ(ifc) */
    int dev_type;              /* foCXC̎(dev) */
    int phy_config;            /* C[Tlbgڑ@̓샂[h(dev) */
    int dialing_type;          /* _CA@(dev) */
    int dev_idle_timeout;      /* ؒfݒ(dev) */
    int p0;                    /* \̈0 */
    unsigned char dhcp;        /* DHCPgpEsgp(ifc) */
    unsigned char dns1_nego;   /* DNST[oAhX擾EȂ(ifc) */
    unsigned char dns2_nego;   /* DNST[oAhX擾EȂ(ifc) */
    unsigned char f_auth;      /* Fؕ@̎wL(ifc) */
    unsigned char auth;        /* Fؕ@(ifc) */
    unsigned char pppoe;       /* PPPoEgpEsgp(ifc) */
    unsigned char prc_nego;    /* PFClSVG[V̋֎~(ifc) */
    unsigned char acc_nego;    /* ACFClSVG[V̋֎~(ifc) */
    unsigned char accm_nego;   /* ACCMlSVG[V̋֎~(ifc) */
    unsigned char p1;          /* \̈1 */
    unsigned char p2;          /* \̈2 */
    unsigned char p3;          /* \̈3 */
    int p4[5];                 /* \̈4 */
} sceNetcnfifData_t __attribute__((aligned(64)));

enum
{
    sceNetcnfifData_type_no_set = -1, /* ݒ肵Ȃ */
    sceNetcnfifData_type_eth = 1,     /* type eth */
    sceNetcnfifData_type_ppp,         /* type ppp */
    sceNetcnfifData_type_nic          /* type nic */
};

enum
{
    sceNetcnfifData_mtu_no_set = -1,   /* ݒ肵Ȃ */
    sceNetcnfifData_mtu_default = 1454 /* mtu 1454 */
};

enum
{
    sceNetcnfifData_idle_timeout_no_set = -1 /* ݒ肵Ȃ */
};

enum
{
    sceNetcnfifData_phy_config_no_set = -1, /* ݒ肵Ȃ */
    sceNetcnfifData_phy_config_auto = 1,    /* phy_config auto */
    sceNetcnfifData_phy_config_10,          /* phy_config 10 */
    sceNetcnfifData_phy_config_10_FD,       /* phy_config 10_fd */
    sceNetcnfifData_phy_config_TX = 5,      /* phy_config tx */
    sceNetcnfifData_phy_config_TX_FD        /* phy_config tx_fd */
};

enum
{
    sceNetcnfifData_dialing_type_no_set = -1, /* ݒ肵Ȃ */
    sceNetcnfifData_dialing_type_tone = 0,    /* dialing_type tone */
    sceNetcnfifData_dialing_type_pulse        /* dialing_type pulse */
};

enum
{
    sceNetcnfifData_dhcp_no_set = 0xff, /* ݒ肵Ȃ */
    sceNetcnfifData_dhcp_no_use = 0,    /* -dhcp */
    sceNetcnfifData_dhcp_use            /* dhcp */
};

enum
{
    sceNetcnfifData_dns_nego_no_set = 0xff, /* ݒ肵Ȃ */
    sceNetcnfifData_dns_nego_on = 1         /* want.dns1_nego/want.dns2_nego */
};

enum
{
    sceNetcnfifData_f_auth_off, /* allow.auth chap/pap ݒ肵Ȃ */
    sceNetcnfifData_f_auth_on   /* allow.auth chap/pap ݒ肷 */
};

enum
{
    sceNetcnfifData_auth_chap_pap = 4 /* allow.auth chap/pap */
};

enum
{
    sceNetcnfifData_pppoe_no_set = 0xff, /* ݒ肵Ȃ */
    sceNetcnfifData_pppoe_use = 1        /* pppoe */
};

enum
{
    sceNetcnfifData_prc_nego_no_set = 0xff, /* ݒ肵Ȃ */
    sceNetcnfifData_prc_nego_off = 0        /* -want.prc_nego */
};

enum
{
    sceNetcnfifData_acc_nego_no_set = 0xff, /* ݒ肵Ȃ */
    sceNetcnfifData_acc_nego_off = 0        /* -want.acc_nego */
};

enum
{
    sceNetcnfifData_accm_nego_no_set = 0xff, /* ݒ肵Ȃ */
    sceNetcnfifData_accm_nego_off = 0        /* -want.accm_nego */
};

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /*__netcnfif_common_h_ */
