/*****************************************************************************
**																			**
**					   	  Neversoft Entertainment							**
**																		   	**
**				   Copyright (C) 1999 - All Rights Reserved				   	**
**																			**
******************************************************************************
**																			**
**	Project:		GEL (Game Engine Library)								**
**																			**
**	Module:			Game Engine												**
**																			**
**	File name:		p_soundtrack.h											**
**																			**
**	Created: 		11/29/2001	-	dc										**
**																			**
*****************************************************************************/

#ifndef __MODULES_P_SOUNDTRACK_H
#define __MODULES_P_SOUNDTRACK_H

/*****************************************************************************
**							  	  Includes									**
*****************************************************************************/

#ifndef __CORE_DEFINES_H
#include <core/defines.h>
#endif
 
/*****************************************************************************
**								   Defines									**
*****************************************************************************/

namespace Pcm
{


/*****************************************************************************
**							Class Definitions								**
*****************************************************************************/


/*****************************************************************************
**							 Private Declarations							**
*****************************************************************************/


/*****************************************************************************
**							  Private Prototypes							**
*****************************************************************************/


/*****************************************************************************
**							  Public Declarations							**
*****************************************************************************/

int				GetNumSoundtracks( void );
const WCHAR*	GetSoundtrackName( int soundtrack );
unsigned int	GetSoundtrackNumSongs( int soundtrack );
const WCHAR*	GetSongName( int soundtrack, int track );
HANDLE			GetSoundtrackWMAHandle( int soundtrack, int track );


/*****************************************************************************
**							   Public Prototypes							**
*****************************************************************************/


/*****************************************************************************
**								Inline Functions							**
*****************************************************************************/

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

} // namespace Pcm

#endif	// __MODULES_P_SOUNDTRACK_H
