/*****************************************************************************
**																			**
**					   	  Neversoft Entertainment							**
**																		   	**
**				   Copyright (C) 1999 - All Rights Reserved				   	**
**																			**
******************************************************************************
**																			**
**	Project:		Core Library											**
**																			**
**	Module:			Debug (Dbg_)											**
**																			**
**	File name:		core/debug/signatrs.h									**
**																			**
**	Created:		05/27/99	-	mjb										**
**																			**
*****************************************************************************/

#ifndef __CORE_DEBUG_SIGNATRS_H
#define __CORE_DEBUG_SIGNATRS_H

#ifdef __NOPT_DEBUG__

/*****************************************************************************
**							  	  Includes									**
*****************************************************************************/


/*****************************************************************************
**								   Defines									**
*****************************************************************************/

namespace Dbg
{

/*****************************************************************************
**							     Type Defines								**
*****************************************************************************/

class Module;

class Signature
{

public :
							Signature( char* name, const Module& module );
							Signature( const char* cl, char* name, const Module& module );

	const char&				GetName( void ) const ;
		
private :

	char*					m_name;			// function's name
	const Module&			m_module;		// function's module
};

/*****************************************************************************
**							  Private Prototypes							**
*****************************************************************************/


/*****************************************************************************
**							  Public Declarations							**
*****************************************************************************/


/*****************************************************************************
**							   Public Prototypes							**
*****************************************************************************/


/*****************************************************************************
**									Macros									**
*****************************************************************************/


/*****************************************************************************
**								Inline Functions							**
*****************************************************************************/

inline	Signature::Signature( char* name, const Module& module )
:	m_name ( name ), 
	m_module ( module )
{

}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

inline	const char&	Signature::GetName( void ) const
{

	return *m_name;
}

} // namespace Dbg

/*****************************************************************************
**							 Private Declarations							**
*****************************************************************************/

#ifdef __PLAT_NGC__
extern		Dbg::Module&	Dbg_module;
extern		Dbg::Signature	Dbg_signature;
#endif

#ifndef __NOPT_STRICT_SIGNATURES__

extern		Dbg::Module&	Dbg_module;
extern		Dbg::Signature	Dbg_signature;

#endif

#endif	// __NOPT_DEBUG__

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

#endif	// __CORE_DEBUG_SIGNATRS_H
