#ifndef __LLIST__
#define __LLIST__

#include <assert.h>

template <class T>
struct Link
{
	T data;
	Link<T>* next;
	Link<T>* prev;
};

template <class T>
class LinkList
{
	Link<T>* head;
	Link<T>* tail;
	int      count;
	Link<T>* curpos;
	int      curposIndex;

public:
	LinkList()
	{
		curpos=head=tail=0;
		count=curposIndex=0;
	}

	void Clear()
	{
		Link<T>* CurLink=head;
		Link<T>* tmpLink;

		while(CurLink)
		{
			tmpLink=CurLink->next;
			delete CurLink;
			CurLink=tmpLink;
		}

		head=tail=0;
		count=0;
	}

	~LinkList()
	{
		Clear();
	}

	inline Link<T>* GetHead() { return head;  }
	inline Link<T>* GetTail() { return tail;  }
	inline int      GetSize() { return count; }

	Link<T>* AddToTail(T* item)
	{
		Link<T>* newLink=new Link<T>;
		newLink->data=*item;
		newLink->prev=tail;
		newLink->next=0;

		if (head==0)
			head=newLink;

		if (tail)
			tail->next=newLink;

		tail=newLink;
		count++;

		return newLink;
	}

	Link<T>* AddToTail()
	{
		Link<T>* newLink=new Link<T>;
		newLink->prev=tail;
		newLink->next=0;

		if (head==0)
			head=newLink;

		if (tail)
			tail->next=newLink;

		tail=newLink;
		count++;

		return newLink;
	}

	Link<T>* AddToTailUnique(T* item)
	{
		Link<T>* curlink=head;

		while(curlink)
		{
			if (curlink->data==*item)
				return 0;

			curlink=curlink->next;
		}

		return AddToTail(item);
	}

	inline Link<T>* AddUnique(T* item)
	{
		return AddToTailUnique(item);
	}

	inline Link<T>* Add(T* item)
	{
		return AddToTail(item);
	}

	inline Link<T>* Add()
	{
		return AddToTail();
	}

	Link<T>* AddToHead(T* item)
	{
		Link<T>* newLink=new Link<T>;
		newLink->data=*item;
		newLink->prev=0;
		newLink->next=head;

		if (tail=0)
			tail=newLink;

		if (head)
			head->prev=newLink;

		head=newLink;
		count++;

		return newLink;
	}

	void Remove(Link<T>* link)	
	{
		count--;

		// Link is head
		if (link==head)
		{
			if (link==tail)
			{
				head=0;
				tail=0;
				delete link;
				return;
			}
			
			head=link->next;
			link->next->prev=0;
			delete link;
			return;
		}

		// Link is middle
		if (link!=head && link!=tail)
		{
			link->next->prev=link->prev;
			link->prev->next=link->next;
			delete link;
		}

		// Link is tail
		if (link==tail)
		{
			tail=link->prev;
			link->prev->next=0;
			delete link;
		}
	}

	T& operator[] (int i)
	{
		curpos=head;

		for(int j=0;j<i;j++)
			curpos=curpos->next;

		return curpos->data;
	}

	/*
	T& operator[] (int i)
	{
		if (curpos==0)
		{
			curpos=head;
			curposIndex=0;
		}

		assert(curpos!=0);

		if (curposIndex<i)
		{
			int dist=i-curposIndex;

			for(int j=0;j<dist;j++)
			{
				curpos=curpos->next;
				assert(curpos!=0);
			}

			curposIndex=i;
			return curpos->data;
		}

		if (curposIndex>i)
		{
			int dist=curposIndex-i;

			for(int j=0;j<dist;j++)
			{
				curpos=curpos->prev;
				assert(curpos!=0);
			}

			curposIndex=i;
			return curpos->data;
		}

		// curposIndex==i
		return curpos->data;
	}
	*/
};

#endif
