#include <stdio.h>
#include <memory.h>
#include <assert.h>

bool	gTextOutput			= true;
bool	gStraightConversion	= true;
FILE*	f;
FILE*	of;
char	textureName[512];
char	textureMaskName[512];

char *rwName[] =
{
    "rwID_NAOBJECT",
    "rwID_STRUCT",
    "rwID_STRING",
    "rwID_EXTENSION",
	"<bad chunk>",
    "rwID_CAMERA",
    "rwID_TEXTURE",
    "rwID_MATERIAL",
    "rwID_MATLIST",
    "rwID_ATOMICSECT",
    "rwID_PLANESECT",
    "rwID_WORLD",
    "rwID_SPLINE",
    "rwID_MATRIX",
    "rwID_FRAMELIST",
    "rwID_GEOMETRY",
    "rwID_CLUMP",
	"<bad chunk>",
    "rwID_LIGHT",
    "rwID_UNICODESTRING",
    "rwID_ATOMIC",
    "rwID_TEXTURENATIVE",
    "rwID_TEXDICTIONARY",
    "rwID_ANIMDATABASE",
    "rwID_IMAGE",
    "rwID_SKINANIMATION",
    "rwID_GEOMETRYLIST",
    "rwID_HANIMANIMATION",
    "rwCOREPLUGINIDFORCEENUMSIZEINT",
};

typedef unsigned int D3DCOLOR;
typedef unsigned int uint32;

typedef enum RwPlatformID
{
    rwID_PCDX7 = 1,
    rwID_PCOGL,
    rwID_MAC,
    rwID_PS2,
    rwID_XBOX,
    rwID_GAMECUBE,
};

typedef enum RwCorePluginID
{
    rwID_NAOBJECT               = 0x00,
    rwID_STRUCT                 = 0x01,
    rwID_STRING                 = 0x02,
    rwID_EXTENSION              = 0x03,
    rwID_CAMERA                 = 0x05,
    rwID_TEXTURE                = 0x06,
    rwID_MATERIAL               = 0x07,
    rwID_MATLIST                = 0x08,
    rwID_ATOMICSECT             = 0x09,
    rwID_PLANESECT              = 0x0A,
    rwID_WORLD                  = 0x0B,
    rwID_SPLINE                 = 0x0C,
    rwID_MATRIX                 = 0x0D,
    rwID_FRAMELIST              = 0x0E,
    rwID_GEOMETRY               = 0x0F,
    rwID_CLUMP                  = 0x10,
    rwID_LIGHT                  = 0x12,
    rwID_UNICODESTRING          = 0x13,
    rwID_ATOMIC                 = 0x14,
    rwID_TEXTURENATIVE          = 0x15,
    rwID_TEXDICTIONARY          = 0x16,
    rwID_ANIMDATABASE           = 0x17,
    rwID_IMAGE                  = 0x18,
    rwID_SKINANIMATION          = 0x19,
    rwID_GEOMETRYLIST           = 0x1A,
    rwID_HANIMANIMATION         = 0x1B,

	rwID_MAX					= 0x1B
//    rwCOREPLUGINIDFORCEENUMSIZEINT = RWFORCEENUMSIZEINT
};


typedef enum RwRasterFormat
{
    rwRASTERFORMATDEFAULT = 0x0000, /* Whatever the hardware likes best */

    rwRASTERFORMAT1555 = 0x0100,    /**<16 bits ! 1 bit alpha, 5 bits red, green and blue */
    rwRASTERFORMAT565 = 0x0200,     /**<16 bits ! 5 bits red and blue, 6 bits green */
    rwRASTERFORMAT4444 = 0x0300,    /**<16 bits ! 4 bits per component */
    rwRASTERFORMATLUM8 = 0x0400,    /**<Gray scale */
    rwRASTERFORMAT8888 = 0x0500,    /**<32 bits ! 8 bits per component */
    rwRASTERFORMAT888 = 0x0600,     /**<24 bits ! 8 bits per component */
    rwRASTERFORMAT16 = 0x0700,      /**<16 bits - undefined: useful for things like Z buffers */
    rwRASTERFORMAT24 = 0x0800,      /**<24 bits - undefined: useful for things like Z buffers */
    rwRASTERFORMAT32 = 0x0900,      /**<32 bits - undefined: useful for things like Z buffers */
    rwRASTERFORMAT555 = 0x0a00,     /**<16 bits ! 5 bits red, green and blue */

    /* Combine the palettised flags with a raster format
     * from above to define the format of the palette
     */

    rwRASTERFORMATAUTOMIPMAP = 0x1000, /**<RenderWare generated the mip levels */

    rwRASTERFORMATPAL8 = 0x2000,    /**<8 bit palettised */
    rwRASTERFORMATPAL4 = 0x4000,    /**<4 bit palettised */

    rwRASTERFORMATMIPMAP = 0x8000,  /**<Mip mapping on */

    rwRASTERFORMATPIXELFORMATMASK = 0x0f00, /**<The format (excluding palettised bits) */
    rwRASTERFORMATMASK = 0xff00     /**<The whole format thing */ ,
};



typedef struct
{
	char type;
	char pad[3];
	unsigned int length;
	RwCorePluginID version;
} RWChunk;

typedef struct {
    int				width, height, depth;
    unsigned short	format;
    unsigned short	version;
    unsigned int	lsb, msb;
    unsigned int	palOffset;
    unsigned int	maxMipLevel;
    unsigned int	miptbp1Lsb, miptbp1Msb;
    unsigned int	miptbp2Lsb, miptbp2Msb;
    unsigned int	sysMemSize;
    unsigned int	sysMemPalSize;
    unsigned int	texCacheSize;
    unsigned int	mipmapKL; /* Was mipmapK. This should be compatible */
} RWTexInfo;

typedef struct __rwSkyNativeTexture
{
	unsigned char	id[4];
    uint32			filterAndAddress;
} RWSkyNativeTexture;

static void seek( FILE* f, unsigned int length )
{
	fseek( f, length, SEEK_CUR );
}


static void report( RWChunk *p )
{
	if( gTextOutput )
	{
		printf ( "Type: %d - %s\nLength: %d (0x%x)\nVersion: %x\nFilePos: %d\n", p->type, rwName[p->type], p->length, p->length, p->version, ftell ( f ) );
	}
}

static void _flip ( unsigned char * p )
{
	unsigned char c;

	c = p[0];
	p[0] = p[3];
	p[3] = c;
	c = p[1];
	p[1] = p[2];
	p[2] = c;
}

static void flipFloat( float * p )
{
	_flip ( (unsigned char *) p );
}

static void flipInt( unsigned int * p )
{
	_flip ( (unsigned char *) p );
}

static void flipShort( unsigned short * p16 )
{
	unsigned char c;
	unsigned char * p;

	p = (unsigned char *)p16;

	c = p[0];
	p[0] = p[1];
	p[1] = c;
}

static void writeInt( FILE *f, unsigned int i )
{
	unsigned int ti = i;

	flipInt ( &ti );
	fwrite ( &ti, 4, 1, f );
}

static void writeShort( FILE *f, unsigned short i )
{
	unsigned short ti = i;

	flipShort ( &ti );
	fwrite ( &ti, 4, 1, f );
}

static void writeFloat( FILE *f, float fl )
{
	float tf = fl;

	flipFloat ( &tf );
	fwrite ( &tf, 4, 1, f );
}



static writeXboxNativeHeader( RWSkyNativeTexture* p_native_info, RWTexInfo* p_tex_info )
{
	uint32	out32;
	char	out8;
	char	name[128];
	char	maskname[128];

	// Current format is:
	// int32	id					must be rwID_XBOX
	// int32	filterandaddress
	// char		name[128]
	// char		maskname[128]
	// int32	width
	// int32	height
	// int32	format
	// uint8	depth	
	// uint8	num mip levels
	// uint8	pad[2]
	out32 = rwID_XBOX;
	fwrite( &out32, 4, 1, of );

	out32 = p_native_info->filterAndAddress;
	fwrite( &out32, 4, 1, of );
	
	fwrite( textureName, 128, 1, of );
	fwrite( textureMaskName, 128, 1, of );

	out32 = p_tex_info->width;
	fwrite( &out32, 4, 1, of );

	out32 = p_tex_info->height;
	fwrite( &out32, 4, 1, of );

	out32 = p_tex_info->format;
	if( p_tex_info->depth == 4 )
	{
		out32 &= ~rwRASTERFORMATMASK;
		out32 |= rwRASTERFORMAT8888 | rwRASTERFORMATPAL4;
	}
	else if( p_tex_info->depth == 8 )
	{
		out32 &= ~rwRASTERFORMATMASK;
		out32 |= rwRASTERFORMAT8888 | rwRASTERFORMATPAL8;
	}

	fwrite( &out32, 4, 1, of );

	out8 = p_tex_info->depth;
	fwrite( &out8, 1, 1, of );

//	out8 = p_tex_info->maxMipLevel;
	out8 = 1;
	fwrite( &out8, 1, 1, of );

	out8 = 0;
	fwrite( &out8, 1, 1, of );
	fwrite( &out8, 1, 1, of );
}


void writeXbox4BitTexture( RWTexInfo* p_tex_info, unsigned short* pPaletteData, unsigned char* pPixelData4 )
{
	// Smallest pallete is 32 entry.
	D3DCOLOR palette[32];

	// TODO: Deal with 32bit palettes.
	for( int i = 0; i < 32; ++i )
	{
		if( i < 16 )
		{
			uint32 red = pPaletteData[i] & 0x1F;			
			uint32 grn = ( pPaletteData[i] >> 5 ) & 0x1F;			
			uint32 blu = ( pPaletteData[i] >> 10 ) & 0x1F;			
			palette[i] = ( red << 3 ) | ( grn << 11 ) | ( blu << 19 ) | 0xFF000000UL;
		}
		else
		{
			palette[i] = 0;
		}
	}	
	fwrite( palette, 4, 32, of );

	// Write out the raw image data, assuming only 1 mip level for now.
	int size = p_tex_info->width * p_tex_info->height / 2;
	fwrite( &size, 4, 1, of );
	fwrite( pPixelData4, 1, size, of );
}





void writeXbox8BitTexture( RWTexInfo* p_tex_info, unsigned short* pPaletteData, unsigned char* pPixelData8 )
{
	D3DCOLOR palette[256];

	// TODO: Deal with 32bit palettes.
	for( int i = 0; i < 256; ++i )
	{
		uint32 red = pPaletteData[i] & 0x1F;			
		uint32 grn = ( pPaletteData[i] >> 5 ) & 0x1F;			
		uint32 blu = ( pPaletteData[i] >> 10 ) & 0x1F;			
		palette[i] = ( red << 3 ) | ( grn << 11 ) | ( blu << 19 ) | 0xFF000000UL;
	}	
	fwrite( palette, 4, 256, of );

	// Write out the raw image data, assuming only 1 mip level for now.
	int size = p_tex_info->width * p_tex_info->height;
	fwrite( &size, 4, 1, of );
	fwrite( pPixelData8, 1, size, of );
}


void writeXbox16BitTexture( RWTexInfo* p_tex_info, unsigned short* pPixelData16 )
{
	// Write out the raw image data, assuming only 1 mip level for now.
	int size = p_tex_info->width * p_tex_info->height * 2;
	fwrite( &size, 4, 1, of );
	fwrite( pPixelData16, 1, size, of );
}

void writeXbox32BitTexture( RWTexInfo* p_tex_info, unsigned int* pPixelData32 )
{
	// Write out the raw image data, assuming only 1 mip level for now.
	int size = p_tex_info->width * p_tex_info->height * 4;
	fwrite( &size, 4, 1, of );
	fwrite( pPixelData32, 1, size, of );
}


int main(int argc, char* argv[])
{
	unsigned int*	pPixelData32;
	unsigned short*	pPixelData16;
	unsigned short*	p16;
	unsigned char*	pPixelData8;
	unsigned char*	p8;
	unsigned char*	pPixelData4;
	unsigned char*	p4;
	unsigned short*	pPaletteData;
	unsigned int	numTex = 0;
	int				lp, lp2;
	RWChunk			chunk;
	RWTexInfo		texInfo;

	// Check we've got a file to convert.
	if( argc < 3 )
	{
		printf ( "Must use as TexConv [input] [output]\n" );
		return 1;
	}

	printf( "TexConv - Convert RenderWare PS2 specific .tex files to Xbox .txx files\n" );	

	// Open the file we're interested in.
	f	= fopen( argv[1], "rb" );
	of	= fopen( argv[2], "wb" );

	// Find all chunks.
	while( fread( &chunk, 12, 1, f ))
	{
		unsigned int countSkip;

		// Seek until we find a valid chunk.
		countSkip = 0;
		while(( chunk.version != 0x310 ) || ( chunk.type > rwID_MAX ))
		{
			p8 = (unsigned char *)&chunk;
			memcpy ( &p8[0], &p8[1], 11 );
			fread( &p8[11], 1, 1, f );
			countSkip++;
		}

		if( countSkip ) printf ( "<<<<< bump %d >>>>>\n", countSkip );

		// Deal with the chunk we just read.
		switch( chunk.type )
		{
			case rwID_TEXDICTIONARY:
			{
				// Skip the first structure.
				if( gStraightConversion ) { fwrite( &chunk, 12, 1, of ); }
				report( &chunk );

				fread( &chunk, 12, 1, f );
				if( gStraightConversion ) { fwrite( &chunk, 12, 1, of ); }

				fread( &numTex, chunk.length, 1, f );
				if( gStraightConversion ) { fwrite( &numTex, chunk.length, 1, of ); }

				printf( "Number of textures: %d\n", numTex );
				report( &chunk );
				break;
			}

			case rwID_TEXTURENATIVE:
			{
				// If we get to this point, should have set numTex by now.
				assert( numTex > 0 );

				for( int texture = 0; texture < numTex; texture++ )
				{
					// Skip the first structure.
					if( gStraightConversion ) { fwrite( &chunk, 12, 1, of ); }
					report( &chunk );

					fread( &chunk, 12, 1, f );		// STRUCT (this is the native PS2 texture info)
					if( gStraightConversion ) { fwrite( &chunk, 12, 1, of ); }
					RWSkyNativeTexture sky_native_texture;
					fread( &sky_native_texture, chunk.length, 1, f );
					report( &chunk );

					fread( &chunk, 12, 1, f );		// STRING (texture name).
					report( &chunk );

					memset( textureName, 0, 128 );
					memset( textureMaskName, 0, 128 );

					fread( textureName, chunk.length, 1, f );
					printf ( "Texture name: %s\n", textureName );

					fread( &chunk, 12, 1, f );		// STRING
					report( &chunk );

					fread( textureMaskName, chunk.length, 1, f );
					printf ( "Texture mask name: %s\n", textureMaskName );

					fread( &chunk, 12, 1, f );		// STRUCT
					report( &chunk );
					fread( &chunk, 12, 1, f );		// STRUCT
					fread( &texInfo, sizeof ( RWTexInfo ), 1, f );
					report( &chunk );
					printf ( "***** > Texture %d of %d\n***** > Width: %d\n***** > Height: %d\n***** > Depth: %d\n", texture + 1, numTex, texInfo.width, texInfo.height, texInfo.depth );	
					fread( &chunk, 12, 1, f );		// STRUCT - pixel data.

					// Write out the Xbox native header. This includes everything up to the actual palette data.
					writeXboxNativeHeader( &sky_native_texture, &texInfo );

					switch( texInfo.depth )
					{
						case 4:
						{
							pPixelData4 = new unsigned char [texInfo.sysMemSize];
							pPaletteData = new unsigned short [texInfo.sysMemPalSize];
							if( pPixelData4 && pPaletteData )
							{
								// Read the pixel data.
								fread( pPixelData4, texInfo.sysMemSize, 1, f );

								// Read the palette data.
								fread( pPaletteData, texInfo.sysMemPalSize, 1, f );

								writeXbox4BitTexture( &texInfo, pPaletteData, pPixelData4 );

								delete [] pPixelData4;
								delete [] pPaletteData;

								// Skip any extra data. Not sure why yet...
								//seek ( f, chunk.length - ( ( texInfo.width * texInfo.height ) + ( 256 * 4 ) ) );
							}
							break;
						}

						case 8:
						{
							pPixelData8 = new unsigned char [texInfo.sysMemSize];
							pPaletteData = new unsigned short [texInfo.sysMemPalSize];
							if( pPixelData8 && pPaletteData )
							{
								// Read the pixel data.
								fread( pPixelData8, texInfo.sysMemSize, 1, f );

								// Read the palette data.
								fread( pPaletteData, texInfo.sysMemPalSize, 1, f );

								writeXbox8BitTexture( &texInfo, pPaletteData, pPixelData4 );

#								if 0
								// Convert from basic PS2 format to funky GC format.
								// GC format is like this:

								// 00 01 02 03 04 05 06 07 | 32 33 34 35 36 37 38 39 |
								// 08 09 10 11 12 13 14 15 | 40 41 42 43 44 45 46 47 |
								// 16 17 18 19 20 21 22 23 | 48 49 50 51 52 53 54 55 |
								// 24 25 26 27 28 29 30 31 | 56 57 58 59 60 61 62 63 | ...and so on...
								p8 = new unsigned char [texInfo.width * texInfo.height];
								if( p8 )
								{
									for( lp = 0; lp < texInfo.height; lp += 4 )
									{
										for ( lp2 = 0; lp2 < texInfo.width; lp2 += 8 )
										{
											p8[ 0+(lp2*4)+(lp*texInfo.width)] = pPixelData8[0+(texInfo.width*0)+lp2+(lp*texInfo.width)];
											p8[ 1+(lp2*4)+(lp*texInfo.width)] = pPixelData8[1+(texInfo.width*0)+lp2+(lp*texInfo.width)];
											p8[ 2+(lp2*4)+(lp*texInfo.width)] = pPixelData8[2+(texInfo.width*0)+lp2+(lp*texInfo.width)];
											p8[ 3+(lp2*4)+(lp*texInfo.width)] = pPixelData8[3+(texInfo.width*0)+lp2+(lp*texInfo.width)];
											p8[ 4+(lp2*4)+(lp*texInfo.width)] = pPixelData8[4+(texInfo.width*0)+lp2+(lp*texInfo.width)];
											p8[ 5+(lp2*4)+(lp*texInfo.width)] = pPixelData8[5+(texInfo.width*0)+lp2+(lp*texInfo.width)];
											p8[ 6+(lp2*4)+(lp*texInfo.width)] = pPixelData8[6+(texInfo.width*0)+lp2+(lp*texInfo.width)];
											p8[ 7+(lp2*4)+(lp*texInfo.width)] = pPixelData8[7+(texInfo.width*0)+lp2+(lp*texInfo.width)];

											p8[ 8+(lp2*4)+(lp*texInfo.width)] = pPixelData8[0+(texInfo.width*1)+lp2+(lp*texInfo.width)];
											p8[ 9+(lp2*4)+(lp*texInfo.width)] = pPixelData8[1+(texInfo.width*1)+lp2+(lp*texInfo.width)];
											p8[10+(lp2*4)+(lp*texInfo.width)] = pPixelData8[2+(texInfo.width*1)+lp2+(lp*texInfo.width)];
											p8[11+(lp2*4)+(lp*texInfo.width)] = pPixelData8[3+(texInfo.width*1)+lp2+(lp*texInfo.width)];
											p8[12+(lp2*4)+(lp*texInfo.width)] = pPixelData8[5+(texInfo.width*1)+lp2+(lp*texInfo.width)];
											p8[13+(lp2*4)+(lp*texInfo.width)] = pPixelData8[6+(texInfo.width*1)+lp2+(lp*texInfo.width)];
											p8[14+(lp2*4)+(lp*texInfo.width)] = pPixelData8[7+(texInfo.width*1)+lp2+(lp*texInfo.width)];
											p8[15+(lp2*4)+(lp*texInfo.width)] = pPixelData8[8+(texInfo.width*1)+lp2+(lp*texInfo.width)];

											p8[16+(lp2*4)+(lp*texInfo.width)] = pPixelData8[0+(texInfo.width*2)+lp2+(lp*texInfo.width)];
											p8[17+(lp2*4)+(lp*texInfo.width)] = pPixelData8[1+(texInfo.width*2)+lp2+(lp*texInfo.width)];
											p8[18+(lp2*4)+(lp*texInfo.width)] = pPixelData8[2+(texInfo.width*2)+lp2+(lp*texInfo.width)];
											p8[19+(lp2*4)+(lp*texInfo.width)] = pPixelData8[3+(texInfo.width*2)+lp2+(lp*texInfo.width)];
											p8[20+(lp2*4)+(lp*texInfo.width)] = pPixelData8[4+(texInfo.width*2)+lp2+(lp*texInfo.width)];
											p8[21+(lp2*4)+(lp*texInfo.width)] = pPixelData8[5+(texInfo.width*2)+lp2+(lp*texInfo.width)];
											p8[22+(lp2*4)+(lp*texInfo.width)] = pPixelData8[6+(texInfo.width*2)+lp2+(lp*texInfo.width)];
											p8[23+(lp2*4)+(lp*texInfo.width)] = pPixelData8[7+(texInfo.width*2)+lp2+(lp*texInfo.width)];

											p8[24+(lp2*4)+(lp*texInfo.width)] = pPixelData8[0+(texInfo.width*3)+lp2+(lp*texInfo.width)];
											p8[25+(lp2*4)+(lp*texInfo.width)] = pPixelData8[1+(texInfo.width*3)+lp2+(lp*texInfo.width)];
											p8[26+(lp2*4)+(lp*texInfo.width)] = pPixelData8[2+(texInfo.width*3)+lp2+(lp*texInfo.width)];
											p8[27+(lp2*4)+(lp*texInfo.width)] = pPixelData8[3+(texInfo.width*3)+lp2+(lp*texInfo.width)];
											p8[28+(lp2*4)+(lp*texInfo.width)] = pPixelData8[4+(texInfo.width*3)+lp2+(lp*texInfo.width)];
											p8[29+(lp2*4)+(lp*texInfo.width)] = pPixelData8[5+(texInfo.width*3)+lp2+(lp*texInfo.width)];
											p8[30+(lp2*4)+(lp*texInfo.width)] = pPixelData8[6+(texInfo.width*3)+lp2+(lp*texInfo.width)];
											p8[31+(lp2*4)+(lp*texInfo.width)] = pPixelData8[7+(texInfo.width*3)+lp2+(lp*texInfo.width)];
										}
									}
									memcpy( pPixelData8, p8, texInfo.width * texInfo.height );
									delete [] p8;
								}

								// Convert 16-bit PS2 -> 16-bit GC pixel format for palette.
								for ( lp = 0; lp < 256; lp++ )
								{
									pPaletteData[lp] = ( ( pPaletteData[lp] & 0x1f ) << 11 ) | ( ( pPaletteData[lp] & 0x3e0 ) << 1 ) | ( ( pPaletteData[lp] & 0x7c00 ) >> 10 );
									flipShort ( &pPaletteData[lp] );
								}

								// Swizzle the palette entries.
								p16 = new unsigned short [256 * 2];
								if( p16 )
								{
									memcpy ( &p16[ 0*8], &pPaletteData[((0*4)+0)*8], 8 * 2 );
									memcpy ( &p16[ 1*8], &pPaletteData[((0*4)+2)*8], 8 * 2 );
									memcpy ( &p16[ 2*8], &pPaletteData[((0*4)+1)*8], 8 * 2 );
									memcpy ( &p16[ 3*8], &pPaletteData[((0*4)+3)*8], 8 * 2 );
									memcpy ( &p16[ 4*8], &pPaletteData[((1*4)+0)*8], 8 * 2 );
									memcpy ( &p16[ 5*8], &pPaletteData[((1*4)+2)*8], 8 * 2 );
									memcpy ( &p16[ 6*8], &pPaletteData[((1*4)+1)*8], 8 * 2 );
									memcpy ( &p16[ 7*8], &pPaletteData[((1*4)+3)*8], 8 * 2 );
									memcpy ( &p16[ 8*8], &pPaletteData[((2*4)+0)*8], 8 * 2 );
									memcpy ( &p16[ 9*8], &pPaletteData[((2*4)+2)*8], 8 * 2 );
									memcpy ( &p16[10*8], &pPaletteData[((2*4)+1)*8], 8 * 2 );
									memcpy ( &p16[11*8], &pPaletteData[((2*4)+3)*8], 8 * 2 );
									memcpy ( &p16[12*8], &pPaletteData[((3*4)+0)*8], 8 * 2 );
									memcpy ( &p16[13*8], &pPaletteData[((3*4)+2)*8], 8 * 2 );
									memcpy ( &p16[14*8], &pPaletteData[((3*4)+1)*8], 8 * 2 );
									memcpy ( &p16[15*8], &pPaletteData[((3*4)+3)*8], 8 * 2 );
									memcpy ( &p16[16*8], &pPaletteData[((4*4)+0)*8], 8 * 2 );
									memcpy ( &p16[17*8], &pPaletteData[((4*4)+2)*8], 8 * 2 );
									memcpy ( &p16[18*8], &pPaletteData[((4*4)+1)*8], 8 * 2 );
									memcpy ( &p16[19*8], &pPaletteData[((4*4)+3)*8], 8 * 2 );
									memcpy ( &p16[20*8], &pPaletteData[((5*4)+0)*8], 8 * 2 );
									memcpy ( &p16[21*8], &pPaletteData[((5*4)+2)*8], 8 * 2 );
									memcpy ( &p16[22*8], &pPaletteData[((5*4)+1)*8], 8 * 2 );
									memcpy ( &p16[23*8], &pPaletteData[((5*4)+3)*8], 8 * 2 );
									memcpy ( &p16[24*8], &pPaletteData[((6*4)+0)*8], 8 * 2 );
									memcpy ( &p16[25*8], &pPaletteData[((6*4)+2)*8], 8 * 2 );
									memcpy ( &p16[26*8], &pPaletteData[((6*4)+1)*8], 8 * 2 );
									memcpy ( &p16[27*8], &pPaletteData[((6*4)+3)*8], 8 * 2 );
									memcpy ( &p16[28*8], &pPaletteData[((7*4)+0)*8], 8 * 2 );
									memcpy ( &p16[29*8], &pPaletteData[((7*4)+2)*8], 8 * 2 );
									memcpy ( &p16[30*8], &pPaletteData[((7*4)+1)*8], 8 * 2 );
									memcpy ( &p16[31*8], &pPaletteData[((7*4)+3)*8], 8 * 2 );

									memcpy( pPaletteData, p16, 256 * 2 );
									delete [] p16;
								}

//								fwrite ( pPixelData8, texInfo.width * texInfo.height, 1, of );
//								fwrite ( pPaletteData, 256 * 2, 1, of );
#								endif

								// Free up memory we used.
								delete [] pPixelData8;
								delete [] pPaletteData;

								// Skip any extra data. Not sure why yet...
								//seek ( f, chunk.length - ( ( texInfo.width * texInfo.height ) + ( 256 * 4 ) ) );
							}
							break;
						}

						case 16:
						{
							pPixelData16 = new unsigned short [texInfo.width * texInfo.height];
							if( pPixelData16 )
							{
								// Read the pixel data.
								fread( pPixelData16, texInfo.width * texInfo.height * 2, 1, f );

								writeXbox16BitTexture( &texInfo, pPixelData16 );

#								if 0
								// Convert PS2 -> GC pixel format.
								for ( lp = 0; lp < texInfo.width * texInfo.height; lp++ )
								{
									pPixelData16[lp] = ( ( pPixelData16[lp] & 0x1f ) << 11 ) | ( ( pPixelData16[lp] & 0x3e0 ) << 1 ) | ( ( pPixelData16[lp] & 0x7c00 ) >> 10 );
									flipShort ( &pPixelData16[lp] );
								}
								// Convert from basic PS2 format to funky GC format.
								// GC format is like this:

								// 00 01 02 03 | 16 17 18 19 |
								// 04 05 06 07 | 20 21 22 23 |
								// 08 09 10 11 | 24 25 26 27 |
								// 12 13 14 15 | 28 29 30 31 | ...and so on...
								p16 = new unsigned short [texInfo.width * texInfo.height * 2];
								if( p16 )
								{
									for ( lp = 0; lp < texInfo.height; lp += 4 )
									{
										for ( lp2 = 0; lp2 < texInfo.width; lp2 += 4 )
										{
											p16[ 0+(lp2*4)+(lp*texInfo.width)] = pPixelData16[0+(texInfo.width*0)+lp2+(lp*texInfo.width)];
											p16[ 1+(lp2*4)+(lp*texInfo.width)] = pPixelData16[1+(texInfo.width*0)+lp2+(lp*texInfo.width)];
											p16[ 2+(lp2*4)+(lp*texInfo.width)] = pPixelData16[2+(texInfo.width*0)+lp2+(lp*texInfo.width)];
											p16[ 3+(lp2*4)+(lp*texInfo.width)] = pPixelData16[3+(texInfo.width*0)+lp2+(lp*texInfo.width)];
											p16[ 4+(lp2*4)+(lp*texInfo.width)] = pPixelData16[0+(texInfo.width*1)+lp2+(lp*texInfo.width)];
											p16[ 5+(lp2*4)+(lp*texInfo.width)] = pPixelData16[1+(texInfo.width*1)+lp2+(lp*texInfo.width)];
											p16[ 6+(lp2*4)+(lp*texInfo.width)] = pPixelData16[2+(texInfo.width*1)+lp2+(lp*texInfo.width)];
											p16[ 7+(lp2*4)+(lp*texInfo.width)] = pPixelData16[3+(texInfo.width*1)+lp2+(lp*texInfo.width)];
											p16[ 8+(lp2*4)+(lp*texInfo.width)] = pPixelData16[0+(texInfo.width*2)+lp2+(lp*texInfo.width)];
											p16[ 9+(lp2*4)+(lp*texInfo.width)] = pPixelData16[1+(texInfo.width*2)+lp2+(lp*texInfo.width)];
											p16[10+(lp2*4)+(lp*texInfo.width)] = pPixelData16[2+(texInfo.width*2)+lp2+(lp*texInfo.width)];
											p16[11+(lp2*4)+(lp*texInfo.width)] = pPixelData16[3+(texInfo.width*2)+lp2+(lp*texInfo.width)];
											p16[12+(lp2*4)+(lp*texInfo.width)] = pPixelData16[0+(texInfo.width*3)+lp2+(lp*texInfo.width)];
											p16[13+(lp2*4)+(lp*texInfo.width)] = pPixelData16[1+(texInfo.width*3)+lp2+(lp*texInfo.width)];
											p16[14+(lp2*4)+(lp*texInfo.width)] = pPixelData16[2+(texInfo.width*3)+lp2+(lp*texInfo.width)];
											p16[15+(lp2*4)+(lp*texInfo.width)] = pPixelData16[3+(texInfo.width*3)+lp2+(lp*texInfo.width)];
										}
									}
									memcpy ( pPixelData16, p16, texInfo.width * texInfo.height * 2 );
									delete [] p16;
								}

								// Write the GC pixel data.
//								fwrite( pPixelData16, texInfo.width * texInfo.height * 2, 1, of );
#								endif

								// Free up memory we used.
								delete [] pPixelData16;

								// Skip any extra data. Not sure why yet...
								seek( f, chunk.length - ( texInfo.width * texInfo.height * 2 ));
							}
							break;
						}

						case 32:
						{
							pPixelData32 = new unsigned int [texInfo.width * texInfo.height];
							if( pPixelData32 )
							{
								// Read the pixel data.
								fread( pPixelData32, texInfo.width * texInfo.height * 4, 1, f );

								writeXbox32BitTexture( &texInfo, pPixelData32 );

								// Free up memory we used.
								delete [] pPixelData32;

								// Skip any extra data. Not sure why yet...
								seek( f, chunk.length - ( texInfo.width * texInfo.height * 4 ));
							}
							break;
						}

						default:
						{
							report( &chunk );
							seek(f,chunk.length);
							printf ( "*************** Error: Unknown bitmap depth.\n" );
							break;
						}
					}
					fread( &chunk, 12, 1, f );		// EXTENSION
					if( gStraightConversion ) { fwrite( &chunk, 12, 1, of ); }
					report( &chunk );
					if( chunk.length > 0 )
					{
						unsigned char* extension = new unsigned char [chunk.length];
						fread( extension, chunk.length, 1, f );
						if( gStraightConversion ) { fwrite( extension, chunk.length, 1, of ); }
						fflush( of );
						delete [] extension;
					}

					fread( &chunk, 12, 1, f );		// TEXTURENATIVE

					// Only write this out if the very last texture.
					if( chunk.type != rwID_TEXTURENATIVE )
					{
						if( gStraightConversion ) { fwrite( &chunk, 12, 1, of ); }
						report( &chunk );
						if( chunk.length > 0 )
						{
							unsigned char* extension = new unsigned char [chunk.length];
							fread( extension, chunk.length, 1, f );
							if( gStraightConversion ) { fwrite( extension, chunk.length, 1, of ); }
							fflush( of );
							delete [] extension;
						}
					}
				}
				break;
			}

			case rwID_EXTENSION:
				if( gStraightConversion ) { fwrite( &chunk, 12, 1, of ); }
				report( &chunk );
				if( chunk.length > 0 )
				{
					unsigned char* extension = new unsigned char [chunk.length];
					fread( extension, chunk.length, 1, f );
					if( gStraightConversion ) { fwrite( extension, chunk.length, 1, of ); }
					fflush( of );
					delete [] extension;
				}
				break;


			default:
				report( &chunk );
				seek( f, chunk.length );
				break;
		}
	}

	// Close files.
	fclose ( f );
	fclose ( of );

	return 0;
}