/*
	mods.cpp
	This is a wrapper DLL for mods.dlm so that we can force the real mods.dlm
	not to register its edit mesh modifier class.  Thus allowing us to override
	it in our own plugin without causing any conflicts

	aml 10-25-02
*/

#include "max.h"

#define MODS_DLM_LIB  "plugins\\mods.wrp"	// Original mods.dlm should be renamed mods.wrp for the wrapper

HINSTANCE hInstance;
HMODULE   hModule;					// This is the handle to the actually mods.dlm library
int       Init = FALSE;

typedef int (*PFLIBNUMBERCLASSES)(void);
typedef ClassDesc* (*PFLIBCLASSDESC)(int);
typedef const TCHAR* (*PFLIBDESCRIPTION)(void);
typedef ULONG (*PFLIBVERSION)(void);

PFLIBNUMBERCLASSES wrpLibNumberClasses;
PFLIBCLASSDESC     wrpLibClassDesc;
PFLIBDESCRIPTION   wrpLibDescription;
PFLIBVERSION       wrpLibVersion;

BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD fdwReason, LPVOID lpvReserved)
{
	::hInstance = hInstance;

	if (!Init)
	{
		Init = TRUE;

		// Load and initialize the actual mods.dlm (mods.wrp)
		hModule = LoadLibrary(MODS_DLM_LIB);

		if (hModule)
		{
			wrpLibNumberClasses = (PFLIBNUMBERCLASSES)GetProcAddress(hModule, "LibNumberClasses");
			wrpLibClassDesc     = (PFLIBCLASSDESC)GetProcAddress(hModule, "LibClassDesc");
			wrpLibDescription   = (PFLIBDESCRIPTION)GetProcAddress(hModule, "LibDescription");
			wrpLibVersion       = (PFLIBVERSION)GetProcAddress(hModule, "LibVersion");
		}
	}

	if (hModule)
		return TRUE;

	return FALSE;
}

__declspec( dllexport ) const TCHAR* LibDescription()
{
	return wrpLibDescription();
}

__declspec( dllexport ) int LibNumberClasses()
{
	// Subtract one as we're not enumerating the Edit Mesh modifier
	return wrpLibNumberClasses() - 1;
}

__declspec( dllexport ) ClassDesc* LibClassDesc(int i)
{
	// Using pluginfo interrogator we know Edit Mesh is class #4
	if (i >= 4)
		i++;

	return wrpLibClassDesc(i);
}

__declspec( dllexport ) ULONG LibVersion()
{
	return wrpLibVersion();	
}

