/**********************************************************************
 *<
	FILE: EPoly.cpp

	DESCRIPTION: Editable PolyMesh

	CREATED BY: Steve Anderson

	HISTORY: created 4 March 1996

 *>	Copyright (c) Discreet 1999, All Rights Reserved.
 **********************************************************************/

#include "EPoly.h"

HINSTANCE hInstance;
static int controlsInit = FALSE;
int enabled = FALSE;

/** public functions **/
BOOL WINAPI DllMain(HINSTANCE hinstDLL,ULONG fdwReason,LPVOID lpvReserved) {
	hInstance = hinstDLL;

	if (!controlsInit) {
		controlsInit = TRUE;
		// MAXontrols
		InitCustomControls(hInstance);
		// initialize Chicago controls
		InitCommonControls();
		// Register us as the editable poly object?
		RegisterEditPolyObjDesc (GetEditablePolyDesc());
	}

	return(TRUE);
}


//------------------------------------------------------
// This is the interface to MAX
//------------------------------------------------------

__declspec( dllexport ) const TCHAR *
LibDescription() { return GetString(IDS_LIB_DESCRIPTION); }

/// MUST CHANGE THIS NUMBER WHEN ADD NEW CLASS
__declspec( dllexport ) int LibNumberClasses() {return 3;}


__declspec( dllexport ) ClassDesc*LibClassDesc(int i) {
	switch(i) {
	case 0: return GetPolySelectDesc();
	case 1: return GetEditablePolyDesc ();
	case 2: return GetEditNormalsDesc();
	default: return NULL;
	}
}

// Return version so can detect obsolete DLLs
__declspec( dllexport ) ULONG LibVersion() { return VERSION_3DSMAX; }

TCHAR *GetString(int id) {
	static TCHAR buf[256];
	if (hInstance)
		return LoadString(hInstance, id, buf, sizeof(buf)) ? buf : NULL;
	return NULL;
}
