/**********************************************************************
 *<
	FILE: DllEntry.cpp

	DESCRIPTION: Contains the Dll Entry stuff

	CREATED BY: 

	HISTORY: 

 *>	Copyright (c) 2000, All Rights Reserved.
 **********************************************************************/
#include "NxUpdate.h"
#include <process.h>

extern ClassDesc2* GetNxUpdateDesc();

HINSTANCE hInstance;
int controlsInit = FALSE;
static int s_checked_for_new_plugin = false;


BOOL WINAPI DllMain(HINSTANCE hinstDLL,ULONG fdwReason,LPVOID lpvReserved)
{
	hInstance = hinstDLL;				// Hang on to this DLL's instance handle.

	if (!controlsInit) {
		controlsInit = TRUE;
		InitCustomControls(hInstance);	// Initialize MAX's custom controls
		InitCommonControls();			// Initialize Win95 controls
	}

	if( !s_checked_for_new_plugin )
	{
		char* path;
		char* args[3];
		char exec_path[_MAX_PATH];

		path = getenv( "PROJ_ROOT" );
		if( path )
		{
			sprintf( exec_path, "%s/bin/win32/newplugin.bat", path );

			args[0] = exec_path;
			args[1] = NULL;
			spawnvp( _P_WAIT, args[0], args );
		}		

		s_checked_for_new_plugin = true;
	}
			
	return (TRUE);
}

__declspec( dllexport ) const TCHAR* LibDescription()
{
	return GetString(IDS_LIBDESCRIPTION);
}

//TODO: Must change this number when adding a new class
__declspec( dllexport ) int LibNumberClasses()
{
	return 1;
}

__declspec( dllexport ) ClassDesc* LibClassDesc(int i)
{
	switch(i) {
		case 0: return GetNxUpdateDesc();
		default: return 0;
	}
}

__declspec( dllexport ) ULONG LibVersion()
{
	return VERSION_3DSMAX;
}

TCHAR *GetString(int id)
{
	static TCHAR buf[256];

	if (hInstance)
		return LoadString(hInstance, id, buf, sizeof(buf)) ? buf : NULL;
	return NULL;
}

