/*
	ScriptSelect.h
	Script Select Custom UI
*/

#ifndef __SCRIPTSELECT__
#define __SCRIPTSELECT__
#include "max.h"
#include "ModalDlg.h"
#include "UIControl.h"
#include "../misc/llist.h"

#define SCRIPTSELECT_CLASSNAME "ScriptSelect"

class ListView;

///////////////////////////////// ScriptSelectDlg

class ScriptSelectDlg: public ModalDlgWindow
{
	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	ListView*      list;
	bool           bAbort;				// True if script search was aborted
	int            swCount;				// Counter to keep track of showwindow messages
	CStr           strName;				// Name of the script to use

	void AddScripts();
	int  CountFiles(char* sdir,char* prefix);
	void Find(char* sdir,char* prefix,char* search);
	bool MatchContent(FILE* fp,char* wildcard,char* buf,int* line);

	void SelChange(LPNMLISTVIEW nmlv);

public:
	ScriptSelectDlg(HINSTANCE hInstance,HWND hwndParent);
	~ScriptSelectDlg();

	void  SetScript(char* name);
	char* GetScript();
	void  Refresh();
};

///////////////////////////////// End ScriptSelectDlg

class ScriptSelect: public UIControl
{
	HWND              hwndButton;
	ScriptSelectDlg*  selectWindow;

	LRESULT WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void BuildControlUI();
	void SetScript();
	HWND GetFocusWindow();

public:
	CLASSNAME(SCRIPTSELECT_CLASSNAME)

	CStr GetValue();
	void SetValue(CStr value);

	ScriptSelect(ScriptSelect& right);
	ScriptSelect(HINSTANCE hInstance);
	ScriptSelect(HINSTANCE hInstance, HWND hwnd);
	~ScriptSelect();

	ScriptSelect& operator= (ScriptSelect& right);
};

#endif
