/*
	TriggerLayout.h
	Trigger Layout Tool/UI
*/

#ifndef __TRIGGERLAYOUT__
#define __TRIGGERLAYOUT__

#include "max.h"

class PickSplineNode;
class PickGeomNode;

class TriggerLayout
{
	friend class PickSplineNode;
	friend class PickGeomNode;

	Interface* ip;
	HWND hwndLayout;

	// MAX UI Interfaces
	ICustEdit *IEditX, *IEditY, *IEditZ;
	ICustEdit *IEditDistrib;

	ISpinnerControl *ISpinX, *ISpinY, *ISpinZ;
	ISpinnerControl *ISpinDistrib;

	ICustButton *IBSplineSelect;
	ICustButton *IBGeomSelect;
	//////////

	INode*     nodeSpline;
	INode*     nodeGeom;

	Tab<INode*> trigList;						// List to keep track of newly created triggers
												// necessary so new updates delete the previously
												// created triggers

	static BOOL CALLBACK DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	inline void ResetTrigList() { trigList.ZeroCount(); }

public:
	TriggerLayout();
	~TriggerLayout();

	void BeginEditParams(IObjParam *ip, ULONG flags, Animatable* prev);
	void EndEditParams(IObjParam *ip, ULONG flags, Animatable* next);

	void SetSpline(INode* newSpline);
	void SetGeom(INode* newGeom);

	void   UpdateTriggers();
	INode* AddTrigger(Matrix3 tm);

	void LinkTriggers();
	void ClearTriggers();
};

#endif
