#include "max.h"
#include "imtl.h"
#include "texutil.h"
#include "buildver.h"
#include "../resource.h"
#include "stdmat.h"
#include <bmmlib.h>
#include "iparamm2.h"
#include "macrorec.h"
#include "gport.h"
#include "NExtAnimatedTexture.h"
#include "NExtTexture.h"

#include <d3dx8.h>

#include "IHardwareMaterial.h"

#define MAXTEXHANDLES vMAX_ANIMATED_TEXTURE_FRAMES
#define vDEFAULT_HOLD_FRAMES 1

#define DORECT(x) Rectangle( hdc, rect.left-(x), rect.top-(x), rect.right+(x), rect.bottom+(x) )

extern HINSTANCE hInstance;

extern TCHAR *GetString(int id);
extern ClassDesc* GetNExtTextureDesc( void );

static Class_ID nextAnimatedBitmapClassID = NEXT_ANIMATEDTEXTURE_CLASS_ID;

static LRESULT CALLBACK NExtAnimatedTexturePStampWndProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );

class NExtAnimatedTexture;
class NExtAnimatedTextureDlg;

#define NDLG 10

static char* loop_types[] = {
	"Loop",
	"Ping Pong"
};

static int mtlPStampIDs[] = {
	IDC_PSTAMP1,
	IDC_PSTAMP2,
	IDC_PSTAMP3,
	IDC_PSTAMP4,
	IDC_PSTAMP5,
	IDC_PSTAMP6,
	IDC_PSTAMP7,
	IDC_PSTAMP8,
	IDC_PSTAMP9,
	IDC_PSTAMP10,
	};

class NExtAnimatedTextureDlg: public ParamDlg {
	public:
		HWND hwmedit;	 	// window handle of the materials editor dialog
		IMtlParams *ip;
		NExtAnimatedTexture *theTex;	 
		HWND hPanel; 		// Rollup pane		
		HWND hScroll;
		BOOL valid;
		ICustButton *iBut[NDLG];
		TexDADMgr dadMgr;
				
		NExtAnimatedTextureDlg(HWND hwMtlEdit, IMtlParams *imp, NExtAnimatedTexture *m); 
		~NExtAnimatedTextureDlg();
		BOOL PanelProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam );		
		void VScroll(int code, short int cpos );
		void LoadDialog(BOOL draw);  // stuff params into dialog
		void ReloadDialog();
		void UpdateMtlDisplay();		
		void UpdateSubTexNames();
		void ActivateDlg(BOOL onOff);
		void Invalidate();
		void Destroy(HWND hWnd);
		void SetNumMaps();
		void DragAndDrop(int ifrom, int ito);

		void DrawPStampBlackBorder(HDC hdc, Rect &rect);
		void DrawPStampHilite( int i, BOOL on);
		void DrawPStampHilite(HDC hdc, BOOL on, Rect &rect );
		void DrawPStamp(HDC hdc, Rect &rect, int i );
		void RemovePStampHilite();

		// methods inherited from ParamDlg:
		Class_ID ClassID() {return nextAnimatedBitmapClassID;  }
		void SetThing(ReferenceTarget *m);
		ReferenceTarget* GetThing() {return (ReferenceTarget *)theTex;}
		void DeleteThis() { delete this;  }	
		void SetTime(TimeValue t);
		int FindSubTexFromHWND(HWND hw);
		void SelectTex(int i);		
	};



class NExtAnimatedTexture: public MultiTex, public INExtAnimatedTexture { 
	public:			
		Tab<Texmap*> subTex;
		Tab<BOOL>mapOn;
		Tab<int>holdFrames;
		int m_loop_type;
		int m_iterations;
		int m_fps;
		int m_phase;
		Interval ivalid;
		int offset;
		int rollScroll;
		int selected;
		NExtAnimatedTextureDlg *paramDlg;

		BOOL ignoreNotify;
		BOOL Param1;
		IParamBlock2 *pblock;   // ref #0		
		
		TexHandle *texHandle[MAXTEXHANDLES];
		int useSubForTex[MAXTEXHANDLES];
		int numTexHandlesUsed;
		Interval texHandleValid;

	
		NExtAnimatedTexture();
		~NExtAnimatedTexture() {
			DiscardTexHandles(); 
			}
		ParamDlg* CreateParamDlg(HWND hwMtlEdit, IMtlParams *imp);
		void ClampOffset();
		void Update(TimeValue t, Interval& valid);
		void Init();
		void Reset();
		Interval Validity(TimeValue t) {Interval v; Update(t,v); return ivalid;}
		void NotifyChanged();		
		void SetNumSubTexmaps(int n) { SetNumMaps(n); }
		void SetNumMaps(int n);

		// Evaluate the color of map for the context.
		AColor EvalColor(ShadeContext& sc);
		
		// For Bump mapping, need a perturbation to apply to a normal.
		// Leave it up to the Texmap to determine how to do this.
		Point3 EvalNormalPerturb(ShadeContext& sc);		

		// Methods to access texture maps of material
		int NumSubTexmaps() {return subTex.Count();}
		Texmap* GetSubTexmap(int i) {return subTex[i];}		
		void SetSubTexmap(int i, Texmap *m);
		TSTR GetSubTexmapSlotName(int i);		

		Class_ID ClassID() {return nextAnimatedBitmapClassID;}
		SClass_ID SuperClassID() {return TEXMAP_CLASS_ID;}
		void GetClassName(TSTR& s) {s=GetString(IDS_RB_NEXTANIMATED_TEXTURE);}
		void DeleteThis() {delete this;}

		int NumSubs() {return subTex.Count();}
		Animatable* SubAnim(int i) {return subTex[i];}
		TSTR SubAnimName(int i);
		int SubNumToRefNum(int subNum) {return subNum+1;}

		// From ref
 		int NumRefs() {return subTex.Count()+1;}
		RefTargetHandle GetReference(int i) {
						if (i==0) return pblock;
						else return subTex[i-1];
						}
		void SetReference(int i, RefTargetHandle rtarg) {
						if(i==0) pblock = (IParamBlock2*) rtarg;
						else subTex[i-1] = (Texmap*)rtarg;
						}

		RefTargetHandle Clone(RemapDir &remap = NoRemap());
		RefResult NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, 
		   PartID& partID, RefMessage message );

		// IO
		IOResult Save(ISave *isave);
		IOResult Load(ILoad *iload);
		int RemapRefOnLoad(int iref) ;

// JBW: direct ParamBlock access is added
		int	NumParamBlocks() { return 1; }					// return number of ParamBlocks in this instance
		IParamBlock2* GetParamBlock(int i) { return pblock; } // return i'th ParamBlock
		IParamBlock2* GetParamBlockByID(BlockID id) { return (pblock->ID() == id) ? pblock : NULL; } // return id'd ParamBlock


		// Multiple map in vp support -- DS 5/4/00
		BOOL SupportTexDisplay() { return TRUE; }
		void ActivateTexDisplay(BOOL onoff);
		BOOL SupportsMultiMapsInViewport() { return TRUE; }
		void SetupGfxMultiMaps(TimeValue t, Material *mtl, MtlMakerCallback &cb);
		void DiscardTexHandles() {
			for (int i=0; i<MAXTEXHANDLES; i++) {
				if (texHandle[i]) {
					texHandle[i]->DeleteThis();
					texHandle[i] = NULL;
					}
				}
			texHandleValid.SetEmpty();
			}
		// From Texmap
		bool IsLocalOutputMeaningful( ShadeContext& sc );

		// From INExtAnimatedTexture
		int	GetFPS( void );
		int	GetPhase( void );
		int	GetIterations( void );
		int	GetLoopType( void );
		int	GetNumFrames( void );
		Texmap*	GetMap( int frame );
		int	GetTime( int frame );
		int	GetDuration( int frame );

	};

class NExtAnimatedTextureClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading) {return new NExtAnimatedTexture;}
	const TCHAR *	ClassName() {return GetString(IDS_RB_NEXTANIMATED_TEXTURE); } // mjm - 2.3.99
	SClass_ID		SuperClassID() {return TEXMAP_CLASS_ID;}
	Class_ID 		ClassID() {return nextAnimatedBitmapClassID;}
	const TCHAR* 	Category() {return TEXMAP_CAT_COMP;}
// PW: new descriptor data accessors added.  Note that the 
//      internal name is hardwired since it must not be localized.
	const TCHAR*	InternalName() { return _T("NExtAnimatedTexture"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }			// returns owning module handle

	};
static NExtAnimatedTextureClassDesc next_animatedtextureCD;
ClassDesc* GetNExtAnimatedTextureDesc() {return &next_animatedtextureCD;}
// JBW: IDs for ParamBlock2 blocks and parameters
// Parameter and ParamBlock IDs
enum { next_animatedtexture_params, };  // pblock ID
// multi_params param IDs
enum 
{ 
	next_animatedtexture_tex, next_animatedtexture_ons,
	next_animatedtexture_frames, next_animatedtexture_fps,
	next_animatedtexture_looptype, next_animatedtexture_iterations,
	next_animatedtexture_phase
};

// per instance gradient block
static ParamBlockDesc2 next_animatedtexture_param_blk ( next_animatedtexture_params, _T("parameters"),  0, &next_animatedtextureCD, P_AUTO_CONSTRUCT + P_AUTO_UI, 0, 
	//rollout
	IDD_NEXTANIMATEDTEXTURE, IDS_DS_BASIC, 0, 0, NULL, 
	// params
	next_animatedtexture_looptype, _T("loopType"), TYPE_INT, 0, 0, 	
		p_default, 		vLOOPTYPE_LOOP, 
		p_ui, 			TYPE_INTLISTBOX, IDC_LOOPTYPE, 0,
		end, 
	next_animatedtexture_fps,	_T("FPS"), TYPE_INT,	P_ANIMATABLE,	0,
		p_enabled,		TRUE,
		p_default, 		60, 
		p_range, 		1, 60, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_FPS, IDC_FPS_SPINNER, 1.0, 
		end,
	next_animatedtexture_phase,	_T("Phase"), TYPE_INT,	P_ANIMATABLE,	0,
		p_enabled,		TRUE,
		p_default, 		0, 
		p_range, 		0, 65535, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_PHASE, IDC_PHASE_SPINNER, 1.0, 
		end,
	next_animatedtexture_iterations, _T("Iterations"), TYPE_INT,	P_ANIMATABLE,	0,
		p_enabled,		TRUE,
		p_default, 		0, 
		p_range, 		0, 65535, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_ITERATIONS, IDC_ITERATIONS_SPINNER, 1.0, 
		end,	
	next_animatedtexture_tex,	_T("mapList"),	TYPE_TEXMAP_TAB, 10,P_OWNERS_REF + P_VARIABLE_SIZE,	IDS_DS_TEXMAP,	
		p_refno,	1, 
		end,
	next_animatedtexture_ons,	_T("mapEnabled"), TYPE_BOOL_TAB, 10,P_VARIABLE_SIZE, IDS_JW_MAP1ENABLE,
		p_default,	TRUE,
		end,
	next_animatedtexture_frames,_T("holdFrames"), TYPE_INT_TAB, 10,P_VARIABLE_SIZE, IDS_HOLDFRAMES,
		p_default,	1,
		end,	
	end
);


static INT_PTR CALLBACK PanelDlgProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) 
	{
	NExtAnimatedTextureDlg *theDlg = (NExtAnimatedTextureDlg*)GetWindowLongPtr(hWnd,GWLP_USERDATA);
	if (msg==WM_INITDIALOG) {
		theDlg = (NExtAnimatedTextureDlg*)lParam;
		theDlg->hPanel = hWnd;
		SetWindowLongPtr(hWnd,GWLP_USERDATA,lParam);
		}	
	else {
	    if ( (theDlg = (NExtAnimatedTextureDlg *)GetWindowLongPtr(hWnd, GWLP_USERDATA) ) == NULL )
			return FALSE; 
		}
	if (theDlg) return theDlg->PanelProc(hWnd,msg,wParam,lParam);
	else return FALSE;
	}

int NExtAnimatedTextureDlg::FindSubTexFromHWND(HWND hw) {
	for (int i=0; i<NDLG; i++) {
		if (hw == iBut[i]->GetHwnd()) return i+theTex->offset;
		}	
	return -1;
	}

void NExtAnimatedTextureDlg::DragAndDrop(int ifrom, int ito) {
	theTex->CopySubTexmap(hPanel,ifrom+theTex->offset, ito+theTex->offset);
	theTex->NotifyChanged();
	}


//-------------------------------------------------------------------

NExtAnimatedTextureDlg::NExtAnimatedTextureDlg(HWND hwMtlEdit, IMtlParams *imp, NExtAnimatedTexture *m) 
	{
	dadMgr.Init(this);
	hwmedit  = hwMtlEdit;
	ip       = imp;
	hPanel   = NULL;
	theTex   = m; 	
	valid    = FALSE;	
	for (int i=0; i<NDLG; i++) iBut[i] = NULL;
	hPanel   = ip->AddRollupPage( 
		hInstance,
		MAKEINTRESOURCE(IDD_NEXTANIMATEDTEXTURE),
		PanelDlgProc, 
		GetString(IDS_RB_NEXTANIMATEDTEXTURE_PARAMS),
		(LPARAM)this);	
	}

void NExtAnimatedTextureDlg::Destroy(HWND hWnd) {
	for (int i=0; i<NDLG; i++) {
		ReleaseICustButton(iBut[i]);
		iBut[i] = NULL; 
		}
	}

void NExtAnimatedTextureDlg::Invalidate()
	{
	valid = FALSE;
	Rect rect;
	rect.left = rect.top = 0;
	rect.right = rect.bottom = 10;
	InvalidateRect(hPanel,&rect,FALSE);
	}

void NExtAnimatedTextureDlg::ReloadDialog() 
	{
	Interval valid;
	theTex->Update(ip->GetTime(), valid);
	LoadDialog(FALSE);
	}

void NExtAnimatedTextureDlg::SetTime(TimeValue t) 
	{
	Interval valid;	
	theTex->Update(ip->GetTime(), valid);
	//LoadDialog(FALSE);
	//InvalidateRect(hPanel,NULL,0);	
	}

NExtAnimatedTextureDlg::~NExtAnimatedTextureDlg() 
	{
	theTex->paramDlg = NULL;	
	SetWindowLongPtr(hPanel, GWLP_USERDATA, NULL);	
	hPanel =  NULL;
	}


void NExtAnimatedTextureDlg::RemovePStampHilite() {
	for (int i=0; i<NDLG; i++) {
		DrawPStampHilite( i, FALSE);
		}
//	if (theMtl->selected>=0) 
//		DrawPStampHilite( theMtl->selected-theMtl->offset, FALSE);
	}

void NExtAnimatedTextureDlg::VScroll(int code, short int cpos ) {
	RemovePStampHilite();
	switch (code) {
		case SB_LINEUP: 	theTex->offset--;		break;
		case SB_LINEDOWN:	theTex->offset++;		break;
		case SB_PAGEUP:		theTex->offset -= NDLG;	break;
		case SB_PAGEDOWN:	theTex->offset += NDLG;	break;
		
		case SB_THUMBPOSITION: 
		case SB_THUMBTRACK:
			theTex->offset = cpos;
			break;
		}
	theTex->ClampOffset();
	UpdateSubTexNames();						
	//LoadDialog(ip->GetTime());
	}

static int mapIDs[] = {IDC_COMP_TEX1,IDC_COMP_TEX2,IDC_COMP_TEX3,IDC_COMP_TEX4,IDC_COMP_TEX5,IDC_COMP_TEX6,
						IDC_COMP_TEX7,IDC_COMP_TEX8,IDC_COMP_TEX9,IDC_COMP_TEX10};
static int labelIDs[] = {IDC_COMP_LABEL1,IDC_COMP_LABEL2,IDC_COMP_LABEL3,IDC_COMP_LABEL4,IDC_COMP_LABEL5,IDC_COMP_LABEL6,
							IDC_COMP_LABEL1,IDC_COMP_LABEL2,IDC_COMP_LABEL3,IDC_COMP_LABEL4};
static int mapOnIDs[] = {IDC_MAPON1,IDC_MAPON2,IDC_MAPON3,IDC_MAPON4,IDC_MAPON5,IDC_MAPON6,
							IDC_MAPON7,IDC_MAPON8,IDC_MAPON9,IDC_MAPON10};
static int holdFrameIDs[] = {IDC_HOLD_FRAMES1,IDC_HOLD_FRAMES2,IDC_HOLD_FRAMES3,IDC_HOLD_FRAMES4,IDC_HOLD_FRAMES5,IDC_HOLD_FRAMES6,
							IDC_HOLD_FRAMES7,IDC_HOLD_FRAMES8,IDC_HOLD_FRAMES9,IDC_HOLD_FRAMES10};


BOOL NExtAnimatedTextureDlg::PanelProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam ) 
	{
	int id = LOWORD(wParam);
	int code = HIWORD(wParam);
    switch (msg)    {
		case WM_INITDIALOG: 
		{	
			HWND drop_down;
			int i;

			ISpinnerControl *spinner;
			
			spinner = SetupIntSpinner( hWnd, IDC_FPS_SPINNER, IDC_FPS, 0, 60, 60 );
			spinner = SetupIntSpinner( hWnd, IDC_PHASE_SPINNER, IDC_PHASE, 0, 65535, 0 );
			spinner = SetupIntSpinner( hWnd, IDC_ITERATIONS_SPINNER, IDC_ITERATIONS, 0, 65535, 0 );

			hScroll	= GetDlgItem(hWnd,IDC_COMP_SCROLL);
			SetScrollRange(hScroll,SB_CTL,0,theTex->NumSubTexmaps()-NDLG,FALSE);
			SetScrollPos(hScroll,SB_CTL,theTex->offset,TRUE);
			EnableWindow(hScroll,theTex->NumSubTexmaps()>NDLG);
			for (i=0; i<NDLG; i++) {
				HWND pstamp_hwnd = GetDlgItem(hWnd, mtlPStampIDs[i]);
				SetWindowLongPtr( pstamp_hwnd, GWLP_WNDPROC, (LONG_PTR)NExtAnimatedTexturePStampWndProc);
				SetWindowLongPtr( pstamp_hwnd, GWLP_USERDATA, (LONG_PTR)this);

				iBut[i] = GetICustButton(GetDlgItem(hWnd,IDC_COMP_TEX1+i));
				iBut[i]->SetDADMgr(&dadMgr);
//				if (i-theTex->offset<theTex->mapOn.Count())
//					SetCheckBox(hWnd, mapOnIDs[i], theTex->mapOn[i-theTex->offset]);
				}
		
			drop_down = GetDlgItem( hWnd, IDC_LOOPTYPE );
			SendMessage( drop_down, CB_RESETCONTENT, 0L, 0L );
			for( i = vNUM_LOOP_TYPES - 1; i >= 0; i-- )
			{
				SendMessage( drop_down, CB_INSERTSTRING, 0L, 
							(LPARAM) loop_types[i] );	
			}										
			return TRUE;
		}
		/*case WM_SHOWWINDOW:
			ICustEdit* edit;
			int value;
			
			edit = GetICustEdit( GetDlgItem( hPanel, IDC_FPS ));
			value = edit->GetInt();
			ReleaseICustEdit( edit );
			//theTex->ignoreNotify = TRUE;
			theTex->pblock->SetValue(next_animatedtexture_fps,0,value);
			//theTex->ignoreNotify = FALSE;						
			break;*/
			
		case WM_PAINT:
			if (!valid) {
				valid = TRUE;
				ReloadDialog();
			}
			return FALSE;

		case WM_VSCROLL:
			VScroll(LOWORD(wParam),(short int)HIWORD(wParam));
			break;
		
		case WM_CUSTEDIT_ENTER: 
		{
			HWND paramWnd;
			ICustEdit* edit;
			int value;

			id = wParam;
			paramWnd = (HWND) lParam;
			edit = GetICustEdit( GetDlgItem( hPanel, id));
			value = edit->GetInt();
			ReleaseICustEdit( edit );
			switch( id )
			{
				case IDC_FPS:		
					theTex->pblock->SetValue(next_animatedtexture_fps,0,value);
					break;
				case IDC_PHASE:		
					theTex->pblock->SetValue(next_animatedtexture_phase,0,value);
					break;
				case IDC_ITERATIONS:
					theTex->pblock->SetValue(next_animatedtexture_iterations,0,value);
					break;
				case IDC_HOLD_FRAMES1:							
				case IDC_HOLD_FRAMES2:							
				case IDC_HOLD_FRAMES3:							
				case IDC_HOLD_FRAMES4:							
				case IDC_HOLD_FRAMES5:							
				case IDC_HOLD_FRAMES6:
				case IDC_HOLD_FRAMES7:
				case IDC_HOLD_FRAMES8:							
				case IDC_HOLD_FRAMES9:							
				case IDC_HOLD_FRAMES10:							
					ICustEdit* edit;
					int frames;
					
					edit = GetICustEdit( GetDlgItem( hPanel, id ));
					frames = edit->GetInt();
					ReleaseICustEdit( edit );
					//theTex->ignoreNotify = TRUE;
					theTex->pblock->SetValue(next_animatedtexture_frames,0,frames,id-IDC_HOLD_FRAMES1+theTex->offset);
					//theTex->ignoreNotify = FALSE;						
					break;
			}
			break;
		}

		case CC_SPINNER_BUTTONUP:
		{
			int id;
			ISpinnerControl* spinner;
			int value;

			id = LOWORD(wParam);
			spinner = (ISpinnerControl*) lParam;
			value = spinner->GetIVal();
			switch( id )
			{
				case IDC_FPS_SPINNER:
					theTex->pblock->SetValue(next_animatedtexture_fps,0,value);
					break;
				case IDC_PHASE_SPINNER:
					theTex->pblock->SetValue(next_animatedtexture_phase,0,value);
					break;
				case IDC_ITERATIONS_SPINNER:
					theTex->pblock->SetValue(next_animatedtexture_iterations,0,value);
					break;
			}
			break;
		}
		case WM_COMMAND: 		    		 	
			if( HIWORD( wParam ) == CBN_SELCHANGE )
			{
				int id, index;
				HWND combo_box;

				id = LOWORD( wParam );
				combo_box = (HWND) lParam;
				index = SendMessage( combo_box,CB_GETCURSEL,0,0);
				theTex->pblock->SetValue(next_animatedtexture_looptype,0,index);

				break;
			}
		
			switch (id) {		
				case IDC_COMP_TEX1: PostMessage(hwmedit,WM_TEXMAP_BUTTON,theTex->offset,(LPARAM)theTex); break;
				case IDC_COMP_TEX2: PostMessage(hwmedit,WM_TEXMAP_BUTTON,theTex->offset+1,(LPARAM)theTex); break;
				case IDC_COMP_TEX3: PostMessage(hwmedit,WM_TEXMAP_BUTTON,theTex->offset+2,(LPARAM)theTex); break;
				case IDC_COMP_TEX4: PostMessage(hwmedit,WM_TEXMAP_BUTTON,theTex->offset+3,(LPARAM)theTex); break;
				case IDC_COMP_TEX5: PostMessage(hwmedit,WM_TEXMAP_BUTTON,theTex->offset+4,(LPARAM)theTex); break;
				case IDC_COMP_TEX6: PostMessage(hwmedit,WM_TEXMAP_BUTTON,theTex->offset+5,(LPARAM)theTex); break;
				case IDC_COMP_TEX7: PostMessage(hwmedit,WM_TEXMAP_BUTTON,theTex->offset+6,(LPARAM)theTex); break;
				case IDC_COMP_TEX8: PostMessage(hwmedit,WM_TEXMAP_BUTTON,theTex->offset+7,(LPARAM)theTex); break;
				case IDC_COMP_TEX9: PostMessage(hwmedit,WM_TEXMAP_BUTTON,theTex->offset+8,(LPARAM)theTex); break;
				case IDC_COMP_TEX10: PostMessage(hwmedit,WM_TEXMAP_BUTTON,theTex->offset+9,(LPARAM)theTex); break;
									
				case IDC_HOLD_FRAMES1:							
				case IDC_HOLD_FRAMES2:							
				case IDC_HOLD_FRAMES3:							
				case IDC_HOLD_FRAMES4:							
				case IDC_HOLD_FRAMES5:							
				case IDC_HOLD_FRAMES6:
				case IDC_HOLD_FRAMES7:
				case IDC_HOLD_FRAMES8:							
				case IDC_HOLD_FRAMES9:							
				case IDC_HOLD_FRAMES10:							
					/*if (HIWORD(wParam)==EN_CHANGE) 
					{
						ICustEdit* edit;
						int frames;
						
						edit = GetICustEdit( GetDlgItem( hPanel, id ));
						frames = edit->GetInt();
						ReleaseICustEdit( edit );
						theTex->ignoreNotify = TRUE;
						theTex->pblock->SetValue(next_animatedtexture_frames,0,frames,id-IDC_HOLD_FRAMES1+theTex->offset);
						theTex->ignoreNotify = FALSE;						
					}*/
					break;							

				case IDC_MAPON1:							
				case IDC_MAPON2:							
				case IDC_MAPON3:							
				case IDC_MAPON4:							
				case IDC_MAPON5:							
				case IDC_MAPON6:
				case IDC_MAPON7:
				case IDC_MAPON8:							
				case IDC_MAPON9:							
				case IDC_MAPON10:							
					theTex->pblock->SetValue(next_animatedtexture_ons,0,GetCheckBox(hWnd, id),id-IDC_MAPON1+theTex->offset);
//					theTex->mapOn[id-IDC_MAPON1+theTex->offset] = GetCheckBox(hWnd, id);
					theTex->NotifyChanged();
					break;							
									
				case IDC_COMP_SETNUM:
					SetNumMaps();
					break;
				}			
			break;
				
		case WM_DESTROY:
			Destroy(hWnd);
			break;
    	}
	return FALSE;
}

void NExtAnimatedTextureDlg::UpdateSubTexNames() 
{
	ICustEdit* edit;
	HWND drop_down;
	Interval iv;
	int value;

	edit = GetICustEdit( GetDlgItem( hPanel, IDC_FPS ));
	theTex->pblock->GetValue(next_animatedtexture_fps,0,value,iv );		
	edit->SetText( value );
	ReleaseICustEdit( edit );

	edit = GetICustEdit( GetDlgItem( hPanel, IDC_PHASE ));
	theTex->pblock->GetValue(next_animatedtexture_phase,0,value,iv );		
	edit->SetText( value );
	ReleaseICustEdit( edit );

	edit = GetICustEdit( GetDlgItem( hPanel, IDC_ITERATIONS ));
	theTex->pblock->GetValue(next_animatedtexture_iterations,0,value,iv );		
	edit->SetText( value );
	ReleaseICustEdit( edit );

	theTex->pblock->GetValue(next_animatedtexture_looptype,0,value,iv );		
	drop_down = GetDlgItem( hPanel, IDC_LOOPTYPE );
	SendMessage( drop_down, CB_SETCURSEL, value, 0L );


	for (int i=theTex->offset; i<theTex->subTex.Count(); i++) 
	{
		int dlg_index;

		dlg_index = i - theTex->offset;
		if (i-theTex->offset>=NDLG) break;

		Texmap *m = theTex->subTex[i];
		TSTR nm;
		if (m) 	nm = m->GetFullName();
		else 	nm = GetString(IDS_DS_NONE);
		TSTR buf;
		buf.printf(_T("%s %d:"),GetString(IDS_RB_MAP2),i+1);
		iBut[i-theTex->offset]->SetText(nm.data());
		SetDlgItemText(hPanel, labelIDs[i-theTex->offset], buf);
//		SetCheckBox(hPanel, mapOnIDs[i-theTex->offset], theTex->mapOn[i]);
		int on, frames;
		
		theTex->pblock->GetValue(next_animatedtexture_ons,0,on,iv,i);
		SetCheckBox(hPanel, mapOnIDs[dlg_index], on);
		
		edit = GetICustEdit( GetDlgItem( hPanel, holdFrameIDs[dlg_index]));
		theTex->pblock->GetValue(next_animatedtexture_frames,0,frames,iv,i);		
		edit->SetText( frames );
		ReleaseICustEdit( edit );

		ShowWindow(GetDlgItem(hPanel,mapIDs[dlg_index]),SW_SHOW);
		ShowWindow(GetDlgItem(hPanel,labelIDs[dlg_index]),SW_SHOW);
		ShowWindow(GetDlgItem(hPanel,mapOnIDs[dlg_index]),SW_SHOW);
		ShowWindow(GetDlgItem(hPanel,holdFrameIDs[dlg_index]),SW_SHOW);
		ShowWindow(GetDlgItem(hPanel,mtlPStampIDs[dlg_index]),SW_SHOW);
			
		HWND hwps = GetDlgItem(hPanel,mtlPStampIDs[dlg_index]);
		InvalidateRect(hwps, NULL, FALSE);
	}
	for (; i<NDLG; i++) 
	{
		ShowWindow(GetDlgItem(hPanel,mapIDs[i]),SW_HIDE);
		ShowWindow(GetDlgItem(hPanel,labelIDs[i]),SW_HIDE);
		ShowWindow(GetDlgItem(hPanel,mapOnIDs[i]),SW_HIDE);
		ShowWindow(GetDlgItem(hPanel,holdFrameIDs[i]),SW_HIDE);
		ShowWindow(GetDlgItem(hPanel,mtlPStampIDs[i]),SW_HIDE); 			
	}		
	TSTR buf;
	buf.printf(_T("%d"),theTex->subTex.Count());
	SetDlgItemText(hPanel,IDC_COMP_NUMMAPS,buf);
	SetScrollRange(hScroll,SB_CTL,0,theTex->subTex.Count()-NDLG,FALSE);
	SetScrollPos(hScroll,SB_CTL,theTex->offset,TRUE);
	EnableWindow(hScroll,theTex->NumSubTexmaps()>NDLG);
}


void NExtAnimatedTextureDlg::LoadDialog(BOOL draw) 
	{	
	if (theTex) {		
		theTex->ClampOffset();
		
		//SetScrollRange(hScroll,SB_CTL,0,theTex->subTex.Count()-NDLG,FALSE);
		//SetScrollPos(hScroll,SB_CTL,theTex->offset,TRUE);
		//EnableWindow(hScroll,theTex->NumSubTexmaps()>NDLG);

		if (theTex->subTex.Count()>NDLG) {
			//EnableWindow(GetDlgItem(hPanel,IDC_COMP_UP),theTex->offset>0);
			//EnableWindow(GetDlgItem(hPanel,IDC_COMP_PAGEUP),theTex->offset>0);
			//EnableWindow(GetDlgItem(hPanel,IDC_COMP_DOWN),theTex->offset+NDLG<theTex->subTex.Count());
			//EnableWindow(GetDlgItem(hPanel,IDC_COMP_PAGEDOWN),theTex->offset+NDLG<theTex->subTex.Count());
		} else {
			//EnableWindow(GetDlgItem(hPanel,IDC_COMP_UP),FALSE);
			//EnableWindow(GetDlgItem(hPanel,IDC_COMP_PAGEUP),FALSE);
			//EnableWindow(GetDlgItem(hPanel,IDC_COMP_DOWN),FALSE);
			//EnableWindow(GetDlgItem(hPanel,IDC_COMP_PAGEDOWN),FALSE);
			}

		Interval valid;
		theTex->Update(ip->GetTime(),valid);		
		UpdateSubTexNames();
		/*TSTR buf;
		buf.printf(_T("%d"),theTex->subTex.Count());
		SetDlgItemText(hPanel,IDC_COMP_NUMMAPS,buf);
		for (int i=0; i<min(theTex->subTex.Count(),NDLG); i++) {
			ShowWindow(GetDlgItem(hPanel,mapIDs[i]),SW_SHOW);
			ShowWindow(GetDlgItem(hPanel,labelIDs[i]),SW_SHOW);
			ShowWindow(GetDlgItem(hPanel,mapOnIDs[i]),SW_SHOW);
			ShowWindow(GetDlgItem(hPanel,holdFrameIDs[i]),SW_SHOW);
			
			HWND hwps = GetDlgItem(hPanel,mtlPStampIDs[i]);
			Rect rect;
			GetClientRect( hwps, &rect );
			InvalidateRect(hwps, &rect, FALSE);
//			SetCheckBox(hPanel, mapOnIDs[i], theTex->mapOn[i+theTex->offset]);
			}
		for (; i<NDLG; i++) {
			ShowWindow(GetDlgItem(hPanel,mapIDs[i]),SW_HIDE);
			ShowWindow(GetDlgItem(hPanel,labelIDs[i]),SW_HIDE);
			ShowWindow(GetDlgItem(hPanel,mapOnIDs[i]),SW_HIDE);
			ShowWindow(GetDlgItem(hPanel,holdFrameIDs[i]),SW_HIDE);
			}
		}*/
	}
}

void NExtAnimatedTextureDlg::SetThing(ReferenceTarget *m) 
	{
	assert (m->ClassID()==nextAnimatedBitmapClassID);
	assert (m->SuperClassID()==TEXMAP_CLASS_ID);
	RemovePStampHilite();
	if (theTex) theTex->paramDlg = NULL;
	theTex = (NExtAnimatedTexture*)m;	
	if (theTex) theTex->paramDlg = this;
	LoadDialog(TRUE);
	}

void NExtAnimatedTextureDlg::UpdateMtlDisplay() {	
	ip->MtlChanged();  
	}

void NExtAnimatedTextureDlg::ActivateDlg(BOOL onOff) {	
	}


static INT_PTR CALLBACK NumMapsDlgProc(
		HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
	{
	switch (msg) {
		case WM_INITDIALOG: {
			ISpinnerControl *spin = 
				SetupIntSpinner(
					hWnd,IDC_COMP_NUMMAPSSPIN,IDC_COMP_NUMMAPS,
					2,1000,(int)lParam);
			ReleaseISpinner(spin);
			CenterWindow(hWnd,GetParent(hWnd));
			break;
			}

		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDOK: {
					ISpinnerControl *spin = 
						GetISpinner(GetDlgItem(hWnd,IDC_COMP_NUMMAPSSPIN));
					EndDialog(hWnd,spin->GetIVal());
					ReleaseISpinner(spin);
					break;
					}

				case IDCANCEL:
					EndDialog(hWnd,-1);
					break;
				}
			break;

		default:
			return FALSE;
		}
	return TRUE;
	}
		
void NExtAnimatedTextureDlg::SetNumMaps()
	{
	int res = DialogBoxParam(
		hInstance,
		MAKEINTRESOURCE(IDD_COMP_SETNUM),
		hPanel,
		NumMapsDlgProc,
		(LPARAM)theTex->subTex.Count());
	if (res>=0) {
		RemovePStampHilite();
		theTex->SetNumMaps(res);
		UpdateSubTexNames();
		UpdateMtlDisplay();
		//LoadDialog(TRUE);
		}
	}

//-----------------------------------------------------------------------------
//  NExtAnimatedTexture
//-----------------------------------------------------------------------------

#define NEXT_ANIMATETEXTURE_VERSION 1

void NExtAnimatedTexture::Init() 
	{	
	macroRecorder->Disable();
	ivalid.SetEmpty();
	offset = 0;
	subTex.Resize(0);
//	mapOn.Resize(0);
	SetNumMaps(NDLG);
	macroRecorder->Enable();
	}

void NExtAnimatedTexture::Reset() 
	{	
	DeleteAllRefsFromMe();
	next_animatedtextureCD.MakeAutoParamBlocks(this);	// make and intialize paramblock2
	Init();
	}

void NExtAnimatedTexture::ClampOffset() {
	if (offset+NDLG>subTex.Count()) offset = subTex.Count()-NDLG;
	if (offset<0) offset=0;
	}

void NExtAnimatedTexture::NotifyChanged() {
	NotifyDependents(FOREVER, PART_ALL, REFMSG_CHANGE);
	}

NExtAnimatedTexture::NExtAnimatedTexture() 
	{	
	for (int i=0; i<MAXTEXHANDLES; i++) {
		texHandle[i] = NULL;
		}
	texHandleValid.SetEmpty();
	paramDlg  = NULL;
	pblock = NULL;
	Param1 = FALSE;
	ignoreNotify = FALSE;
	selected = 0;
	m_fps = 60;
	m_phase = 0;
	m_loop_type = vLOOPTYPE_LOOP;
	m_iterations = 0;
	
	next_animatedtextureCD.MakeAutoParamBlocks(this);	// make and intialize paramblock2
	Init();
	rollScroll=0;
	}

void NExtAnimatedTexture::SetNumMaps(int n)
	{
	int ct = subTex.Count();
	if (n!=ct) 
	{
		if (n<ct) 
		{
			for (int i=n; i<ct; i++) 
			{
				// Tell mtledit to deactivate texture map in UI
				if (subTex[i])
					subTex[i]->DeactivateMapsInTree();
				ReplaceReference(i+1,NULL);				
			}
		}
		subTex.SetCount(n);
		holdFrames.SetCount(n);
//		mapOn.SetCount(n);
		pblock->SetCount(next_animatedtexture_tex,n);
		pblock->SetCount(next_animatedtexture_frames,n);
		macroRec->Disable();  // JBW 4/21/99, only record one count change
		pblock->SetCount(next_animatedtexture_ons,n);
		macroRec->Enable();

		if (n>ct) 
		{
			for (int i=ct; i<subTex.Count(); i++) 
			{
				subTex[i] = NULL;				
				pblock->SetValue(next_animatedtexture_ons,0,TRUE,i);
				pblock->SetValue(next_animatedtexture_frames,0,vDEFAULT_HOLD_FRAMES,i);
//				mapOn[i] = TRUE;
				ReplaceReference(i+1,(ReferenceTarget*)GetNExtTextureDesc()->Create());			
				GetCOREInterface()->AssignNewName(subTex[i]);
			}
		}		
		NotifyChanged();
		}
	}

//need to remap references since we added a paramblock
int NExtAnimatedTexture::RemapRefOnLoad(int iref) 
{
if (Param1) iref += 1;
return iref;
}


static AColor black(0.0f,0.0f,0.0f,0.0f);

AColor NExtAnimatedTexture::EvalColor(ShadeContext& sc) {	
	AColor c;
	if (sc.GetCache(this,c)) 
		return c; 
	if (gbufID) sc.SetGBufferID(gbufID);
	AColor res(0,0,0);	
	for (int i=0; i<subTex.Count(); i++) {
//		int on;
		Interval iv;
//		pblock->GetValue(next_animatedtexture_ons,0,on,iv,i);

		if (!subTex[i]||!mapOn[i]) continue;
//		if (!subTex[i]||!on) continue;
		res = CompOver(subTex[i]->EvalColor(sc),res);
		}
	sc.PutCache(this,res); 
	return res;
	}


Point3 NExtAnimatedTexture::EvalNormalPerturb(ShadeContext& sc) 
	{
	Point3 p(0,0,0);
	if (gbufID) sc.SetGBufferID(gbufID);
    BOOL c = FALSE;
	for (int i=0; i<subTex.Count(); i++) {
//		int on;
		Interval iv;
//		pblock->GetValue(next_animatedtexture_ons,0,on,iv,i);
		if (!subTex[i]||!mapOn[i]) continue;
//		if (!subTex[i]||!on) continue;
		Point3 d = subTex[i]->EvalNormalPerturb(sc);
		if (!c) {
			p = d;
			c = 1;
			}	
		else {
			// composite perturbations using alpha -- DS 4/4/97
			AColor col = subTex[i]->EvalColor(sc);
			p = (1.0f-col.a)*p + d;
			}
		}
	return p;	
	}

RefTargetHandle NExtAnimatedTexture::Clone(RemapDir &remap) 
	{
	NExtAnimatedTexture *mnew = new NExtAnimatedTexture();
	*((MtlBase*)mnew) = *((MtlBase*)this);  // copy superclass stuff	
	mnew->ivalid.SetEmpty();	
	mnew->subTex.SetCount(subTex.Count());
	mnew->ReplaceReference(0,remap.CloneRef(pblock));

	mnew->offset = offset;
	mnew->mapOn.SetCount(subTex.Count()); //DS 3/8/99  this seems necessary due to the param block 2 changes.
	mnew->holdFrames.SetCount(subTex.Count()); //DS 3/8/99  this seems necessary due to the param block 2 changes.

	mnew->m_loop_type = m_loop_type;
	mnew->m_iterations = m_iterations;
	mnew->m_fps = m_fps;
	mnew->m_phase = m_phase;

	for (int i = 0; i<subTex.Count(); i++) {
		mnew->subTex[i] = NULL;
		if (subTex[i]) {
			mnew->ReplaceReference(i+1,remap.CloneRef(subTex[i]));
			GetCOREInterface()->AssignNewName(mnew->subTex[i]);
			}
//		mnew->mapOn[i] = mapOn[i];
		}
	BaseClone(this, mnew, remap);
	return (RefTargetHandle)mnew;
	}

ParamDlg* NExtAnimatedTexture::CreateParamDlg(HWND hwMtlEdit, IMtlParams *imp) 
	{
	NExtAnimatedTextureDlg *dm = new NExtAnimatedTextureDlg(hwMtlEdit, imp, this);
	dm->LoadDialog(TRUE);	
	paramDlg = dm;
	return dm;	
	}


void NExtAnimatedTexture::Update(TimeValue t, Interval& valid) 
	{
	if (!ivalid.InInterval(t)) {
		ivalid.SetInfinite();		
		int n = pblock->Count(next_animatedtexture_ons);
		if (n!=mapOn.Count()) mapOn.SetCount(n);
		if (n!=holdFrames.Count()) holdFrames.SetCount(n);
		pblock->GetValue( next_animatedtexture_fps, 0, m_fps, valid );
		pblock->GetValue( next_animatedtexture_phase, 0, m_phase, valid );
		pblock->GetValue( next_animatedtexture_looptype, 0, m_loop_type, valid );
		pblock->GetValue( next_animatedtexture_iterations, 0, m_iterations, valid );		
		for (int i=0; i<subTex.Count(); i++) {
			pblock->GetValue(next_animatedtexture_ons,0,mapOn[i],valid,i);
			pblock->GetValue(next_animatedtexture_frames,0,holdFrames[i],valid,i);
	
			if (subTex[i]) 
				subTex[i]->Update(t,ivalid);
			}
		}		
	valid &= ivalid;
	}

void NExtAnimatedTexture::SetSubTexmap(int i, Texmap *m) {
	if (i>=subTex.Count()) {
		int n = subTex.Count();
		subTex.SetCount(i+1);
		pblock->SetCount(next_animatedtexture_tex,i+1);

		for (int j=n; j<=i; j++)
			subTex[j] = NULL;
		}
	ReplaceReference(i+1,m);
	if (paramDlg)
	{
		paramDlg->UpdateSubTexNames();
		paramDlg->UpdateMtlDisplay();
	}
}

TSTR NExtAnimatedTexture::GetSubTexmapSlotName(int i) {
	TSTR buf;
	buf.printf("%s %d",GetString(IDS_RB_MAP2),i+1);
	return buf;
	}
	 
TSTR NExtAnimatedTexture::SubAnimName(int i) {	
	return GetSubTexmapTVName(i);
	}

RefResult NExtAnimatedTexture::NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, 
   PartID& partID, RefMessage message ) {
	switch (message) {
		case REFMSG_CHANGE:			
			if( ignoreNotify )
			{
				return REF_SUCCEED; 
			}
			if (paramDlg) 
				paramDlg->Invalidate();
			if (pblock->LastNotifyParamID() == next_animatedtexture_tex && pblock->Count(next_animatedtexture_tex) != subTex.Count())
				SetNumMaps(pblock->Count(next_animatedtexture_tex));
			else if (pblock->LastNotifyParamID() == next_animatedtexture_ons && pblock->Count(next_animatedtexture_ons) != subTex.Count())
				SetNumMaps(pblock->Count(next_animatedtexture_ons));
			DiscardTexHandles(); // DS 5/4/00
			ivalid.SetEmpty();
			if (IsTex(hTarget)) {
				int n = subTex.Count();
				for (int i=0; i<n; i++) {
					if (subTex[i] && ((Texmap *)hTarget==subTex[i])) {
						subTex[i]->DiscardPStamp(PS_TINY);
						break;
					}
				}
			}
			if (paramDlg&&Active())
			{
				paramDlg->RemovePStampHilite();
				paramDlg->ip->MtlChanged();
			}
			break;
		
		case REFMSG_GET_PARAM_DIM:
			return REF_STOP; 
		
		case REFMSG_GET_PARAM_NAME: {
			GetParamName *gpn = (GetParamName*)partID;
			gpn->name= GetSubTexmapSlotName(gpn->index);			
			return REF_STOP; 
			}
		}
	return(REF_SUCCEED);
	}


#define MTL_HDR_CHUNK 		0x4000
#define PARAM2_CHUNK 		0x4010
#define SUBTEX_COUNT_CHUNK	0x0010
#define MAPOFF_CHUNK		0x1000

#define LOOPTYPE_CHUNK		0xC000
#define ITERATIONS_CHUNK	0xC001
#define FPS_CHUNK			0xC002
#define PHASE_CHUNK			0xC003


IOResult NExtAnimatedTexture::Save(ISave *isave) { 
	IOResult res;
	ULONG nb;
	// Save common stuff
	isave->BeginChunk(MTL_HDR_CHUNK);
	res = MtlBase::Save(isave);
	if (res!=IO_OK) return res;
	isave->EndChunk();
	
	int c = subTex.Count();
	isave->BeginChunk(SUBTEX_COUNT_CHUNK);
	isave->Write(&c,sizeof(c),&nb);
	isave->EndChunk();

	isave->BeginChunk(PARAM2_CHUNK);
	isave->EndChunk();

	isave->BeginChunk(LOOPTYPE_CHUNK);
	isave->Write(&m_loop_type,sizeof(int),&nb);
	isave->EndChunk();

	isave->BeginChunk(ITERATIONS_CHUNK);
	isave->Write(&m_iterations,sizeof(int),&nb);
	isave->EndChunk();

	isave->BeginChunk(FPS_CHUNK);
	isave->Write(&m_fps,sizeof(int),&nb);
	isave->EndChunk();

	isave->BeginChunk(PHASE_CHUNK);
	isave->Write(&m_phase,sizeof(int),&nb);
	isave->EndChunk();

	/*	for (int i=0; i<subTex.Count(); i++) {
		if (mapOn[i]==0) {
			isave->BeginChunk(MAPOFF_CHUNK+i);
			isave->EndChunk();
			}
		}
*/

	return IO_OK;
	}	
	  

//watje
class CompTexPostLoadCallback:public  PostLoadCallback
{
public:
	NExtAnimatedTexture      *s;
	Tab<BOOL> ons;

	int Param1;
	CompTexPostLoadCallback(NExtAnimatedTexture *r, BOOL b, Tab<BOOL> bl) {s=r;Param1 = b;ons = bl;}
	void proc(ILoad *iload);
};

void CompTexPostLoadCallback::proc(ILoad *iload)
{
	if (Param1)
		{
		s->pblock->SetCount(next_animatedtexture_frames,ons.Count());
		s->pblock->SetCount(next_animatedtexture_ons,ons.Count());
		s->pblock->SetCount(next_animatedtexture_tex,ons.Count());
		for (int i=0; i<s->subTex.Count(); i++) {
			s->pblock->SetValue(next_animatedtexture_ons,0,ons[i],i);

			}
		}
	delete this;
}

IOResult NExtAnimatedTexture::Load(ILoad *iload) { 
	IOResult res;	
	ULONG nb;
	Param1 = TRUE;
	while (IO_OK==(res=iload->OpenChunk())) {
		int id = iload->CurChunkID();
		if (id>=MAPOFF_CHUNK&&id<=MAPOFF_CHUNK+0x1000) {
			mapOn[id-MAPOFF_CHUNK] = FALSE; 
			}
		else 
		switch(id)  {
			case LOOPTYPE_CHUNK:
				iload->Read(&m_loop_type,sizeof(int),&nb);
				break;
			case ITERATIONS_CHUNK:
				iload->Read(&m_iterations,sizeof(int),&nb);
				break;
			case FPS_CHUNK:
				iload->Read(&m_fps,sizeof(int),&nb);
				break;
			case PHASE_CHUNK:
				iload->Read(&m_phase,sizeof(int),&nb);
				break;
			case SUBTEX_COUNT_CHUNK: {
				int c;
				iload->Read(&c,sizeof(c),&nb);
				subTex.SetCount(c);
				mapOn.SetCount(c);
				holdFrames.SetCount(c);
				for (int i=0; i<c; i++)  {
					subTex[i] = NULL;
					mapOn[i] = TRUE;
					holdFrames[i] = vDEFAULT_HOLD_FRAMES;
					}
				break;
				}

			case MTL_HDR_CHUNK:
				res = MtlBase::Load(iload);
				break;
			case PARAM2_CHUNK:
				Param1 = FALSE;
				break;
			}
		iload->CloseChunk();
		if (res!=IO_OK) 
			return res;
		}	
	CompTexPostLoadCallback* comptexplcb = new CompTexPostLoadCallback(this,Param1,mapOn);
	iload->RegisterPostLoadCallback(comptexplcb);

	return IO_OK;
	}


// DDS 5/4/00  Support for multiple texture display in viewports.
void NExtAnimatedTexture::ActivateTexDisplay(BOOL onoff) {
	if (!onoff) {
		DiscardTexHandles();
		}
	}

#define TX_MODULATE 0
#define TX_PMALPHABLEND 1

struct TexOp {
	UBYTE colorOp;
	UBYTE colorAlphaSource;
	UBYTE colorScale;
	UBYTE alphaOp;
	UBYTE alphaAlphaSource;
	UBYTE alphaScale;
	};

static TexOp txops[2] = {
	{ GW_TEX_MODULATE,    GW_TEX_TEXTURE, GW_TEX_SCALE_1X, GW_TEX_LEAVE,  GW_TEX_TEXTURE, GW_TEX_SCALE_1X }, 
	{ GW_TEX_PREMULT_ALPHA_BLEND, GW_TEX_TEXTURE, GW_TEX_SCALE_1X, GW_TEX_LEAVE,  GW_TEX_TEXTURE, GW_TEX_SCALE_1X }, 
	};

static void SetTexOps(TextureInfo *ti, int type) {
	ti->colorOp = txops[type].colorOp;
	ti->colorAlphaSource = txops[type].colorAlphaSource;
	ti->colorScale = txops[type].colorScale;
	ti->alphaOp = txops[type].alphaOp;
	ti->alphaAlphaSource = txops[type].alphaAlphaSource;
	ti->alphaScale = txops[type].alphaScale;
	}

static Color whiteCol(1.0f, 1.0f, 1.0f);

static void SetHWTexOps(IHardwareMaterial *pIHWMat, int ntx, int type)
{
	pIHWMat->SetTextureColorArg(ntx, 1, D3DTA_TEXTURE);
	pIHWMat->SetTextureColorArg(ntx, 2, D3DTA_CURRENT);
	pIHWMat->SetTextureAlphaArg(ntx, 1, D3DTA_TEXTURE);
	pIHWMat->SetTextureAlphaArg(ntx, 2, D3DTA_CURRENT);
	switch (type) {
	case TX_MODULATE:
	default:
		pIHWMat->SetTextureColorOp(ntx, D3DTOP_MODULATE);
		pIHWMat->SetTextureAlphaOp(ntx, D3DTOP_SELECTARG2);
		pIHWMat->SetDiffuseColor(whiteCol);
		pIHWMat->SetAmbientColor(whiteCol);
		break;
	case TX_PMALPHABLEND:
		pIHWMat->SetTextureColorOp(ntx, D3DTOP_BLENDTEXTUREALPHAPM);
		pIHWMat->SetTextureAlphaOp(ntx, D3DTOP_SELECTARG2);
		break;
	}
	pIHWMat->SetTextureTransformFlag(ntx, D3DTTFF_COUNT2);
}

void NExtAnimatedTexture::SetupGfxMultiMaps(TimeValue t, Material *mtl, MtlMakerCallback &cb)
{
	Interval valid;
	Texmap *sub[MAXTEXHANDLES];
	int texOp;

	IHardwareMaterial *pIHWMat = (IHardwareMaterial *)GetProperty(PROPID_HARDWARE_MATERIAL);
	if (pIHWMat) {
		// This is only true if Direct3D is in use
		if (texHandleValid.InInterval(t)) {
			pIHWMat->SetNumTexStages(numTexHandlesUsed);
			int nt = numTexHandlesUsed;
			if (numTexHandlesUsed == 1) {
				texOp = TX_MODULATE;
			}
			else {
				texOp = TX_PMALPHABLEND;
			}
			for (int i = 0; i < nt; i++) {
				if (texHandle[i]) {
					pIHWMat->SetTexture(i, texHandle[i]->GetHandle());
					// Kludge to pass in the TextureStage number
					mtl->texture[0].useTex = i;
					cb.GetGfxTexInfoFromTexmap(t, mtl->texture[0], subTex[useSubForTex[i]]); 		
					SetHWTexOps(pIHWMat, i, texOp);
				}
			}
			return;
		}
		else {
			DiscardTexHandles();
		}

		int forceW = 0;
		int forceH = 0;

		int nsupport = cb.NumberTexturesSupported();

		nsupport = (nsupport > MAXTEXHANDLES) ? MAXTEXHANDLES : nsupport;

		numTexHandlesUsed = 0;

		for (int i = 0; i < MAXTEXHANDLES; i++) {
			texHandle[i] = NULL;
			sub[i] = NULL;
		}

		int nmaps = 0;
		for (i = 0; i < subTex.Count(); i++) {
			if (mapOn[i]) {
				if (subTex[i]) {
					sub[nmaps] = subTex[i];
					useSubForTex[nmaps] = i;
					if (++nmaps >= nsupport) {
						break;
					}
				}
			}
		}

		pIHWMat->SetNumTexStages(nmaps);
		for (i = 0; i < nmaps; i++) {
			pIHWMat->SetTexture(i, (DWORD_PTR)NULL);
		}

		numTexHandlesUsed  = nmaps;

		texHandleValid.SetInfinite();
		
		if (numTexHandlesUsed == 1) {
			texOp = TX_MODULATE;
		}
		else {
			texOp = TX_PMALPHABLEND;
		}
		for (i = 0; i < numTexHandlesUsed; i++) {
			// Kludge to pass in the TextureStage number
			mtl->texture[0].useTex = i;
			cb.GetGfxTexInfoFromTexmap(t, mtl->texture[0], sub[i]);
			BITMAPINFO *bmi = sub[i]->GetVPDisplayDIB(t, cb, valid, FALSE, 0, 0);
			texHandle[i] = cb.MakeHandle(bmi);
			pIHWMat->SetTexture(i, texHandle[i]->GetHandle());
			SetHWTexOps(pIHWMat, i, texOp);
		}
	}
	else {
		if (texHandleValid.InInterval(t)) {
			mtl->texture.SetCount(numTexHandlesUsed);
			int nt = numTexHandlesUsed;
			for (int i=0; i<nt; i++) {
				if (texHandle[i]) {
					mtl->texture[i].textHandle = texHandle[i]->GetHandle();
					cb.GetGfxTexInfoFromTexmap(t, mtl->texture[i], subTex[useSubForTex[i]] ); 		
					SetTexOps(&mtl->texture[i],numTexHandlesUsed==1?TX_MODULATE:TX_PMALPHABLEND);
				}
			}
			return;
		}
		else {
			DiscardTexHandles();
		}

		int forceW = 0;
		int forceH = 0;

		int nsupport = cb.NumberTexturesSupported();

		nsupport = (nsupport > MAXTEXHANDLES) ? MAXTEXHANDLES : nsupport;

		numTexHandlesUsed = 0;

		for (int i=0; i<MAXTEXHANDLES; i++) {
			texHandle[i] = NULL;
			sub[i]=NULL;
			}

		
		int nmaps = 0;
		for (i=0; i<subTex.Count(); i++) {
			if (mapOn[i]) {
				if (subTex[i]) {
					sub[nmaps] = subTex[i];
					useSubForTex[nmaps] = i;
					if (++nmaps>=nsupport)
						break;
					}
				}
			}

		mtl->texture.SetCount(nmaps);
		for (i=0; i<nmaps; i++) {
			mtl->texture[i].textHandle = NULL;
			}

		numTexHandlesUsed  = nmaps;

		texHandleValid.SetInfinite();
		
		for (i=0; i<nmaps; i++) {
			cb.GetGfxTexInfoFromTexmap(t, mtl->texture[i], sub[i] ); 		
			BITMAPINFO *bmi = sub[i]->GetVPDisplayDIB(t,cb,valid,FALSE,0,0); 
			texHandle[i] = cb.MakeHandle(bmi); 
			mtl->texture[i].textHandle = texHandle[i]->GetHandle();
			SetTexOps(&mtl->texture[i],nmaps==1?TX_MODULATE:TX_PMALPHABLEND);
			}
		mtl->texture.SetCount(nmaps);
	}
}

//
// This map is not meaningful unless all of its submaps are on. 
//
bool NExtAnimatedTexture::IsLocalOutputMeaningful( ShadeContext& sc )
{
	for ( int i = 0; i < NumSubTexmaps(); i++ ) 
	{
		if ( SubTexmapOn( i ) && ( GetSubTexmap( i ) != NULL ) )
			return true;
	}
	
	return false;
}

void NExtAnimatedTextureDlg::DrawPStampBlackBorder(HDC hdc, Rect &rect) {
	SelectObject( hdc, GetStockObject( NULL_BRUSH ) );
	SelectObject(hdc,GetStockObject(BLACK_PEN));
	DORECT(0);
	}

void NExtAnimatedTextureDlg::DrawPStampHilite(HDC hdc, BOOL on, Rect &rect) {
	SelectObject( hdc, GetStockObject( NULL_BRUSH ) );
	HPEN hGray = CreatePen( PS_SOLID, 0, GetCustSysColor( COLOR_BTNFACE ) );
	SelectObject(hdc, hGray);
	if (on) SelectObject(hdc, GetStockObject(WHITE_PEN));
	DORECT(1);
	if (on) SelectObject(hdc, GetStockObject(BLACK_PEN));
	DORECT(2);
	DeleteObject( hGray);
	}

void NExtAnimatedTextureDlg::DrawPStampHilite( int i, BOOL on) {
	HWND hwStamp = GetDlgItem(hPanel, mtlPStampIDs[i]);
	HDC hdc = GetDC(hwStamp);
	Rect rect;
	GetClientRect(hwStamp,&rect);
	DrawPStampHilite(hdc, on, rect);
	}

void NExtAnimatedTextureDlg::DrawPStamp(HDC hdc, Rect &rect, int i ) {
	i += theTex->offset; 
	if (i>=theTex->subTex.Count()) 
		return;
	Texmap *m = theTex->subTex[i];
	if (m==NULL) {
	    HBRUSH hOldbrush = (HBRUSH)SelectObject(hdc,GetCustSysColorBrush(COLOR_BTNFACE));
		DORECT(0);
	    SelectObject(hdc,hOldbrush);
		}
	else {
		PStamp *ps = m->GetPStamp(PS_TINY);
		if (!ps) 
			ps = m->CreatePStamp(PS_TINY,TRUE);
		int w = ps->Width();
		int h = ps->Height();
		int scanw = ByteWidth(w);
		int nb = scanw*h;
		UBYTE *workImg = new UBYTE[nb];
		ps->GetImage(workImg);

		GetGPort()->DisplayMap(hdc, rect, 0, 0, workImg, scanw); 
		delete workImg;

/*
		int h = rect.bottom-rect.top; 
		int w = rect.right-rect.left;
		if (w>h) w = h;
		if (h>w) h = w;
		int scanw = ByteWidth(w);
		int nb = scanw*h;
		UBYTE *workImg = new UBYTE[nb];
		
		// Need to put this into Interface with separate w,h
		GetCOREInterface()->Execute(I_EXEC_RENDER_MTL_SAMPLE,(ULONG_PTR)m, (ULONG_PTR)w, (ULONG_PTR)workImg);
		GetGPort()->DisplayMap(hdc, rect, 0, 0, workImg, scanw); 
		delete workImg;
*/
		}
	DrawPStampBlackBorder(hdc, rect);
	if (i==theTex->selected) {
		DrawPStampHilite(hdc, TRUE, rect);
		}
	}				

void NExtAnimatedTextureDlg::SelectTex(int i) {
	if (theTex->selected>=0)
		DrawPStampHilite(theTex->selected-theTex->offset,FALSE);
	theTex->selected = i+theTex->offset;
	if (i>=0)
		DrawPStampHilite(i, TRUE);
	}


static int SubMtlNumFromPStampID(int id) {
	for (int i=0; i<NDLG; i++) {
		if (mtlPStampIDs[i]==id) return i;
		}
	return 0;
	}


static LRESULT CALLBACK NExtAnimatedTexturePStampWndProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam ) 
{
	int id = SubMtlNumFromPStampID(GetWindowLongPtr(hwnd,GWL_ID));
	HWND hwParent = GetParent(hwnd);
	NExtAnimatedTextureDlg *theDlg = (NExtAnimatedTextureDlg *)GetWindowLongPtr(hwParent, GWLP_USERDATA);
	if (theDlg==NULL) return FALSE;

    switch (msg) {
		case WM_COMMAND: 	
		case WM_MOUSEMOVE: 	
		case WM_CREATE:
		case WM_DESTROY: 
		break;

		case WM_LBUTTONUP: 
			theDlg->SelectTex( id );
			break;

		case WM_PAINT: 	
		{
			PAINTSTRUCT ps;
			Rect rect;
			HDC hdc = BeginPaint( hwnd, &ps );
			if (!IsRectEmpty(&ps.rcPaint)) {
				GetClientRect( hwnd, &rect );
				theDlg->DrawPStamp( hdc, rect, id )	;
				}
			EndPaint( hwnd, &ps );
		}													
		break;
	}
	return DefWindowProc(hwnd,msg,wParam,lParam);
} 									   

int	NExtAnimatedTexture::GetFPS( void )
{
	return m_fps;
}

int	NExtAnimatedTexture::GetPhase( void )
{
	return m_phase;
}

int	NExtAnimatedTexture::GetIterations( void )
{
	return m_iterations;
}

int	NExtAnimatedTexture::GetLoopType( void )
{
	return m_loop_type;
}

int	NExtAnimatedTexture::GetNumFrames( void )
{
	int i, num_frames;

	num_frames = 0;
	for( i = 0; i < subTex.Count(); i++ )
	{
		bool active;
		
		active = false;
		if( subTex[i] && ( subTex[i]->ClassID() == NEXT_TEXTURE_CLASS_ID ))
		{
			INExtTexture* next_tex = dynamic_cast< INExtTexture* >( subTex[i] );
			if( next_tex->BaseMapDefined( 0 ) && mapOn[i] )
			{
				active = true;
			}
		}	

		if( active )
		{
			num_frames++;
		}
	}
	return num_frames;
}


Texmap*	NExtAnimatedTexture::GetMap( int frame )
{
	int i;

	for( i = 0; i < subTex.Count(); i++ )
	{
		bool active;
		
		active = false;
		if( subTex[i] && ( subTex[i]->ClassID() == NEXT_TEXTURE_CLASS_ID ))
		{
			INExtTexture* next_tex = dynamic_cast< INExtTexture* >( subTex[i] );
			if( next_tex->GetBaseMap( 0, true ) && mapOn[i] )
			{
				active = true;
			}
		}	

		if( active )
		{
			if( frame == 0 )
			{
				Texmap* map;
				Interval ivalid;

				ivalid.SetInfinite();
				pblock->GetValue( next_animatedtexture_tex, 0, map, ivalid, i );
				return subTex[i];
			}
			frame--;
		}
	}

	return NULL;
}

int	NExtAnimatedTexture::GetTime( int frame )
{
	int i;
	float scale;
	int running_time;

	scale = 1000.f / m_fps;
	running_time = 0;
	for( i = 0; i < subTex.Count(); i++ )
	{
		bool active;
		
		active = false;
		if( subTex[i] && ( subTex[i]->ClassID() == NEXT_TEXTURE_CLASS_ID ))
		{
			INExtTexture* next_tex = dynamic_cast< INExtTexture* >( subTex[i] );
			if( next_tex->GetBaseMap( 0, true ) && mapOn[i] )
			{
				active = true;
			}
		}	

		if( active )
		{
			if( frame == 0 )
			{
				return running_time;
			}
			running_time += ( scale * holdFrames[i] );
			frame--;
		}
	}

	return running_time;
}

int	NExtAnimatedTexture::GetDuration( int frame )
{
	int i;
	float scale;
	
	scale = 1000.f / m_fps;
	for( i = 0; i < subTex.Count(); i++ )
	{
		bool active;
		
		active = false;
		if( subTex[i] && ( subTex[i]->ClassID() == NEXT_TEXTURE_CLASS_ID ))
		{
			INExtTexture* next_tex = dynamic_cast< INExtTexture* >( subTex[i] );
			if( next_tex->GetBaseMap( 0, true ) && mapOn[i] )
			{
				active = true;
			}
		}	

		if( active )
		{
			if( frame == 0 )
			{
				int hold;

				hold = holdFrames[i];
				return ( hold * scale );
			}
			frame--;
		}
	}

	return 0;
}