/*
	ScriptBrowse.cpp
	Script Browser/Categorizer Dialog

	Adam Lippmann
	12-21-01
*/

#include "ScriptBrowse.h"

AddNodeDlg::AddNodeDlg(HINSTANCE hInstance,HWND hwndParent) :
	MSDlgWindow(hInstance,MAKEINTRESOURCE(IDD_ADDNODE),hwndParent)
{
	fpCallback=NULL;
	vpCallback=NULL;

	Show();
}

AddNodeDlg::~AddNodeDlg()
{
	
}


void AddNodeDlg::SetCallback(void(*func)(CStr,void*),void* vpValue)
{
	fpCallback=func;
	vpCallback=vpValue;
}

CStr AddNodeDlg::GetName()
{
	char buf[256];
	GetDlgItemText(hwnd,IDC_EDIT1,buf,256);
	return CStr(buf);
}

BOOL AddNodeDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_ACTIVATE:
		if (LOWORD(wParam)==WA_INACTIVE)
			EnableAccelerators();
		else
			DisableAccelerators();
		
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK:
			Hide();
			if (fpCallback)
				fpCallback(GetName(),vpCallback);
			return TRUE;
		
		case IDCANCEL:

			return TRUE;
		}

		return TRUE;

	case WM_CLOSE:
		Hide();
		return TRUE;
	}

	return FALSE;
}

///////////////////////////////////////////////////////////

ScriptBrowse::ScriptBrowse(HINSTANCE hInstance,HWND hwndParent,PropEditor* pPropEdit) :
	MSDlgWindow(hInstance,MAKEINTRESOURCE(IDD_SCRIPTBROWSE),hwndParent), ttip(hInstance)
{
	this->pPropEdit=pPropEdit;
	pAddNodeDlg=NULL;

	// Tell the pattern edit box that we want notification when the user presses return
	ICustEdit* IEdit=GetICustEdit(GetDlgItem(hwnd,IDC_PATTERN));
	IEdit->WantReturn(TRUE);
	ReleaseICustEdit(IEdit);

	// Fill the script browser with all the globals
	int size=pPropEdit->scriptDB.GetSize();
	pPropEdit->scriptDB.IterateStart();

	for(int i=0;i<size;i++)
	{
		TypeDesc* curScript;

		curScript=pPropEdit->scriptDB.IterateNext();
		SendDlgItemMessage(hwnd,IDC_GLOBALLIST,LB_ADDSTRING,0,(LPARAM)(char*)curScript->Name);
	}

	tview=new TreeView(hInstance,GetDlgItem(hwnd,IDC_TREE1));

	Show();
}

ScriptBrowse::~ScriptBrowse()
{
	if (tview)
		delete tview;
}

BOOL ScriptBrowse::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	ICustEdit* IEdit;
	char       Text[256];
	NMHDR*     nmhdr;

	switch(msg)
	{
	case WM_ACTIVATE:
		if (LOWORD(wParam)==WA_INACTIVE)
			EnableAccelerators();
		else
			DisableAccelerators();
		
		return TRUE;
	
	case WM_NOTIFY:
		nmhdr=(NMHDR*)lParam;

		switch(nmhdr->idFrom)
		{
		case IDC_TREE1:
			switch(nmhdr->code)
			{
			case TVN_SELCHANGED:
				EnableWindow(GetDlgItem(hwnd,IDC_QADDCHILD),TRUE);
				return TRUE;
			}
		}
		return FALSE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_GETDESCRIPTION:
			GetDescription();
			return TRUE;

		case IDC_QADDSCRIPT:
			AddScripts();
			return TRUE;

		case IDC_QADDNODE:
			AddNode();
			return TRUE;

		case IDC_QADDCHILD:
			AddChildNode();
			return TRUE;

		case IDC_QDEF:
			GoToDefinition();
			return TRUE;

		case IDC_QOK:
			Hide();
			return TRUE;

		case IDC_QCANCEL:
			Hide();
			return TRUE;

		case IDC_QINSERT:
			InsertScript();
			return TRUE;

		case IDC_GLOBALLIST:
			switch(HIWORD(wParam))
			{
			case LBN_SELCHANGE:
				ListSelChange();
			}
			return TRUE;

		case IDC_PATTERN:
			switch(HIWORD(wParam))
			{
			case EN_CHANGE:
				IEdit=GetICustEdit(GetDlgItem(hwnd,IDC_PATTERN));
				
				if (IEdit->GotReturn())
				{
					IEdit->GetText(Text,256);
					ProcessPattern(Text);
				}

				ReleaseICustEdit(IEdit);
				break;
			}
			break;
		}
		break;

	case WM_CLOSE:
		Hide();
		return TRUE;
	}

	return FALSE;
}

void ScriptBrowse::ProcessPattern(CStr strPattern)
{
	// Clear the global list box
	SendDlgItemMessage(hwnd,IDC_GLOBALLIST,LB_RESETCONTENT,0,0);

	// Fill the script browser with all the globals
	int size=pPropEdit->scriptDB.GetSize();
	pPropEdit->scriptDB.IterateStart();

	for(int i=0;i<size;i++)
	{
		TypeDesc* curScript;

		curScript=pPropEdit->scriptDB.IterateNext();

		if (MatchPattern(curScript->Name,strPattern))
			SendDlgItemMessage(hwnd,IDC_GLOBALLIST,LB_ADDSTRING,0,(LPARAM)(char*)curScript->Name);
	}
}

void ScriptBrowse::ListSelChange()
{
	char buf[256];

	int index=SendDlgItemMessage(hwnd,IDC_GLOBALLIST,LB_GETCURSEL,0,0);
	SendDlgItemMessage(hwnd,IDC_GLOBALLIST,LB_GETTEXT,index,(LPARAM)buf);

	SetDlgItemText(hwnd,IDC_SCRIPTNAME,buf);
}

void ScriptBrowse::GoToDefinition()
{
	char buf[256];

	int index=SendDlgItemMessage(hwnd,IDC_GLOBALLIST,LB_GETCURSEL,0,0);
	SendDlgItemMessage(hwnd,IDC_GLOBALLIST,LB_GETTEXT,index,(LPARAM)buf);

	pPropEdit->GoToScriptDefinition(buf);
}

void ScriptBrowse::GetDescription()
{
	POINT pt;
	CStr keyword=pPropEdit->pRichText->GetWord();

	if (keyword==CStr(""))
		return;

	TypeDesc* tdesc=pPropEdit->scriptDB.GetItem(keyword);
	CStr      strDesc;

	if (tdesc)
	{
		strDesc=pPropEdit->ParseScriptDesc(tdesc->ScriptFile,tdesc->Name);
		if (strDesc.Length()>0)
		{
			GetCursorPos(&pt);
			ttip.CreateTip(strDesc,pt.x,pt.y);
		}
	}
}

void ScriptBrowse::AddToTreeCB(CStr str,void* pThis)
{
	ScriptBrowse* pthis=(ScriptBrowse*)pThis;
	TVItem* item=pthis->tview->AddField(str);
	pthis->tview->SetItemData(item,(void*)item);
	InvalidateRect(GetDlgItem(pthis->hwnd,IDC_TREE1),NULL,TRUE);
}

void ScriptBrowse::AddToTreeChildCB(CStr str,void* pThis)
{
	ScriptBrowse* pthis=(ScriptBrowse*)pThis;
	
	TVItem* parent=(TVItem*)pthis->tview->GetSelection();
	TVItem* item  =pthis->tview->AddField(parent,str);
	pthis->tview->SetItemData(item,(void*)item);
	InvalidateRect(GetDlgItem(pthis->hwnd,IDC_TREE1),NULL,TRUE);
}

void ScriptBrowse::AddNode()
{
	if (pAddNodeDlg)
		delete pAddNodeDlg;

	pAddNodeDlg=new AddNodeDlg(hInstance,hwnd);
	pAddNodeDlg->SetCallback(AddToTreeCB,this);
}

void ScriptBrowse::AddChildNode()
{
	if (pAddNodeDlg)
		delete pAddNodeDlg;

	pAddNodeDlg=new AddNodeDlg(hInstance,hwnd);
	pAddNodeDlg->SetCallback(AddToTreeChildCB,this);
}

void ScriptBrowse::InsertScript()
{
	char buf[256];

	int index=SendDlgItemMessage(hwnd,IDC_GLOBALLIST,LB_GETCURSEL,0,0);
	SendDlgItemMessage(hwnd,IDC_GLOBALLIST,LB_GETTEXT,index,(LPARAM)buf);

	pPropEdit->pRichText->InsertText(buf);
}

void ScriptBrowse::AddScripts()
{
	int numSels=SendDlgItemMessage(hwnd,IDC_GLOBALLIST,LB_GETSELCOUNT,0,0);

	//INT sels=new INT[numSels];


}
