/*
	ReplaceInNodes.cpp
	Replaces a string with another in all the currently selected nodes
*/

#include "ReplaceInNodes.h"
#include "Resource.h"
#include "ParseFuncs.h"

ReplaceInNodesDlg::ReplaceInNodesDlg(HINSTANCE hInstance,HWND hwndParent,Interface* ip) :
	MSDlgWindow(hInstance,MAKEINTRESOURCE(IDD_REPLACEINNODES),hwndParent)
{
	// Initialize custom controls
	IEditSearch  = GetICustEdit(GetDlgItem(hwnd,IDC_EDITSEARCH));
	IEditReplace = GetICustEdit(GetDlgItem(hwnd,IDC_EDITREPLACE));

	this->ip = ip;
}

ReplaceInNodesDlg::~ReplaceInNodesDlg()
{
	ReleaseICustEdit(IEditSearch);
	ReleaseICustEdit(IEditReplace);
}

void ReplaceInNodesDlg::BuildNodeList(INodeTab& nodes,INode* root)
{
	if (!root)
	{
		nodes.ZeroCount();
		root = ip->GetRootNode();
	}
		
	int nKids = root->NumberOfChildren();

	for(int i=0;i<nKids;i++)
	{
		INode* node = root->GetChildNode(i);
		BuildNodeList(nodes,node);
	}

	if (root != ip->GetRootNode())
		nodes.Append(1,&root);
}

BOOL ReplaceInNodesDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK:
			{
				char bufSearch[256];
				char bufReplace[256];

				IEditSearch->GetText(bufSearch,255);
				IEditReplace->GetText(bufReplace,255);

				if (IsDlgButtonChecked(hwnd,IDC_APPLYALL)==BST_CHECKED)
					ProcNodeReplace(bufSearch,bufReplace,true);
				else
					ProcNodeReplace(bufSearch,bufReplace,false);

				MessageBox(hwnd,"Replacement completed","Replace In Nodes",MB_ICONINFORMATION|MB_OK);

				return TRUE;
			}

		case IDCANCEL:
			Hide();
			return TRUE;
		}
	}

	return FALSE;
}

void ReplaceInNodesDlg::ProcNodeReplace(char* search,char* replace,bool bReplaceAll)
{
	if (bReplaceAll)
	{
		// Perform the search/replace on all nodes in the scene
		INodeTab nodes;
		BuildNodeList(nodes);

		for(int i=0;i<nodes.Count();i++)
		{
			CStr propBuffer;
			nodes[i]->GetUserPropBuffer(propBuffer);

			// Perform search and replace on the user property buffer
			propBuffer = ReplaceStr(propBuffer,search,replace);

			nodes[i]->SetUserPropBuffer(propBuffer);
		}
	}
	else
	{
		// Perform the search/replace on all the selected nodes
		int count = ip->GetSelNodeCount();

		for(int i=0;i<count;i++)
		{
			CStr   propBuffer;
			INode* node = ip->GetSelNode(i);

			node->GetUserPropBuffer(propBuffer);
			propBuffer = ReplaceStr(propBuffer,search,replace);
			node->SetUserPropBuffer(propBuffer);
		}
	}
}
