/*
	ConfigData.h
	ConfigData structures

	12-20-01
*/

#ifndef __CONFIGDATA__
#define __CONFIGDATA__

class ScriptIniParser;

//#include "max.h"
#include "../misc/llist.h"
#include "../misc/Saveable.h"

// ConfigClass Flags
#define CCLASS_CREATEDATSTART	 0x01
#define CCLASS_ABSENTINNETGAMES  0x02
#define CCLASS_TRICKOBJECT       0x04
#define CCLASS_OCCLUDER          0x08
#define NUM_CCLASSES             4

/////////////////////////// Config file structures
struct ConfigProp: public Saveable
{
	CStr  name;
	CStr  value;
	CStr  extdata;						// Extended data for describing UI information
	DWORD userData;

	bool operator== (ConfigProp& right)
	{
		if (name == right.name)
			return true;

		return false;
	}

	// For sorting (sorting is done by name only)
	bool operator > (ConfigProp& right)
	{
		if (name > right.name)
			return true;
		
		return false;
	}

	int operator < (ConfigProp& right)
	{
		if (name < right.name)
			return true;

		return false;
	}

	ConfigProp() { userData = 0; }

	int GetSize()
	{
		return GetStringSize(name) + GetStringSize(value) + GetStringSize(extdata) + sizeof(DWORD);
	}

	void Store(void* data)
	{
		unsigned char* pos = (unsigned char*)data;

		WriteString(&pos, name);
		WriteString(&pos, value);
		WriteString(&pos, extdata);

		memcpy(pos, &userData, sizeof(DWORD));
		pos += sizeof(DWORD);
	}

	void Retrieve(void* data)
	{
		unsigned char* pos = (unsigned char*)data;

		GetString(&pos, name);
		GetString(&pos, value);
		GetString(&pos, extdata);

		memcpy(&userData, pos, sizeof(DWORD));
		pos += sizeof(DWORD);
	}
};

struct ConfigType
{
	CStr                  name;
	CStr                  strCmds;		// Commands/Properties to be added to objects of this type
	CStr                  strGroup;		// Group specifies the submenu hierarchy that this type appears in

	bool operator== (ConfigType& right)
	{
		if (name == right.name)
			return true;

		return false;
	}
};

struct ConfigClass
{
	CStr                  name;			// Name of the class
	CStr                  strCmds;		// Commands/Properties to be added to objects of this class
	CStr                  strGroup;		// Group specifies the submenu hierarchy that this class appears in
	LinkList<ConfigType>  types;		// List of class types

	bool operator== (ConfigClass& right)
	{
		if (name == right.name)
			return true;

		return false;
	}
};

struct ConfigScript: public Saveable
{
	CStr                  name;			// The name of the alternate script
	//CStr                  filename;	// The script file that this script will be written to
	CStr                  buffer;		// The script contents

	bool operator== (ConfigScript& right)
	{
		if (name == right.name)
			return true;

		return false;
	}

	int GetSize()
	{
		return GetStringSize(name) + GetStringSize(buffer);
	}

	void Store(void* data)
	{
		unsigned char* pos = (unsigned char*)data;

		WriteString(&pos, name);
		WriteString(&pos, buffer);
	}

	void Retrieve(void* data)
	{
		unsigned char* pos = (unsigned char*)data;

		GetString(&pos, name);
		GetString(&pos, buffer);
	}
};

struct ConfigProgram: public Saveable
{
	enum ProgType
	{
		CFGPROG_STATIC,		// Program results may be cached
		CFGPROG_VOLATILE,	// Program results MUST ALWAYS be revaluated at export time
	};

	CStr     filename;		// The MaxScript file to execute
	CStr     scriptContext;	// The script context that should be created in the PE for this particular program
	ProgType type;			// Determines ability to cache program results

	ConfigProgram()
	{
		type = CFGPROG_STATIC;
	}

	int GetSize()
	{
		return GetStringSize(filename) + GetStringSize(scriptContext) + sizeof(ProgType);
	}

	void Store(void* data)
	{
		unsigned char* pos = (unsigned char*)data;

		WriteString(&pos, filename);
		WriteString(&pos, scriptContext);

		*((ProgType*)pos) = type;
		pos += sizeof(ProgType);
	}

	void Retrieve(void* data)
	{
		unsigned char* pos = (unsigned char*)data;

		GetString(&pos, filename);
		GetString(&pos, scriptContext);

		type = *((ProgType*)pos);
		pos += sizeof(ProgType);
	}

	bool operator ==(ConfigProgram& right)
	{
		if (filename      == right.filename &&
			scriptContext == right.scriptContext)
			return true;

		return false;
	}
};

CStr ParseNodeConfigProps(LinkList<ConfigProp>* cplist,DWORD* flags,INode* node,
						  CStr* unkBuf=0,CStr* clusterBuf=0,
						  LinkList<ConfigProgram>* programs=0,
					      LinkList<ConfigScript>* scriptList=0,
						  int* terrain=0);

CStr ParseConfigProps(LinkList<ConfigProp>* cplist,DWORD* flags,CStr& propBuffer,
					  CStr* unkBuf=0,CStr* clusterBuf=0,
					  LinkList<ConfigProgram>* program=0,
					  LinkList<ConfigScript>* scriptList=0,
					  int* terrain=0);

void ParseArray(LinkList<CStr>* list,CStr value);
CStr GetPropValue(INode* node, CStr propName);
CStr GetPropValueDef(ScriptIniParser* pparser, INode* node, CStr propName);
void AddPropValue(INode* node, CStr category, CStr propName, CStr propValue, CStr extdata = "");
void AddPropValue(INode* node, CStr category, CStr propName, float value, CStr extdata = "");
void AddPropValue(INode* node, CStr category, CStr propName, int value, CStr extdata = "");
bool RemovePropBufProp(INode* node, CStr propName);
CStr GetClassName(char* propBuffer);
CStr GetTypeName(char* propBuffer);
bool GetProperty(char* buf, char* prop, char* out);
int  GetTerrainType(CStr propBuffer, LinkList<ConfigProp>* cplist);
int  GetTerrainType(CStr propBuffer, CStr name, CStr value);

///////////// Particle system @nextparticle related /////////////////////////////////////////////////
bool GetParticleOrientation(char* extdata, Point3* pptMid, Point3* pptEnd, float*  pfMidWidth,
							                                               float*  pfMidHeight,
																		   float*  pfMidLength,
																		   float*  pfEndWidth,
																		   float*  pfEndHeight,
																		   float*  pfEndLength,
																		   Point3* pptMidScale,
																		   Point3* pptEndScale);

void SetParticleOrientation(INode* node, Point3 ptMid, Point3 ptEnd, float  fMidWidth,
							                                         float  fMidHeight,
																	 float  fMidLength,
																	 float  fEndWidth,
																	 float  fEndHeight,
																	 float  fEndLenth,
																	 Point3 ptMidScale,
																	 Point3 ptEndScale);

CStr BuildParticleOrientation(Point3 ptMid, Point3 ptEnd, float  fMidWidth,
							                              float  fMidHeight,
														  float  fMidLength,
														  float  fEndWidth,
														  float  fEndHeight,
														  float  fEndLength,
														  Point3 ptMidScale,
														  Point3 ptEndScale);

bool ComputeParticleOrientation(INode* node, Point3* pptMid, Point3* pptEnd, float*  pfMidWidth,
								                                             float*  pfMidHeight,
																			 float*  pfMidLength,
																			 float*  pfEndWidth,
																			 float*  pfEndHeight,
																			 float*  pfEndLength,
																			 Point3* pptMidScale,
																			 Point3* pptEndScale);
/////////////////////////////////////////////////////////////////////////////////////////////////////

void AttachExtendedData(LinkList<ConfigProp>* cplist,CStr& buf);

#endif
