/*
	Saveable.cpp
	Class to provide helper functions for saving variable-sized
	data to fixed sections of memory
	aml - 10-10-02
*/

#include "..\Export\CutsceneExportDlg.h"
#include "Saveable.h"
#include "..\PropEdit\ConfigData.h"
#include "llist.h"

extern Interface* gInterface;

void WriteNodeList(unsigned char** data, LinkList<INode*>* list)
{
	LinkList<SaveableStr> nameList;
	
	Link<INode*>* link = list->GetHead();

	while(link)
	{
		if (link->data)
		{
			CStr name = link->data->GetName();
			SaveableStr sname = name;
			nameList.Add(&sname);
		}

		link = link->next;
	}

	WriteList<SaveableStr>(data, &nameList);
}

void GetNodeList(unsigned char** data, LinkList<INode*>* list)
{
	list->Clear();

	LinkList<SaveableStr> nameList;
	GetList<SaveableStr>(data, &nameList);

	Link<SaveableStr>* link = nameList.GetHead();

	while(link)
	{
		INode* node = gInterface->GetINodeByName(link->data);

		if (node)
			list->Add(&node);

		link = link->next;
	}
}

int GetNodeListSize(LinkList<INode*>* list)
{
	LinkList<SaveableStr> nameList;
	
	Link<INode*>* link = list->GetHead();

	while(link)
	{
		if (link->data)
		{
			SaveableStr name = CStr(link->data->GetName());
			nameList.Add(&name);
		}

		link = link->next;
	}

	return ListSize(&nameList);
}

void WriteString(unsigned char** data, CStr& str)
{
	int size = str.Length();

	memcpy(*data, &size, sizeof(int));
	(*data) += sizeof(int);
	memcpy(*data, (char*)str, size);
	(*data) += size;
}

void GetString(unsigned char** data, CStr& str)
{
	int   size;
	char* buf;

	memcpy(&size, *data, sizeof(int));
	(*data) += sizeof(int);
	buf = new char[size + 1];
	memcpy(buf, *data, size);
	buf[size] = '\0';
	(*data) += size;

	str = buf;
	delete [] buf;
}

int GetStringSize(CStr& str)
{
	return str.Length() + sizeof(int);
}

int GetStringSize(unsigned char** data)
{
	int size;
	memcpy(&size, *data, sizeof(int));

	return size + sizeof(int);
}  

void Write(unsigned char** data, unsigned int size, void* pSrcData)
{
	memcpy(*data, pSrcData, size);
	(*data) += size;
}

void Read(unsigned char** data, unsigned int size, void* pDestData)
{
	memcpy(pDestData, *data, size);
	(*data) += size;
}

//////////////////////////////////
// Manual implementations of template funcs

int ListSizeConfigProp(unsigned char** data)
{
	unsigned char* pos = *data;
	int size;

	memcpy(&size, pos, sizeof(int));
	pos += sizeof(int);

	int subsize = 0;

	for(int i = 0; i < size; i++)
	{
		ConfigProp data;
		data.Retrieve(pos);
		subsize += data.GetSize();
	}

	return subsize + sizeof(int);
}

int ListSizeConfigScript(unsigned char** data)
{
	unsigned char* pos = *data;
	int size;

	memcpy(&size, pos, sizeof(int));
	pos += sizeof(int);

	int subsize = 0;

	for(int i = 0; i < size; i++)
	{
		ConfigScript data;
		data.Retrieve(pos);
		subsize += data.GetSize();
	}

	return subsize + sizeof(int);
}

int ListSizeConfigProgram(unsigned char** data)
{
	unsigned char* pos = *data;
	int size;

	memcpy(&size, pos, sizeof(int));
	pos += sizeof(int);

	int subsize = 0;

	for(int i = 0; i < size; i++)
	{
		ConfigProgram data;
		data.Retrieve(pos);
		subsize += data.GetSize();
	}

	return subsize + sizeof(int);
}

int ListSizeCutsceneObj(unsigned char** data)
{
	unsigned char* pos = *data;
	int size;

	memcpy(&size, pos, sizeof(int));
	pos += sizeof(int);

	int subsize = 0;

	for(int i = 0; i < size; i++)
	{
		CutsceneObj data;
		data.Retrieve(pos);
		subsize += data.GetSize();
	}

	return subsize + sizeof(int);
}

//////////////////////////////////
