#ifndef __IMAGE_IMAGE_H__
#define __IMAGE_IMAGE_H__

#include <next.h>

#define	vINVALID_CHECKSUM 0xFFFFFFFF

class	NxTexture
{
public:
	enum
	{
		v32_BIT,
		v24_BIT,
		v16_BIT,
		v8_BIT,
		v4_BIT,		
		v8_BIT_GRAY,
		v4_BIT_GRAY,
		v2_BIT,
		v1_BIT,
		v2_BIT_GRAY,
		v1_BIT_GRAY,
	};

	enum
	{
		vMAX_MIP_LEVELS = 10,
		vMIN_MIP_WIDTH = 4,
		vMIN_MIP_HEIGHT = 4,
	};

	enum
	{
		mFORCE_BYTE_PER_COMPONENT		=	0x0001,
		mCHANGE_FULLY_TRANSPARENT_COLOR	=	0x0002,
		mAUTO_GENERATE_MIPMAPS			=	0x0004,
		mTRANSPARENT					=	0x0008,
		mOPAQUE							=	0x0010,
		mCOMPRESS_NGC					=	0x0020,
		mCOMPRESS_XBOX					=	0x0040,
		mPOST_GENERATED_TEXTURE			=   0x0080,  // This flag is set to indicate that this texture
													 // is generated proceedurally using data from other
													 // textures.  The texture exporter will process the
													 // loading of these textures last.   aml

		mAUTO_GENERATE_NGC_MIPS			=   0x0100,
		mAUTO_GENERATE_XBOX_MIPS        =   0x0200,
	};	

	NxTexture( void );	
	~NxTexture( void );

	bool	operator==( NxTexture& texture );

	int GetBpp( void );
	int GetPaletteBpp( void );
	void SetBpp( int bpp );
	void SetPaletteBpp( int bpp );

	void SetPixelFormat( int format );
	void SetPaletteFormat( int format );
	int	GetPixelFormat( void );
	int	GetPaletteFormat( void );

	char* GetTexelData( int mip_level );
	char* GetPaletteData( void );

	void SetTexelData( int mip_level, char* data );
	void SetPaletteData( char* data );

	int	GetTexelDataSize( int mip_level );
	int GetPaletteDataSize( void );
	int	GetTotalDataSize( void );

	int	GetWidth( int mip_level );
	int GetHeight( int mip_level );

	void SetWidth( int mip_level, int width );
	void SetHeight( int mip_level, int height );

	int	GetBytesPerRow( int mip_level );

	void SetNumPaletteEntries( int entries );
	int GetNumPaletteEntries( void );

	bool IsPaletted( void );

	void	SetName( char* name, int mip_level );
	char*	GetName( int mip_level );
	char*	GetMipPath( int mip_level );

	bool	LoadImage( bool bBuildPostGenMips = false );
	bool    SaveImage( char* filename );

	void	SetMap( BitmapInfo* map );
	BitmapInfo*	GetMap( void );

	bool	ShouldAutoGenerateMipMaps( void );
	bool    ShouldAutoGenerate32BitMips( void );
	bool	ShouldCompressComponents( void );
	bool	ShouldChangeTransparentColor( void );	
	
	void	SetTransparentColor( Color trans_color );
	Color	GetTransparentColor( void );
	void	SetFlags( int flags );
	int		GetFlags( void );

	void	SetAutoGenerateMipMaps( bool auto_generate );
	
	void	SetNumMipLevels( int num_mip_levels );
	int		GetNumMipLevels( void );

	void	SetDrawOrder( int order );
	int		GetDrawOrder( void );

	void	GenerateChecksum( void );
	unsigned long	GetChecksum( void );
	void	SetChecksum( unsigned long checksum );

	void	SetValidity( bool valid );
	bool	IsValid( void );

	void	SetPlatformFlags( int flags );
	int		GetPlatformFlags( void );

	BOOL	UsesBasePal(int mip);
	void    SetUseBasePal(int mip,BOOL bUseBasePal);

	bool	IsGrayscale( void );
	void	Dump( void );

	FILETIME	GetFileTime( int mip_level );
	void		SetFileTime( int mip_level, FILETIME time );

private:
	void	initialize( void );	
	bool	load_png( char* path, int mip_level );
	bool	auto_generate_8_bit_palette_mipmaps( bool has_alpha );
	bool	auto_generate_4_bit_palette_mipmaps( bool has_alpha );
	int		get_transparent_edge_flags( void );
	void	create_transparent_mip_edges( int trans_flags, unsigned char trans_index );

	BOOL m_useBasePal[vMAX_MIP_LEVELS];	// aml

	int m_platform_flags;

	int	m_pixel_format[vMAX_MIP_LEVELS];
	int	m_palette_format;

	int	m_width[vMAX_MIP_LEVELS];
	int	m_height[vMAX_MIP_LEVELS];

	int m_bpp[vMAX_MIP_LEVELS];
	int m_palette_bpp;

	char*	m_texel_data[vMAX_MIP_LEVELS];
	char*	m_palette_data;

	int		m_num_palette_entries;
	
	int		m_mip_levels;

	int		m_flags;		

	char	m_name[vMAX_MIP_LEVELS][256];

	Color	m_transparent_color;

	BitmapInfo*	m_map;

	unsigned long m_checksum;

	bool	m_grayscale;
	bool	m_valid;
	int		m_draw_order;

	FILETIME m_filetime[vMAX_MIP_LEVELS];
};

#endif	// __IMAGE_IMAGE_H__