/*
	CASFlags.h
	Create-A-Skater flags
	3-25-01
*/

#ifndef __CASFLAGS__
#define __CASFLAGS__

#include "IDataChannel.h"
#include "ifacedatamgr.h"

#define vCASFACE_FLAGS_CHANNEL_ID	Class_ID(0x85003c, 0x144f1b1f)

typedef	__int64	CASFlagType;

class CASFaceFlagsData : public IFaceDataChannel  
{
	public:
		// Our Storage Container

		Tab<CASFlagType> m_data;
		CASFaceFlagsData( ) 
		{ 
		};

		~CASFaceFlagsData( ) 
		{
		};
		
		// From IFaceDataChannel
		virtual BOOL FacesCreated( ULONG at, ULONG num ) ;
		BOOL FacesClonedAndAppended( BitArray& set ) ;
		BOOL FacesDeleted( BitArray& set ) ;
		BOOL FacesDeleted( ULONG from, ULONG num ) ;
		void AllFacesDeleted() ;
		BOOL FaceCopied( ULONG from, ULONG to ) ;
		BOOL FaceInterpolated( ULONG numSrc, ULONG* srcFaces,float* coeff, ULONG targetFace ); 


		IFaceDataChannel* CreateChannel( ) ;
		IFaceDataChannel* CloneChannel( ) ;
		BOOL AppendChannel( const IFaceDataChannel* fromChan ) ;

		//from IDataChannel
		
		Class_ID DataChannelID()const { return vCASFACE_FLAGS_CHANNEL_ID; }; 
		ULONG Count() const { return m_data.Count(); };

		void DeleteThis(){delete this;}; 

		// Simple data access
		BOOL GetValue( ULONG at, CASFlagType& val ) const;
		BOOL GetValue( BitArray& set, CASFlagType& mask, CASFlagType& diff );
		void SetValue( ULONG at, const CASFlagType& val );
		void SetValue( BitArray& set, const CASFlagType& val );
};

bool ValidFlagConfiguration( CASFlagType mask );

extern	Tab<CASFlagType> g_cas_deleted_face_data;

#endif // __CASFLAGS__
