#ifndef __EXPORT_SCENEEXPORTOPTIONS_H__
#define __EXPORT_SCENEEXPORTOPTIONS_H__

#include "ScriptOptimize.h"

class SceneExportOptions
{
public:

	enum
	{
		//vVERSION_NUMBER = 0x0003,	// Updated to ver. 3 for m_ExportCameras
		//vVERSION_NUMBER = 0x0004,	// Updated to ver. 4 for export to origin option
		//vVERSION_NUMBER = 0x0005,	// Updated to ver. 5 for m_QuickUpdateSelectedOnly
		//vVERSION_NUMBER = 0x0006,	// Updated to ver. 6 for m_DirWarn
		//vVERSION_NUMBER = 0x0007,	// Updated to ver. 7 for m_GenerateLightmaps
		//vVERSION_NUMBER = 0x0008, // Updated to ver. 8 for m_QNCompressionLevel
		vVERSION_NUMBER = 0x0009,	// Updated to ver. 9 for m_PeriodicDays
	};

	enum
	{
		vMAX_LENGTH_SCENE_NAME	= 64,
		vMAX_LENGTH_EXPORT_SET	= 64
	};

	SceneExportOptions( void );

	int		 m_Version;
	bool	 m_Optimized;
	bool	 m_ExportAsSky;
	bool	 m_ExportVisibleOnly;
	bool	 m_ExportAll;
	bool	 m_ExportSelected;
	bool	 m_ExportSelectionSet;
	TSTR	 m_SceneName;
	TSTR	 m_ExportSet;
	bool     m_ExportCameras;		// aml
	bool     m_ExportFromOrigin;	// aml  (Recenter all exported nodes to origin)
	bool	 m_QuickUpdateSelectedOnly;
	bool     m_DirWarn;
	bool     m_GenerateLightmaps;	// aml
	OptLevel m_QNCompressionLevel;	// aml
	int      m_PeriodicDays;		// aml  Number of days between QN replace database rebuilds for periodic QN compression
};


class SceneOptionsDlg
{
public:
	void Show( void );
	void Hide( void );	
private:
	HWND m_wnd;	
};

int	GetSizeSceneExportOptions( void );
void GetSceneExportOptions( SceneExportOptions* options );
void SetSceneExportOptions( SceneExportOptions* options );

#endif // __EXPORT_SCENEEXPORTOPTIONS_H__