/*
	CutsceneController.h
	The cutscene controller allows user define times in an animation
	sequence in which specific game related properties change (visibility, etc.)
	the cutscene controller is also used for defining scripts that fire at
	various times from within TrackView

    aml - 1-23-03
*/

#ifndef __CUTSCENECONTROLLER__
#define __CUTSCENECONTROLLER__

#define CUTSCENECONTROL_CLASS_ID  Class_ID(0x7d0728b3, 0x6cf916f6)

#include "max.h"
#include "control.h"

class CutsceneControl: public StdControl
{

public:
	CutsceneControl();
	~CutsceneControl();

	CutsceneControl& operator=(const CutsceneControl& from);

	void GetValueLocalTime(TimeValue    t,
		                   void*        val,
						   Interval&    valid,
						   GetSetMethod method = CTRL_ABSOLUTE);

	void SetValueLocalTime(TimeValue    t,
		                   void*        val,
						   int          commit = 1,
						   GetSetMethod method = CTRL_ABSOLUTE);

	void Extrapolate(Interval  range,
		             TimeValue t,
					 void*     val,
					 Interval& valid,
					 int       type);

	void* CreateTempValue();
	void  DeleteTempValue(void* val);
	void  ApplyValue(void* val, void* delta);
	void  MultiplyValue(void* val, float m);
};

class CutsceneClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading) { return new CutsceneControl(); }
	const TCHAR *	ClassName() {return _T("Neversoft CutsceneController"); }
	SClass_ID		SuperClassID() {return UTILITY_CLASS_ID;}
	Class_ID 		ClassID() {return DEBUGTOOL_CLASS_ID;}
	const TCHAR* 	Category() {return _T("DebugTool");}
	const TCHAR*	InternalName() { return _T("DebugTool"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }			// returns owning module handle	
};

#endif
