// sps2bmp.cpp : 
//

#include "stdafx.h"
#include "stdio.h"
#include "string.h"
#include "memory.h"
#include "stdlib.h"



int main(int argc, char* argv[])
{

	if (argc == 1)
	{
		printf ("%s  Compiled %s %s\n", argv[0], __DATE__, __TIME__);
		printf (" usage:\n %s filename.sps\n", argv[0]);
		printf (" converts a THPS4 screenshot from .SPS format (Gameshark saved game)\n");
		printf (" to filename.BMP.   The original file is overritten\n");
		return 0;
	}
	
	char	filename[2048];
	strcpy(filename,argv[1]);

	if (strlen(filename)<5)
	{
		printf("bad file name");
		return -1;
	}

	char *p_ext = &filename[strlen(filename)-4]; 
	if (stricmp(".sps",p_ext))
	{
		printf ("must run on a .sps file\n");
		return -1;
	}


	FILE* p_f = fopen(filename,"rb");
	if (!p_f)
	{
		printf ("File %s not found\n",filename);
		return -1;
	}
	fseek(p_f,0,SEEK_END);
	long len=ftell(p_f);
	if (len <880000 || len>890000)
	{
		printf("Bad file size\n");
		fclose(p_f);
	}
	
	fseek(p_f,0,SEEK_SET);
	unsigned char *pBuf=(unsigned char*)malloc(len);
	fread(pBuf,len,1,p_f);
	fclose (p_f);

	// We now have the whole file in pBuf
	// search for the string "BM6 ", which indicates the start of the bmp
	// this is going to be within the first 10K
	unsigned char *p = (unsigned char *)pBuf;
	while (p < pBuf+25000)
	{
		if (p[0] == 0x42 && p[1] == 0x4d && p[2] == 0x36 && p[3] == 0x20 && p[4] == 0x0D)
		{
			// alright!!! we've found the files, so just write it out over the original
			sprintf(p_ext,".bmp");
			p_f = fopen(filename,"wb");
			if (!p_f)
			{
				printf("error writing file\n");
				return -1;
			}
			fwrite(p,1,54+640*448*3,p_f);
			fclose(p_f);

			

			printf ("Done\n");
			return 0;
		}

		p++;
	}

	printf ("This does not contain a BMP\n");
	return -1;


	return 0;
}
