#ifndef __STRIP_STRIP_H__
#define __STRIP_STRIP_H__

#define	vSTRIP_ERROR	-1

// Interface to the stripper object
class INxStripper
{
public:
	virtual	void	Reset( void ) = 0;
	virtual void	SetObject( class NxObject* object ) = 0;
	virtual	void	AddFace( class NxFace* face ) = 0;	
	virtual bool	Stripify( bool use_adc = true ) = 0;
	virtual bool	StripifyForXbox( void ) = 0;
	virtual bool	StripifyForNgc( int flags ) = 0;
	virtual	class	NxMeshList*	GetMeshList( void ) = 0;
	virtual	void	SetPlatform( int platform ) = 0;
};

INxStripper*	GetNxStripper( void );

#endif	// __STRIP_STRIP_H__