// PCDLL.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "windows.h"
#include "PCDLL.h"
#include "PCViewer\PCViewerConv.h"

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}


PCDLL_API int PCDLL_export( char * filename, char * dict_name, char * lmp_name, char * col_name, char * dst_scene, char * usg_name, char * cas_name, bool optimized )
{
	char save_name[256];

			IPCViewerConverter* pcview_conv;
			pcview_conv = GetPCViewerConverter();
			pcview_conv->LoadScene( filename );
			pcview_conv->LoadTextureDictionary( dict_name );
			pcview_conv->LoadLightmaps( lmp_name );
			
			if (!pcview_conv->SaveCollisionData( col_name ))
				return -1;
			
			if (!pcview_conv->ConvertData())
				return -2;

			if (!pcview_conv->SaveScene( dst_scene ))
				return -3;

			strcpy( save_name, dict_name );
			strcat( save_name, ".pcv" );
			
			if (!pcview_conv->SaveTextureDictionary( save_name, usg_name ))
				return -4;

			pcview_conv->SaveCASFlags( cas_name );

	return 0;
}

