#include <memory.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <assert.h>
#include <Strip/Strip.h>
#include <GC/GameCubeConv.h>
#include <List/Search.h>
//#include <Util.h>
#include <Misc/GenCRC.h>
#include <windows.h>
#include <nvDXT/DXTLib.h>
#include <ngcdll/progmesh.h>

#include "Utility.h"
#include "VirtualFile.h"

#include <dolphin\gd.h>

#include <MiniBall/MiniBall.h>

#include <sys/ngc/p_gx.h>

#define writeBig64(_f,_p) (_f)->Write((const char*)_p,8,true);
#define writeBig32(_f,_p) (_f)->Write((const char*)_p,4,true);
#define writeBig16(_f,_p) (_f)->Write((const char*)_p,2,true);
#define writeBig8(_f,_p) (_f)->Write((const char*)_p,1,true);

#define WORST_TOL 512	//48		// Effectively turn off...
#define MIN_COL_LEN 50000.0f	//320.0f

#define WEIGHT_SHIFT 14
#define POS_SHIFT 6
#define NORM_SHIFT 14
#define UV_SHIFT 10

#define WEIGHT_MUL ( 1 << WEIGHT_SHIFT )
#define POS_MUL ( 1 << POS_SHIFT )
#define NORM_MUL ( 1 << NORM_SHIFT )
#define UV_MUL ( 1 << UV_SHIFT )

#define HASH_SIZE (65536*4)
#define HASH_MASK (HASH_SIZE-1)

#define POS_EPSILON ( 1.0f / 16.0f )				// 1/16 pixel best accuracy.
#define NRM_EPSILON ( 1.0f / 360.0f )				// Need high accuracy for env maps.
#define UV_EPSILON ( 1.0f / ( 256.0f * 8.0f ) )		// Assumes largest texture - 256x256, 1/8 pixel accuracy.
#define WEIGHT_EPSILON ( 1.0f / 512.0f )			// 1/512th accuracy.

#define GD_SIZE (1024*512)		// 512k should be more than enough.

bool  g_uv_reset = true;
float g_min_u;
float g_max_u;
float g_min_v;
float g_max_v;

extern short g_tex_off[4];
extern short g_alpha_off[4];
extern int g_num_tex;

static char	_gdbuffer[GD_SIZE+32];
static char	* gdbuffer = &_gdbuffer[(((((uint32)_gdbuffer)+31)&~31) - ((uint32)_gdbuffer))];

static int g_wibble_cols;

static int g_h_pos[HASH_SIZE];
static int g_h_skin_pos[HASH_SIZE];
static int g_h_nrm[HASH_SIZE];
static int g_h_col[HASH_SIZE];
static int g_h_uv[HASH_SIZE];

static float g_u_pos[65536*2][3];
static int g_u_num_pos = 0;
static int g_num_pos = 0;

static float g_u_nrm[65536][3];
static int g_u_num_nrm = 0;
static int g_num_nrm = 0;

static unsigned int g_u_col[65536];
static int g_u_num_col = 0;
static int g_num_col = 0;

static short g_u_uv[65536][2];
static int g_u_num_uv = 0;
static int g_num_uv = 0;

typedef struct {
	float x;
	float y;
	float z;
	float nx;
	float ny;
	float nz;
	float w0;
	float w1;
	float w2;
	int i0;
	int i1;
	int i2;
	NxVertex * p_v;
} SKINPOS;

static SKINPOS g_u_skin_pos[65536];
static int g_u_num_skin_pos = 0;
static int g_num_skin_pos = 0;

int get_pos( float x, float y, float z, int index )
{
	if ( index != -1 ) return index;

	int key = ( (*(unsigned int*)&x) ^ ((*(unsigned int*)&y)<<4) ^ ((*(unsigned int*)&z)<<8) ) & HASH_MASK;

	sint32 ix = (sint32)( x * 16.0f );
	sint32 iy = (sint32)( y * 16.0f );
	sint32 iz = (sint32)( z * 16.0f );

	while ( g_h_pos[key] != -1 )
	{
		sint32 cix = (sint32)( g_u_pos[g_h_pos[key]][0] * 16.0f );
		sint32 ciy = (sint32)( g_u_pos[g_h_pos[key]][1] * 16.0f );
		sint32 ciz = (sint32)( g_u_pos[g_h_pos[key]][2] * 16.0f );

		if ( ix == cix )
		{
			if ( iy == ciy )
			{
				if ( iz == ciz )
				{
					return g_h_pos[key];
				}
			}
		}

//		if ( fabsf( x - g_u_pos[g_h_pos[key]][0] ) < POS_EPSILON )
//		{
//			if ( fabsf( y - g_u_pos[g_h_pos[key]][1] ) < POS_EPSILON )
//			{
//				if ( fabsf( z - g_u_pos[g_h_pos[key]][2] ) < POS_EPSILON )
//				{
//					return g_h_pos[key];
//				}
//			}
//		}

		key++;
		key &= HASH_MASK;
	}

	return -1;
}

void add_pos( float x, float y, float z )
{
	int key = ( (*(unsigned int*)&x) ^ ((*(unsigned int*)&y)<<4) ^ ((*(unsigned int*)&z)<<8) ) & HASH_MASK;

	while ( g_h_pos[key] != -1 )
	{
		key++;
		key &= HASH_MASK;
	}

	sint32 ix = (sint32)( x * 16.0f );
	sint32 iy = (sint32)( y * 16.0f );
	sint32 iz = (sint32)( z * 16.0f );

	float fx = ( (float)ix ) / 16.0f;
	float fy = ( (float)iy ) / 16.0f;
	float fz = ( (float)iz ) / 16.0f;

	g_u_pos[g_u_num_pos][0] = fx;
	g_u_pos[g_u_num_pos][1] = fy;
	g_u_pos[g_u_num_pos][2] = fz;
	g_h_pos[key] = g_u_num_pos;
	g_u_num_pos++;
}

int get_skin_pos( float x, float y, float z, float nx, float ny, float nz, float w0, float w1, float w2, int i0, int i1, int i2 )
{
	int key = ( (*(unsigned int*)&x) ^ ((*(unsigned int*)&y)<<4) ^ ((*(unsigned int*)&z)<<8) ^ (*(unsigned int*)&nx) ^ ((*(unsigned int*)&ny)<<4) ^ ((*(unsigned int*)&nz)<<8) ^ (*(unsigned int*)&w0)  ^ ((*(unsigned int*)&w1)<<4)  ^ ((*(unsigned int*)&w2)<<8) ^ i0 ^ (i1<<4) | (i2<<8) ) & HASH_MASK;

	while ( g_h_skin_pos[key] != -1 )
	{
//		printf( "." );
		if ( fabsf( x - g_u_skin_pos[g_h_skin_pos[key]].x ) < POS_EPSILON )
		{
//			printf( "x" );
			if ( fabsf( y - g_u_skin_pos[g_h_skin_pos[key]].y ) < POS_EPSILON )
			{
//				printf( "y" );
				if ( fabsf( z - g_u_skin_pos[g_h_skin_pos[key]].z ) < POS_EPSILON )
				{
//					printf( "z" );
					if ( fabsf( nx - g_u_skin_pos[g_h_skin_pos[key]].nx ) < NRM_EPSILON )
					{
//						printf( "X" );
						if ( fabsf( ny - g_u_skin_pos[g_h_skin_pos[key]].ny ) < NRM_EPSILON )
						{
//							printf( "Y" );
							if ( fabsf( nz - g_u_skin_pos[g_h_skin_pos[key]].nz ) < NRM_EPSILON )
							{
//								printf( "Z" );
								if ( fabsf( w0 - g_u_skin_pos[g_h_skin_pos[key]].w0 ) < WEIGHT_EPSILON )
								{
//									printf( "0" );
									if ( fabsf( w1 - g_u_skin_pos[g_h_skin_pos[key]].w1 ) < WEIGHT_EPSILON )
									{
//										printf( "1" );
										if ( fabsf( w2 - g_u_skin_pos[g_h_skin_pos[key]].w2 ) < WEIGHT_EPSILON )
										{
//											printf( "2" );
											if ( g_u_skin_pos[g_h_skin_pos[key]].i0 == i0 )
											{
//												printf( "o" );
												if ( g_u_skin_pos[g_h_skin_pos[key]].i1 == i1 )
												{
//													printf( "i" );
													if ( g_u_skin_pos[g_h_skin_pos[key]].i2 == i2 )
													{
//														printf( "z" );
														return g_h_skin_pos[key];
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}

		key++;
		key &= HASH_MASK;
	}

	return -1;
}

void add_skin_pos( float x, float y, float z, float nx, float ny, float nz, float w0, float w1, float w2, int i0, int i1, int i2, NxVertex *p_v ) 
{
	int key = ( (*(unsigned int*)&x) ^ ((*(unsigned int*)&y)<<4) ^ ((*(unsigned int*)&z)<<8) ^ (*(unsigned int*)&nx) ^ ((*(unsigned int*)&ny)<<4) ^ ((*(unsigned int*)&nz)<<8) ^ (*(unsigned int*)&w0)  ^ ((*(unsigned int*)&w1)<<4)  ^ ((*(unsigned int*)&w2)<<8) ^ i0 ^ (i1<<4) | (i2<<8) ) & HASH_MASK;

	while ( g_h_skin_pos[key] != -1 )
	{
		key++;
		key &= HASH_MASK;
	}

	g_u_skin_pos[g_u_num_skin_pos].x = x;
	g_u_skin_pos[g_u_num_skin_pos].y = y;
	g_u_skin_pos[g_u_num_skin_pos].z = z;
	g_u_skin_pos[g_u_num_skin_pos].nx = nx;
	g_u_skin_pos[g_u_num_skin_pos].ny = ny;
	g_u_skin_pos[g_u_num_skin_pos].nz = nz;
	g_u_skin_pos[g_u_num_skin_pos].w0 = w0;
	g_u_skin_pos[g_u_num_skin_pos].w1 = w1;
	g_u_skin_pos[g_u_num_skin_pos].w2 = w2;
	g_u_skin_pos[g_u_num_skin_pos].i0 = i0;
	g_u_skin_pos[g_u_num_skin_pos].i1 = i1;
	g_u_skin_pos[g_u_num_skin_pos].i2 = i2;
	g_u_skin_pos[g_u_num_skin_pos].p_v = p_v;
	g_h_skin_pos[key] = g_u_num_skin_pos;
	g_u_num_skin_pos++;
}

int get_nrm( float x, float y, float z )
{
	int key = ( (*(unsigned int*)&x) ^ ((*(unsigned int*)&y)<<4) ^ ((*(unsigned int*)&z)<<8) ) & HASH_MASK;

	sint32 ix = (sint32)( x * NORM_MUL );
	sint32 iy = (sint32)( y * NORM_MUL );
	sint32 iz = (sint32)( z * NORM_MUL );

	while ( g_h_nrm[key] != -1 )
	{
		sint32 cix = (sint32)( g_u_nrm[g_h_nrm[key]][0] * NORM_MUL );
		sint32 ciy = (sint32)( g_u_nrm[g_h_nrm[key]][1] * NORM_MUL );
		sint32 ciz = (sint32)( g_u_nrm[g_h_nrm[key]][2] * NORM_MUL );

		if ( ix == cix )
		{
			if ( iy == ciy )
			{
				if ( iz == ciz )
				{
					return g_h_nrm[key];
				}
			}
		}

		key++;
		key &= HASH_MASK;
	}

//	while ( g_h_nrm[key] != -1 )
//	{
//		if ( fabsf( x - g_u_nrm[g_h_nrm[key]][0] ) < NRM_EPSILON )
//		{
//			if ( fabsf( y - g_u_nrm[g_h_nrm[key]][1] ) < NRM_EPSILON )
//			{
//				if ( fabsf( z - g_u_nrm[g_h_nrm[key]][2] ) < NRM_EPSILON )
//				{
//					return g_h_nrm[key];
//				}
//			}
//		}
//
//		key++;
//		key &= HASH_MASK;
//	}

	return -1;
}

void add_nrm( float x, float y, float z )
{
	int key = ( (*(unsigned int*)&x) ^ ((*(unsigned int*)&y)<<4) ^ ((*(unsigned int*)&z)<<8) ) & HASH_MASK;

	while ( g_h_nrm[key] != -1 )
	{
		key++;
		key &= HASH_MASK;
	}

	sint32 ix = (sint32)( x * NORM_MUL );
	sint32 iy = (sint32)( y * NORM_MUL );
	sint32 iz = (sint32)( z * NORM_MUL );

	float fx = ( (float)ix ) / NORM_MUL;
	float fy = ( (float)iy ) / NORM_MUL;
	float fz = ( (float)iz ) / NORM_MUL;

	g_u_nrm[g_u_num_nrm][0] = fx;
	g_u_nrm[g_u_num_nrm][1] = fy;
	g_u_nrm[g_u_num_nrm][2] = fz;

//	g_u_nrm[g_u_num_nrm][0] = x;
//	g_u_nrm[g_u_num_nrm][1] = y;
//	g_u_nrm[g_u_num_nrm][2] = z;
	g_h_nrm[key] = g_u_num_nrm;
	g_u_num_nrm++;
}

int get_col( unsigned int col )
{
	int key = col & HASH_MASK;

	while ( g_h_col[key] != -1 )
	{
		if ( col == g_u_col[g_h_col[key]] )
		{
			return g_h_col[key];
		}

		key++;
		key &= HASH_MASK;
	}

	return -1;
}

void add_col( unsigned int col )
{
	int key = col & HASH_MASK;

	while ( g_h_col[key] != -1 )
	{
		key++;
		key &= HASH_MASK;
	}

	g_u_col[g_u_num_col] = col;
	g_h_col[key] = g_u_num_col;
	g_u_num_col++;
}

int get_uv( short u, short v )
{
	int key = ( u ^ ( v << 2 ) ) & HASH_MASK;

	while ( g_h_uv[key] != -1 )
	{
		if ( u == g_u_uv[g_h_uv[key]][0] )
		{
			if ( v == g_u_uv[g_h_uv[key]][1] )
			{
				return g_h_uv[key];
			}
		}

		key++;
		key &= HASH_MASK;
	}

	return -1;
}

void add_uv( short u, short v )
{
	int key = ( u ^ ( v << 2 ) ) & HASH_MASK;

	while ( g_h_uv[key] != -1 )
	{
		key++;
		key &= HASH_MASK;
	}

	g_u_uv[g_u_num_uv][0] = u;
	g_u_uv[g_u_num_uv][1] = v;
	g_h_uv[key] = g_u_num_uv;
	g_u_num_uv++;
}

void init_hash_tables( void )
{
	for ( int lp = 0; lp < HASH_SIZE; lp++ )
	{
		g_h_pos[lp] = -1;
		g_h_skin_pos[lp] = -1;
		g_h_nrm[lp] = -1;
		g_h_col[lp] = -1;
		g_h_uv[lp] = -1;
	}

//	add_col( 0x80808080 );

	// Reset global pools.
	g_u_num_pos = 0;
	g_u_num_skin_pos = 0;
	g_u_num_nrm = 0;
	g_u_num_col = 0;
	g_u_num_uv = 0;
	g_num_pos = 0;
	g_num_skin_pos = 0;
	g_num_nrm = 0;
	g_num_col = 0;
	g_num_uv = 0;
}

bool	gTextureOverride = false;
int		gTextureOverrideMapping[Utils::vNUM_PLATFORMS] = { 0, 1, 2 };

class GameCubeConverter : public IGameCubeConverter
{
public:
	bool	SaveCollisionData( char* path );
	bool	ConvertData( void );
	bool	SaveScene( char* path );
	bool	SaveTextureDictionary( char* path, char* usg_path );
	void	SetAlpha( void );
	bool	SaveCASFlags( char* path );
	bool	SaveWeightMap( char* path );
	int		GetPlatformFlags( void );
	__int64	GetBlendParameters( int blend_mode, int fixed );

private:
	void	OptimizeVertexLists( void );
	void	ApplyMaterialColors( void );
	void	CreateTriStrips( void );

	void	ExpandGrassGeometry( void );

	bool	SaveMaterials( IoUtils::CVirtualOutputFile* pOutputFile );
	bool	SaveMaterials2( IoUtils::CVirtualOutputFile* pGDFile, bool skinned );
	bool	SaveGeometry( IoUtils::CVirtualOutputFile* pOutputFile );
	bool	SaveGeometry2( IoUtils::CVirtualOutputFile* pGDFile );

	unsigned int CalculateMaterialBytes2( void );

	// Stuff stolen from Nintendo's compression library source.
	void	TCFixCMPWord( unsigned short* data );
	void	TCFixEndian( unsigned char* src, unsigned int numBytes );
	void	TCPackTile_CMP ( char * pData, int width, int height, unsigned int tileX, unsigned int tileY, unsigned short* dstPtr);
	void	FixCompressedTexture ( char * pData, int width, int height, char * pFixed );

	typedef struct
	{
		void *	pNext;
		int		count;
		int		matrix;
		float *	pPosNormal;
		short *	pIndex;			// Note: Purely for remapping purposes.
		NxVertex ** ppVertex;
	} skinSingle;

	typedef struct
	{
		void *	pNext;
		int		count;
		char	matrix0;
		char	matrix1;
		char	pad0;
		char	pad1;
		float *	pPosNormal;
		float *	pWeight;
		short *	pIndex;			// Note: Purely for remapping purposes.
		NxVertex ** ppVertex;
	} skinDouble;

	typedef struct
	{
		void *	pNext;
		int		count;
		int		matrix;
		float *	pPosNormal;
		float *	pWeight;
		short *	pIndex;
	} skinAdd;
};

//typedef enum _GXTexFmt
//{
//
//#define _GX_TF_CTF     0x20 /* copy-texture-format only */
//#define _GX_TF_ZTF     0x10 /* Z-texture-format */
//
//    GX_TF_I4     = 0x0,
//    GX_TF_I8     = 0x1,
//    GX_TF_IA4    = 0x2,
//    GX_TF_IA8    = 0x3,
//    GX_TF_RGB565 = 0x4,
//    GX_TF_RGB5A3 = 0x5,
//    GX_TF_RGBA8  = 0x6,
//    GX_TF_CMPR   = 0xE,
//
//    GX_CTF_R4    = 0x0 | _GX_TF_CTF,
//    GX_CTF_RA4   = 0x2 | _GX_TF_CTF,
//    GX_CTF_RA8   = 0x3 | _GX_TF_CTF,
//    GX_CTF_YUVA8 = 0x6 | _GX_TF_CTF,
//    GX_CTF_A8    = 0x7 | _GX_TF_CTF,
//    GX_CTF_R8    = 0x8 | _GX_TF_CTF,
//    GX_CTF_G8    = 0x9 | _GX_TF_CTF,
//    GX_CTF_B8    = 0xA | _GX_TF_CTF,
//    GX_CTF_RG8   = 0xB | _GX_TF_CTF,
//    GX_CTF_GB8   = 0xC | _GX_TF_CTF,
//
//    GX_TF_Z8     = 0x1 | _GX_TF_ZTF,
//    GX_TF_Z16    = 0x3 | _GX_TF_ZTF,
//    GX_TF_Z24X8  = 0x6 | _GX_TF_ZTF,
//
//    GX_CTF_Z4    = 0x0 | _GX_TF_ZTF | _GX_TF_CTF,
//    GX_CTF_Z8M   = 0x9 | _GX_TF_ZTF | _GX_TF_CTF,
//    GX_CTF_Z8L   = 0xA | _GX_TF_ZTF | _GX_TF_CTF,
//    GX_CTF_Z16L  = 0xC | _GX_TF_ZTF | _GX_TF_CTF,
//
//    GX_TF_A8     = GX_CTF_A8 // to keep compatibility
//} GXTexFmt;
	
unsigned char*	gpCompressedData		= NULL;
int				gDXTFormat;
int				gDXTBytesWritten;

void WriteDTXnFile( DWORD count, void *buffer )
{
	// It seems this gets called three times per texture.
	// First with a 4-byte block - ID sanity check perhaps?
	// Second, with a 124-byte block - header information?
	// Third, with a block dependent on the size of the texture - the actual DXT compressed texture information.
	if(( count != 4 ) && ( count != 124 ))
	{
		memcpy( gpCompressedData, buffer, count );
		gpCompressedData	+= count;
		gDXTBytesWritten	+= count;
	}
}



void ReadDTXnFile(DWORD count, void * buffer)
{
}

static GameCubeConverter*	sp_gc_conv = NULL;

IGameCubeConverter* GetGameCubeConverter( void )
{
	if ( sp_gc_conv == NULL )
	{
		sp_gc_conv = new GameCubeConverter;
	}

	return sp_gc_conv;
}

void ResetGameCubeConverter()
{
	init_hash_tables();
	if ( sp_gc_conv )
	{
		delete sp_gc_conv;
		sp_gc_conv = NULL;
	}
}

void	GameCubeConverter::ExpandGrassGeometry( void )
{
	int i;

	for( i = 0; i < m_scene->m_NumObjects; i++ )
	{
		int j, k, l, total_verts, total_faces;
		NxObject* object;
		NxVertex* new_vert_list;
		NxFace* new_face_list;		
		int num_new_faces, num_new_verts, dst_vert_idx, dst_face_idx;

		object = &m_scene->m_Objects[i];
		if( object->m_Flags & NxObject::mINVISIBLE )
		{
			continue;
		}

		// First, count up the number of extra faces we'll have to create as a result of grass
		// rendering, which creates a new mesh per grass level		
		num_new_faces = 0;
		for( j = 0; j < object->m_NumFaces; j++ )
		{
			NxMaterial* material;
			NxFace* face=&object->m_Faces[j];

			material = m_scene->GetMaterial( face->m_MatChecksum );
			if(( material == NULL ) || !( material->m_grassify ))
			{
				continue;
			}

			if ( HasValidUVs(material, object, face, 0 ) )
			{
				num_new_faces += material->m_grassLayers;
			}
		}

		num_new_verts = num_new_faces * 3;

		total_faces = object->m_NumFaces + num_new_faces;
		total_verts = object->m_NumVerts + num_new_verts;

		new_vert_list = new NxVertex[ total_verts ];
		new_face_list = new NxFace[ total_faces ];

		// First, copy all of the existing faces and verts into the new array
		memcpy( new_vert_list, object->m_Verts, sizeof( NxVertex ) * object->m_NumVerts );
		memcpy( new_face_list, object->m_Faces, sizeof( NxFace ) * object->m_NumFaces );

		// Now fill the rest of the array with the new verts and faces from the extra passes
		dst_vert_idx = object->m_NumVerts;
		dst_face_idx = object->m_NumFaces;

		int eCount=0;

		for( j = 0; j < object->m_NumFaces; j++ )
		{
			NxFace* src_face, *dst_face;
			NxMaterial* material;
			int src_uv_channel;
			NxVertex src_verts[3];

			src_face = &new_face_list[j];
			material = m_scene->GetMaterial( src_face->m_MatChecksum );
			if( ( material == NULL )  || !( material->m_grassify ))
			{
				continue;
			}
			
			if (!HasValidUVs(material, object, src_face, 0 ))
			{
				continue;
			}

			src_verts[0] = new_vert_list[src_face->m_Vertex[0]];
			src_verts[1] = new_vert_list[src_face->m_Vertex[1]];
			src_verts[2] = new_vert_list[src_face->m_Vertex[2]];

			int num_grass_layers = material->m_grassLayers;
			float layer_height = material->m_grassHeight / num_grass_layers;

			// Add each extra face to the face list
			// Add each faces' verts to the vert list
			for( k = 0; k < num_grass_layers; k++ )
			{
				src_uv_channel = get_source_uv_channel( src_face->m_PassFlags, 0 );

				eCount++;

				dst_face = &new_face_list[ dst_face_idx ];

				// Note that the material checksum is case-sensitve (so we use GenerateCRC(string, length))
				char material_name[64];
				sprintf( material_name, "Grass-Grass_Layer%d", k );
				uint32 layer_mat_checksum = GenerateCRC(material_name, strlen( material_name ));

				*dst_face = *src_face;
				dst_face->m_Pass = ( 0 );
				dst_face->m_FaceFlags |= NxFace::mFD_NO_SKATER_SHADOW;
				dst_face->m_MatChecksum = layer_mat_checksum;
				dst_face->m_Vertex[0] = dst_vert_idx;
				dst_face->m_Vertex[1] = dst_vert_idx + 1;
				dst_face->m_Vertex[2] = dst_vert_idx + 2;

				for( l = 0; l < 3; l++ )
				{
					new_vert_list[dst_vert_idx] = src_verts[l];
					new_vert_list[dst_vert_idx].m_Pos[1] += (layer_height * (k + 1));
			
					// Calculate uv's based on xz's
					float u	= src_verts[l].m_Pos[0] / 48.0f;
					float v	= src_verts[l].m_Pos[2] / 48.0f;

					// Now copy over pass-specific info into the new vertex (which represents a subsequent pass)
					new_vert_list[dst_vert_idx].m_TexCoord[src_uv_channel][0] = u;
					new_vert_list[dst_vert_idx].m_TexCoord[src_uv_channel][1] = v;

					dst_vert_idx++;
				}
				dst_face_idx++;

				// Adjust layer material
				NxMaterial* layer_material = m_scene->GetMaterial(layer_mat_checksum);
				if (!layer_material)
				{
					printf("Error: Can't find grass material %s\n", material_name);
					continue;
				}

				// DrawOrder must be above 1500 so shadow is drawn first
				float base_draw_order = Mth::Max(1501.0f, material->m_DrawOrder);
				if (layer_material->m_DrawOrder != (base_draw_order + k))
				{
					layer_material->m_GroupFlags |= NxMaterial::mGROUP_TRANSPARENT;
					layer_material->m_DrawOrder = base_draw_order + k;

					if( layer_material->m_Sorted )
					{
						// Sort "sorted" materials to the end of the list
						// I add one to make sure that we won't get a value of 0, which would merge sorted materials
						// in with unsorted ones.  Then I multiply * 1000 to make sure the sorted materials
						// sort to the end of the list
						layer_material->SetPri(( layer_material->m_DrawOrder + 1 ) * 1000.0f );
					}
					else
					{
						layer_material->SetPri( layer_material->m_DrawOrder );
					}

					// Re-add to list
					layer_material->Remove();
					m_scene->RemoveMaterialFromLookup(layer_material);
					m_scene->m_Materials.AddNodeBackwards(layer_material);
					m_scene->AddMaterialToLookup(layer_material);
				}
			}			
		}
		
		// We don't need the originals anymore
		delete [] object->m_Verts;
		delete [] object->m_Faces;

		// Point the object to its new topology
		assert(dst_vert_idx == total_verts);
		assert(dst_face_idx == total_faces);
		object->m_NumVerts = total_verts;
		object->m_NumFaces = total_faces;		
		
		object->m_Verts = new_vert_list;
		object->m_Faces = new_face_list;
		object->m_Flags |= NxObject::mGRASS;
	}

	// Clear these stat variables
	iReject=0; iTotal=0;
}

void GameCubeConverter::OptimizeVertexLists( void )
{
	int i;

	for( i = 0; i < m_scene->m_NumObjects; i++ )
	{
		NxObject* object;		

		object = &m_scene->m_Objects[i];
		object->OptimizeVertList( m_scene );
	}
}



void GameCubeConverter::ApplyMaterialColors( void )
{
	for( int i = 0; i < m_scene->m_NumObjects; i++ )
	{
		NxObject* object;		

		object = &m_scene->m_Objects[i];
		if( object->m_Flags & NxObject::mINVISIBLE )
		{
			continue;
		}
		for( int j = 0; j < object->m_NumFaces; j++ )
		{
			NxMaterial* material = m_scene->GetMaterial( object->m_Faces[j].m_MatChecksum );
			if( material )
			{
				// Modulate vertex color with the first-pass material color.
				// (Previously was modulating with the material color from all passes).
				float r = 1.0f;
				float g = 1.0f;
				float b = 1.0f;
//				for( int p = 0; p < material->m_NumPasses; ++p )
				for( int p = 0; p < 1; ++p )
				{
					r *= material->m_Passes[p].m_Color[0];
					g *= material->m_Passes[p].m_Color[1];
					b *= material->m_Passes[p].m_Color[2];
				}
				
				for( int k = 0; k < 3; k++ )
				{
					object->m_Verts[object->m_Faces[j].m_Vertex[k]].m_Color[0] *= r;
					object->m_Verts[object->m_Faces[j].m_Vertex[k]].m_Color[1] *= g;
					object->m_Verts[object->m_Faces[j].m_Vertex[k]].m_Color[2] *= b;
				}
			}
		}
	}
}



void GameCubeConverter::CreateTriStrips( void )
{
	int				num_objects	= m_scene->m_NumObjects;
	INxStripper*	stripper	= GetNxStripper();
	
	for( int i = 0; i < num_objects; i++ )
	{
		if( m_scene->m_Objects[i].m_Flags & NxObject::mINVISIBLE )
		{
			continue;
		}
		stripper->Reset();
		stripper->SetObject( &m_scene->m_Objects[i] );
		stripper->SetPlatform( Utils::vPLATFORM_NGC );
		if( stripper->StripifyForNgc( m_scene->m_Objects[i].m_Flags ))
//		if( stripper->Stripify( false ))
		{
			m_scene->m_Objects[i].m_MeshList = *stripper->GetMeshList();
		}
		else
		{
			exit( 666 );
		}
	}
}

#define OUTPUT_COLL_BSP

bool	GameCubeConverter::SaveCollisionData( char* path )
{
	bool success = false;

	IoUtils::CVirtualOutputFile theOutputFile;

	// 10-meg buffer
	theOutputFile.Init(10*1024*1024);

	int i, j, num_obj, version;

	const float one_f = 1.0f;
	const int zero = 0;
	const int one = 1;
	
	printf( "Collision Data...." );

#ifdef OUTPUT_COLL_BSP
	// Reserve space for BSP nodes
	NxCollBSPNode **p_node_array = new NxCollBSPNode *[m_scene->m_NumCollBSPTreeNodes];
	int node_array_index = 0;
	int node_array_offset = 0;
#endif // OUTPUT_COLL_BSP

	version = vNGC_COLLISION_VERSION_NUMBER + 1;
//	theOutputFile.Write((const char*) &version, sizeof( int ));
	writeBig32( &theOutputFile, &version );

	// Number of collision objects
	num_obj = m_scene->m_NumObjects;
	int non_collision_objects = 0;
//	for( i = 0; i < num_obj; i++ )
//	{
//		if (m_scene->m_Objects[i].m_NumCollVerts == 0)
//			non_collision_objects++;
//	}
	int num_collision_objects = num_obj - non_collision_objects;
//	theOutputFile.Write((const char*) &num_collision_objects, sizeof( int ));
	writeBig32( &theOutputFile, &num_collision_objects );

	// Calculate the size of the vert and face arrays
	int total_num_verts = 0;
//	int total_num_faces_large = 0, total_num_faces_small = 0;
	int total_num_faces = 0;
	for ( i = 0; i < num_obj; i++ )
	{
		// Skip empty objects
//		if (m_scene->m_Objects[i].m_NumCollVerts == 0)
//			continue;

		total_num_verts += m_scene->m_Objects[i].m_NumCollVerts;
//		if (m_scene->m_Objects[i].UseFaceSmall())
//		{
//			total_num_faces_small += m_scene->m_Objects[i].m_NumCollFaces;
//		} else {
//			total_num_faces_large += m_scene->m_Objects[i].m_NumCollFaces;
//		}
		total_num_faces += m_scene->m_Objects[i].m_NumCollFaces;
	}

	// Output the size of the vert and face arrays
//	theOutputFile.Write((const char*) &total_num_verts, sizeof( int ));
//  theOutputFile.Write((const char*) &total_num_faces_large, sizeof( short ));
//	theOutputFile.Write((const char*) &total_num_faces_small, sizeof( short ));
	writeBig32( &theOutputFile, &total_num_verts );
	writeBig32( &theOutputFile, &total_num_faces );
//	writeBig32( &theOutputFile, &total_num_faces_large );
//	writeBig32( &theOutputFile, &total_num_faces_small );

	// Padding
//	theOutputFile.Write((const char*) &zero, sizeof( int ));
//	theOutputFile.Write((const char*) &zero, sizeof( int ));
//	theOutputFile.Write((const char*) &zero, sizeof( int ));

	int master_vert_idx = 0, master_face_idx = 0, master_face_offset = 0, intensity_offset = 0;
	for( i = 0; i < num_obj; i++ )
	{
		NxObject* object;
		unsigned short num_verts, num_faces;

		object = &m_scene->m_Objects[i];

		// Skip empty objects
//		if (object->m_NumCollVerts == 0)
//			continue;
					
		// Write out the flags which describe the object's properties
//		theOutputFile.Write((const char*) &object->m_Checksum, sizeof( unsigned long ));			
		writeBig32( &theOutputFile, &object->m_Checksum );
		
		// Padding for m_Flags
//		theOutputFile.Write((const char*) &zero, sizeof( short ));
		writeBig16( &theOutputFile, &zero );
		
		num_verts = object->m_NumCollVerts;
//		theOutputFile.Write((const char*) &num_verts, sizeof( unsigned short ));
		writeBig16( &theOutputFile, &num_verts );

		num_faces = object->m_NumCollFaces;
//		theOutputFile.Write((const char*) &num_faces, sizeof( unsigned short ));
		writeBig16( &theOutputFile, &num_faces );
		
		// m_use_face_small
//		if (object->UseFaceSmall())
//		{
//			theOutputFile.Write((const char*) &one, sizeof( char ));
//		} else {
//			theOutputFile.Write((const char*) &zero, sizeof( char ));
//		}
		theOutputFile.Write((const char*) &zero, sizeof( char ));

		// Padding for m_pad_8
		theOutputFile.Write((const char*) &zero, sizeof( char ));

		// Using offset for pointer mp_faces
		//theOutputFile.Write((const char*) &master_face_idx, sizeof( int ));
		//theOutputFile.Write((const char*) &master_face_offset, sizeof( int ));
		writeBig32( &theOutputFile, &master_face_offset );

		// Write out bounding box/sphere data
//		theOutputFile.Write((const char*) &object->m_BoundingBox.m_Min, 3 * sizeof( float ));
//		theOutputFile.Write((const char*) &one_f, sizeof( float ));		// Vector pad
//		theOutputFile.Write((const char*) &object->m_BoundingBox.m_Max, 3 * sizeof( float ));
//		theOutputFile.Write((const char*) &one_f, sizeof( float ));		// Vector pad
		writeBig32( &theOutputFile, &object->m_BoundingBox.m_Min[0] );
		writeBig32( &theOutputFile, &object->m_BoundingBox.m_Min[1] );
		writeBig32( &theOutputFile, &object->m_BoundingBox.m_Min[2] );
		writeBig32( &theOutputFile, &one_f );
		writeBig32( &theOutputFile, &object->m_BoundingBox.m_Max[0] );
		writeBig32( &theOutputFile, &object->m_BoundingBox.m_Max[1] );
		writeBig32( &theOutputFile, &object->m_BoundingBox.m_Max[2] );
		writeBig32( &theOutputFile, &one_f );

#if 0	// Not exporting bounding sphere now
		float center[3], diag[3];
		float radius, diag_length;

		diag_length = 0;
		for( j = 0; j < 3; j++ )
		{
			center[j] = ( object->m_BoundingBox.m_Max[j] + object->m_BoundingBox.m_Min[j] ) / 2;
			diag[j] = ( object->m_BoundingBox.m_Max[j] - object->m_BoundingBox.m_Min[j] );
			diag_length += ( diag[j] * diag[j] );
		}
		diag_length = sqrtf( diag_length );
		radius = diag_length / 2.0f;
//		theOutputFile.Write((const char*) &center, 3 * sizeof( float ));
//		theOutputFile.Write((const char*) &radius, sizeof( float ));
		writeBig32( &theOutputFile, &center );
		writeBig32( &theOutputFile, &radius );
#endif

		// Using index for pointers mp_vert_pos and mp_vert_rgba
//		theOutputFile.Write((const char*) &master_vert_idx, sizeof( int ));
//		theOutputFile.Write((const char*) &master_vert_idx, sizeof( int ));
//		writeBig32( &theOutputFile, &master_vert_idx );
		int zero = 0;
		writeBig32( &theOutputFile, &zero );
		//writeBig32( file, &master_vert_idx );

		master_vert_idx += num_verts;
		master_face_idx += num_faces;
//		if (object->UseFaceSmall())
//		{
//			master_face_offset += (num_faces * NxObject::sFaceSmallSize);
//		} else {
			master_face_offset += (num_faces * /*NxObject::sFaceLargeSize*/10);
//		}

#ifdef OUTPUT_COLL_BSP
		// Put BSP tree into array and write out first index
		int node_offset = NxCollBSPNode::AssignNodesToArray(object->mp_BSPRoot, p_node_array,
														   node_array_index, node_array_offset);
		assert(node_array_index <= m_scene->m_NumCollBSPTreeNodes);
		//theOutputFile.Write((const char*) &node_offset, sizeof( int ));
		writeBig32( &theOutputFile, &node_offset );
#else
		// Padding for rest of class
		//theOutputFile.Write((const char*) &zero, sizeof( int ));
		writeBig32( &theOutputFile, &zero );
#endif // OUTPUT_COLL_BSP
		//theOutputFile.Write((const char*) &zero, sizeof( int ));
		writeBig32( &theOutputFile, &intensity_offset );
		writeBig32( &theOutputFile, &zero );
		intensity_offset += ( num_faces *3 );
	}


//	// Quick test - component adds.
//	int count[3];
//	int max[3];
//	for ( int comp = 0; comp < 3; comp++ )
//	{
//		count[comp] = 0;
//		max[comp] = 0;
//
//		for( i = 0; i < num_obj; i++ )
//		{
//			NxVertex* vert_list;
//			NxObject* object;
//
//			object = &m_scene->m_Objects[i];
//			vert_list = object->mp_CollVerts;
//
//			init_hash_tables();
//			for( j = 0; j < object->m_NumCollVerts; j++ )
//			{
//				NxVertex* vert;	
//
//				vert = &vert_list[j];
//
//				// Write out positions				
//				int pos_idx = get_pos( vert->m_Pos[comp], 0.0f, 0.0f );
//				if ( pos_idx == -1 )
//				{
//					add_pos( vert->m_Pos[comp], 0.0f, 0.0f );
//				}
//			}
//			count[comp] += g_u_num_pos;
//			if ( g_u_num_pos > max[comp] ) max[comp] = g_u_num_pos;
//		}
//		printf( "\nComponent %d: %d, max %d", comp, count[comp], max[comp] );
//	}
//	init_hash_tables();


	// Export array of vert positions and colors
	int nverts = 0;

	for( i = 0; i < num_obj; i++ )
	{
		NxVertex* vert_list;
		NxObject* object;

		object = &m_scene->m_Objects[i];
		vert_list = object->mp_CollVerts;

		for( j = 0; j < object->m_NumCollVerts; j++ )
		{
			NxVertex* vert;	

			vert = &vert_list[j];
					
			// Write out positions				
//			writeBig32( &theOutputFile, &vert->m_Pos[0] );
//			writeBig32( &theOutputFile, &vert->m_Pos[1] );
//			writeBig32( &theOutputFile, &vert->m_Pos[2] );
			nverts++;
			int pos_idx = get_pos( vert->m_Pos[0], vert->m_Pos[1], vert->m_Pos[2], -1 );
			if ( pos_idx == -1 )
			{
				add_pos( vert->m_Pos[0], vert->m_Pos[1], vert->m_Pos[2] );
			}
		}
	}
	printf( "\nnCollisionVerts: %d", nverts );
	printf( "\nnCompressedVerts: %d", g_u_num_pos );

	int verts = 0;
	for( i = 0; i < num_obj; i++ )
	{
		NxVertex* vert_list;
		NxObject* object;

		object = &m_scene->m_Objects[i];
		vert_list = object->mp_CollVerts;

		NxFace* face_list = object->mp_CollFaces;

//		printf( "\nIntensity %4d:", i );
		for( j = 0; j < object->m_NumCollFaces; j++ )
		{
			NxFace* face = &face_list[j];

			for ( int corner = 0; corner < 3; corner++ )
			{
				unsigned short vidx;
			
				vidx = object->mp_ToCollVertIdxs[face->m_Vertex[corner]];

				NxVertex* vert = &vert_list[vidx];

				// Write out the colors of the verts (potentially used to tint the skater)
				unsigned char red, green, blue, alpha, intensity;
				red = (unsigned char) (( vert->m_Color[0] * 255.0f ) + 0.5f );
				green = (unsigned char) (( vert->m_Color[1] * 255.0f ) + 0.5f );
				blue = (unsigned char) (( vert->m_Color[2] * 255.0f ) + 0.5f );
				alpha = (unsigned char) (( vert->m_Color[3] * 255.0f ) + 0.5f );

				intensity = (unsigned char)( ( (int)red + (int)green + (int)blue ) / 3 );
				theOutputFile.Write((const char*) &intensity, sizeof( char ));
//				printf( " %02x", intensity );
				verts++;
			}
		}

	}
	// Round up to 4 bytes.
	int bytes = ( 4 - verts ) & 3;
	for ( j = 0; j < bytes; j++ )
	{
		unsigned char zeropad = 0;
		theOutputFile.Write((const char*) &zeropad, sizeof( char ));
	}

#if 0
	// Export array of vert colors
	for( i = 0; i < num_obj; i++ )
	{
		NxVertex* vert_list;
		NxObject* object;

		object = &m_scene->m_Objects[i];
		vert_list = object->mp_CollVerts;

		for( j = 0; j < object->m_NumCollVerts; j++ )
		{
			NxVertex* vert;				
			unsigned char red, green, blue, alpha;
			
			vert = &vert_list[j];

			// Write out the colors of the verts (potentially used to tint the skater)
			red = (unsigned char) (( vert->m_Color[0] * 128.0f ) + 0.5f );
			green = (unsigned char) (( vert->m_Color[1] * 128.0f ) + 0.5f );
			blue = (unsigned char) (( vert->m_Color[2] * 128.0f ) + 0.5f );
			alpha = (unsigned char) (( vert->m_Color[3] * 128.0f ) + 0.5f );
			theOutputFile.Write((const char*) &red, sizeof( char ));
			theOutputFile.Write((const char*) &green, sizeof( char ));
			theOutputFile.Write((const char*) &blue, sizeof( char ));
			theOutputFile.Write((const char*) &alpha, sizeof( char ));
		}	
	}

	// Pad to 128-bit boundary
	int remainder = (total_num_verts % 4);
	if (remainder) {
		for (i = 0; i < (4 - remainder); i++)
		{
//			theOutputFile.Write((const char*) &zero, sizeof( int ));
			writeBig32( &theOutputFile, &zero );
		}
	}
#endif

	// Export array of faces
	int n8 = 0;
	int n16 = 0;
	for( i = 0; i < num_obj; i++ )
	{
		NxFace* face_list;
		NxObject* object;

		object = &m_scene->m_Objects[i];
		face_list = object->mp_CollFaces;

		// Skip empty objects
//		if (object->m_NumCollVerts == 0)
//			continue;

		NxVertex* vert_list;
		vert_list = object->mp_CollVerts;

//		printf( "\nFace %4d:", i );
		for( j = 0; j < object->m_NumCollFaces; j++ )
		{
			NxFace* face;
			NxMaterial* material;

			face = &face_list[j];

			// Write out the face's flags
			//theOutputFile.Write((const char*) &face->m_FaceFlags, sizeof( FlagType ));
			unsigned short flags = (unsigned short) face->m_FaceFlags;
//			theOutputFile.Write((const char*) &flags, sizeof( unsigned short ));
			writeBig16( &theOutputFile, &flags );

			// Write out the face's terrain type. We used to write out the material's checksum and we let
			// the game find the terrain type via indirection, but it seems wasteful when we can get it here.
			material = m_scene->GetMaterial( face->m_MatChecksum );
			short terrain = 0;
			if( material )
			{
				terrain = (short) material->m_Terrain;
			}
//			theOutputFile.Write((const char *) &terrain, sizeof( short ));
			writeBig16( &theOutputFile, &terrain );

			// Write out the face's vertex indices
			unsigned short vidx0, vidx1, vidx2;
//			vidx0 = (unsigned short) object->mp_ToCollVertIdxs[face->m_Vertex[0]];
//			vidx1 = (unsigned short) object->mp_ToCollVertIdxs[face->m_Vertex[1]];
//			vidx2 = (unsigned short) object->mp_ToCollVertIdxs[face->m_Vertex[2]];


			vidx0 = get_pos( vert_list[object->mp_ToCollVertIdxs[face->m_Vertex[0]]].m_Pos[0],
							 vert_list[object->mp_ToCollVertIdxs[face->m_Vertex[0]]].m_Pos[1],
							 vert_list[object->mp_ToCollVertIdxs[face->m_Vertex[0]]].m_Pos[2], -1 );
																				   
			vidx1 = get_pos( vert_list[object->mp_ToCollVertIdxs[face->m_Vertex[1]]].m_Pos[0],
							 vert_list[object->mp_ToCollVertIdxs[face->m_Vertex[1]]].m_Pos[1],
							 vert_list[object->mp_ToCollVertIdxs[face->m_Vertex[1]]].m_Pos[2], -1 );
																				   
			vidx2 = get_pos( vert_list[object->mp_ToCollVertIdxs[face->m_Vertex[2]]].m_Pos[0],
							 vert_list[object->mp_ToCollVertIdxs[face->m_Vertex[2]]].m_Pos[1],
							 vert_list[object->mp_ToCollVertIdxs[face->m_Vertex[2]]].m_Pos[2], -1 );

			if ( vidx0 == -1 ) printf( "\nObj %d face %d index %d BAD!!!", i, j, 0 );
			if ( vidx1 == -1 ) printf( "\nObj %d face %d index %d BAD!!!", i, j, 1 );
			if ( vidx2 == -1 ) printf( "\nObj %d face %d index %d BAD!!!", i, j, 2 );

//			printf( "(%d,%d,%d)", vidx0, vidx1, vidx2 );

			writeBig16( &theOutputFile, &vidx0 );
			writeBig16( &theOutputFile, &vidx1 );
			writeBig16( &theOutputFile, &vidx2 );
			n16 ++;

//			if (object->UseFaceSmall())	// Garrett: Hopefully, the indexes don't have to move from a short to a char
//			{
//				theOutputFile.Write((const char*) &vidx0, sizeof( unsigned char ));
//				theOutputFile.Write((const char*) &vidx1, sizeof( unsigned char ));
//				theOutputFile.Write((const char*) &vidx2, sizeof( unsigned char ));
//				theOutputFile.Write((const char*) &zero, sizeof( unsigned char ));
//				n8 ++;
//			} else {
////				theOutputFile.Write((const char*) &vidx0, sizeof( unsigned short ));
////				theOutputFile.Write((const char*) &vidx1, sizeof( unsigned short ));
////				theOutputFile.Write((const char*) &vidx2, sizeof( unsigned short ));
////				theOutputFile.Write((const char*) &zero, sizeof( unsigned short ));
//				writeBig16( &theOutputFile, &vidx0 );
//				writeBig16( &theOutputFile, &vidx1 );
//				writeBig16( &theOutputFile, &vidx2 );
//				writeBig16( &theOutputFile, &zero );
//				n16 ++;
//			}

			// Write out the face's material checksum -- used to get at the material's properties
			//theOutputFile.Write((const char*) &face->m_MatChecksum, sizeof( unsigned long ));
		}
	}	
	printf( "\nn8BitIndices: %d", n8 );
	printf( "\nn16BitIndices: %d", n16 );

	// Round up to 4 bytes.
	if ( n16 & 1 )
	{
		unsigned short zeropad = 0;
		theOutputFile.Write((const char*) &zeropad, sizeof( short ));
	}

#ifdef OUTPUT_COLL_BSP
	// Export BSP node arrray size
	//theOutputFile.Write((const char*) &node_array_offset, sizeof( int ));
	writeBig32( &theOutputFile, &node_array_offset );

	// Export array of BSP nodes
	assert(node_array_index == m_scene->m_NumCollBSPTreeNodes);
	int master_face_index = 0;
	int node_offset_check = 0;
	for( i = 0; i < node_array_index; i++ )
	{
		NxCollBSPNode *p_bsp_node = p_node_array[i];
		NxCollBSPLeaf *p_bsp_leaf = NULL;
		node_offset_check += 8;
		if (p_bsp_node->m_split_axis == 3)
		{
			p_bsp_leaf = static_cast<NxCollBSPLeaf *>(p_bsp_node);
		}

		if (p_bsp_leaf)
		{
			// m_split axis must always be in line with the low byte of m_split_point
			//theOutputFile.Write((const char*) &(p_bsp_leaf->m_num_faces), sizeof( unsigned short ));
			writeBig16( &theOutputFile, &(p_bsp_leaf->m_num_faces) );
			theOutputFile.Write((const char*) &zero, sizeof( char ));
			theOutputFile.Write((const char*) &(p_bsp_node->m_split_axis), sizeof( char ));
		} else {
			////theOutputFile.Write((const char*) &zero, sizeof( unsigned short ));
			//writeBig16( &theOutputFile, &zero );
			int iSplitPoint = (int) (p_bsp_node->m_split_point * COLLISION_SUB_INCH_PRECISION);
			iSplitPoint = (iSplitPoint << NxCollBSPNode::NUM_AXIS_BITS) | p_bsp_node->m_split_axis;
			//theOutputFile.Write((const char*) &iSplitPoint, sizeof( int ));
			writeBig32( &theOutputFile, &iSplitPoint );
			////theOutputFile.Write((const char*) &(p_bsp_node->m_split_point), sizeof( float ));
		}

		if (p_bsp_leaf)
		{
			// Write out index to master face index array
			//theOutputFile.Write((const char*) &master_face_index, sizeof( int ));
			writeBig32( &theOutputFile, &master_face_index );
			master_face_index += p_bsp_leaf->m_num_faces;
		} else {
			// Write out indexes to master node array
			//theOutputFile.Write((const char*) &(p_bsp_node->mp_less_branch->m_array_offset), sizeof( int ));
			writeBig32( &theOutputFile, &(p_bsp_node->mp_less_branch->m_array_offset) );
		}
	}

	assert(node_array_offset == node_offset_check);

	// Export array of BSP face indexes
	for( i = 0; i < node_array_index; i++ )
	{
		// Check for leaf
		if (p_node_array[i]->m_split_axis == 3)
		{
			NxCollBSPLeaf *p_bsp_leaf = static_cast<NxCollBSPLeaf *>(p_node_array[i]);
			for (int j = 0; j < p_bsp_leaf->m_num_faces; j++)
			{
				//theOutputFile.Write((const char*) &(p_bsp_leaf->mp_face_idx_array[j]), sizeof( unsigned short ));
				writeBig16( &theOutputFile, &(p_bsp_leaf->mp_face_idx_array[j]) );
			}
		}
	}

	if (p_node_array)
	{
		delete p_node_array;
	}
#endif // OUTPUT_COLL_BSP

	// break the lock, if necessary
	SetFileAttributes( path, FILE_ATTRIBUTE_NORMAL );
	if ( !theOutputFile.Save( path ) )
	{
		goto save_error;
	}

	success = true;

save_error:
	return success;	
}

bool	GameCubeConverter::ConvertData( void )
{
	//ExpandGrassGeometry();
	// These are done only for faces flagged as "render as separate geometry"
	SeparateMultiPassMeshes();
	ExpandMultiPassMaterials();
	
	// Bakes in the material colors to the vertex colors.
//	ApplyMaterialColors();

	OptimizeVertexLists();
	
	// Strips the geometry.
	CreateTriStrips();

	// PS2 specific steps to generate VRAM swapping banks and associated geometry.
//	CreateTextureGroups();
//	CreateMeshGroups();

	return true;
}

bool GameCubeConverter::SaveGeometry( IoUtils::CVirtualOutputFile* pOutputFile )
{
	int i;
	int	num_objects	= m_scene->m_NumObjects;
	short *	pRemapIndex = NULL;
	short *	pRemapVertex = NULL;

	// Determine how many of these objects are invisible, and adjust the object count accordingly.
	int num_invisible_objects = 0;
	for( i = 0; i < num_objects; i++ )
	{
		NxObject*	object		= m_scene->m_Objects + i;
		if( object->m_Flags & NxObject::mINVISIBLE )
		{
			++num_invisible_objects;
		}
	}

	int num_visible_objects = num_objects - num_invisible_objects;

//	pOutputFile->Write((const char*)&num_visible_objects, sizeof( int ));
	writeBig32( pOutputFile, &num_visible_objects );

	for( i = 0; i < num_objects; i++ )
	{
		NxObject*	object		= m_scene->m_Objects + i;
		NxVertex*	vert_list	= object->m_Verts;
		NxFace*		face_list	= object->m_Faces;

		// Skip invisible objects.
		if( object->m_Flags & NxObject::mINVISIBLE )
		{
			continue;
		}

		// Check this checksum doesn't already clash.
		for( int check = 0; check < i; ++check )
		{
			NxObject* test_object = m_scene->m_Objects + check;
			if( test_object->m_Checksum == object->m_Checksum )
			{
				// Just set the object checksum to be something random for now...
				object->m_Checksum = rand();
			}
		}

		// Write out the object checksum.
//		pOutputFile->Write((const char*)&object->m_Checksum, sizeof( unsigned long ));
		writeBig32( pOutputFile, &object->m_Checksum );

		// Write out hierarchy bone index.
		int boneidx = -1;
		int num_hierarchy_objects = m_scene->m_Model.nBones;
		for (uint8 bone_idx = 0; bone_idx < num_hierarchy_objects; bone_idx++)
		{
			uint32 cur_checksum = m_scene->m_Model.bones[bone_idx].crc;
			uint32 parent_checksum;
			NxObject *p_cur_object = m_scene->FindObject(cur_checksum);
			int16 parent_index = -1;
			//NxObject *p_parent_object = NULL;

			assert(p_cur_object);
			parent_checksum = p_cur_object->m_ParentCRC;
			if (parent_checksum)
			{
				//p_parent_object = m_scene->FindObject(parent_checksum);
				//assert(p_parent_object);
			
				// Find parent index
				for (int i = 0; i < num_hierarchy_objects; i++)
				{
					if (parent_checksum == m_scene->m_Model.bones[i].crc)
					{
						parent_index = i;
						break;
					}
				}

				assert(parent_index >= 0);
			}

			if ( cur_checksum == object->m_Checksum )
			{
				boneidx = bone_idx;
			}
		}
		writeBig32( pOutputFile, &boneidx );

		// Write out the flags which describe the object's properties
//		pOutputFile->Write((const char*)&object->m_Flags, sizeof( int ));
		writeBig32( pOutputFile, &object->m_Flags );
		
		// How many meshes in this object.		
		int num_meshes = object->m_MeshList.m_NumMeshes[0];
//		pOutputFile->Write((const char*)&num_meshes, sizeof( int ));
		writeBig32( pOutputFile, &num_meshes );

		// Write out bounding box data.
//		pOutputFile->Write((const char*)&object->m_BoundingBox.m_Min, 3 * sizeof( float ));
//		pOutputFile->Write((const char*)&object->m_BoundingBox.m_Max, 3 * sizeof( float ));
		writeBig32( pOutputFile, &object->m_BoundingBox.m_Min[0] );
		writeBig32( pOutputFile, &object->m_BoundingBox.m_Min[1] );
		writeBig32( pOutputFile, &object->m_BoundingBox.m_Min[2] );
		writeBig32( pOutputFile, &object->m_BoundingBox.m_Max[0] );
		writeBig32( pOutputFile, &object->m_BoundingBox.m_Max[1] );
		writeBig32( pOutputFile, &object->m_BoundingBox.m_Max[2] );

		// ...and bounding sphere data.
		float center[3], diag[3];
		float diag_length = 0.0f;
		for( int a = 0; a < 3; ++a )
		{
			center[a] = ( object->m_BoundingBox.m_Max[a] + object->m_BoundingBox.m_Min[a] ) / 2;
			diag[a] = ( object->m_BoundingBox.m_Max[a] - object->m_BoundingBox.m_Min[a] );
			diag_length += ( diag[a] * diag[a] );
		}
		diag_length = sqrtf( diag_length );
		float radius = diag_length / 2.0f;
//		pOutputFile->Write((const char*)&center, 3 * sizeof( float ));
//		pOutputFile->Write((const char*)&radius, sizeof( float ));
		writeBig32( pOutputFile, &center[0] );
		writeBig32( pOutputFile, &center[1] );
		writeBig32( pOutputFile, &center[2] );
		writeBig32( pOutputFile, &radius );
		
		// How many vertices in this object.
		int num_verts = object->m_NumVerts;
//		pOutputFile->Write((const char*)&num_verts, sizeof( int ));
		writeBig32( pOutputFile, &num_verts );

		// Figure vertex data stride.
		int stride	= sizeof( float ) * 3;	// Position.
		stride		+= ( object->m_Flags & NxObject::mTEXTURED ) ? ( sizeof( float ) * 2 * vMAX_MATERIAL_PASSES ) : 0;	// UVs.
		stride		+= ( object->m_Flags & NxObject::mCOLORED ) ? ( sizeof( char ) * 4 ) : 0;
		stride		+= ( object->m_Flags & NxObject::mNORMALS ) ? ( sizeof( float ) * 3 ) : 0;
//		pOutputFile->Write((const char*)&stride, sizeof( int ));
		writeBig32( pOutputFile, &stride );

		// Build the default Remap table (will be overwritten if skinned).
		pRemapIndex = new short[num_verts];
		pRemapVertex = new short[num_verts];
		for( int vv = 0; vv < num_verts; ++vv )
		{
			pRemapIndex[vv] = vv;
			pRemapVertex[vv] = vv;
		}

		// This is a fucker. I need to sort the vertices by bone pairs.
#define W_EPSILON 0.00001f
		void *			pDoubleHead = NULL;
		void *			pAddHead = NULL;

//		if( object->m_Flags & NxObject::mSKINNED )
//		{
//			// Quick patch - find all duplicate weight 0 & 1s. Combine them & shunt up the other weights.
//			for( int vv = 0; vv < num_verts; ++vv )
//			{
//				NxVertex* vert = object->m_Verts + vv;
//
//				if ( vert->m_WeightedIndex[0] == vert->m_WeightedIndex[1] )
//				{
//					vert->m_Weight[0] = vert->m_Weight[0] + vert->m_Weight[1];
//					vert->m_WeightedIndex[1] = vert->m_WeightedIndex[2];
//					vert->m_WeightedIndex[2] = vert->m_WeightedIndex[3];
//					vert->m_WeightedIndex[3] = vert->m_WeightedIndex[4];
//					vert->m_WeightedIndex[4] = vert->m_WeightedIndex[5];
//					vert->m_WeightedIndex[5] = 0;
//					vert->m_Weight[1] = vert->m_Weight[2];
//					vert->m_Weight[2] = vert->m_Weight[3];
//					vert->m_Weight[3] = vert->m_Weight[4];
//					vert->m_Weight[4] = vert->m_Weight[5];
//					vert->m_Weight[5] = 0.0f;
//					vert->m_NumWeights--;
//				}
//				// Sort the weights, then use only the first 3.
//				vert->SortVertexWeights();
//				vert->NormalizeVertexWeights( 3 );
//			}
//			// First thing, we need to know the number of bones.
//			int max_bone = 0;
//			for( int v = 0; v < num_verts; ++v )
//			{
//				NxVertex* vert = object->m_Verts + v;
//				if ( vert->m_WeightedIndex[0] > max_bone ) max_bone = vert->m_WeightedIndex[0];
//				if ( vert->m_WeightedIndex[1] > max_bone ) max_bone = vert->m_WeightedIndex[1];
//				if ( vert->m_WeightedIndex[2] > max_bone ) max_bone = vert->m_WeightedIndex[2];
////				if ( vert->m_WeightedIndex[3] > max_bone ) max_bone = vert->m_WeightedIndex[3];
//			}
//			max_bone++;
//			//printf( "\n(1)Max bone: %d", max_bone );
//
//			// Build the double & single add weight arrays.
//
//			// First the doubles...
//			for ( int b0 = 0; b0 <= max_bone; b0++ )
//			{
//				for ( int b1 = 0; b1 <= max_bone; b1++ )
//				{
//					// Take care of the duplicate cases.
//					if ( b0 > b1 ) continue;
//
//					// Count how many matches we have.
//					int numMatches = 0;
//					for( int v = 0; v < num_verts; ++v )
//					{
//						NxVertex* vert = object->m_Verts + v;
//
//						if (	( ( vert->m_WeightedIndex[0] == b0 ) && ( vert->m_WeightedIndex[1] == b1 ) ) ||
//								( ( vert->m_WeightedIndex[0] == b1 ) && ( vert->m_WeightedIndex[1] == b0 ) ) )
////								( ( vert->m_WeightedIndex[0] == b0 ) && ( vert->m_Weight[1] <= W_EPSILON ) ) )
//						{
//							numMatches++;
//						}
//					}
//
//					// If we have matches, build a double array & link it in.
//					if ( numMatches )
//					{
//						skinDouble *	pCurrentDouble;
//						pCurrentDouble = new skinDouble;
//						pCurrentDouble->pNext = pDoubleHead;
//						pDoubleHead = (void *)pCurrentDouble;
//						pCurrentDouble->count = numMatches;
//						pCurrentDouble->matrix0 = b0;
//						pCurrentDouble->matrix1 = b1;
//						pCurrentDouble->pad0 = 0;
//						pCurrentDouble->pad1 = 0;
//						pCurrentDouble->pPosNormal = new float[6 * numMatches];
//						pCurrentDouble->pWeight = new float[2 * numMatches];
//						pCurrentDouble->pIndex = new short[numMatches];
//
//						int index = 0;
//						for( int v = 0; v < num_verts; ++v )
//						{
//							NxVertex* vert = object->m_Verts + v;
//
//							if (	( ( vert->m_WeightedIndex[0] == b0 ) && ( vert->m_WeightedIndex[1] == b1 ) ) ||
//									( ( vert->m_WeightedIndex[0] == b1 ) && ( vert->m_WeightedIndex[1] == b0 ) ) )
////									( ( vert->m_WeightedIndex[0] == b0 ) && ( vert->m_Weight[1] <= W_EPSILON ) ) )
//							{
//								pCurrentDouble->pPosNormal[(index * 6) + 0] = vert->m_Pos[0];
//								pCurrentDouble->pPosNormal[(index * 6) + 1] = vert->m_Pos[1];
//								pCurrentDouble->pPosNormal[(index * 6) + 2] = vert->m_Pos[2];
//								pCurrentDouble->pPosNormal[(index * 6) + 3] = vert->m_Normal[0];
//								pCurrentDouble->pPosNormal[(index * 6) + 4] = vert->m_Normal[1];
//								pCurrentDouble->pPosNormal[(index * 6) + 5] = vert->m_Normal[2];
//
//								//printf( "\nWeight %3d: %2d:%2d - %f:%f", v, vert->m_WeightedIndex[0], vert->m_WeightedIndex[1], vert->m_Weight[0], vert->m_Weight[1] );
//								if ( ( vert->m_WeightedIndex[0] == b1 ) && ( vert->m_WeightedIndex[1] == b0 ) )
//								{
//									pCurrentDouble->pWeight[(index * 2) + 0] = vert->m_Weight[1];
//									pCurrentDouble->pWeight[(index * 2) + 1] = vert->m_Weight[0];
//									//printf( "\nWeighta %3d: %2d:%2d - %f:%f", v, b0, b1, vert->m_Weight[1], vert->m_Weight[0] );
//								} else {
//									pCurrentDouble->pWeight[(index * 2) + 0] = vert->m_Weight[0];
//									pCurrentDouble->pWeight[(index * 2) + 1] = vert->m_Weight[1];
//									//printf( "\nWeightb %3d: %2d:%2d - %f:%f", v, b0, b1, vert->m_Weight[0], vert->m_Weight[1] );
//								}
//								vert->m_WeightedIndex[0] = 0x7fff;
//								vert->m_WeightedIndex[1] = 0x7fff;
//								pCurrentDouble->pIndex[index] = v;
//								index++;
//							}
//						}
//						if ( index != numMatches ) printf ( "\nMismatch: %d should be  %d", index, numMatches );
//					}
//				}
//			}
//
//			{
//				for( int v = 0; v < num_verts; ++v )
//				{
//					NxVertex* vert = object->m_Verts + v;
//
//					if ( vert->m_WeightedIndex[0] != 0x7fff )
//					{
//						printf( "\nDuplicate index: Vertex %04d: %02d, %02d, %02d, %02d (%f, %f, %f, %f)", v, vert->m_WeightedIndex[0], vert->m_WeightedIndex[1], vert->m_WeightedIndex[2], vert->m_WeightedIndex[3], vert->m_Weight[0], vert->m_Weight[1], vert->m_Weight[2], vert->m_Weight[3] );
//					}
//				}
//			}
//			// Now that we've built the doubles, we have enough information to remap the vertices.
//			skinDouble *	pD = (skinDouble *)pDoubleHead;
//			int				vertex = 0;
//			while ( pD )
//			{
//				//printf( "\nNew group" );
//				for ( int lp = 0; lp < pD->count; lp++ ) {
//					// Get the index.
//					short index = pD->pIndex[lp];
//					// Set up the remap index.
//					//printf( "\nRemap: %d -> %d", index, vertex );
//					pRemapIndex[index] = vertex;
//					pRemapVertex[vertex] = index;
//					pD->pIndex[lp] = vertex;
//					// Fill in the vertex data.
//					//NxVertex* vert = object->m_Verts + vertex;
//					//vert->m_Pos[0] = pD->pPosNormal[(lp * 6) + 0];
//					//vert->m_Pos[1] = pD->pPosNormal[(lp * 6) + 1];
//					//vert->m_Pos[2] = pD->pPosNormal[(lp * 6) + 2];
//					//vert->m_Normal[0] = pD->pPosNormal[(lp * 6) + 3];
//					//vert->m_Normal[1] = pD->pPosNormal[(lp * 6) + 4];
//					//vert->m_Normal[2] = pD->pPosNormal[(lp * 6) + 5];
//					// Next vert.
//					vertex++;
//				}
//				// Next array.
//				pD = (skinDouble *)pD->pNext;
//			}
//
////			printf( "\nDone: %d verts, %d\n", num_verts, vertex );
//
//			// Now, build single add weight arrays.
//			for ( int bone = 0; bone < max_bone; bone++ )
//			{
//				// Count how many matches we have.
//				int numMatches = 0;
//				for( int v = 0; v < num_verts; ++v )
//				{
//					NxVertex* vert = object->m_Verts + v;
//
////					if (	( ( vert->m_WeightedIndex[2] == bone ) && ( vert->m_Weight[2] > W_EPSILON ) ) ||
////							( ( vert->m_WeightedIndex[3] == bone ) && ( vert->m_Weight[3] > W_EPSILON ) ) )
//					if (	( ( vert->m_WeightedIndex[2] == bone ) && ( vert->m_Weight[2] > W_EPSILON ) ) )
//					{
//						numMatches++;
//					}
//				}
//
//				// If we have matches, build a single add array & link it in.
//				if ( numMatches )
//				{
//					skinAdd *	pCurrentAdd;
//					pCurrentAdd = new skinAdd;
//					pCurrentAdd->pNext = pAddHead;
//					pAddHead = (void *)pCurrentAdd;
//					pCurrentSingle->count = numMatches;
//					pCurrentAdd->matrix = bone;
//					pCurrentAdd->pPosNormal = new float[6 * numMatches];
//					pCurrentAdd->pWeight = new float[numMatches];
//					pCurrentAdd->pIndex = new short[numMatches];
//
//					int index = 0;
//					for( int v = 0; v < num_verts; ++v )
//					{
//						NxVertex* vert = object->m_Verts + v;
//
//						int ww = 2;
////						for ( int ww = 2; ww < NxVertex::vMAX_WEIGHTS_PER_VERTEX; ww++ )
//						{
//							if ( ( vert->m_WeightedIndex[ww] == bone ) && ( vert->m_Weight[ww] > W_EPSILON ) )
//							{
//								pCurrentAdd->pPosNormal[(index * 6) + 0] = vert->m_Pos[0];
//								pCurrentAdd->pPosNormal[(index * 6) + 1] = vert->m_Pos[1];
//								pCurrentAdd->pPosNormal[(index * 6) + 2] = vert->m_Pos[2];
//								pCurrentAdd->pPosNormal[(index * 6) + 3] = vert->m_Normal[0];
//								pCurrentAdd->pPosNormal[(index * 6) + 4] = vert->m_Normal[1];
//								pCurrentAdd->pPosNormal[(index * 6) + 5] = vert->m_Normal[2];
//								pCurrentAdd->pWeight[index] = vert->m_Weight[ww];
//								pCurrentAdd->pIndex[index] = pRemapIndex[v];
//								index++;
//								vert->m_WeightedIndex[ww] = 0x7fff;
//								//printf( "\nWeight %3d: %2d - %f", v, bone, vert->m_Weight[2] );
//							}
//						}
//					}
//				}
//			}
//		}
		
		// No vertex or normal pool is output for skinned data. The double/single add lists will build the vert/normal pools.
		if( !(object->m_Flags & NxObject::mSKINNED) )
		{
			// Write out the vertex data. Positions first (always present).
			for( int v = 0; v < num_verts; ++v )
			{
				NxVertex* vert = object->m_Verts + pRemapVertex[v];
	//			pOutputFile->Write((const char*) &vert->m_Pos[0], sizeof( float ));
	//			pOutputFile->Write((const char*) &vert->m_Pos[1], sizeof( float ));
	//			pOutputFile->Write((const char*) &vert->m_Pos[2], sizeof( float ));
				writeBig32( pOutputFile, &vert->m_Pos[0] );
				writeBig32( pOutputFile, &vert->m_Pos[1] );
				writeBig32( pOutputFile, &vert->m_Pos[2] );
			}

			// Normals if present.
			if( object->m_Flags & NxObject::mNORMALS )
			{					
				for( int v = 0; v < num_verts; ++v )
				{
					NxVertex* vert = object->m_Verts + pRemapVertex[v];
	//				pOutputFile->Write((const char*) &vert->m_Normal[0], sizeof( float ));
	//				pOutputFile->Write((const char*) &vert->m_Normal[1], sizeof( float ));
	//				pOutputFile->Write((const char*) &vert->m_Normal[2], sizeof( float ));
					//writeBig32( pOutputFile, &vert->m_Normal[0] );
					//writeBig32( pOutputFile, &vert->m_Normal[1] );
					//writeBig32( pOutputFile, &vert->m_Normal[2] );
					for ( int lp2 = 0; lp2 < 3; lp2++ )
					{
						short sh;
						sh = (short)( ( vert->m_Normal[lp2] * NORM_MUL ) + ( vert->m_Normal[lp2] > ( NORM_MUL / 2.0f ) ? NORM_MUL : 0.0f ) );
						writeBig16( pOutputFile, &sh );
//						if ( fabs( vert->m_Normal[lp2] ) > 128.0f )
//						{
//							printf( "\n******************** Bogus pos" );
//						}
					}
				}
			}
		}

//		// Double weight lists (if present)
//		if( object->m_Flags & NxObject::mSKINNED )
//		{
//			skinDouble *	pD;
//
//			// First, work out how many lists & how many pairs we're going to write.
//			pD = (skinDouble *)pDoubleHead;
//			int lists = 0;
//			int pairs = 0;
//			int extras = 0;
//			while ( pD )
//			{
//				pairs += pD->count;
//				lists++;
//				// Next array.
//				pD = (skinDouble *)pD->pNext;
//			}
//			// Write header information (int)numBytes, (int)numLists:
//			// Note: numBytes does not includes the 8 bytes for the header.
//			int bytes = ( ( 4 + 4 ) * lists ) + ( ( 4 * 6 ) * pairs ) + ( ( 4 * 2 ) * pairs );
//			writeBig32( pOutputFile, &bytes );
//			writeBig32( pOutputFile, &lists );
//
////			printf( "\nDouble list bytes: %d", bytes );
//
//			// Now, write out each list in turn.
//			pD = (skinDouble *)pDoubleHead;
//			int fpos = pOutputFile->TellPos();
//			while ( pD )
//			{
//				int lp;
//				// Write list header.
//				int mtx = pD->matrix0 | ( pD->matrix1 << 8 );
//				//if ( pD->count <= 1 ) printf( "\nDouble list, %3d verts, mat %2d %2d", pD->count, pD->matrix0, pD->matrix1 );
//				writeBig32( pOutputFile, &pD->count );
//				writeBig32( pOutputFile, &mtx );
//				// Write vertex/normal pairs.
//				for ( lp = 0; lp < pD->count; lp++ ) {
//					writeBig32( pOutputFile, &pD->pPosNormal[(lp * 6) + 0] );
//					writeBig32( pOutputFile, &pD->pPosNormal[(lp * 6) + 1] );
//					writeBig32( pOutputFile, &pD->pPosNormal[(lp * 6) + 2] );
//					writeBig32( pOutputFile, &pD->pPosNormal[(lp * 6) + 3] );
//					writeBig32( pOutputFile, &pD->pPosNormal[(lp * 6) + 4] );
//					writeBig32( pOutputFile, &pD->pPosNormal[(lp * 6) + 5] );
//
//
//
////					for ( int lp2 = 0; lp2 < 6; lp2++ )
////					{
////						short sh;
////						float mul = ( lp2 < 3 ) ? POS_MUL : NORM_MUL;
////						sh = (short)( ( pD->pPosNormal[(lp * 6) + lp2] * mul ) + ( pD->pPosNormal[(lp * 6) + lp2] > ( mul / 2.0f ) ? mul : 0.0f ) );
////						writeBig16( pOutputFile, &sh );
//////						if ( fabs( pD->pPosNormal[(lp * 6) + lp2] ) >= 128.0f )
//////						{
//////							printf( "\n******************** Bogus pos" );
//////						}
////					}
//				}
////				short pad = 0;
////				if ( pD->count & 1 ) writeBig16( pOutputFile, &pad );				   				// Write out normals
//				// Write weight pairs.
//				for ( lp = 0; lp < pD->count; lp++ ) {
////					if ( ( pD->pWeight[(lp*2)+0] > 255.0f ) || ( pD->pWeight[(lp*2)+0] < 0.0f ) ) printf( "\nBogus weight!!!" );
////					if ( ( pD->pWeight[(lp*2)+1] > 255.0f ) || ( pD->pWeight[(lp*2)+1] < 0.0f ) ) printf( "\nBogus weight!!!" );
////					unsigned char w;
////					w = (unsigned char)( pD->pWeight[(lp * 2) + 0] * WEIGHT_MUL );
////					pOutputFile->Write( &w, 1 );
////					w = (unsigned char)( pD->pWeight[(lp * 2) + 1] * WEIGHT_MUL );
////					pOutputFile->Write( &w, 1 );
//					writeBig32( pOutputFile, &pD->pWeight[(lp * 2) + 0] );
//					writeBig32( pOutputFile, &pD->pWeight[(lp * 2) + 1] );
//					//printf( "\nDouble weight %f %f %d %d", pD->pWeight[(lp * 2) + 0], pD->pWeight[(lp * 2) + 1], (unsigned char)( pD->pWeight[(lp * 2) + 0] * WEIGHT_MUL ), (unsigned char)( pD->pWeight[(lp * 2) + 1] * WEIGHT_MUL ) );
//				}
////				if ( pD->count & 1 ) writeBig16( pOutputFile, &pad );
//				// Next array.
//				pD = (skinDouble *)pD->pNext;
//			}
//			fpos = pOutputFile->TellPos() - fpos;
////			printf( "\nDifference: actual: %d calc: %d", fpos, bytes );
//
//		}
//		// Single add weight lists (if present)
//		if( object->m_Flags & NxObject::mSKINNED )
//		{
//			skinAdd* pS;
//
//			// First, count up how many bytes we're going to output & how many lists we have.
//			pS = (skinAdd *)pAddHead;
//			int bytes = 0;
//			int lists = 0;
//			while ( pS )
//			{
//				bytes += 2 * 4;
//				bytes += pS->count * ( 6 * 4 );
////				if ( pS->count & 1 ) bytes += 2;
//				bytes += pS->count * 4;
////				if ( pS->count & 3 ) bytes += 4 - ( pS->count & 3 );
//				bytes += pS->count * 2;
//				bytes += ( pS->count & 1 ) * 2;
//				lists++;
//
//				pS = (skinAdd *)pS->pNext;
//			}
//			// Write header information (int)numBytes, (int)numLists:
//			writeBig32( pOutputFile, &bytes );
//			writeBig32( pOutputFile, &lists );
////			printf( "\nAdd list bytes: %d", bytes );
//			// Write out the single add lists.
//			pS = (skinAdd *)pAddHead;
//			int fpos = pOutputFile->TellPos();
//			while ( pS )
//			{
////				printf( "\nSingle add list, %3d verts, mat %2d", pS->count, pS->matrix );
//				int lp;
//				writeBig32( pOutputFile, &pS->count );
//				writeBig32( pOutputFile, &pS->matrix );
//				//printf ( "\nSingleadd : Count: %d, Mat: %d", pS->count, pS->matrix );
//				for ( lp = 0; lp < pS->count; lp++ ) {
//					writeBig32( pOutputFile, &pS->pPosNormal[(lp * 6) + 0] );
//					writeBig32( pOutputFile, &pS->pPosNormal[(lp * 6) + 1] );
//					writeBig32( pOutputFile, &pS->pPosNormal[(lp * 6) + 2] );
//					writeBig32( pOutputFile, &pS->pPosNormal[(lp * 6) + 3] );
//					writeBig32( pOutputFile, &pS->pPosNormal[(lp * 6) + 4] );
//					writeBig32( pOutputFile, &pS->pPosNormal[(lp * 6) + 5] );
////					for ( int lp2 = 0; lp2 < 6; lp2++ )
////					{
////						short sh;
////						float mul = ( lp2 < 3 ) ? POS_MUL : NORM_MUL;
////						sh = (short)( ( pS->pPosNormal[(lp * 6) + lp2] * mul ) + ( pS->pPosNormal[(lp * 6) + lp2] > ( mul / 2.0f ) ? mul : 0.0f ) );
////						writeBig16( pOutputFile, &sh );
//////						if ( fabs( pS->pPosNormal[(lp * 6) + lp2] ) >= 128.0f )
//////						{
//////							printf( "\n******************** Bogus pos" );
//////						}
////					}
//				}
////				short pad16 = 0;
////				if ( pS->count & 1 ) writeBig16( pOutputFile, &pad16 );
//				for ( lp = 0; lp < pS->count; lp++ ) {
//					writeBig32( pOutputFile, &pS->pWeight[lp] );
////					unsigned char w;
//////					if ( ( pS->pWeight[lp] > 255.0f ) || ( pS->pWeight[lp] < 0.0f ) ) printf( "\nBogus weight!!!" );
////					w = (unsigned char)( pS->pWeight[lp] * WEIGHT_MUL );
////					pOutputFile->Write( &w, 1 );
////					//printf( "\nSingle add weight %f %d", pS->pWeight[lp], w );
////
//				}
////				if ( pS->count & 3 )
////				{
////					char zero = 0;
////					for ( int ww = 0; ww < ( 4 - ( pS->count & 3 ) ); ww++ )
////					{
////						pOutputFile->Write( &zero, 1 );
////					}
////				}
//				for ( lp = 0; lp < pS->count; lp++ ) {
//					writeBig16( pOutputFile, &pS->pIndex[lp] );
//				}
//				if ( pS->count & 1 )
//				{
//					short zero = 0;
//					writeBig16( pOutputFile, &zero );
//				}
//				pS = (skinAdd *)pS->pNext;
//			}
//			fpos = pOutputFile->TellPos() - fpos;
////			printf( "\nDifference: actual: %d calc: %d", fpos, bytes );
//		}

//		// Vertex weights if present.
//		if( object->m_Flags & NxObject::mSKINNED )
//		{
//			// First of all, figure what is the maximum number of weights used per vertex. Also sort in descending order of weight size.
//			int v;
//			int max_weight = 0;
//			for( v = 0; v < num_verts; ++v )
//			{
//				NxVertex* vert = object->m_Verts + pRemapVertex[v];
//
//				vert->SortVertexWeights();
//				for( int i = max_weight + 1; i < NxVertex::vMAX_WEIGHTS_PER_VERTEX; ++i )
//				{
//					if( vert->m_Weight[i] <= 0.0f )
//					{
//						break;
//					}
//					max_weight = i;
//				}
////				pOutputFile->Write((const char*) &vert->m_Weight[0], sizeof( float ));
////				pOutputFile->Write((const char*) &vert->m_Weight[1], sizeof( float ));
////				pOutputFile->Write((const char*) &vert->m_Weight[2], sizeof( float ));
//				writeBig32( pOutputFile, &vert->m_Weight[0] );
//				writeBig32( pOutputFile, &vert->m_Weight[1] );
//				writeBig32( pOutputFile, &vert->m_Weight[2] );
//			}
//			
///*
//			for( v = 0; v < num_verts; ++v )
//			{
//				NxVertex* vert = object->m_Verts + v;
//				pOutputFile->Write((const char*) &vert->m_Weight[0], sizeof( float ));
//				pOutputFile->Write((const char*) &vert->m_Weight[1], sizeof( float ));
//				pOutputFile->Write((const char*) &vert->m_Weight[2], sizeof( float ));
//			}
//*/
//		}
//
//		// Vertex bone indices if present.
//		if( object->m_Flags & NxObject::mSKINNED )
//		{
//			for( int v = 0; v < num_verts; ++v )
//			{
//				NxVertex* vert = object->m_Verts + pRemapVertex[v];
//
//				unsigned short indices[3] = { vert->m_WeightedIndex[0], vert->m_WeightedIndex[1], vert->m_WeightedIndex[2] };
////				pOutputFile->Write((const char*)&indices[0], sizeof( unsigned short ));
////				pOutputFile->Write((const char*)&indices[1], sizeof( unsigned short ));
////				pOutputFile->Write((const char*)&indices[2], sizeof( unsigned short ));
//				writeBig16( pOutputFile, &indices[0] );
//				writeBig16( pOutputFile, &indices[1] );
//				writeBig16( pOutputFile, &indices[2] );
//			}
//		}
		
		// Texture coordinate sets if present.
		if( object->m_Flags & NxObject::mTEXTURED )
		{
			// Figure out what the maximum number of passes on any of the meshes is for this object.
			int max_passes = 0;
			for( unsigned int m = 0; m < (unsigned int)num_meshes; ++m )
			{
				NxMesh		*p_mesh		= object->m_MeshList.m_Meshes[0][m];
				NxMaterial	*p_material	= m_scene->GetMaterial( p_mesh->m_MatChecksum );
				if( p_material )
				{
					if( p_material->m_NumPasses > max_passes )
					{
						max_passes = p_material->m_NumPasses;
					}
				}
			}
			
			// Write out how many sets of texture coodinates present.
//			int num_tc_sets = vMAX_MATERIAL_PASSES;
			int num_tc_sets = max_passes;
//			pOutputFile->Write((const char*)&num_tc_sets, sizeof( int ));
			writeBig32( pOutputFile, &num_tc_sets );
			
			for( int v = 0; v < num_verts; ++v )
			{
				NxVertex* vert = object->m_Verts + pRemapVertex[v];
				for( int tc = 0; tc < num_tc_sets; ++tc )
				{
//					pOutputFile->Write((const char*) &vert->m_TexCoord[tc][0], sizeof( float ));
//					pOutputFile->Write((const char*) &vert->m_TexCoord[tc][1], sizeof( float ));
					//writeBig32( pOutputFile, &vert->m_TexCoord[tc][0] );
					//writeBig32( pOutputFile, &vert->m_TexCoord[tc][1] );
//					short sh;
//					sh = (short)( vert->m_TexCoord[tc][0] * UV_MUL );
//					writeBig16( pOutputFile, &sh );
//					sh = (short)( vert->m_TexCoord[tc][1] * UV_MUL );
//					writeBig16( pOutputFile, &sh );

					// Round floats to 10 bit accuracy.
					int sh;
					float fl;
					sh = (int)( vert->m_TexCoord[tc][0] * UV_MUL );
					fl = (float)( (float)sh / (float)UV_MUL );
					writeBig32( pOutputFile, &fl );
					sh = (int)( vert->m_TexCoord[tc][1] * UV_MUL );
					fl = (float)( (float)sh / (float)UV_MUL );
					writeBig32( pOutputFile, &fl );
				}
			}
		}

		// Vertex colors if present.
		if( object->m_Flags & NxObject::mCOLORED )
		{
			for( int v = 0; v < num_verts; ++v )
			{
				NxVertex* vert = object->m_Verts + pRemapVertex[v];
				unsigned char red = (unsigned char) (( vert->m_Color[0] * 255.0f ) + 0.5f );
				unsigned char green = (unsigned char) (( vert->m_Color[1] * 255.0f ) + 0.5f );
				unsigned char blue = (unsigned char) (( vert->m_Color[2] * 255.0f ) + 0.5f );
				unsigned char alpha = (unsigned char) (( vert->m_Color[3] * 255.0f ) + 0.5f );

				// Write out in BGRA format.
				pOutputFile->Write((const char*) &red, sizeof( unsigned char ));
				pOutputFile->Write((const char*) &green, sizeof( unsigned char ));
				pOutputFile->Write((const char*) &blue, sizeof( unsigned char ));
				pOutputFile->Write((const char*) &alpha, sizeof( unsigned char ));
			}
		}				
	
		// Vertex color wibble animation indices if present.
		if( object->m_Flags & NxObject::mVCWIBBLE )
		{
			for( int v = 0; v < num_verts; ++v )
			{
				NxVertex* vert = object->m_Verts + v;
				
				unsigned char index = (unsigned char)vert->m_WibbleIndex;
				pOutputFile->Write((const char*)&index, sizeof( unsigned char ));
			}
		}				

		// Write out the mesh data.
		for( int m = 0; m < num_meshes; ++m )
		{
			NxMesh*	mesh = object->m_MeshList.m_Meshes[0][m];
			
			// Checksum of the material for this mesh.
			unsigned long mat_checksum = mesh->m_MatChecksum;
//			pOutputFile->Write((const char*) &mat_checksum, sizeof( unsigned long ));
			writeBig32( pOutputFile, &mat_checksum );

			mesh->m_Flags |= mesh->m_ShadowFlags;			
//			mesh->SetWibbleFlags();

/////////////////////////////////////////
			{
				NxVertex* vert_list;
				bool has_wibble_data;

				mesh->m_Flags &= ~NxObject::mVCWIBBLE;

				// If the object didn't have any wibble data, this mesh won't have any
				if(( mesh->m_Object->m_Flags & NxObject::mVCWIBBLE ) != 0 )
				{
					has_wibble_data = false;
					vert_list = mesh->m_Object->m_Verts;
					int v = 0;
					bool quit = false;
					while ( mesh->m_VertStrip[v].m_Index )
					{
						unsigned short num = mesh->m_VertStrip[v].m_Index;
						v++;

						for ( int vv = 0; vv < num; vv++ )
						{
							unsigned short idx = pRemapIndex[mesh->m_VertStrip[v+vv].m_Index];

							NxVertex* vert;
							vert = &vert_list[idx];
							if( vert->m_WibbleIndex > 0 )
							{
								mesh->m_Flags |= NxObject::mVCWIBBLE;
								quit = true;
								break;
							}
						}
						if ( quit ) break;
						v += num;
					}			
				}
			}
/////////////////////////////////////////

			// Write out the flags which describe the object's properties
//			pOutputFile->Write((const char*) &mesh->m_Flags, sizeof( int ));
			writeBig32( pOutputFile, &mesh->m_Flags );

			float center[3];
			float diag[3];
			float diag_length = 0;
			for( int i0 = 0; i0 < 3; i0++ )
			{
				center[i0] = ( object->m_BoundingBox.m_Max[i0] + object->m_BoundingBox.m_Min[i0] ) / 2;
				diag[i0] = ( object->m_BoundingBox.m_Max[i0] - object->m_BoundingBox.m_Min[i0] );
				diag_length += ( diag[i0] * diag[i0] );
			}
			diag_length = sqrtf( diag_length );
			float radius = diag_length / 2.0f;
//			pOutputFile->Write((const char*) &center, 3 * sizeof( float ));
//			pOutputFile->Write((const char*) &radius, sizeof( float ));
			writeBig32( pOutputFile, &center[0] );
			writeBig32( pOutputFile, &center[1] );
			writeBig32( pOutputFile, &center[2] );
			writeBig32( pOutputFile, &radius );


			// How many vertices in this strip.
			int num_verts = mesh->m_NumStripVerts;
//			pOutputFile->Write((const char*) &num_verts, sizeof( int ));
			writeBig32( pOutputFile, &num_verts );
			
			int v = 0;
			while ( mesh->m_VertStrip[v].m_Index )
			{
				unsigned short num = mesh->m_VertStrip[v].m_Index;
				writeBig16( pOutputFile, &num );
				v++;
	
				for ( int vv = 0; vv < num; vv++ )
				{
					unsigned short idx = pRemapIndex[mesh->m_VertStrip[v+vv].m_Index];
					writeBig16( pOutputFile, &idx );
				}
				v += num;
			}			
			unsigned short end = 0;
			writeBig16( pOutputFile, &end );

			// Build the CAS flags for this mesh.
//			if(( object->m_Flags & NxObject::mSKINNED ) && ( num_verts >= 3 ))
//			{
//				int v = 0;
//				while ( mesh->m_VertStrip[v].m_Index )
//				{
//					unsigned short num = mesh->m_VertStrip[v].m_Index;
//					v++;
//
//					unsigned int index0 = mesh->m_VertStrip[v+0].m_Index;
//					unsigned int index1 = mesh->m_VertStrip[v+1].m_Index;
//
//					for ( int vv = 2; vv < num; vv++ )
//					{
//						unsigned int index2 = mesh->m_VertStrip[v+vv].m_Index;
//
//						// Only bother checking if this is a non-degenerate tri.
//						if(( index0 != index1 ) && ( index0 != index2 ) && ( index1 != index2 ))
//						{
//							unsigned long cas_face_flags = mesh->FindCASFaceFlags( index0, index1, index2 );
//							if( cas_face_flags > 0 )
//							{
//								// Store the mesh number and the three indices.
//								if( !object->AddCASData( cas_face_flags, ( m << 16 ) | pRemapIndex[index0], ( pRemapIndex[index1] << 16 ) | pRemapIndex[index2] ))
//								{
//									printf( "ERROR: Increase number of cas data from %d!\n", NxObject::vMAXCASDATA );
//									return false;
//								}
//							}
//						}
//						index0 = index1;
//						index1 = index2;
//					}
//					v += num;
//				}			
//			}
		}
		// Clean up.
		if ( pRemapIndex ) delete pRemapIndex;
		if ( pRemapVertex ) delete pRemapVertex;
	}	

	// Write out hierarchy data, if any
	int num_hierarchy_objects = m_scene->m_Model.nBones;
	assert(num_hierarchy_objects < 256);
	writeBig32( pOutputFile, &num_hierarchy_objects );

	for (uint8 bone_idx = 0; bone_idx < num_hierarchy_objects; bone_idx++) {
		uint32 cur_checksum = m_scene->m_Model.bones[bone_idx].crc;
		uint32 parent_checksum;
		NxObject *p_cur_object = m_scene->FindObject(cur_checksum);
		int16 parent_index = -1;
		//NxObject *p_parent_object = NULL;

		assert(p_cur_object);
		parent_checksum = p_cur_object->m_ParentCRC;
		if (parent_checksum)
		{
			//p_parent_object = m_scene->FindObject(parent_checksum);
			//assert(p_parent_object);
		
			// Find parent index
			for (int i = 0; i < num_hierarchy_objects; i++)
			{
				if (parent_checksum == m_scene->m_Model.bones[i].crc)
				{
					parent_index = i;
					break;
				}
			}

			assert(parent_index >= 0);
		}

		// Write the data
		writeBig32( pOutputFile, &cur_checksum );
		writeBig32( pOutputFile, &parent_checksum );
		writeBig16( pOutputFile, &parent_index );
		pOutputFile->Write((const char*) &bone_idx, sizeof( char ));

		// Padding
		uint32 pad = 0;
		pOutputFile->Write((const char*) &pad, sizeof( char ));
		pOutputFile->Write((const char*) &pad, sizeof( int ));

		// Write the matrix
		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[0] );
		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[1] );
		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[2] );
		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[3] );
		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[4] );
		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[5] );
		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[6] );
		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[7] );
		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[8] );
		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[9] );
		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[10] );
		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[11] );
		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[12] );
		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[13] );
		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[14] );
		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[15] );

#if 0
		printf("Bone %d\n", bone_idx);
		printf("Checksum %x\n", cur_checksum);
		printf("Parent Checksum %x\n", parent_checksum);
		printf("Parent Index %x\n", parent_index);
		Mth::Matrix mat = m_scene->m_Model.bones[bone_idx].mat;
		printf("[ %f %f %f %f]\n", mat[0][0], mat[0][1], mat[0][2], mat[0][3]);
		printf("[ %f %f %f %f]\n", mat[1][0], mat[1][1], mat[1][2], mat[1][3]);
		printf("[ %f %f %f %f]\n", mat[2][0], mat[2][1], mat[2][2], mat[2][3]);
		printf("[ %f %f %f %f]\n", mat[3][0], mat[3][1], mat[3][2], mat[3][3]);
#endif
	}

	return true;
}

bool GameCubeConverter::SaveGeometry2( IoUtils::CVirtualOutputFile* pGDFile )
{
	int no_correct_count = 0;
	int correct_count = 0;
	int				i;
	int				num_objects			= m_scene->m_NumObjects;
	int				num_visible_objects;
	unsigned int	zero				= 0;
	short			num_meshes;
	int				num_verts;
	NxMesh *		p_mesh;
	NxMaterial *	p_material;
	int				tex_passes;
	int				tc;

	short *	pRemapIndex = NULL;
	short *	pRemapVertex = NULL;
	int * pShadowRemap = NULL;

	int color2 = 0;

	// Determine how many of these objects are invisible, and adjust the object count accordingly.
	int num_invisible_objects = 0;
	for( i = 0; i < num_objects; i++ )
	{
		NxObject*	object		= m_scene->m_Objects + i;
		if( object->m_Flags & NxObject::mINVISIBLE )
		{
			++num_invisible_objects;
		}
	}

	num_visible_objects = num_objects - num_invisible_objects;

	uint16 num_materials = (uint16)m_scene->m_Materials.CountItems();

	// Arrays for object bounding sphere & mesh bounding sphere.
	int total_meshes = 0;
	for( i = 0; i < num_objects; i++ )
	{
		NxObject*	object		= m_scene->m_Objects + i;
		num_meshes	= object->m_MeshList.m_NumMeshes[0];
		total_meshes += num_meshes;
	}
	float * obs;
	float * mbs;
	if ( num_objects ) obs = new float[num_objects*4];
	if ( total_meshes ) mbs = new float[total_meshes*4];
 
	// Stage 1: Create unique vertex lists. Also calculate bounding spheres.
	int ob_mesh = 0;
	bool skinned = false;
	for( i = 0; i < num_objects; i++ )
	{
//		printf( "\nunique %d of %d (%d,%d,%d,%d)", i, num_objects, g_u_num_pos, g_u_num_nrm, g_u_num_col, g_u_num_uv );
		NxObject*	object		= m_scene->m_Objects + i;
		NxVertex*	vert_list	= object->m_Verts;
		NxFace*		face_list	= object->m_Faces;
		
		// Skip invisible objects.
		if( object->m_Flags & NxObject::mSKINNED )
		{
			skinned = true;
		}

		if( object->m_Flags & NxObject::mINVISIBLE )
		{
			continue;
		}
		
		// Check this checksum doesn't already clash.
		for( int check = 0; check < i; ++check )
		{
			NxObject* test_object = m_scene->m_Objects + check;
			if( test_object->m_Checksum == object->m_Checksum )
			{
				// Just set the object checksum to be something random for now...
				object->m_Checksum = rand();
			}
		}
		
		num_meshes	= object->m_MeshList.m_NumMeshes[0];
		num_verts	= object->m_NumVerts;

		// Correct the billboard type.
		if ( !( object->m_Flags & NxObject::mBILLBOARD ) )
		{
			object->m_BillboardType = NxObject::BBT_NOT_BILLBOARD;
		}

		// Hack billboard verts.
		for ( int vertex = 0; vertex < object->m_NumVerts; vertex++ )
		{
			NxVertex* vert = object->m_Verts + vertex;

			float p10[3];
			float p20[3];
			float n[3];

			if ( ( object->m_BillboardType == NxObject::BBT_SCREEN_ALIGNED ) || ( object->m_BillboardType == NxObject::BBT_AXIAL_ALIGNED ) )
			{
				float p[3];

				if ( object->m_BillboardType == NxObject::BBT_SCREEN_ALIGNED )
				{
					p[0] = 0.0f;
					p[1] = 1.0f;
					p[2] = 0.0f;
				}
				else
				{
					p[0] = object->m_PivotAxis[0];
					p[1] = object->m_PivotAxis[1];
					p[2] = object->m_PivotAxis[2];
				}

				// Need to change billboard to normal/pivot space.
				if ( vertex == 0 )
				{
					NxVertex* vert1 = object->m_Verts + vertex + 1;
					NxVertex* vert2 = object->m_Verts + vertex + 2;

//					printf( "\n********* ( %8.3f %8.3f %8.3f )", vert->m_Pos[0], vert->m_Pos[1], vert->m_Pos[2] );
//					printf( " ( %8.3f %8.3f %8.3f )", vert1->m_Pos[0], vert1->m_Pos[1], vert1->m_Pos[2] );
//					printf( " ( %8.3f %8.3f %8.3f )", vert2->m_Pos[0], vert2->m_Pos[1], vert2->m_Pos[2] );
					p10[0] = vert1->m_Pos[0] - vert->m_Pos[0];
					p10[1] = vert1->m_Pos[1] - vert->m_Pos[1];
					p10[2] = vert1->m_Pos[2] - vert->m_Pos[2];

					p20[0] = vert2->m_Pos[0] - vert->m_Pos[0];
					p20[1] = vert2->m_Pos[1] - vert->m_Pos[1];
					p20[2] = vert2->m_Pos[2] - vert->m_Pos[2];

					float l;

					n[0] = ( p10[1] * p20[2] ) - ( p10[2] * p20[1] );
					n[1] = ( p10[2] * p20[0] ) - ( p10[0] * p20[2] );
					n[2] = ( p10[0] * p20[1] ) - ( p10[1] * p20[0] );

					l = sqrtf( ( n[0] * n[0] ) + ( n[1] * n[1] ) + ( n[2] * n[2] ) );
					n[0] /= l;
					n[1] /= l;
					n[2] /= l;
				}

				// Create coordinate system based on pivot.
				float _u[3];
				float _v[3];

				_u[0] = ( n[1] * p[2] ) - ( n[2] * p[1] );
				_u[1] = ( n[2] * p[0] ) - ( n[0] * p[2] );
				_u[2] = ( n[0] * p[1] ) - ( n[1] * p[0] );

				_v[0] = ( _u[1] * n[2] ) - ( _u[2] * n[1] );
				_v[1] = ( _u[2] * n[0] ) - ( _u[0] * n[2] );
				_v[2] = ( _u[0] * n[1] ) - ( _u[1] * n[0] );

				// Translate positions by origin.
				vert->m_Pos[0] -= object->m_BillboardOrigin[0];
				vert->m_Pos[1] -= object->m_BillboardOrigin[1];
				vert->m_Pos[2] -= object->m_BillboardOrigin[2];

//				printf( "\n\nPos: %8.3f %8.3f %8.3f", vert->m_Pos[0], vert->m_Pos[1], vert->m_Pos[2] );
//				printf( " Nrm: %8.3f %8.3f %8.3f", n[0], n[1], n[2] );

				float xx = ( vert->m_Pos[0] * _u[0] ) + ( vert->m_Pos[1] * _u[1] ) + ( vert->m_Pos[2] * _u[2] );
				float yy = ( vert->m_Pos[0] * _v[0] ) + ( vert->m_Pos[1] * _v[1] ) + ( vert->m_Pos[2] * _v[2] );
				float zz = ( vert->m_Pos[0] * n[0] ) + ( vert->m_Pos[1] * n[1] ) + ( vert->m_Pos[2] * n[2] );

				vert->m_Pos[0] = xx;
				vert->m_Pos[1] = yy;
				vert->m_Pos[2] = zz;

////				printf( " ( %8.3f %8.3f %8.3f )", p10[0], p10[1], p10[2] );
////				printf( " ( %8.3f %8.3f %8.3f )", p20[0], p20[1], p20[2] );
//				printf( " ( %8.3f %8.3f %8.3f )", vert->m_Pos[0], vert->m_Pos[1], vert->m_Pos[2] );
//				printf( "\n------> r: %6.3f %6.3f %6.3f", _u[0], _u[1], _u[2] );
//				printf( " u: %6.3f %6.3f %6.3f", _v[0], _v[1], _v[2] );
//				printf( " a: %6.3f %6.3f %6.3f", n[0], n[1], n[2] );
			}
		}

		// Object mini-ball.
		const int d = 3;
		Miniball<d>			omb;
		Miniball<d>::Point	ombp;

		float obbmin[3];
		float obbmax[3];
		bool failed = false;

		// Build spheres.
		int save_ob_mesh = ob_mesh;
		for( int m = 0; m < num_meshes; ++m )
		{
//			printf( "\nSphere %d, %d", i, m );
			p_mesh		= object->m_MeshList.m_Meshes[0][m];

			// An array of mesh pointers to meshes of the same material, but different LOD levels.
			NxMesh *mesh_array[8] = { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL }; 
			mesh_array[0] = p_mesh;
			
			// We need to figure out if there are lower LOD level meshes that correspond to this mesh (i.e. have the same material).
			unsigned int lod_level;
			for( lod_level = 1; lod_level < 8; ++lod_level )
			{
				if( object->m_MeshList.m_NumMeshes[lod_level] == 0 )
					break;

				for( int mitll = 0; mitll < object->m_MeshList.m_NumMeshes[lod_level]; ++mitll )
				{
					if( object->m_MeshList.m_Meshes[lod_level][mitll]->m_MatChecksum == p_mesh->m_MatChecksum )
					{
						// This level contains a corresponding mesh.
						mesh_array[lod_level] = object->m_MeshList.m_Meshes[lod_level][mitll];
						break;
					}
				}
				if( mesh_array[lod_level] == NULL )
				{
					break;
				}
			}

			// Mesh Bounding sphere.
			Miniball<d>			mmb;
			Miniball<d>::Point	mmbp;

			float bbmin[3];
			float bbmax[3];

			// Go through each mesh adding new vertices.
			int v = 0;
			while ( p_mesh->m_VertStrip[v].m_Index )
			{
				unsigned short num = p_mesh->m_VertStrip[v].m_Index;
				v++;

				for ( int vv = 0; vv < num; vv++ )
				{
					unsigned short idx = p_mesh->m_VertStrip[v+vv].m_Index;

					NxVertex* vert = object->m_Verts + idx;
	
					float px = vert->m_Pos[0];
					float py = vert->m_Pos[1];
					float pz = vert->m_Pos[2];
	
					// Add point to mesh miniball.
					mmbp[0] = px;
					mmbp[1] = py;
					mmbp[2] = pz;
					mmb.check_in( mmbp );
	
					// Add point to object miniball.
					ombp[0] = px;
					ombp[1] = py;
					ombp[2] = pz;
					omb.check_in( ombp );

					if ( v == 0 )
					{
						bbmin[0] = bbmax[0] = px;
						bbmin[1] = bbmax[1] = py;
						bbmin[2] = bbmax[2] = pz;
					}
					else
					{
						if( px < bbmin[0] )
							bbmin[0] = px;
						if( py < bbmin[1] )
							bbmin[1] = py;
						if( pz < bbmin[2] )
							bbmin[2] = pz;

						if( px > bbmax[0] )
							bbmax[0] = px;
						if( py > bbmax[1] )
							bbmax[1] = py;
						if( pz > bbmax[2] )
							bbmax[2] = pz;
					}
				}
				v += num;
			}

			if ( m == 0 )
			{
				obbmin[0] = bbmin[0];
				obbmin[1] = bbmin[1];
				obbmin[2] = bbmin[2];

				obbmax[0] = bbmax[0];
				obbmax[1] = bbmax[1];
				obbmax[2] = bbmax[2];
			}
			else
			{
				if ( obbmin[0] > bbmin[0] ) obbmin[0] = bbmin[0];
				if ( obbmin[1] > bbmin[1] ) obbmin[1] = bbmin[1];
				if ( obbmin[2] > bbmin[2] ) obbmin[2] = bbmin[2];

				if ( obbmax[0] < bbmax[0] ) obbmax[0] = bbmax[0];
				if ( obbmax[1] < bbmax[1] ) obbmax[1] = bbmax[1];
				if ( obbmax[2] < bbmax[2] ) obbmax[2] = bbmax[2];
			}

			// Build the mesh sphere.
			mmb.build();
			mmbp = mmb.center();
			mbs[(ob_mesh*4)+0] = (float)mmbp[0];
			mbs[(ob_mesh*4)+1] = (float)mmbp[1];
			mbs[(ob_mesh*4)+2] = (float)mmbp[2];
			mbs[(ob_mesh*4)+3] = (float)( sqrt( mmb.squared_radius()));

			// Sanity check the sphere; it seems in rare cases the MiniBall stuff is erroneous.
			v = 0;
			while ( p_mesh->m_VertStrip[v].m_Index )
			{
				unsigned short num = p_mesh->m_VertStrip[v].m_Index;
				v++;

				for ( int vv = 0; vv < num; vv++ )
				{
					unsigned short idx = p_mesh->m_VertStrip[v+vv].m_Index;

					NxVertex* vert = object->m_Verts + idx;
	
					float px = vert->m_Pos[0] - mbs[(ob_mesh*4)+0];
					float py = vert->m_Pos[1] - mbs[(ob_mesh*4)+1];
					float pz = vert->m_Pos[2] - mbs[(ob_mesh*4)+2];

					float dist_from_sphere_center = (float)sqrt(( px * px ) + ( py * py ) + ( pz * pz ));
					if(( dist_from_sphere_center > mbs[(ob_mesh*4)+3] ) && fabs( dist_from_sphere_center - mbs[(ob_mesh*4)+3] ) > 0.5f )
					{
						// Do the standard bounding sphere by using the bounding box.
						float diag0 = ( bbmax[0] - bbmin[0] ) * 0.5f;
						float diag1 = ( bbmax[1] - bbmin[1] ) * 0.5f;
						float diag2 = ( bbmax[2] - bbmin[2] ) * 0.5f;

						mbs[(ob_mesh*4)+0]	= bbmin[0] + diag0;
						mbs[(ob_mesh*4)+1]	= bbmin[1] + diag1;
						mbs[(ob_mesh*4)+2]	= bbmin[2] + diag2;

						mbs[(ob_mesh*4)+3]	= sqrtf(( diag0 * diag0 ) + ( diag1 * diag1 ) + ( diag2 * diag2 ));
						failed = true;
					}
				}
				v += num;
			}

			ob_mesh++;
		}

		// Build the object sphere.
		omb.build();
		ombp = omb.center();
		obs[(i*4)+0] = (float)ombp[0];
		obs[(i*4)+1] = (float)ombp[1];
		obs[(i*4)+2] = (float)ombp[2];
		obs[(i*4)+3] = (float)( sqrt( omb.squared_radius())); 

		if( failed )
		{
			// Do the standard bounding sphere by using the bounding box.
			float diag0 = ( obbmax[0] - obbmin[0] ) * 0.5f;
			float diag1 = ( obbmax[1] - obbmin[1] ) * 0.5f;
			float diag2 = ( obbmax[2] - obbmin[2] ) * 0.5f;

			obs[(i*4)+0]	= obbmin[0] + diag0;
			obs[(i*4)+1]	= obbmin[1] + diag1;
			obs[(i*4)+2]	= obbmin[2] + diag2;

			obs[(i*4)+3]	= sqrtf(( diag0 * diag0 ) + ( diag1 * diag1 ) + ( diag2 * diag2 ));
		}
//		printf( "\nSphere: (%8.3f %8.3f %8.3f %8.3f)", obs[(i*4)+0], obs[(i*4)+1], obs[(i*4)+2], obs[(i*4)+3] );





//		// Splay normals.
//		if( !(object->m_Flags & NxObject::mSKINNED) && ( object->m_Flags & NxObject::mNORMALS ) )
//		{
////			printf( "\nSplay" );
//			for ( int vertex = 0; vertex < object->m_NumVerts; vertex++ )
//			{
//				NxVertex* vert = object->m_Verts + vertex;
//
//				// Calculate intersection of ray and sphere.
//				// Realtime Rendering Second Edition, page 571.
//				float ix = 0.0f;
//				float iy = 0.0f;
//				float iz = 0.0f;
//
//				float ox = vert->m_Pos[0];
//				float oy = vert->m_Pos[1];
//				float oz = vert->m_Pos[2];
//				float dx = vert->m_Normal[0];
//				float dy = vert->m_Normal[1];
//				float dz = vert->m_Normal[2];
//				float cx = obs[(i*4)+0];
//				float cy = obs[(i*4)+1];
//				float cz = obs[(i*4)+2];
//				float r = obs[(i*4)+3] + ( 12.0f * 10.0f );		// 10 feet reflection.
//
//				float lx = cx - ox;
//				float ly = cy - oy;
//				float lz = cz - oz;
//
//				float s = ( lx * dx ) + ( ly * dy ) + ( lz * dz );
//
//				float l2 = ( lx * lx ) + ( ly * ly ) + ( lz * lz );
//				float r2 = r * r;
//
//				float t = 0.0f;
//				if ( !( ( s < 0.0f ) && ( l2 > r2 ) ) )
//				{
//					float m2 = l2 - ( s * s );
//
//					if ( !( m2 > r2 ) )
//					{
//						float q = sqrtf( r2 - m2 );
//
//						if ( l2 > r2 )
//						{
//							t = s - q;
//						}
//						else
//						{
//							t = s + q;
//						}
//						ix = ox + ( t * dx );
//						iy = oy + ( t * dy );
//						iz = oz + ( t * dz );
//					}
//				}
//
//				// Calculate new normal (center of circle to intersection point).
//				float nx = ix - cx;
//				float ny = iy - cy;
//				float nz = iz - cz;
//				float len = sqrtf( ( nx * nx ) + ( ny * ny ) + ( nz * nz ) );
//				float rlen = 1.0f / len;
//				nx = nx * rlen;
//				ny = ny * rlen;
//				nz = nz * rlen;
//
//				vert->m_Normal[0] = nx;
//				vert->m_Normal[1] = ny;
//				vert->m_Normal[2] = nz;
////				printf( "\nNormal: pos(%8.3f %8.3f %8.3f) old(%8.3f %8.3f %8.3f) new(%8.3f %8.3f %8.3f) ix(%8.3f %8.3f %8.3f)", ox, oy, oz, dx, dy, dz, nx, ny, nz, ix, iy, iz );
//			}
//		}

		// Add only referenced vertex data.
//		printf( "\nAdd object %d (%d/%d, worst %d) ", i, g_u_num_nrm, g_num_nrm, g_worst_nrm );
		for( int m = 0; m < num_meshes; ++m )
		{
//			printf( "\nAdd %d", m );
			p_mesh		= object->m_MeshList.m_Meshes[0][m];
			p_material	= m_scene->GetMaterial( p_mesh->m_MatChecksum );

			// An array of mesh pointers to meshes of the same material, but different LOD levels.
			NxMesh *mesh_array[8] = { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL }; 
			mesh_array[0] = p_mesh;
			
			// We need to figure out if there are lower LOD level meshes that correspond to this mesh (i.e. have the same material).
			unsigned int lod_level;
			for( lod_level = 1; lod_level < 8; ++lod_level )
			{
				if( object->m_MeshList.m_NumMeshes[lod_level] == 0 )
					break;

				for( int mitll = 0; mitll < object->m_MeshList.m_NumMeshes[lod_level]; ++mitll )
				{
					if( object->m_MeshList.m_Meshes[lod_level][mitll]->m_MatChecksum == p_mesh->m_MatChecksum )
					{
						// This level contains a corresponding mesh.
						mesh_array[lod_level] = object->m_MeshList.m_Meshes[lod_level][mitll];
						break;
					}
				}
				if( mesh_array[lod_level] == NULL )
				{
					break;
				}
			}

//			printf( "\n\n***** LOD Levels: %d\n\n", lod_level );

			// Set number of texture passes.
			tex_passes = 0;
			if( object->m_Flags & NxObject::mTEXTURED )
			{
				if( p_material )
				{
					tex_passes = p_material->m_NumPasses;
				}
			}

			// Scan color information and see if this mesh needs correction or not.
			bool correct = false;
//			int worst = 0;
//			if ( !( object->m_Flags & NxObject::mSKINNED ) && ( object->m_Flags & NxObject::mCOLORED ) )
//			{
//				bool ignore = true;
//				for ( int p = 0; p < p_material->m_NumPasses; p++ )
//				{
//					if ( p_material->m_Passes[p].m_BlendMode == vBLEND_MODE_DIFFUSE ) continue;
//					if( !(p_material->m_Passes[p].m_Flags & NxMaterialPass::IGNORE_VERTEX_ALPHA) )
//					{
//						ignore = false;
//						break;
//					}
//				}
//
//
//				int count = 0;
//				int v = 0;
//				int c0[4] = { 0, 0, 0, 0 };
//				int c1[4] = { 0, 0, 0, 0 };
//				int c2[4] = { 0, 0, 0, 0 };
//
//				float pos0[3] = { 0.0f, 0.0f, 0.0f };
//				float pos1[3] = { 0.0f, 0.0f, 0.0f };
//				float pos2[3] = { 0.0f, 0.0f, 0.0f };
//
////				printf( "\nMesh: %4d %s", m, ignore ? "i" : " " );
//				while ( p_mesh->m_VertStrip[v].m_Index )
//				{
//					unsigned short num = p_mesh->m_VertStrip[v].m_Index;
//					v++;
//
//					unsigned int last_color = 0;
////					printf( "\n *%3d*", num );
//					for ( int vv = 0; vv < num; vv++ )
//					{
//						unsigned short idx;
//						NxVertex* vert;
//
//						idx = p_mesh->m_VertStrip[v+vv].m_Index;
//						vert = object->m_Verts + idx;
//
//						// Color index.
//						unsigned char r = (unsigned char) (( vert->m_Color[0] * 128.0f ) + 0.5f );
//						unsigned char g = (unsigned char) (( vert->m_Color[1] * 128.0f ) + 0.5f );
//						unsigned char b = (unsigned char) (( vert->m_Color[2] * 128.0f ) + 0.5f );
//						unsigned char a = (unsigned char) (( vert->m_Color[3] * 128.0f ) + 0.5f );
//						unsigned int color = ( r << 24 ) | ( g << 16 ) | ( b << 8 ) | a;
//
////						printf( " (%08x)", color );
//						c0[0] = c1[0];
//						c0[1] = c1[1];
//						c0[2] = c1[2];
//						c0[3] = c1[3];
//						c1[0] = c2[0];
//						c1[1] = c2[1];
//						c1[2] = c2[2];
//						c1[3] = c2[3];
//						c2[0] = r;
//						c2[1] = g;
//						c2[2] = b;
//						c2[3] = a;
//
//						pos0[0] = pos1[0];
//						pos0[1] = pos1[1];
//						pos0[2] = pos1[2];
//						pos1[0] = pos2[0];
//						pos1[1] = pos2[1];
//						pos1[2] = pos2[2];
//						pos2[0] = vert->m_Pos[0];
//						pos2[1] = vert->m_Pos[0]; 
//						pos2[2] = vert->m_Pos[0]; 
//
//						count++;
//
//						if ( vv > 1 )
//						{
//							float mlen;
//							float tlen;
//							mlen = fabsf( sqrtf( ( ( pos1[0] - pos0[0] ) * ( pos1[0] - pos0[0] ) ) +
//												 /*( ( pos1[1] - pos0[1] ) * ( pos1[1] - pos0[1] ) ) +*/
//												 ( ( pos1[2] - pos0[2] ) * ( pos1[2] - pos0[2] ) ) ) );
//							tlen = fabsf( sqrtf( ( ( pos2[0] - pos1[0] ) * ( pos2[0] - pos1[0] ) ) +
//												 /*( ( pos2[1] - pos1[1] ) * ( pos2[1] - pos1[1] ) ) +*/
//												 ( ( pos2[2] - pos1[2] ) * ( pos2[2] - pos1[2] ) ) ) );
//							if ( tlen > mlen ) mlen = tlen;
//							tlen = fabsf( sqrtf( ( ( pos0[0] - pos2[0] ) * ( pos0[0] - pos2[0] ) ) +
//												 /*( ( pos0[1] - pos2[1] ) * ( pos0[1] - pos2[1] ) ) +*/
//												 ( ( pos0[2] - pos2[2] ) * ( pos0[2] - pos2[2] ) ) ) );
//							if ( tlen > mlen ) mlen = tlen;
//							// See what the worst difference is.
//							if ( mlen > MIN_COL_LEN )
//							{
//								for ( int lp = 0; lp < ( ignore ? 3 : 4 ); lp++ )
//								{
//									unsigned char diff;
//									diff = abs( c0[lp] - c1[lp] );
//									if ( diff > worst ) worst = diff;
//
//									diff = abs( c1[lp] - c2[lp] );
//									if ( diff > worst ) worst = diff;
//
//									diff = abs( c2[lp] - c0[lp] );
//									if ( diff > worst ) worst = diff;
//								}
//							}
//						}
//					}
//					v += num;
//				}
//				if ( worst < WORST_TOL )
//				{
//					no_correct_count += count;
//				}													 	
//				else
//				{
//					correct_count += count;
//					correct = true;
//				}
//
////				printf( "\nMesh: %4d - worst = %d\n", m, worst );
//			}
			p_material->m_grassify = correct;		// Grassify now flags if material should correct or not.


			// Go through each mesh adding new vertices.
//			char modified[65536];
//			for ( int mmm = 0; mmm < 65536; mmm++ ) modified[mmm] = 0;

			// Find scale of tex coords for this mesh.
			g_uv_reset = true;
			bool same[3] = { true, true, true };
			int count_same = 0;
			int v = 0;
			while ( p_mesh->m_VertStrip[v].m_Index )
			{
				unsigned short num = p_mesh->m_VertStrip[v].m_Index;
				v++;

				for ( int vv = 0; vv < num; vv++ )
				{
					unsigned short idx = p_mesh->m_VertStrip[v+vv].m_Index;

					NxVertex* vert = object->m_Verts + idx;

					// Add Texture coordinates.
//					printf( "t" );
					float uu;
					float vv;
					for( tc = 0; tc < tex_passes; ++tc )
					{
						if ( tc == 0 )
						{
							uu = vert->m_TexCoord[tc][0];
							vv = vert->m_TexCoord[tc][1];
							count_same++;
						}
						else
						{
							if ( ( uu != vert->m_TexCoord[tc][0] ) || ( v != vert->m_TexCoord[tc][1] ) )
							{
								same[tc-1] = false;
							}
						}

						if ( p_material->m_Passes[tc].m_MappingMode == vMAPPING_ENVIRONMENT ) continue;
						unsigned int TexChecksum = p_material->m_Passes[tc].GetTextureChecksum( Utils::vPLATFORM_NGC );
						if ( GetTextureByChecksum( TexChecksum ) == 0 ) continue;

						float u = vert->m_TexCoord[tc][0];
						float v = vert->m_TexCoord[tc][1];
						if ( g_uv_reset )
						{
							// First one.
							g_min_u = u;
							g_max_u = u;
							g_min_v = v;
							g_max_v = v;
							g_uv_reset = false;
						}
						else
						{
							if ( u < g_min_u ) g_min_u = u;
							if ( u > g_max_u ) g_max_u = u;
							if ( v < g_min_v ) g_min_v = v;
							if ( v > g_max_v ) g_max_v = v;
						}

						g_num_uv++;
					}
				}
				v += num;
			}
//			printf( "\nBounds: %8.3f %8.3f %8.3f %8.3f", g_min_u, g_max_u, g_min_v, g_max_v );
//			if ( ( tex_passes > 1 ) && ( count_same > 0 ) )
//			{
//				if ( same[0] ) printf( "\nPass 1 same as pass 0: %d indices", count_same );
//				if ( same[1] ) printf( "\nPass 2 same as pass 0: %d indices", count_same );
//				if ( same[2] ) printf( "\nPass 3 same as pass 0: %d indices", count_same );
//			}

			uint32 mask;
			int vat = 5;	//2;
			for ( int mvat = 7; mvat >= 5; mvat-- )
			{
				float mul = 1.0f;
				switch ( mvat )
				{
					case 7:
						mul = 1024.0f;
						break;
					case 6:
						mul = 256.0f;
						break;
					case 5:
						mul = 64.0f;
						break;
					case 4:
						mul = 16.0f;
						break;
					case 3:
						mul = 4.0f;
						break;
					default:
					case 2:
						mul = 1.0f;
						break;
				}
				mask  = (uint32)( fabsf( g_min_u ) * mul );
				mask |= (uint32)( fabsf( g_min_v ) * mul );
				mask |= (uint32)( fabsf( g_max_u ) * mul );
				mask |= (uint32)( fabsf( g_max_v ) * mul );

				if ( ( mask & 0xffff8000 ) == 0 )
				{
					vat = mvat;
					break;
				}
			}

			int u_bound = (int)((fabsf( g_min_u ) > fabsf( g_max_u )) ? fabsf( g_min_u ) : fabsf( g_max_u ));
			int v_bound = (int)((fabsf( g_min_v ) > fabsf( g_max_v )) ? fabsf( g_min_v ) : fabsf( g_max_v ));
			int bound = u_bound > v_bound ? u_bound : v_bound;
			if ( bound > 2047 ) printf( "\nBound Error: %d %8.3f %8.3f %8.3f %8.3f", bound, g_min_u, g_max_u, g_min_v, g_max_v );

//			printf( "\nMask: %08x Vat: %d", mask, vat );
			p_mesh->m_Topology[NxMesh::vMAX_FACES-1][2] = vat;

//			int vat = 2;		// No fixed point.
//			int u_bound = (int)((fabsf( g_min_u ) > fabsf( g_max_u )) ? fabsf( g_min_u ) : fabsf( g_max_u ));
//			int v_bound = (int)((fabsf( g_min_v ) > fabsf( g_max_v )) ? fabsf( g_min_v ) : fabsf( g_max_v ));
//			int bound = u_bound > v_bound ? u_bound : v_bound;
//			if ( bound < 32 )
//			{
//				vat = 7;
//			}
//			else if ( bound < 128 )
//			{
//				vat = 6;
//			}
//			else if ( bound < 512 )
//			{
//				vat = 5;
//			}
//			else if ( bound < 2048 )
//			{
//				vat = 4;
//			}
//			else if ( bound < 8192 )
//			{
//				vat = 3;
//			}
//			p_mesh->m_Topology[NxMesh::vMAX_FACES-1][2] = vat;

//        material->m_BasePass
//			// Axis aligned - need to change billboard to normal/pivot space.
//			if ( vertex == 0 )
//			{
//				NxVertex* vert1 = object->m_Verts + vertex + 1;
//				NxVertex* vert2 = object->m_Verts + vertex + 2;
//
////						printf( "\n********* ( %8.3f %8.3f %8.3f )", vert->m_Pos[0], vert->m_Pos[1], vert->m_Pos[2] );
////						printf( " ( %8.3f %8.3f %8.3f )", vert1->m_Pos[0], vert1->m_Pos[1], vert1->m_Pos[2] );
////						printf( " ( %8.3f %8.3f %8.3f )", vert2->m_Pos[0], vert2->m_Pos[1], vert2->m_Pos[2] );
//				p10[0] = vert1->m_Pos[0] - vert->m_Pos[0];
//				p10[1] = vert1->m_Pos[1] - vert->m_Pos[1];
//				p10[2] = vert1->m_Pos[2] - vert->m_Pos[2];
//
//				p20[0] = vert2->m_Pos[0] - vert->m_Pos[0];
//				p20[1] = vert2->m_Pos[1] - vert->m_Pos[1];
//				p20[2] = vert2->m_Pos[2] - vert->m_Pos[2];
//
//				float l;
//
//				l = sqrtf( ( p10[0] * p10[0] ) + ( p10[1] * p10[1] ) + ( p10[2] * p10[2] ) );
//				p10[0] /= l;
//				p10[1] /= l;
//				p10[2] /= l;
//
//				l = sqrtf( ( p20[0] * p20[0] ) + ( p20[1] * p20[1] ) + ( p20[2] * p20[2] ) );
//				p20[0] /= l;
//				p20[1] /= l;
//				p20[2] /= l;
//
//				n[0] = ( p10[1] * p20[2] ) - ( p10[2] * p20[1] );
//				n[1] = ( p10[2] * p20[0] ) - ( p10[0] * p20[2] );
//				n[2] = ( p10[0] * p20[1] ) - ( p10[1] * p20[0] );
//			}


			v = 0;
			int min_index = 65535*4;
			int max_index = -1;
			while ( p_mesh->m_VertStrip[v].m_Index )
			{
				unsigned short num = p_mesh->m_VertStrip[v].m_Index;
				v++;

				for ( int vv = 0; vv < num; vv++ )
				{
					unsigned short idx = p_mesh->m_VertStrip[v+vv].m_Index;

					NxVertex* vert = object->m_Verts + idx;

					// Add Position.
//					printf( "p" );
					//if( !(object->m_Flags & NxObject::mSKINNED) )
					{
						int idx;
						vert->m_WeightedIndex[5] = -1;
						if ( ( idx = get_pos( vert->m_Pos[0], vert->m_Pos[1], vert->m_Pos[2], -1 ) ) == -1 )
						{
							idx = g_u_num_pos;
							add_pos( vert->m_Pos[0], vert->m_Pos[1], vert->m_Pos[2] );
						}

						if ( idx < min_index ) min_index = idx;
						if ( idx > max_index ) max_index = idx;

						g_num_pos++;
					}

					// Add normals.
					if( !(object->m_Flags & NxObject::mSKINNED) && ( object->m_Flags & NxObject::mNORMALS ) )
					{
						// Calculate intersection of ray and sphere.
						// Realtime Rendering Second Edition, page 571.
						float ix = 0.0f;
						float iy = 0.0f;
						float iz = 0.0f;
		
						float ox = vert->m_Pos[0];
						float oy = vert->m_Pos[1];
						float oz = vert->m_Pos[2];
						float dx = vert->m_Normal[0];
						float dy = vert->m_Normal[1];
						float dz = vert->m_Normal[2];
						float cx = mbs[(save_ob_mesh*4)+0];
						float cy = mbs[(save_ob_mesh*4)+1];
						float cz = mbs[(save_ob_mesh*4)+2];
//						float r = mbs[(save_ob_mesh*4)+3] + ( 12.0f * 10.0f );		// 10 feet reflection.
//						float cx = obs[(i*4)+0];
//						float cy = obs[(i*4)+1];
//						float cz = obs[(i*4)+2];
						float r = obs[(i*4)+3] + ( 12.0f * 10.0f );		// 10 feet reflection.
		
						float lx = cx - ox;
						float ly = cy - oy;
						float lz = cz - oz;
		
						float s = ( lx * dx ) + ( ly * dy ) + ( lz * dz );
		
						float l2 = ( lx * lx ) + ( ly * ly ) + ( lz * lz );
						float r2 = r * r;
		
						float t = 0.0f;
						if ( !( ( s < 0.0f ) && ( l2 > r2 ) ) )
						{
							float m2 = l2 - ( s * s );
		
							if ( !( m2 > r2 ) )
							{
								float q = sqrtf( r2 - m2 );
		
								if ( l2 > r2 )
								{
									t = s - q;
								}
								else
								{
									t = s + q;
								}
								ix = ox + ( t * dx );
								iy = oy + ( t * dy );
								iz = oz + ( t * dz );
							}
						}
		
						// Calculate new normal (center of circle to intersection point).
						float nx = ix - cx;
						float ny = iy - cy;
						float nz = iz - cz;
						float len = sqrtf( ( nx * nx ) + ( ny * ny ) + ( nz * nz ) );
						float rlen = 1.0f / len;
						nx = nx * rlen;
						ny = ny * rlen;
						nz = nz * rlen;
		
  						if ( get_nrm( nx, ny, nz ) == -1 )
						{
							add_nrm( nx, ny, nz );
						}
//						s16 nx16 = (s16)( nx * (float)NORM_MUL );
//						s16 ny16 = (s16)( ny * (float)NORM_MUL );
//						s16 nz16 = (s16)( nz * (float)NORM_MUL );
//
//						if ( modified[idx] == 0 )
//						{
//							modified[idx] = 1;
//							vert->m_Normal[0] = nx; 
//							vert->m_Normal[1] = ny; 
//							vert->m_Normal[2] = nz; 
//						}
//
//						if ( get_nrm( nx16, ny16, nz16 ) == -1 )
//						{
//							add_nrm( nx16, ny16, nz16 );
//						}
						g_num_nrm++;


////						printf( "n" );
//						if ( get_nrm( vert->m_Normal[0], vert->m_Normal[1], vert->m_Normal[2] ) == -1 )
//						{
//							add_nrm( vert->m_Normal[0], vert->m_Normal[1], vert->m_Normal[2] );
//						}
//						g_num_nrm++;
					}

					// Add Color.
					// Don't add colors if this object is wibbled.
					if( object->m_Flags & NxObject::mCOLORED )
					{
//						printf( "c" );
						// Add color if this mesh is not wibbled, or wibbled, but color of 0.
						if ( !(object->m_Flags & NxObject::mVCWIBBLE) || ( (object->m_Flags & NxObject::mVCWIBBLE) && vert->m_WibbleIndex == 0 ) )
						{
							unsigned char r = (unsigned char) (( vert->m_Color[0] * 128.0f ) + 0.5f );
							unsigned char g = (unsigned char) (( vert->m_Color[1] * 128.0f ) + 0.5f );
							unsigned char b = (unsigned char) (( vert->m_Color[2] * 128.0f ) + 0.5f );
							unsigned char a = (unsigned char) (( vert->m_Color[3] * 128.0f ) + 0.5f );
							unsigned int color = ( r << 24 ) | ( g << 16 ) | ( b << 8 ) | a;
	
							if ( get_col( color ) == -1 )
							{
								add_col( color );
							}
							g_num_col++;
						}
					}				

					// Add Texture coordinates.
//					printf( "t" );
					for( tc = 0; tc < tex_passes; ++tc )
					{
						if ( p_material->m_Passes[tc].m_MappingMode == vMAPPING_ENVIRONMENT ) continue;
						unsigned int TexChecksum = p_material->m_Passes[tc].GetTextureChecksum( Utils::vPLATFORM_NGC );
						if ( GetTextureByChecksum( TexChecksum ) == 0 ) continue;

						short u, v;
						switch ( p_mesh->m_Topology[NxMesh::vMAX_FACES-1][2] )
						{
							default:
							case 2:
								u = (short)vert->m_TexCoord[tc][0];
								v = (short)vert->m_TexCoord[tc][1];
								break;
							case 3:
								u = (short)( vert->m_TexCoord[tc][0] * 4.0f );
								v = (short)( vert->m_TexCoord[tc][1] * 4.0f );
								break;
							case 4:
								u = (short)( vert->m_TexCoord[tc][0] * 16.0f );
								v = (short)( vert->m_TexCoord[tc][1] * 16.0f );
								break;
							case 5:
								u = (short)( vert->m_TexCoord[tc][0] * 64.0f );
								v = (short)( vert->m_TexCoord[tc][1] * 64.0f );
								break;
							case 6:
								u = (short)( vert->m_TexCoord[tc][0] * 256.0f );
								v = (short)( vert->m_TexCoord[tc][1] * 256.0f );
								break;
							case 7:
								u = (short)( vert->m_TexCoord[tc][0] * 1024.0f );
								v = (short)( vert->m_TexCoord[tc][1] * 1024.0f );
								break;
						}

						if ( get_uv( u, v ) == -1 )
						{
							add_uv( u, v );
						}
						g_num_uv++;
					}
				}
				v += num;
			}

			// See if we need to adjust some verts.
			if ( ( max_index - min_index ) >= 65535 )
			{
				printf( "\nFixing Mesh Index Range Problem: ( %5d %5d ) Moving: ", min_index, max_index );
			}
			while ( ( max_index - min_index ) >= 65535 )
			{
				// Find the lowest index & add it again.
				v = 0;
				bool quit = false;
				while ( p_mesh->m_VertStrip[v].m_Index && !quit )
				{
					unsigned short num = p_mesh->m_VertStrip[v].m_Index;
					v++;

					for ( int vv = 0; vv < num; vv++ )
					{
						unsigned short idx = p_mesh->m_VertStrip[v+vv].m_Index;

						NxVertex* vert = object->m_Verts + idx;

						int vidx = get_pos( vert->m_Pos[0], vert->m_Pos[1], vert->m_Pos[2], vert->m_WeightedIndex[5] );
						if ( vidx == min_index )
						{
							// Found it. Add it again. Flag the index used.
							vert->m_WeightedIndex[5] = g_u_num_pos;
//							add_pos( vert->m_Pos[0], vert->m_Pos[1], vert->m_Pos[2] );
							sint32 ix = (sint32)( vert->m_Pos[0] * 16.0f );
							sint32 iy = (sint32)( vert->m_Pos[1] * 16.0f );
							sint32 iz = (sint32)( vert->m_Pos[2] * 16.0f );

							float fx = ( (float)ix ) / 16.0f;
							float fy = ( (float)iy ) / 16.0f;
							float fz = ( (float)iz ) / 16.0f;

							g_u_pos[g_u_num_pos][0] = fx;
							g_u_pos[g_u_num_pos][1] = fy;
							g_u_pos[g_u_num_pos][2] = fz;
							g_u_num_pos++;

							quit = true;
							printf( " %5d", vidx );
							break;
						}
					}

					v += num;
				}

				// Recalculate min & max.
				v = 0;
				min_index = 65535*4;
				max_index = -1;
				while ( p_mesh->m_VertStrip[v].m_Index )
				{
					unsigned short num = p_mesh->m_VertStrip[v].m_Index;
					v++;

					for ( int vv = 0; vv < num; vv++ )
					{
						unsigned short idx = p_mesh->m_VertStrip[v+vv].m_Index;

						NxVertex* vert = object->m_Verts + idx;

						int vidx = get_pos( vert->m_Pos[0], vert->m_Pos[1], vert->m_Pos[2], vert->m_WeightedIndex[5] );
						if ( vidx < min_index ) min_index = vidx;
						if ( vidx > max_index ) max_index = vidx;
					}

					v += num;
				}
			}





































































//			printf( "\nObject %4d: Mesh %3d: Tex coord range: U: %8.3f %8.3f V: %8.3f %8.3f ", i, m, g_min_u, g_max_u, g_min_v, g_max_v );
			save_ob_mesh++;
		}
	}

	printf( "\nNum norms: %d / %d ", g_u_num_nrm, g_num_nrm );

	Mesh ** pp_mesh = NULL;
	int total_mesh_groups = 0;

//	mesh->numVerts = g_u_num_pos;
//	mesh->verts = new MeshVertex[mesh->numVerts];
//	for ( int vi = 0; vi < mesh->numVerts; vi++ )
//	{
//		mesh->verts[vi].x = g_u_pos[vi][0];
//		mesh->verts[vi].y = g_u_pos[vi][1];
//		mesh->verts[vi].z = g_u_pos[vi][2];
//
//		int index = -1;
//		for ( int ovi = 0; ovi < object->m_NumVerts; ovi++ )
//		{
//			if ( get_pos( object->m_Verts[ovi].m_Pos[0], object->m_Verts[ovi].m_Pos[1], object->m_Verts[ovi].m_Pos[2] ) == vi )
//			{
//				index = ovi;
//				break;
//			}
//		}
//		if ( index == -1 ) printf( "\nVertex %4d, index %4d", vi, index );
//
//		mesh->verts[vi].idx = index;
//	}

	// Simplification.
	int ** mesh_matrix = NULL;
	int * num_mesh = NULL;
	printf( "\n%d objects", num_objects );
	for( i = 0; i < num_objects; i++ )
	{
//		printf( "\nunique %d of %d (%d,%d,%d,%d)", i, num_objects, g_u_num_pos, g_u_num_nrm, g_u_num_col, g_u_num_uv );
		NxObject*	object		= m_scene->m_Objects + i;
		NxVertex*	vert_list	= object->m_Verts;
		NxFace*		face_list	= object->m_Faces;
			
		// Skip invisible objects.
		if( object->m_Flags & NxObject::mINVISIBLE )
		{
			continue;
		}
		
		// Check this checksum doesn't already clash.
		for( int check = 0; check < i; ++check )
		{
			NxObject* test_object = m_scene->m_Objects + check;
			if( test_object->m_Checksum == object->m_Checksum )
			{
				// Just set the object checksum to be something random for now...
				object->m_Checksum = rand();
			}
		}
		
		if( 0 )	//object->m_Flags & NxObject::mSKINNED )	// Turned off.
		{

			printf( "\n%d meshes", num_meshes );

			num_meshes	= object->m_MeshList.m_NumMeshes[0];
			num_verts	= object->m_NumVerts;


			mesh_matrix = new int *[num_meshes];
			num_mesh = new int[num_meshes];
			int * mesh_assigned = new int[num_meshes];
			int num_mesh_groups = 0;

			for( int mm = 0; mm < num_meshes; ++mm ) mesh_matrix[mm] = new int[num_meshes];
			for( int ma = 0; ma < num_meshes; ++ma ) mesh_assigned[ma] = 0;

			// Build face arrays.
			struct sFace
			{
				int f[3];
			};
			sFace **p_face;
			p_face = new sFace *[num_meshes];

			for( int fmesh = 0; fmesh < num_meshes; ++fmesh )
			{
				NxMesh *p_mesh = object->m_MeshList.m_Meshes[0][fmesh];

				p_face[fmesh] = new sFace[p_mesh->m_NumFaces];

				for ( int v0 = 0; v0 < p_mesh->m_NumFaces; v0++ )
				{
					int p0 = p_mesh->m_Topology[v0][0];
					int p1 = p_mesh->m_Topology[v0][1];
					int p2 = p_mesh->m_Topology[v0][2];

					int pp0 = get_pos( object->m_Verts[p0].m_Pos[0], object->m_Verts[p0].m_Pos[1], object->m_Verts[p0].m_Pos[2], object->m_Verts[p0].m_WeightedIndex[5] );
					int pp1 = get_pos( object->m_Verts[p1].m_Pos[0], object->m_Verts[p1].m_Pos[1], object->m_Verts[p1].m_Pos[2], object->m_Verts[p1].m_WeightedIndex[5] );
					int pp2 = get_pos( object->m_Verts[p2].m_Pos[0], object->m_Verts[p2].m_Pos[1], object->m_Verts[p2].m_Pos[2], object->m_Verts[p2].m_WeightedIndex[5] );

					p_face[fmesh][v0].f[0] = pp0;
					p_face[fmesh][v0].f[1] = pp1;
					p_face[fmesh][v0].f[2] = pp2;
				}
			}

			// Check connections..
			for( int mesh0 = 0; mesh0 < num_meshes; ++mesh0 )
			{
				NxMesh *p_mesh0		= object->m_MeshList.m_Meshes[0][mesh0];
				//printf( "\n%d meshes", num_meshes );

				num_mesh[mesh0] = 0;

				if ( mesh_assigned[mesh0] ) continue;

				mesh_matrix[num_mesh_groups][num_mesh[num_mesh_groups]] = mesh0;
				num_mesh[num_mesh_groups]++;
				mesh_assigned[mesh0] = 1;

				for( int mesh1 = 0; mesh1 < num_meshes; ++mesh1 )
				{
					if ( mesh0 == mesh1 ) continue;
					if ( mesh_assigned[mesh1] ) continue;

					NxMesh *p_mesh1		= object->m_MeshList.m_Meshes[0][mesh1];
				
					int connected = 0;
					for ( int v0 = 0; v0 < p_mesh0->m_NumFaces; v0++ )
					{
//						int p0 = p_mesh0->m_Topology[v0][0];
//						int p1 = p_mesh0->m_Topology[v0][1];
//						int p2 = p_mesh0->m_Topology[v0][2];
//
//						int pp0 = get_pos( object->m_Verts[p0].m_Pos[0], object->m_Verts[p0].m_Pos[1], object->m_Verts[p0].m_Pos[2] ); 
//						int pp1 = get_pos( object->m_Verts[p1].m_Pos[0], object->m_Verts[p1].m_Pos[1], object->m_Verts[p1].m_Pos[2] ); 
//						int pp2 = get_pos( object->m_Verts[p2].m_Pos[0], object->m_Verts[p2].m_Pos[1], object->m_Verts[p2].m_Pos[2] ); 

						int pp0 = p_face[mesh0][v0].f[0];
						int pp1 = p_face[mesh0][v0].f[1];
						int pp2 = p_face[mesh0][v0].f[2];

						for ( int v1 = 0; v1 < p_mesh1->m_NumFaces; v1++ )
						{
//							int q0 = p_mesh1->m_Topology[v1][0];
//							int q1 = p_mesh1->m_Topology[v1][1];
//							int q2 = p_mesh1->m_Topology[v1][2];
//
//							int qq0 = get_pos( object->m_Verts[q0].m_Pos[0], object->m_Verts[q0].m_Pos[1], object->m_Verts[q0].m_Pos[2] ); 
//							int qq1 = get_pos( object->m_Verts[q1].m_Pos[0], object->m_Verts[q1].m_Pos[1], object->m_Verts[q1].m_Pos[2] ); 
//							int qq2 = get_pos( object->m_Verts[q2].m_Pos[0], object->m_Verts[q2].m_Pos[1], object->m_Verts[q2].m_Pos[2] ); 

							int qq0 = p_face[mesh1][v1].f[0];
							int qq1 = p_face[mesh1][v1].f[1];
							int qq2 = p_face[mesh1][v1].f[2];

							if ( ( pp0 == qq0 ) || ( pp0 == qq1 ) || ( pp0 == qq2 ) ) connected++;
							if ( ( pp1 == qq0 ) || ( pp1 == qq1 ) || ( pp1 == qq2 ) ) connected++;
							if ( ( pp2 == qq0 ) || ( pp2 == qq1 ) || ( pp2 == qq2 ) ) connected++;
						}
					}
					if ( connected )
					{
						mesh_matrix[num_mesh_groups][num_mesh[num_mesh_groups]] = mesh1;
						num_mesh[num_mesh_groups]++;
						mesh_assigned[mesh1] = 1;
					}

//					printf( "\nMesh %2d: Connected %4d times with mesh %d", mesh0, connected, mesh1 );
				}
				num_mesh_groups++;
			}

			delete mesh_assigned;

			pp_mesh = new Mesh*[num_mesh_groups];
			total_mesh_groups = num_mesh_groups;

			// Delete temp face lists.
			for( int dmesh = 0; dmesh < num_meshes; ++dmesh )
			{
				delete p_face[dmesh];
			}
			delete p_face;

			for ( int gr = 0; gr < num_mesh_groups; gr++ )
			{
//				printf( "\nMesh Group %2d:", gr );
//				for ( int it = 0; it < num_mesh[gr]; it++ )
//				{
//					printf( " %2d", mesh_matrix[gr][it] );
//				}

				pp_mesh[gr] = new Mesh; 
				Mesh * mesh = pp_mesh[gr];
				mesh->numVerts = 0;
				mesh->verts = NULL;
				mesh->numFaces = 0;
				mesh->faces = new MeshFace[65536];

				int * vert_used= new int[g_u_num_pos];

				for ( int vv = 0; vv < g_u_num_pos; vv++ ) vert_used[vv] = 0;

				for ( int it = 0; it < num_mesh[gr]; it++ )
				{
					p_mesh		= object->m_MeshList.m_Meshes[0][mesh_matrix[gr][it]];
					p_material	= m_scene->GetMaterial( p_mesh->m_MatChecksum );

					// An array of mesh pointers to meshes of the same material, but different LOD levels.
					NxMesh *mesh_array[8] = { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL }; 
					mesh_array[0] = p_mesh;

					// We need to figure out if there are lower LOD level meshes that correspond to this mesh (i.e. have the same material).
					unsigned int lod_level;
					for( lod_level = 1; lod_level < 8; ++lod_level )
					{
						if( object->m_MeshList.m_NumMeshes[lod_level] == 0 )
							break;

						for( int mitll = 0; mitll < object->m_MeshList.m_NumMeshes[lod_level]; ++mitll )
						{
							if( object->m_MeshList.m_Meshes[lod_level][mitll]->m_MatChecksum == p_mesh->m_MatChecksum )
							{
								// This level contains a corresponding mesh.
								mesh_array[lod_level] = object->m_MeshList.m_Meshes[lod_level][mitll];
								break;
							}
						}
						if( mesh_array[lod_level] == NULL )
						{
							break;
						}
					}

	//				printf( "\nMesh %d: %d faces", m, p_mesh->m_NumFaces );
					int fc = mesh->numFaces;
					for ( int v = 0; v < p_mesh->m_NumFaces; v++ )
					{
						int p0 = p_mesh->m_Topology[v][0]; 
						int p1 = p_mesh->m_Topology[v][1]; 
						int p2 = p_mesh->m_Topology[v][2]; 

						int r0 = get_pos( object->m_Verts[p0].m_Pos[0], object->m_Verts[p0].m_Pos[1], object->m_Verts[p0].m_Pos[2], object->m_Verts[p0].m_WeightedIndex[5] ); 
						int r1 = get_pos( object->m_Verts[p1].m_Pos[0], object->m_Verts[p1].m_Pos[1], object->m_Verts[p1].m_Pos[2], object->m_Verts[p1].m_WeightedIndex[5] ); 
						int r2 = get_pos( object->m_Verts[p2].m_Pos[0], object->m_Verts[p2].m_Pos[1], object->m_Verts[p2].m_Pos[2], object->m_Verts[p2].m_WeightedIndex[5] ); 

	//					printf( "\nPoly %4d %4d %4d   %4d %4d %4d", p0, p1, p2, r0, r1, r2 );

						if ( r0!=r1 && r1!=r2 && r2!=r0 )
						{
	//						mesh->faces[mesh->numFaces].v[0] = p0;
	//						mesh->faces[mesh->numFaces].v[1] = p1;
	//						mesh->faces[mesh->numFaces].v[2] = p2;

							mesh->faces[mesh->numFaces].v[0] = r0;
							mesh->faces[mesh->numFaces].v[1] = r1;
							mesh->faces[mesh->numFaces].v[2] = r2;
							mesh->faces[mesh->numFaces].mesh = mesh_matrix[gr][it];

							vert_used[r0] = 1;
							vert_used[r1] = 1;
							vert_used[r2] = 1;

	//						printf( "\nMade Face: %4d %4d %4d", mesh->faces[mesh->numFaces].v[0], mesh->faces[mesh->numFaces].v[1], mesh->faces[mesh->numFaces].v[2] );
							mesh->numFaces++;
						}
					}
				}

				mesh->numVerts = 0;
				mesh->verts = new MeshVertex[g_u_num_pos];
				int * mesh_remap = new int[g_u_num_pos];
				for ( int vi = 0; vi < g_u_num_pos; vi++ )
				{
					if ( !vert_used[vi] ) continue;

					mesh->verts[mesh->numVerts].x = g_u_pos[vi][0];
					mesh->verts[mesh->numVerts].y = g_u_pos[vi][1];
					mesh->verts[mesh->numVerts].z = g_u_pos[vi][2];
	
					int index = -1;
					int num_bones = 0;
					for ( int ovi = 0; ovi < object->m_NumVerts; ovi++ )
					{
						if ( get_pos( object->m_Verts[ovi].m_Pos[0], object->m_Verts[ovi].m_Pos[1], object->m_Verts[ovi].m_Pos[2], object->m_Verts[ovi].m_WeightedIndex[5] ) == vi )
						{
							index = ovi;
							if ( object->m_Verts[ovi].m_Weight[0] > 0.01f ) num_bones++;
							if ( object->m_Verts[ovi].m_Weight[1] > 0.01f ) num_bones++;
							if ( object->m_Verts[ovi].m_Weight[2] > 0.01f ) num_bones++;
							break;
						}
					}
					if ( index == -1 ) printf( "\nVertex %4d, index %4d", vi, index );
	
					mesh->verts[mesh->numVerts].idx = index;
					mesh->verts[mesh->numVerts].num_bones = num_bones;
					mesh_remap[vi] = mesh->numVerts;
					mesh->numVerts++;
				}

				// Now, remap the faces we already added.
				for ( int f = 0; f < mesh->numFaces; f++ )
				{
					mesh->faces[f].v[0] = mesh_remap[mesh->faces[f].v[0]];
					mesh->faces[f].v[1] = mesh_remap[mesh->faces[f].v[1]];
					mesh->faces[f].v[2] = mesh_remap[mesh->faces[f].v[2]];
				}
			}









//			// Build mesh structure & copy verts.
//
////			mesh->numVerts = object->m_NumVerts;
////			mesh->verts = new MeshVertex[object->m_NumVerts];
////			for ( int vi = 0; vi < object->m_NumVerts; vi++ )
////			{
////				mesh->verts[vi].x = object->m_Verts[vi].m_Pos[0];
////				mesh->verts[vi].y = object->m_Verts[vi].m_Pos[1];
////				mesh->verts[vi].z = object->m_Verts[vi].m_Pos[2];
////				mesh->verts[vi].idx = vi;
////			}
//
//			mesh->numVerts = g_u_num_pos;
//			mesh->verts = new MeshVertex[mesh->numVerts];
//			for ( int vi = 0; vi < mesh->numVerts; vi++ )
//			{
//				mesh->verts[vi].x = g_u_pos[vi][0];
//				mesh->verts[vi].y = g_u_pos[vi][1];
//				mesh->verts[vi].z = g_u_pos[vi][2];
//
//				int index = -1;
//				for ( int ovi = 0; ovi < object->m_NumVerts; ovi++ )
//				{
//					if ( get_pos( object->m_Verts[ovi].m_Pos[0], object->m_Verts[ovi].m_Pos[1], object->m_Verts[ovi].m_Pos[2] ) == vi )
//					{
//						index = ovi;
//						break;
//					}
//				}
//				if ( index == -1 ) printf( "\nVertex %4d, index %4d", vi, index );
//
//				mesh->verts[vi].idx = index;
//			}
//
//			mesh->numFaces = 0;
//			mesh->faces = new MeshFace[65536];
//
//
//
//			num_meshes	= object->m_MeshList.m_NumMeshes[0];
//			num_verts	= object->m_NumVerts;
//	
//
//
//
//
//			for( int m = 0; m < num_meshes; ++m )
//			{
//				p_mesh		= object->m_MeshList.m_Meshes[0][m];
//				p_material	= m_scene->GetMaterial( p_mesh->m_MatChecksum );
//	
//				// An array of mesh pointers to meshes of the same material, but different LOD levels.
//				NxMesh *mesh_array[8] = { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL }; 
//				mesh_array[0] = p_mesh;
//				
//				// We need to figure out if there are lower LOD level meshes that correspond to this mesh (i.e. have the same material).
//				unsigned int lod_level;
//				for( lod_level = 1; lod_level < 8; ++lod_level )
//				{
//					if( object->m_MeshList.m_NumMeshes[lod_level] == 0 )
//						break;
//	
//					for( int mitll = 0; mitll < object->m_MeshList.m_NumMeshes[lod_level]; ++mitll )
//					{
//						if( object->m_MeshList.m_Meshes[lod_level][mitll]->m_MatChecksum == p_mesh->m_MatChecksum )
//						{
//							// This level contains a corresponding mesh.
//							mesh_array[lod_level] = object->m_MeshList.m_Meshes[lod_level][mitll];
//							break;
//						}
//					}
//					if( mesh_array[lod_level] == NULL )
//					{
//						break;
//					}
//				}
//	
////				printf( "\nMesh %d: %d faces", m, p_mesh->m_NumFaces );
//				int fc = mesh->numFaces;
//				for ( int v = 0; v < p_mesh->m_NumFaces; v++ )
//				{
//					int p0 = p_mesh->m_Topology[v][0]; 
//					int p1 = p_mesh->m_Topology[v][1]; 
//					int p2 = p_mesh->m_Topology[v][2]; 
//
//					int r0 = get_pos( object->m_Verts[p0].m_Pos[0], object->m_Verts[p0].m_Pos[1], object->m_Verts[p0].m_Pos[2] ); 
//					int r1 = get_pos( object->m_Verts[p1].m_Pos[0], object->m_Verts[p1].m_Pos[1], object->m_Verts[p1].m_Pos[2] ); 
//					int r2 = get_pos( object->m_Verts[p2].m_Pos[0], object->m_Verts[p2].m_Pos[1], object->m_Verts[p2].m_Pos[2] ); 
//
////					printf( "\nPoly %4d %4d %4d   %4d %4d %4d", p0, p1, p2, r0, r1, r2 );
//
//					if ( r0!=r1 && r1!=r2 && r2!=r0 )
//					{
////						mesh->faces[mesh->numFaces].v[0] = p0;
////						mesh->faces[mesh->numFaces].v[1] = p1;
////						mesh->faces[mesh->numFaces].v[2] = p2;
//
//						mesh->faces[mesh->numFaces].v[0] = r0;
//						mesh->faces[mesh->numFaces].v[1] = r1;
//						mesh->faces[mesh->numFaces].v[2] = r2;
//						mesh->faces[mesh->numFaces].mesh = m;
//
////						printf( "\nMade Face: %4d %4d %4d", mesh->faces[mesh->numFaces].v[0], mesh->faces[mesh->numFaces].v[1], mesh->faces[mesh->numFaces].v[2] );
//						mesh->numFaces++;
//					}
//				}
////				printf( " (%d)", mesh->numFaces - fc );
//
////				// Go through each mesh adding new vertices.
////				int v = 0;
////				while ( p_mesh->m_VertStrip[v].m_Index )
////				{
////					unsigned short num = p_mesh->m_VertStrip[v].m_Index;
////					v++;
////	
////					int p0;
////	
////					int p1 = p_mesh->m_VertStrip[v+0].m_Index;
////					int p2 = p_mesh->m_VertStrip[v+1].m_Index;
////	
////					for ( int vv = 2; vv < num; vv++ )
////					{
////						p0 = p1;
////						p1 = p2;
////						p2 = p_mesh->m_VertStrip[v+vv].m_Index; 
////	
////						if ( p0!=p1 && p1!=p2 && p2!=p0 )
////						{
////							mesh->faces[mesh->numFaces].v[0] = get_pos( object->m_Verts[p0].m_Pos[0], object->m_Verts[p0].m_Pos[1], object->m_Verts[p0].m_Pos[2] ); 
////							mesh->faces[mesh->numFaces].v[1] = get_pos( object->m_Verts[p1].m_Pos[0], object->m_Verts[p1].m_Pos[1], object->m_Verts[p1].m_Pos[2] ); 
////							mesh->faces[mesh->numFaces].v[2] = get_pos( object->m_Verts[p2].m_Pos[0], object->m_Verts[p2].m_Pos[1], object->m_Verts[p2].m_Pos[2] ); 
////							mesh->numFaces++;
//////						mesh->faces[mesh->numFaces].v[0] = get_pos( object->m_Verts[p0].m_Pos[0], object->m_Verts[p0].m_Pos[1], object->m_Verts[p0].m_Pos[2] );
//////						mesh->faces[mesh->numFaces].v[1] = get_pos( object->m_Verts[p1].m_Pos[0], object->m_Verts[p1].m_Pos[1], object->m_Verts[p1].m_Pos[2] );
//////						mesh->faces[mesh->numFaces].v[2] = get_pos( object->m_Verts[p2].m_Pos[0], object->m_Verts[p2].m_Pos[1], object->m_Verts[p2].m_Pos[2] );
////						}
////					}
////					v += num;
////				}
//
////				// Go through each mesh adding new vertices.
////				int v = 0;
////				while ( p_mesh->m_VertStrip[v].m_Index )
////				{
////					unsigned short num = p_mesh->m_VertStrip[v].m_Index;
////					v++;
////
////					NxVertex* vert;
////					int p0;
////
////					vert = object->m_Verts + p_mesh->m_VertStrip[v+0].m_Index;
////					int p1 = get_pos( vert->m_Pos[0], vert->m_Pos[1], vert->m_Pos[2] );
////					vert = object->m_Verts + p_mesh->m_VertStrip[v+1].m_Index;
////					int p2 = get_pos( vert->m_Pos[0], vert->m_Pos[1], vert->m_Pos[2] );
////
////					for ( int vv = 2; vv < num; vv++ )
////					{
////						unsigned short idx = p_mesh->m_VertStrip[v+vv].m_Index;
////
////						vert = object->m_Verts + idx;
////
////						p0 = p1;
////						p1 = p2;
////						p2 = get_pos( vert->m_Pos[0], vert->m_Pos[1], vert->m_Pos[2] );
////
////						if ( p0!=p1 && p1!=p2 && p2!=p0 )
////						{
////							mesh->faces[mesh->numFaces].v[0] = p0;
////							mesh->faces[mesh->numFaces].v[1] = p1;
////							mesh->faces[mesh->numFaces].v[2] = p2;
////							mesh->numFaces++;
////						}
////					}
////					v += num;
////				}
//			}
		}
	}

	Mesh * mesh = new Mesh;
	mesh->numFaces = 0;
	mesh->numVerts = 0;
	mesh->faces = NULL;
	mesh->verts = NULL;

//	if( mesh->numFaces )
	if( total_mesh_groups )
	{
//		for ( int vi = 0; vi < mesh->numVerts; vi++ )
//		{
//			bool found = false;
//			for ( int fi = 0; fi < mesh->numFaces; fi++ )
//			{
//				if ( ( mesh->faces[fi].v[0] == vi ) || ( mesh->faces[fi].v[1] == vi ) || ( mesh->faces[fi].v[2] == vi ) )
//				{
//					found = true;
//					break;
//				}
//			}
//			if ( !found ) printf( "\nExtra vert: %d", vi );
//		}

		printf( "Shadow Volumes...." );
		for ( int mm = 0; mm < total_mesh_groups; mm++ )
		{
			printf( "\nMesh Group %2d:", mm );

			Mesh * p_mesh = pp_mesh[mm];
		
			List<int> order;
			List<int> map;
			PMarg arg;

			arg.useedgelength	= true;
			arg.usecurvature	= true;
			arg.protecttexture	= false;
			arg.protectsmooth	= false;
			arg.protectvc		= false;
			arg.lockborder		= false;
			arg.lockselected	= false;

#define MIN_POLY 50
#define MAX_POLY 3000

#define MIN_REDUX 0.4f
#define MAX_REDUX 0.1f

//			printf( "\nsinf 0 %8.3f", sinf( 0.0f ) );
//			printf( "\nsinf 1 %8.3f", sinf( ( 3.141592f / 2.0f ) ) );
//			printf( "\nsinf 0 %8.3f", sinf( ( 3.141592f / 2.0f ) * 0.1f ) );
//			printf( "\nsinf 0 %8.3f", sinf( ( 3.141592f / 2.0f ) * 0.9f ) );

			// Calculate reduction factor.
			float factor;
			if ( p_mesh->numFaces > MIN_POLY )
			{
				if ( p_mesh->numFaces < MAX_POLY )
				{
					factor = MIN_REDUX - ( ( MIN_REDUX - MAX_REDUX ) * sinf( ( ( p_mesh->numFaces - (float)MIN_POLY ) / ( (float)MAX_POLY - (float)MIN_POLY ) ) * ( 3.141592f / 2.0f ) ) );
				}
				else
				{
					float factor = MAX_REDUX;
				}
			}
			else
			{
				factor = MIN_REDUX;
			}

			printf( "%8.3f (before: %4d,%4d) ", factor, p_mesh->numFaces, p_mesh->numVerts );
			ComputeProgressiveMesh( p_mesh, order, map, arg );
			DoProgressiveMesh( p_mesh, order, map, factor, 0, 0 );
			printf( "(after: %4d,%4d) ", p_mesh->numFaces, p_mesh->numVerts );

			for ( int it = 0; it < num_mesh[mm]; it++ )
			{
				printf( " %2d", mesh_matrix[mm][it] );
			}
		}

	
		// Combine back to 1 mesh.
		mesh->numFaces = 0;
		mesh->numVerts = 0;
		for ( int mm = 0; mm < total_mesh_groups; mm++ )
		{
			Mesh * p_mesh = pp_mesh[mm];

			mesh->numFaces += p_mesh->numFaces;
			mesh->numVerts += p_mesh->numVerts;
		}
		mesh->faces = new MeshFace[mesh->numFaces];
		mesh->verts = new MeshVertex[mesh->numVerts];
		int fo = 0;
		int vo = 0;
		for ( int mm = 0; mm < total_mesh_groups; mm++ )
		{
			Mesh * p_mesh = pp_mesh[mm];

			for ( int face = 0; face < p_mesh->numFaces; face++ )
			{
				mesh->faces[fo].v[0] = p_mesh->faces[face].v[0] + vo;
				mesh->faces[fo].v[1] = p_mesh->faces[face].v[1] + vo;
				mesh->faces[fo].v[2] = p_mesh->faces[face].v[2] + vo;
				mesh->faces[fo].mesh = p_mesh->faces[face].mesh;
				fo++;
			}

			for ( int vert = 0; vert < p_mesh->numVerts; vert++ )
			{
				mesh->verts[vo].x = p_mesh->verts[vert].x;
				mesh->verts[vo].y = p_mesh->verts[vert].y;
				mesh->verts[vo].z = p_mesh->verts[vert].z;
				mesh->verts[vo].idx = p_mesh->verts[vert].idx;
				mesh->verts[vo].num_bones = p_mesh->verts[vert].num_bones;
				vo++;
			}
		}
		printf( "\nFinal Faces after: %d, %d", mesh->numFaces, mesh->numVerts );

		for ( int fr = 0; fr < mesh->numFaces; fr++ )
		{
			bool remove = false;
			for ( int fd = 0; fd < mesh->numFaces; fd++ )
			{
				if ( fr == fd ) continue;
				if ( ( mesh->faces[fr].v[0] == mesh->faces[fd].v[0] ) &&
					 ( mesh->faces[fr].v[1] == mesh->faces[fd].v[1] ) &&
					 ( mesh->faces[fr].v[2] == mesh->faces[fd].v[2] ) ) remove = true;

				if ( ( mesh->faces[fr].v[0] == mesh->faces[fd].v[1] ) &&
					 ( mesh->faces[fr].v[1] == mesh->faces[fd].v[2] ) &&
					 ( mesh->faces[fr].v[2] == mesh->faces[fd].v[0] ) ) remove = true;
			
				if ( ( mesh->faces[fr].v[0] == mesh->faces[fd].v[2] ) &&
					 ( mesh->faces[fr].v[1] == mesh->faces[fd].v[0] ) &&
					 ( mesh->faces[fr].v[2] == mesh->faces[fd].v[1] ) ) remove = true;
			
				if ( ( mesh->faces[fr].v[0] == mesh->faces[fd].v[2] ) &&
					 ( mesh->faces[fr].v[1] == mesh->faces[fd].v[1] ) &&
					 ( mesh->faces[fr].v[2] == mesh->faces[fd].v[0] ) ) remove = true;
			
				if ( ( mesh->faces[fr].v[0] == mesh->faces[fd].v[1] ) &&
					 ( mesh->faces[fr].v[1] == mesh->faces[fd].v[0] ) &&
					 ( mesh->faces[fr].v[2] == mesh->faces[fd].v[2] ) ) remove = true;
			
				if ( ( mesh->faces[fr].v[0] == mesh->faces[fd].v[0] ) &&
					 ( mesh->faces[fr].v[1] == mesh->faces[fd].v[2] ) &&
					 ( mesh->faces[fr].v[2] == mesh->faces[fd].v[1] ) ) remove = true;
			}
			if ( remove )
			{
				mesh->faces[fr].mesh = mesh->faces[mesh->numFaces-1].mesh;
				mesh->faces[fr].v[0] = mesh->faces[mesh->numFaces-1].v[0];
				mesh->faces[fr].v[1] = mesh->faces[mesh->numFaces-1].v[1];
				mesh->faces[fr].v[2] = mesh->faces[mesh->numFaces-1].v[2];
				mesh->numFaces--;
				fr--;		// Force this entry to be looked at again.
			}
		}
		printf( "\nFaces after duplicate removal: %d, %d", mesh->numFaces, mesh->numVerts );


		
//			List<int> order;
//			List<int> map;
//			PMarg arg;
//
//			arg.useedgelength	= true;
//			arg.usecurvature	= true;
//			arg.protecttexture	= false;
//			arg.protectsmooth	= false;
//			arg.protectvc		= false;
//			arg.lockborder		= false;
//			arg.lockselected	= false;
//
//			printf( "\nFaces before: %d, %d %d", p_mesh->numFaces, p_mesh->numVerts, g_u_num_pos );
//			ComputeProgressiveMesh( p_mesh, order, map, arg );
//			DoProgressiveMesh( p_mesh, order, map, 0.2f, 0, 0 );
//			printf( "\nFaces after: %d, %d", p_mesh->numFaces, p_mesh->numVerts );
//		}


		struct sShadowEdge
		{
			short neighbor[3];
		};

		sShadowEdge * p_edge = new sShadowEdge[mesh->numFaces];

		for ( int s = 0; s < mesh->numFaces; s++ )
		{
			int found01 = 0;
			int found12 = 0;
			int found20 = 0;
	
			p_edge[s].neighbor[0] = -1;
			p_edge[s].neighbor[1] = -1;
			p_edge[s].neighbor[2] = -1;

			int s0 = mesh->faces[s].v[0];
			int s1 = mesh->faces[s].v[1];
			int s2 = mesh->faces[s].v[2];

			for ( int t = 0; t < mesh->numFaces; t++ )
			{
				if ( t == s ) continue;
				//if ( found01 && found12 && found20 ) break;
	
				int t0 = mesh->faces[t].v[0];
				int t1 = mesh->faces[t].v[1];
				int t2 = mesh->faces[t].v[2];

				if (
					( ( s0 == t0 ) && ( s1 == t1 ) ) ||
					( ( s0 == t1 ) && ( s1 == t2 ) ) ||
					( ( s0 == t2 ) && ( s1 == t0 ) ) ||
					( ( s0 == t0 ) && ( s1 == t2 ) ) ||
					( ( s0 == t2 ) && ( s1 == t1 ) ) ||
					( ( s0 == t1 ) && ( s1 == t0 ) )
				   )
				{
					p_edge[s].neighbor[0] = t;
					found01++;
//					continue;
				}
	
				if (
					( ( s1 == t0 ) && ( s2 == t1 ) ) ||
					( ( s1 == t1 ) && ( s2 == t2 ) ) ||
					( ( s1 == t2 ) && ( s2 == t0 ) ) ||
					( ( s1 == t0 ) && ( s2 == t2 ) ) ||
					( ( s1 == t2 ) && ( s2 == t1 ) ) ||
					( ( s1 == t1 ) && ( s2 == t0 ) )
				   )
				{
					p_edge[s].neighbor[1] = t;
					found12++;
//					continue;
				}
	
				if (
					( ( s2 == t0 ) && ( s0 == t1 ) ) ||
					( ( s2 == t1 ) && ( s0 == t2 ) ) ||
					( ( s2 == t2 ) && ( s0 == t0 ) ) ||
					( ( s2 == t0 ) && ( s0 == t2 ) ) ||
					( ( s2 == t2 ) && ( s0 == t1 ) ) ||
					( ( s2 == t1 ) && ( s0 == t0 ) )
				   )
				{
					p_edge[s].neighbor[2] = t;
					found20++;
//					continue;
				}
			}
			// If multiple connecting polys, treat as a neighborless edge.
			if ( found01 > 1 )
			{
				p_edge[s].neighbor[0] = -2;
			}
			if ( found12 > 1 )
			{
				p_edge[s].neighbor[1] = -2;
			}
			if ( found20 > 1 )
			{
				p_edge[s].neighbor[2] = -2;
			}
		}

	
//		for ( int v = 0; v < mesh->numVerts; v++ )
//		{
//			printf( "\nVert %3d: %8.3f %8.3f %8.3f %3d %3d", v, mesh->verts[v].x, mesh->verts[v].y, mesh->verts[v].z, mesh->verts[v].idx, get_pos( mesh->verts[v].x, mesh->verts[v].y, mesh->verts[v].z ) );
//			printf( " ( %8.3f %8.3f %8.3f )", ( mesh->verts[v].x + 20.0f ) * 20.0f, ( mesh->verts[v].y + 20.0f ) * 20.0f, ( mesh->verts[v].z + 20.0f ) * 20.0f );
//		}
	
//		for ( int f = 0; f < mesh->numFaces; f++ )
//		{
//			printf( "\nFace %3d: %3d %3d %3d ( %3d %3d %3d ) %2d", f, mesh->faces[f].v[0], mesh->faces[f].v[1], mesh->faces[f].v[2], p_edge[f].neighbor[0], p_edge[f].neighbor[1], p_edge[f].neighbor[2], mesh->faces[f].mesh );
//		}
	}


	// Stage 2: Output global data.

	// unsigned int num visible objects
	// unsigned int num positions
	// unsigned int numcolors
	// unsigned int num uvs
	// unsigned int dummy
	// unsigned int dummy
	// unsigned int dummy
	// unsigned int dummy

	// Work out if this is skinned or not & set num pos correctly.
	int num_pos = 0;
	for( int o = 0; o < num_objects; o++ )
	{
		NxObject*	object		= m_scene->m_Objects + o;
	
		if ( !(object->m_Flags & NxObject::mSKINNED) )
		{
			num_pos = g_u_num_pos;
		}
	}

	// Calculate number of bytes used on vertex pools.
	int pool_bytes = 0;
	int rounded_pool_bytes;

	int material_bytes = CalculateMaterialBytes2();

	int total_cols = g_u_num_col + g_wibble_cols;		// g_wibble_cols is calculated in CalculateMaterialBytes2.

	pool_bytes += material_bytes;

	pool_bytes += sizeof( float ) * 3 * num_pos;
	pool_bytes += sizeof( s16 ) * 3 * g_u_num_nrm;
	pool_bytes += sizeof( unsigned int ) * total_cols;
	pool_bytes += sizeof( s16 ) * 2 * g_u_num_uv;
	pool_bytes += sizeof( uint16 ) * 3 * mesh->numFaces * 2; 
	rounded_pool_bytes = ( pool_bytes + 31 ) & ~31;

	uint16 num_obj = (uint16)num_visible_objects;
	uint32 pos = (uint32)num_pos;
	uint16 nrm = (uint16)g_u_num_nrm;
	uint16 col = (uint16)total_cols;
	uint16 uv = (uint16)g_u_num_uv;
	pGDFile->Write( (const char *)&pos,					4, true );
	pGDFile->Write( (const char *)&zero,				2, true );
	pGDFile->Write( (const char *)&nrm,					2, true );
	pGDFile->Write( (const char *)&col,					2, true );
	pGDFile->Write( (const char *)&uv,					2, true );
	pGDFile->Write( (const char *)&rounded_pool_bytes,	4, true );
	pGDFile->Write( (const char *)&num_obj,				2, true );
	pGDFile->Write( (const char *)&num_materials,		2, true );
	pGDFile->Write( (const char *)&mesh->numFaces,		4, true );
	// Last 8 bytes written out in SaveMaterials2 now.
	

	SaveMaterials2( pGDFile, skinned );

//	printf( "\n%x %x %x %x", num_objects, g_u_num_pos, g_u_num_col, g_u_num_uv );

	int fpos = pGDFile->TellPos();
	// Positions.
//	printf( "\nPos: %d", g_u_num_pos );
	for ( i = 0; i < num_pos; i++ )
	{
		pGDFile->Write( (const char *)&g_u_pos[i][0], 4, true );
		pGDFile->Write( (const char *)&g_u_pos[i][1], 4, true );
		pGDFile->Write( (const char *)&g_u_pos[i][2], 4, true );
	}

	// Save dummy values for wibble data.
	for ( i = 0; i < g_wibble_cols; i++ )
	{
		pGDFile->Write( (const char *)&zero, 4, true );
	}

	// Colors.
	for ( i = 0; i < g_u_num_col; i++ )
	{
		pGDFile->Write( (const char *)&g_u_col[i], 4, true );
	}

	// UVs.
	for ( i = 0; i < g_u_num_uv; i++ )
	{
//		pGDFile->Write( (const char *)&g_u_uv[i][0], 4, true );
//		pGDFile->Write( (const char *)&g_u_uv[i][1], 4, true );
		pGDFile->Write( (const char *)&g_u_uv[i][0], 2, true );
		pGDFile->Write( (const char *)&g_u_uv[i][1], 2, true );
	}

	// Normals. Last now because they could end unaligned.
//	printf( "\nNrm: %d", g_u_num_nrm );
	for ( i = 0; i < g_u_num_nrm; i++ )
	{
//		pGDFile->Write( (const char *)&g_u_nrm[i][0], 4, true );
//		pGDFile->Write( (const char *)&g_u_nrm[i][1], 4, true );
//		pGDFile->Write( (const char *)&g_u_nrm[i][2], 4, true );
		short nx = (short)(g_u_nrm[i][0] * (float)NORM_MUL);
		short ny = (short)(g_u_nrm[i][1] * (float)NORM_MUL);
		short nz = (short)(g_u_nrm[i][2] * (float)NORM_MUL);
		pGDFile->Write( (const char *)&nx, 2, true );
		pGDFile->Write( (const char *)&ny, 2, true );
		pGDFile->Write( (const char *)&nz, 2, true );
	}








//	fpos = pGDFile->TellPos() - fpos;
//	printf( "\nPool: %d (%d)", fpos, rounded_pool_bytes - material_bytes );

//	// Stage 4: Sort meshes based on opaque/pretrans/dyntrans/posttrans.
//	int * p_object_remap = new int[num_objects];
//	int num_remapped = 0;
//
//	int * added = new int[num_objects];
//	for( i = 0; i < num_objects; i++ ) added[i] = 0;
//
//	// First, stick in all opaque objects.
//	for( i = 0; i < num_objects; i++ )
//	{
////		if ( added[i] ) continue;
//
//		NxObject*	object		= m_scene->m_Objects + i;
//
//		num_meshes	= object->m_MeshList.m_NumMeshes[0];
//
//		// See if all meshes in this object are opaque.
//		bool opaque = true;
//		for( int m = 0; m < num_meshes; ++m )
//		{
//			p_mesh		= object->m_MeshList.m_Meshes[0][m];
//			p_material	= m_scene->GetMaterial( p_mesh->m_MatChecksum );
//
//			__int64 equation = GetBlendParameters( p_material->m_Passes[0].m_BlendMode, p_material->m_Passes[0].m_FixedAlpha );
//			int mode = (int)equation;
//			if ( mode != vBLEND_MODE_DIFFUSE )
//			{
//				opaque = false;
//				break;
//			}
//		}
//
//		// If everything's opaque, add it.
//		if ( opaque )
//		{
//			added[i] = 1;
//			p_object_remap[num_remapped] = i;
//			num_remapped++;
//		}
//	}
//
//	// Now, stick in everyting else.
//	for( i = 0; i < num_objects; i++ )
//	{
//		if ( added[i] ) continue;
//
////		// See if all meshes in this object are opaque.
////		bool opaque = true;
////		for( int m = 0; m < num_meshes; ++m )
////		{
////			p_mesh		= object->m_MeshList.m_Meshes[0][m];
////			p_material	= m_scene->GetMaterial( p_mesh->m_MatChecksum );
////
////			__int64 equation = GetBlendParameters( p_material->m_Passes[p].m_BlendMode, p_material->m_Passes[0].m_FixedAlpha );
////			int mode = (int)equation;
////			if ( mode != vBLEND_MODE_DIFFUSE )
////			{
////				opaque = false;
////				break;
////			}
////		}
////
////		// If everything's opaque, add it.
////		if ( opaque && !added[i] )
//		{
//			added[i] = 1;
//			p_object_remap[num_remapped] = i;
//			num_remapped++;
//		}
//	}

	// Stage 5: Output object mesh data.

	int g_p_indices8 = 0;
	int g_p_indices16 = 0;
	int g_c_indices8 = 0;
	int g_c_indices16 = 0;
	int g_t_indices8 = 0;
	int g_t_indices16 = 0;

	ob_mesh = 0;

	bool first = true;
	for( int i = 0; i < num_objects; i++ )
	{
//		printf( "\nAAA %d", i );
//		i = p_object_remap[obj];

		NxObject*	object		= m_scene->m_Objects + i;
		NxVertex*	vert_list	= object->m_Verts;
		NxFace*		face_list	= object->m_Faces;
		
		// Skip invisible objects.
		if( object->m_Flags & NxObject::mINVISIBLE )
		{
			continue;
		}
		
		// Check this checksum doesn't already clash.
		for( int check = 0; check < i; ++check )
		{
			NxObject* test_object = m_scene->m_Objects + check;
			if( test_object->m_Checksum == object->m_Checksum )
			{
				// Just set the object checksum to be something random for now...
				object->m_Checksum = rand();
			}
		}
		
		num_meshes	= object->m_MeshList.m_NumMeshes[0];
		num_verts	= object->m_NumVerts;

		// Build the default Remap table (will be overwritten if skinned).
		pRemapIndex = new short[num_verts];
		pRemapVertex = new short[num_verts];
		for( int vv = 0; vv < num_verts; ++vv )
		{
			pRemapIndex[vv] = vv;
			pRemapVertex[vv] = vv;
		}
	
		// This is a fucker. I need to sort the vertices by bone pairs.
#define W_EPSILON 0.00001f
		void *			pSingleHead = NULL;
		void *			pDoubleHead = NULL;
		void *			pAddHead = NULL;
	
		if( object->m_Flags & NxObject::mSKINNED )
		{
			// Quick patch - find all duplicate weight 0 & 1s. Combine them & shunt up the other weights.
			for( int vv = 0; vv < num_verts; ++vv )
			{
				NxVertex* vert = object->m_Verts + vv;
	
				if ( vert->m_WeightedIndex[0] == vert->m_WeightedIndex[1] )
				{
					vert->m_Weight[0] = vert->m_Weight[0] + vert->m_Weight[1];
					vert->m_WeightedIndex[1] = vert->m_WeightedIndex[2];
					vert->m_WeightedIndex[2] = vert->m_WeightedIndex[3];
					vert->m_WeightedIndex[3] = vert->m_WeightedIndex[4];
					vert->m_WeightedIndex[4] = vert->m_WeightedIndex[5];
					vert->m_WeightedIndex[5] = 0;
					vert->m_Weight[1] = vert->m_Weight[2];
					vert->m_Weight[2] = vert->m_Weight[3];
					vert->m_Weight[3] = vert->m_Weight[4];
					vert->m_Weight[4] = vert->m_Weight[5];
					vert->m_Weight[5] = 0.0f;
					//vert->m_NumWeights--;
				}
				// Sort the weights, then use only the first 3.
				vert->SortVertexWeights();
				vert->NormalizeVertexWeights( 3 );
			}
			// First thing, we need to know the number of bones.
			int max_bone = 0;
			int count1 = 0;
			int count2 = 0;
			int count3 = 0;
			printf( "\nNum Verts: %d", num_verts );
			for( int v = 0; v < num_verts; ++v )
			{
				NxVertex* vert = object->m_Verts + v;
				if ( vert->m_WeightedIndex[0] > max_bone ) max_bone = vert->m_WeightedIndex[0];
				if ( vert->m_WeightedIndex[1] > max_bone ) max_bone = vert->m_WeightedIndex[1];
				if ( vert->m_WeightedIndex[2] > max_bone ) max_bone = vert->m_WeightedIndex[2];
//				if ( vert->m_WeightedIndex[3] > max_bone ) max_bone = vert->m_WeightedIndex[3];
				//printf( "Weights %2d: %3d %8.3f %2d %8.3f %2d %8.3f\n", v, vert->m_WeightedIndex[0], vert->m_Weight[0], vert->m_WeightedIndex[1], vert->m_Weight[1], vert->m_WeightedIndex[2], vert->m_Weight[2] );

				if ( vert->m_Weight[2] <= W_EPSILON )
				{
					if ( vert->m_Weight[1] <= W_EPSILON )
					{
						vert->m_NumWeights = 1;
						count1++;
					}
					else
					{
						vert->m_NumWeights = 2;
						count2++;
					}
				}
				else
				{
					vert->m_NumWeights = 3;
					count3++;
				}
			}
			max_bone++;
			printf( "\nMax bone: %d Counts; %d %d %d\n", max_bone, count1, count2, count3 );
	
			// Find & remove duplicates.

			pShadowRemap = new int[num_verts];
			for( int v0 = 0; v0 < num_verts; ++v0 )
			{
				NxVertex* vert0 = object->m_Verts + v0;

				float x = vert0->m_Pos[0];
				float y = vert0->m_Pos[1];
				float z = vert0->m_Pos[2];
				float nx = vert0->m_Normal[0];
				float ny = vert0->m_Normal[1];
				float nz = vert0->m_Normal[2];
				float w0 = ( vert0->m_NumWeights >= 1 ) ? vert0->m_Weight[0] : 0.0f;
				float w1 = ( vert0->m_NumWeights >= 2 ) ? vert0->m_Weight[1] : 0.0f;
				float w2 = ( vert0->m_NumWeights >= 3 ) ? vert0->m_Weight[2] : 0.0f;
				int i0 = ( vert0->m_NumWeights >= 1 ) ? vert0->m_WeightedIndex[0] : 0; 
				int i1 = ( vert0->m_NumWeights >= 2 ) ? vert0->m_WeightedIndex[1] : 0; 
				int i2 = ( vert0->m_NumWeights >= 3 ) ? vert0->m_WeightedIndex[2] : 0; 

				int idx;
				idx = get_skin_pos( x, y, z, nx, ny, nz, w0, w1, w2, i0, i1, i2 );
				if ( idx == -1 )
				{
					idx = g_u_num_skin_pos;
					add_skin_pos( x, y, z, nx, ny, nz, w0, w1, w2, i0, i1, i2, vert0 );
				}
				pShadowRemap[v0] = idx;
			}
			int num_dupes = g_u_num_skin_pos;
			printf( "\nNum Verts: %d", num_verts );
			printf( "\nNum Dupes: %d", num_dupes );

			// Build the double & single add weight arrays.
	
			// First the doubles...
			for ( int b0 = 0; b0 <= max_bone; b0++ )
			{
				for ( int b1 = 0; b1 <= max_bone; b1++ )
				{
					// Take care of the duplicate cases.
					if ( b0 > b1 ) continue;
	
					// Count how many matches we have.
					int numMatches = 0;
//					for( int v = 0; v < num_verts; ++v )
//					{
//						NxVertex* vert = object->m_Verts + v;
//	
//						if (	( ( vert->m_WeightedIndex[0] == b0 ) && ( vert->m_WeightedIndex[1] == b1 ) ) ||
//								( ( vert->m_WeightedIndex[0] == b1 ) && ( vert->m_WeightedIndex[1] == b0 ) ) )
//	//							( ( vert->m_WeightedIndex[0] == b0 ) && ( vert->m_Weight[1] <= W_EPSILON ) ) )
//						{
//							numMatches++;
//						}
//					}
	
					for( int v = 0; v < g_u_num_skin_pos; ++v )
					{
//						NxVertex* vert = object->m_Verts + v;
	
						if (	( ( g_u_skin_pos[v].i0 == b0 ) && ( g_u_skin_pos[v].i1 == b1 ) ) ||
								( ( g_u_skin_pos[v].i0 == b1 ) && ( g_u_skin_pos[v].i1 == b0 ) ) )
	//							( ( g_u_skin_pos[v].i0 == b0 ) && ( vert->m_Weight[1] <= W_EPSILON ) ) )
						{
							numMatches++;
						}
					}
	
					// If we have matches, build a double array & link it in.
					if ( numMatches )
					{
						skinDouble *	pCurrentDouble;
						pCurrentDouble = new skinDouble;
						pCurrentDouble->pNext = pDoubleHead;
						pDoubleHead = (void *)pCurrentDouble;
						pCurrentDouble->count = numMatches;
						pCurrentDouble->matrix0 = b0;
						pCurrentDouble->matrix1 = b1;
						pCurrentDouble->pad0 = 0;
						pCurrentDouble->pad1 = 0;
						pCurrentDouble->pPosNormal = new float[6 * numMatches];
						pCurrentDouble->pWeight = new float[2 * numMatches];
						pCurrentDouble->pIndex = new short[numMatches];
						pCurrentDouble->ppVertex = new NxVertex*[numMatches];
	
						int index = 0;
						for( int v = 0; v < g_u_num_skin_pos; ++v )
						{
//							NxVertex* vert = object->m_Verts + v;
	
							if (	( ( g_u_skin_pos[v].i0 == b0 ) && ( g_u_skin_pos[v].i1 == b1 ) ) ||
									( ( g_u_skin_pos[v].i0 == b1 ) && ( g_u_skin_pos[v].i1 == b0 ) ) )
	//								( ( g_u_skin_pos[v].i0 == b0 ) && ( vert->m_Weight[1] <= W_EPSILON ) ) )
							{
								pCurrentDouble->pPosNormal[(index * 6) + 0] = g_u_skin_pos[v].x;
								pCurrentDouble->pPosNormal[(index * 6) + 1] = g_u_skin_pos[v].y;
								pCurrentDouble->pPosNormal[(index * 6) + 2] = g_u_skin_pos[v].z;
								pCurrentDouble->pPosNormal[(index * 6) + 3] = g_u_skin_pos[v].nx;
								pCurrentDouble->pPosNormal[(index * 6) + 4] = g_u_skin_pos[v].ny;
								pCurrentDouble->pPosNormal[(index * 6) + 5] = g_u_skin_pos[v].nz;
	
								//printf( "\nWeight %3d: %2d:%2d - %f:%f", v, vert->m_WeightedIndex[0], vert->m_WeightedIndex[1], vert->m_Weight[0], vert->m_Weight[1] );
								if ( ( g_u_skin_pos[v].i0 == b1 ) && ( g_u_skin_pos[v].i1 == b0 ) )
								{
									pCurrentDouble->pWeight[(index * 2) + 0] = g_u_skin_pos[v].w1;
									pCurrentDouble->pWeight[(index * 2) + 1] = g_u_skin_pos[v].w0;
									//printf( "\nWeighta %3d: %2d:%2d - %f:%f", v, b0, b1, vert->m_Weight[1], vert->m_Weight[0] );
								} else {
									pCurrentDouble->pWeight[(index * 2) + 0] = g_u_skin_pos[v].w0;
									pCurrentDouble->pWeight[(index * 2) + 1] = g_u_skin_pos[v].w1;
									//printf( "\nWeightb %3d: %2d:%2d - %f:%f", v, b0, b1, vert->m_Weight[0], vert->m_Weight[1] );
								}
								g_u_skin_pos[v].i0 |= 0x4000;
								g_u_skin_pos[v].i1 |= 0x4000;
								pCurrentDouble->pIndex[index] = v;
								pCurrentDouble->ppVertex[index] = g_u_skin_pos[v].p_v;
								index++;
							}
						}
						if ( index != numMatches ) printf ( "\nMismatch: %d should be  %d", index, numMatches );
					}
				}
			}
	
//			{
//				for( int v = 0; v < g_u_num_skin_pos; ++v )
//				{
////					NxVertex* vert = object->m_Verts + v;
//	
//					if ( g_u_skin_pos[v].i0 != 0x7fff )
//					{
//						printf( "\nDuplicate index: Vertex %04d: %02d, %02d, %02d, %02d (%f, %f, %f, %f)", v, vert->m_WeightedIndex[0], vert->m_WeightedIndex[1], vert->m_WeightedIndex[2], vert->m_WeightedIndex[3], vert->m_Weight[0], vert->m_Weight[1], vert->m_Weight[2], vert->m_Weight[3] );
//					}
//				}
//			}

			// Turn doubles with only 1 weight into singles.
			for ( int bone = 0; bone <= max_bone; bone++ )
			{
				// Count how many matches we have.
				skinDouble *	pD = (skinDouble *)pDoubleHead;
				int numMatches = 0;
				while ( pD )
				{
					for ( int lp = 0; lp < pD->count; lp++ )
					{
						if ( ( ( pD->pWeight[(2*lp)+0] < W_EPSILON ) && ( pD->matrix1 == bone ) ) || ( ( pD->pWeight[(2*lp)+1] < W_EPSILON ) && ( pD->matrix0 == bone ) ) )
						{
							numMatches++;
						}
					}
					pD = (skinDouble *)pD->pNext;
				}

				if ( numMatches )
				{
					// Build an array of single matches & remove them from the double list.
					skinSingle *	pCurrentSingle;
					pCurrentSingle = new skinSingle;
					pCurrentSingle->pNext = pSingleHead;
					pSingleHead = (void *)pCurrentSingle;
					pCurrentSingle->count = numMatches;
					pCurrentSingle->matrix = bone;
					pCurrentSingle->pPosNormal = new float[6 * numMatches];
					pCurrentSingle->pIndex = new short[numMatches];
					pCurrentSingle->ppVertex = new NxVertex*[numMatches];

					pD = (skinDouble *)pDoubleHead;
					int index = 0;
					while ( pD )
					{
						// Add verts to single list.
						for ( int lp = 0; lp < pD->count; lp++ )
						{
							if ( ( ( pD->pWeight[(2*lp)+0] < W_EPSILON ) && ( pD->matrix1 == bone ) ) || ( ( pD->pWeight[(2*lp)+1] < W_EPSILON ) && ( pD->matrix0 == bone ) ) )
							{
								pCurrentSingle->pPosNormal[(index * 6) + 0] = pD->pPosNormal[(lp * 6) + 0];
								pCurrentSingle->pPosNormal[(index * 6) + 1] = pD->pPosNormal[(lp * 6) + 1];
								pCurrentSingle->pPosNormal[(index * 6) + 2] = pD->pPosNormal[(lp * 6) + 2];
								pCurrentSingle->pPosNormal[(index * 6) + 3] = pD->pPosNormal[(lp * 6) + 3];
								pCurrentSingle->pPosNormal[(index * 6) + 4] = pD->pPosNormal[(lp * 6) + 4];
								pCurrentSingle->pPosNormal[(index * 6) + 5] = pD->pPosNormal[(lp * 6) + 5];

								pCurrentSingle->pIndex[index] = pD->pIndex[lp];
								pCurrentSingle->ppVertex[index] = pD->ppVertex[lp];
								index++;

								// Remove from double list.
//								if ( pD->count == 1 )
//								{
//									// We removed all verts - need to completely remove this entry.
//									if ( pDoubleHead == pD )
//									{
//										// Easy, just link over.
//										pDoubleHead = (skinDouble *)pD->pNext;
//									}
//									else
//									{
//										// Scan for this entry & link over.
//										skinDouble * pDD = (skinDouble *)pDoubleHead;
//										while ( pDD )
//										{
//											if ( pDD->pNext == pD )
//											{
//												pDD->pNext = pD->pNext;
//												break;
//											}
//											pDD = (skinDouble *)pDD->pNext;
//										}
//									}
//									delete pD->pPosNormal;
//									delete pD->pWeight;
//									delete pD->pIndex;
//									break;		// No need to carry on searching.
//								}
//								else
//								{
									pD->count--;
									if ( lp != pD->count )
									{
										// Not the last entry, so copy last entry to this one.
										pD->pPosNormal[(lp * 6) + 0] = pD->pPosNormal[(pD->count * 6) + 0];
										pD->pPosNormal[(lp * 6) + 1] = pD->pPosNormal[(pD->count * 6) + 1];
										pD->pPosNormal[(lp * 6) + 2] = pD->pPosNormal[(pD->count * 6) + 2];
										pD->pPosNormal[(lp * 6) + 3] = pD->pPosNormal[(pD->count * 6) + 3];
										pD->pPosNormal[(lp * 6) + 4] = pD->pPosNormal[(pD->count * 6) + 4];
										pD->pPosNormal[(lp * 6) + 5] = pD->pPosNormal[(pD->count * 6) + 5];
										pD->pWeight[(lp * 2) + 0] = pD->pWeight[(pD->count * 2) + 0];
										pD->pWeight[(lp * 2) + 1] = pD->pWeight[(pD->count * 2) + 1];
										pD->pIndex[lp] = pD->pIndex[pD->count];
										pD->ppVertex[lp] = pD->ppVertex[pD->count];
										lp--;
									}
//								}
							}
						}
						pD = (skinDouble *)pD->pNext;
					}
				}
			}

			// Now that we've built the singles & doubles, we have enough information to remap the vertices.
			int				vertex = 0;
			skinSingle *	pS = (skinSingle *)pSingleHead;
			while ( pS )
			{
				//printf( "\nNew group" );
				for ( int lp = 0; lp < pS->count; lp++ ) {
					// Get the index.

					short index = pS->pIndex[lp];
					// See if any verts match this index.
//					for( int v0 = 0; v0 < num_verts; ++v0 )
//					{
//						NxVertex* vert0 = object->m_Verts + v0;
//
//						float x = vert0->m_Pos[0];
//						float y = vert0->m_Pos[1];
//						float z = vert0->m_Pos[2];
//						float nx = vert0->m_Normal[0];
//						float ny = vert0->m_Normal[1];
//						float nz = vert0->m_Normal[2];
//						float w0 = ( vert0->m_NumWeights >= 1 ) ? vert0->m_Weight[0] : 0.0f;
//						float w1 = ( vert0->m_NumWeights >= 2 ) ? vert0->m_Weight[1] : 0.0f;
//						float w2 = ( vert0->m_NumWeights >= 3 ) ? vert0->m_Weight[2] : 0.0f;
//						int i0 = ( vert0->m_NumWeights >= 1 ) ? vert0->m_WeightedIndex[0] : 0; 
//						int i1 = ( vert0->m_NumWeights >= 2 ) ? vert0->m_WeightedIndex[1] : 0; 
//						int i2 = ( vert0->m_NumWeights >= 3 ) ? vert0->m_WeightedIndex[2] : 0; 
//
//						int remapped_idx = get_skin_pos( x, y, z, nx, ny, nz, w0, w1, w2, i0, i1, i2 );
//						if ( remapped_idx == index )
//						{
//							index = remapped_idx;
							// Set up the remap index.
							//printf( "\nRemap: %d -> %d", index, vertex );
							//printf( "\nRemapS %d %d", index, vertex );
							pRemapIndex[index] = vertex;
							pRemapVertex[vertex] = index;
							pS->pIndex[lp] = vertex;
							// Next vert.
							vertex++;
//						}
//					}
				}
				// Next array.
				pS = (skinSingle *)pS->pNext;
			}

			skinDouble *	pD = (skinDouble *)pDoubleHead;
			while ( pD )
			{
				//printf( "\nNew group" );
				for ( int lp = 0; lp < pD->count; lp++ ) {
					// Get the index.
					short index = pD->pIndex[lp];
					// See if any verts match this index.
//					for( int v0 = 0; v0 < num_verts; ++v0 )
//					{
//						NxVertex* vert0 = object->m_Verts + v0;
//
//						float w0 = ( vert0->m_NumWeights >= 1 ) ? vert0->m_Weight[0] : 0.0f;
//						float w1 = ( vert0->m_NumWeights >= 2 ) ? vert0->m_Weight[1] : 0.0f;
//						float w2 = ( vert0->m_NumWeights >= 3 ) ? vert0->m_Weight[2] : 0.0f;
//						int i0 = ( vert0->m_NumWeights >= 1 ) ? vert0->m_WeightedIndex[0] : 0; 
//						int i1 = ( vert0->m_NumWeights >= 2 ) ? vert0->m_WeightedIndex[1] : 0; 
//						int i2 = ( vert0->m_NumWeights >= 3 ) ? vert0->m_WeightedIndex[2] : 0; 
//
//						int remapped_idx = get_skin_pos( vert0->m_Pos[0], vert0->m_Pos[1], vert0->m_Pos[2], vert0->m_Normal[0], vert0->m_Normal[1], vert0->m_Normal[2], w0, w1, w2, i0, i1, i2 );
//						if ( remapped_idx == index )
//						{
//							index = v0;
							// Set up the remap index.
							//printf( "\nRemap: %d -> %d", index, vertex );
							//printf( "\nRemapD %d %d", index, vertex );
							pRemapIndex[index] = vertex;
							pRemapVertex[vertex] = index;
							pD->pIndex[lp] = vertex;
							// Next vert.
							vertex++;
//						}
//					}
				}
				// Next array.
				pD = (skinDouble *)pD->pNext;
			}
	
//				printf( "\nDone: %d verts, %d\n", num_verts, vertex );
	
			// Now, build single add weight arrays.
			for ( int bone = 0; bone < max_bone; bone++ )
			{
				// Count how many matches we have.
				int numMatches = 0;
				for( int v = 0; v < g_u_num_skin_pos; ++v )
				{
//					NxVertex* vert = object->m_Verts + v;
	
	//					if (	( ( vert->m_WeightedIndex[2] == bone ) && ( vert->m_Weight[2] > W_EPSILON ) ) ||
	//							( ( vert->m_WeightedIndex[3] == bone ) && ( vert->m_Weight[3] > W_EPSILON ) ) )
					if (	( ( g_u_skin_pos[v].i2 == bone ) && ( g_u_skin_pos[v].w2 > W_EPSILON ) ) )
					{
						numMatches++;
					}
				}
	
				// If we have matches, build a single add array & link it in.
				if ( numMatches )
				{
					skinAdd *	pCurrentAdd;
					pCurrentAdd = new skinAdd;
					pCurrentAdd->pNext = pAddHead;
					pAddHead = (void *)pCurrentAdd;
					pCurrentAdd->count = numMatches;
					pCurrentAdd->matrix = bone;
					pCurrentAdd->pPosNormal = new float[6 * numMatches];
					pCurrentAdd->pWeight = new float[numMatches];
					pCurrentAdd->pIndex = new short[numMatches];
	
					int index = 0;
					for( int v = 0; v < g_u_num_skin_pos; ++v )
					{
//						NxVertex* vert = object->m_Verts + v;
	
//						int ww = 2;
	//						for ( int ww = 2; ww < NxVertex::vMAX_WEIGHTS_PER_VERTEX; ww++ )
						{
							if ( ( g_u_skin_pos[v].i2 == bone ) && ( g_u_skin_pos[v].w2 > W_EPSILON ) )
							{
								pCurrentAdd->pPosNormal[(index * 6) + 0] = g_u_skin_pos[v].x;
								pCurrentAdd->pPosNormal[(index * 6) + 1] = g_u_skin_pos[v].y;
								pCurrentAdd->pPosNormal[(index * 6) + 2] = g_u_skin_pos[v].z;
								pCurrentAdd->pPosNormal[(index * 6) + 3] = g_u_skin_pos[v].nx;
								pCurrentAdd->pPosNormal[(index * 6) + 4] = g_u_skin_pos[v].ny;
								pCurrentAdd->pPosNormal[(index * 6) + 5] = g_u_skin_pos[v].nz;
								pCurrentAdd->pWeight[index] = g_u_skin_pos[v].w2;
								pCurrentAdd->pIndex[index] = pRemapIndex[v];
//								pCurrentAdd->pIndex[index] = get_skin_pos( g_u_skin_pos[v].x,
//																		   g_u_skin_pos[v].y,
//																		   g_u_skin_pos[v].z,
//																		   g_u_skin_pos[v].nx,
//																		   g_u_skin_pos[v].ny,
//																		   g_u_skin_pos[v].nz,
//																		   g_u_skin_pos[v].w0,
//																		   g_u_skin_pos[v].w1,
//																		   g_u_skin_pos[v].w2,
//																		   g_u_skin_pos[v].i0,
//																		   g_u_skin_pos[v].i1,
//																		   g_u_skin_pos[v].i2 ); 
								index++;
								g_u_skin_pos[v].i2 |= 0x4000;
								//printf( "\nWeight %3d: %2d - %f", v, bone, vert->m_Weight[2] );
							}
						}
					}
				}
			}
		}



		// Revert the indices back to normal.
		for( int v = 0; v < g_u_num_skin_pos; ++v )
		{
			g_u_skin_pos[v].i0 &= ~0x4000;
			g_u_skin_pos[v].i1 &= ~0x4000;
			g_u_skin_pos[v].i2 &= ~0x4000;
		}







		int singleBytes = 0;
		int doubleBytes = 0;
		int addBytes = 0;
		uint16 singleLists = 0;
		uint16 doubleLists = 0;
		uint16 addLists = 0;
		// Calculate sizes.
		if( object->m_Flags & NxObject::mSKINNED )
		{
			// ----------
			// Singles
			// ----------
			skinSingle *	pS;

			// First, work out how many lists & how many pairs we're going to write.
			pS = (skinSingle *)pSingleHead;
			int bytes = 0;
			int lists = 0;
			int pairs = 0;
			while ( pS )
			{
				pairs += pS->count;
				lists++;
				// Next array.
				pS = (skinSingle *)pS->pNext;
			}
			// Write header information (int)numBytes, (int)numLists:
			// Note: numBytes does not includes the 8 bytes for the header.
			bytes = ( ( 4 + 4 ) * lists ) + ( ( 2 * 6 ) * pairs );
			singleBytes = bytes;
			singleLists = lists;

			// ----------
			// Doubles
			// ----------
			skinDouble *	pD;

			// First, work out how many lists & how many pairs we're going to write.
			pD = (skinDouble *)pDoubleHead;
			lists = 0;
			pairs = 0;
			while ( pD )
			{
				if ( pD->count ) pairs += pD->count;
				if ( pD->count ) lists++;
				// Next array.
				pD = (skinDouble *)pD->pNext;
			}
			// Write header information (int)numBytes, (int)numLists:
			// Note: numBytes does not includes the 8 bytes for the header.
			bytes = ( ( 4 + 4 ) * lists ) + ( ( 2 * 6 ) * pairs ) + ( ( 2 * 2 ) * pairs );
			doubleBytes = bytes;
			doubleLists = lists;

			// ----------
			// Adds
			// ----------
			skinAdd* pA;

			bytes = 0;
			lists = 0;

			// First, count up how many bytes we're going to output & how many lists we have.
			pA = (skinAdd *)pAddHead;
			while ( pA )
			{
				bytes += 2 * 4;
				bytes += pA->count * ( 2 * 6 );
	//				if ( pA->count & 1 ) bytes += 2;
				bytes += pA->count * 2;
	//				if ( pA->count & 3 ) bytes += 4 - ( pA->count & 3 );
				bytes += pA->count * 2;
//				bytes += ( pA->count & 1 ) * 2;
				lists++;

				pA = (skinAdd *)pA->pNext;
			}
			addBytes = bytes;
			addLists = lists;
		}

		int skinBytes = ( ( (int)singleBytes + (int)doubleBytes + (int)addBytes ) + 31 ) & 0xffffffe0;
		int padBytes = skinBytes - ( (int)singleBytes + (int)doubleBytes + (int)addBytes );

		// Work out hierarchy bone index.
		unsigned short boneidx = -1;
		int num_hierarchy_objects = m_scene->m_Model.nBones;
		for (uint8 bone_idx = 0; bone_idx < num_hierarchy_objects; bone_idx++)
		{
			uint32 cur_checksum = m_scene->m_Model.bones[bone_idx].crc;
			uint32 parent_checksum;
			NxObject *p_cur_object = m_scene->FindObject(cur_checksum);
			int16 parent_index = -1;
			//NxObject *p_parent_object = NULL;

			assert(p_cur_object);
			parent_checksum = p_cur_object->m_ParentCRC;
			if (parent_checksum)
			{
				//p_parent_object = m_scene->FindObject(parent_checksum);
				//assert(p_parent_object);
			
				// Find parent index
				for (int i = 0; i < num_hierarchy_objects; i++)
				{
					if (parent_checksum == m_scene->m_Model.bones[i].crc)
					{
						parent_index = i;
						break;
					}
				}

				assert(parent_index >= 0);
			}

			if ( cur_checksum == object->m_Checksum )
			{
				boneidx = bone_idx;
			}
		}

		// Write out shadow volume data & end of pool data, first time through.
		// Needs to be here as it needs the skin data remap table.
		if ( first && ( mesh->numFaces ) )
		{
			// Shadow faces.
			for ( int f = 0; f < mesh->numFaces; f++ )
			{
//				float x0 = mesh->verts[mesh->faces[f].v[0]].x;
//				float y0 = mesh->verts[mesh->faces[f].v[0]].y;
//				float z0 = mesh->verts[mesh->faces[f].v[0]].z;
//
//				float x1 = mesh->verts[mesh->faces[f].v[1]].x;
//				float y1 = mesh->verts[mesh->faces[f].v[1]].y;
//				float z1 = mesh->verts[mesh->faces[f].v[1]].z;
//
//				float x2 = mesh->verts[mesh->faces[f].v[2]].x;
//				float y2 = mesh->verts[mesh->faces[f].v[2]].y;
//				float z2 = mesh->verts[mesh->faces[f].v[2]].z;
//
				int idx0 = mesh->verts[ mesh->faces[f].v[0] ].idx;
				int idx1 = mesh->verts[ mesh->faces[f].v[1] ].idx;
				int idx2 = mesh->verts[ mesh->faces[f].v[2] ].idx;

//				printf( "\nFace %4d: %4d %4d %4d", f, mesh->faces[f].v[0], mesh->faces[f].v[1], mesh->faces[f].v[2] );
//
//				printf( "\nVerts %3d: %6.3f %6.3f %6.3f - %6.3f %6.3f %6.3f - %6.3f %6.3f %6.3f", f, x0, y0, z0, x1, y1, z1, x2, y2, z2 );
//
////				float x0 = object->m_Verts[idx0].m_Pos[0];
////				float y0 = object->m_Verts[idx0].m_Pos[1];
////				float z0 = object->m_Verts[idx0].m_Pos[2];
////
////				float x1 = object->m_Verts[idx1].m_Pos[0];
////				float y1 = object->m_Verts[idx1].m_Pos[1];
////				float z1 = object->m_Verts[idx1].m_Pos[2];
////
////				float x2 = object->m_Verts[idx2].m_Pos[0];
////				float y2 = object->m_Verts[idx2].m_Pos[1];
////				float z2 = object->m_Verts[idx2].m_Pos[2];
//
//				float nx0 = object->m_Verts[idx0].m_Normal[0];
//				float ny0 = object->m_Verts[idx0].m_Normal[1];
//				float nz0 = object->m_Verts[idx0].m_Normal[2];
//											    
//				float nx1 = object->m_Verts[idx1].m_Normal[0];
//				float ny1 = object->m_Verts[idx1].m_Normal[1];
//				float nz1 = object->m_Verts[idx1].m_Normal[2];
//											    
//				float nx2 = object->m_Verts[idx2].m_Normal[0];
//				float ny2 = object->m_Verts[idx2].m_Normal[1];
//				float nz2 = object->m_Verts[idx2].m_Normal[2];
//
//				float p10x = x1 - x0;
//				float p10y = y1 - y0;
//				float p10z = z1 - z0;
//
//				float p20x = x2 - x0;
//				float p20y = y2 - y0;
//				float p20z = z2 - z0;
//
//				float nx = ( p10y * p20z ) - ( p10z * p20y );
//				float ny = ( p10z * p20x ) - ( p10x * p20z );
//				float nz = ( p10x * p20y ) - ( p10y * p20x );
//
//				nx0 = ( nx0 + nx1 + nx2 ) / 3.0f;
//				ny0 = ( ny0 + ny1 + ny2 ) / 3.0f;
//				nz0 = ( nz0 + nz1 + nz2 ) / 3.0f;
//
////				float dot = ( nx * px ) + ( ny * py ) + ( nz * pz );
//				float dot0 = ( nx0 * nx ) + ( ny0 * ny ) + ( nz0 * nz );
//				float dot1 = dot0;
//				float dot2 = dot0;
////				float dot1 = ( nx1 * nx ) + ( ny1 * ny ) + ( nz1 * nz );
////				float dot2 = ( nx2 * nx ) + ( ny2 * ny ) + ( nz2 * nz );
//
//				printf( "\nNormals %3d: n: %6.3f %6.3f %6.3f, 0: %6.3f %6.3f %6.3f, 1: %6.3f %6.3f %6.3f, 2: %6.3f %6.3f %6.3f, d: %7.2f %7.2f %7.2f",
//						f, nx, ny, nz,
//						nx0, ny0, nz0,
//						nx1, ny1, nz1,
//						nx2, ny2, nz2,
//						dot0, dot1, dot1
//						);
//
//				if ( ( dot0 < 0 ) && ( dot1 < 0 ) && ( dot2 < 0 ) )
//				{
//					// Reverse the index order.
//					int temp = idx0;
//					idx0 = idx2;
//					idx2 = temp;
//				
//					// Stuff back in for neighbor list generation.
////					mesh->verts[ mesh->faces[f].v[0] ].idx = idx0;
////					mesh->verts[ mesh->faces[f].v[1] ].idx = idx1;
////					mesh->verts[ mesh->faces[f].v[2] ].idx = idx2;
//
//
//					temp = mesh->faces[f].v[0];
//					mesh->faces[f].v[0] = mesh->faces[f].v[2];
//					mesh->faces[f].v[2] = temp;
//				}
				uint16 idx;

				idx = pRemapIndex[ pShadowRemap[idx0] ];
				pGDFile->Write( (const char *)&idx, 2, true );
				idx = pRemapIndex[ pShadowRemap[idx1] ];
				pGDFile->Write( (const char *)&idx, 2, true );
				idx = pRemapIndex[ pShadowRemap[idx2] ];
				pGDFile->Write( (const char *)&idx, 2, true );


//				printf( "\nPoly %3d: (%7.3f %7.3f %7.3f) (%7.3f %7.3f %7.3f) (%7.3f %7.3f %7.3f) %d", f,
//						( mesh->verts[ mesh->faces[f].v[0] ].x * 10.0f ) + 150.0f, ( mesh->verts[ mesh->faces[f].v[0] ].y * 10.0f ) + 150.0f, ( mesh->verts[ mesh->faces[f].v[0] ].z * 10.0f ) + 150.0f,
//						( mesh->verts[ mesh->faces[f].v[1] ].x * 10.0f ) + 150.0f, ( mesh->verts[ mesh->faces[f].v[1] ].y * 10.0f ) + 150.0f, ( mesh->verts[ mesh->faces[f].v[1] ].z * 10.0f ) + 150.0f,
//						( mesh->verts[ mesh->faces[f].v[2] ].x * 10.0f ) + 150.0f, ( mesh->verts[ mesh->faces[f].v[2] ].y * 10.0f ) + 150.0f, ( mesh->verts[ mesh->faces[f].v[2] ].z * 10.0f ) + 150.0f,
//						mesh->faces[f].mesh
//						 );

//				for ( int corner = 0; corner < 3; corner++ )
//				{
////					printf( "\nOutput: %4d %4d", mesh->faces[f].v[corner], pRemapIndex[ mesh->faces[f].v[corner] ] );
//					uint16 idx = pRemapIndex[ mesh->verts[ mesh->faces[f].v[corner] ].idx ];
////					uint16 idx = pRemapIndex[ mesh->faces[f].v[corner] ];
//					pGDFile->Write( (const char *)&idx, 2, true );
//
//					idx = get_pos( mesh->verts[ mesh->faces[f].v[corner] ].x, mesh->verts[ mesh->faces[f].v[corner] ].y, mesh->verts[ mesh->faces[f].v[corner] ].z );
//					pGDFile->Write( (const char *)&idx, 2, true );
//
////					float x = mesh->verts[ mesh->faces[f].v[corner] ].x;
////					float y = mesh->verts[ mesh->faces[f].v[corner] ].y;
////					float z = mesh->verts[ mesh->faces[f].v[corner] ].z;
////
////					for ( int iv = 0; iv < object->m_NumVerts; iv++ )
////					{
////						if ( ( object->m_Verts[iv].m_Pos[0] == x ) &&
////							 ( object->m_Verts[iv].m_Pos[1] == y ) &&
////							 ( object->m_Verts[iv].m_Pos[2] == z ) )
////						{
////							uint16 idx = pRemapIndex[iv];
////							pGDFile->Write( (const char *)&idx, 2, true );
////							break;
////						}
////					}
//				}





//				p0 = pRemapIndex[ mesh->faces[f].v[0] ];
//				p1 = pRemapIndex[ mesh->faces[f].v[1] ];
//				p2 = pRemapIndex[ mesh->faces[f].v[2] ];
//
//				pGDFile->Write( (const char *)&p0, 2, true );
//				pGDFile->Write( (const char *)&p1, 2, true );
//				pGDFile->Write( (const char *)&p2, 2, true );

//				for ( int v = 0; v < mesh->numVerts; v++ )
//				{
//					printf( "\nVert %3d: %8.3f %8.3f %8.3f %d %8.3f %8.3f %8.3f", v, mesh->verts[v].x, mesh->verts[v].y, mesh->verts[v].z, mesh->verts[v].idx, vert_list[mesh->verts[v].idx].m_Pos[0], vert_list[mesh->verts[v].idx].m_Pos[1], vert_list[mesh->verts[v].idx].m_Pos[2] );
//				}
//
//				for ( int f = 0; f < mesh->numFaces; f++ )
//				{
//					printf( "\nFace %3d: %3d %3d %3d", f, mesh->faces[f].v[0], mesh->faces[f].v[1], mesh->faces[f].v[2] );
//				}
			}

			// Create neighbor list.
			struct sShadowEdge
			{
				short neighbor[3];
			};

			int num_shadow_faces = mesh->numFaces;
			sShadowEdge *p_edge = new sShadowEdge[num_shadow_faces];
			int s, t;

			// Find neighbor edges.
			for ( s = 0; s < num_shadow_faces; s++ )
			{
				int found01 = 0;
				int found12 = 0;
				int found20 = 0;

				p_edge[s].neighbor[0] = -1;
				p_edge[s].neighbor[1] = -1;
				p_edge[s].neighbor[2] = -1;

				int s0 = mesh->verts[ mesh->faces[s].v[0] ].idx; 
				int s1 = mesh->verts[ mesh->faces[s].v[1] ].idx; 
				int s2 = mesh->verts[ mesh->faces[s].v[2] ].idx; 

				for ( t = 0; t < num_shadow_faces; t++ )
				{
					if ( t == s ) continue;
					//if ( found01 && found12 && found20 ) break;

					int t0 = mesh->verts[ mesh->faces[t].v[0] ].idx;  
					int t1 = mesh->verts[ mesh->faces[t].v[1] ].idx;  
					int t2 = mesh->verts[ mesh->faces[t].v[2] ].idx;  

					if (
						( ( s0 == t0 ) && ( s1 == t1 ) ) ||
						( ( s0 == t1 ) && ( s1 == t2 ) ) ||
						( ( s0 == t2 ) && ( s1 == t0 ) ) ||
						( ( s0 == t0 ) && ( s1 == t2 ) ) ||
						( ( s0 == t2 ) && ( s1 == t1 ) ) ||
						( ( s0 == t1 ) && ( s1 == t0 ) )
					   )
					{
						p_edge[s].neighbor[0] = t;
						found01++;
	//					continue;
					}

					if (
						( ( s1 == t0 ) && ( s2 == t1 ) ) ||
						( ( s1 == t1 ) && ( s2 == t2 ) ) ||
						( ( s1 == t2 ) && ( s2 == t0 ) ) ||
						( ( s1 == t0 ) && ( s2 == t2 ) ) ||
						( ( s1 == t2 ) && ( s2 == t1 ) ) ||
						( ( s1 == t1 ) && ( s2 == t0 ) )
					   )
					{
						p_edge[s].neighbor[1] = t;
						found12++;
	//					continue;
					}

					if (
						( ( s2 == t0 ) && ( s0 == t1 ) ) ||
						( ( s2 == t1 ) && ( s0 == t2 ) ) ||
						( ( s2 == t2 ) && ( s0 == t0 ) ) ||
						( ( s2 == t0 ) && ( s0 == t2 ) ) ||
						( ( s2 == t2 ) && ( s0 == t1 ) ) ||
						( ( s2 == t1 ) && ( s0 == t0 ) )
					   )
					{
						p_edge[s].neighbor[2] = t;
						found20++;
	//					continue;
					}
				}
				// If multiple connecting polys, treat as a neighborless edge.
				if ( found01 > 1 )
				{
					p_edge[s].neighbor[0] = -1;
				}
				if ( found12 > 1 )
				{
					p_edge[s].neighbor[1] = -1;
				}
				if ( found20 > 1 )
				{
					p_edge[s].neighbor[2] = -1;
				}
//				printf( "\nFace %3d: %3d %3d %3d ( %3d %3d %3d ) %2d", s, mesh->faces[s].v[0], mesh->faces[s].v[1], mesh->faces[s].v[2], p_edge[s].neighbor[0], p_edge[s].neighbor[1], p_edge[s].neighbor[2], mesh->faces[s].mesh );
//				printf( " ( %8.3f %8.3f %8.3f )", ( mesh->verts[mesh->faces[s].v[0]].x + 20.0f ) * 20.0f, ( mesh->verts[mesh->faces[s].v[0]].y + 20.0f ) * 20.0f, ( mesh->verts[mesh->faces[s].v[0]].z + 20.0f ) * 20.0f );
//				printf( " ( %8.3f %8.3f %8.3f )", ( mesh->verts[mesh->faces[s].v[1]].x + 20.0f ) * 20.0f, ( mesh->verts[mesh->faces[s].v[1]].y + 20.0f ) * 20.0f, ( mesh->verts[mesh->faces[s].v[1]].z + 20.0f ) * 20.0f );
//				printf( " ( %8.3f %8.3f %8.3f )", ( mesh->verts[mesh->faces[s].v[2]].x + 20.0f ) * 20.0f, ( mesh->verts[mesh->faces[s].v[2]].y + 20.0f ) * 20.0f, ( mesh->verts[mesh->faces[s].v[2]].z + 20.0f ) * 20.0f );
			}


			for ( s = 0; s < num_shadow_faces; s++ )
			{
				pGDFile->Write( (const char *)&p_edge[s].neighbor[0], 2, true );
				pGDFile->Write( (const char *)&p_edge[s].neighbor[1], 2, true );
				pGDFile->Write( (const char *)&p_edge[s].neighbor[2], 2, true );
			}

			if ( p_edge ) delete p_edge;
		}

		if ( first )
		{
			fpos = pGDFile->TellPos() - fpos;

			// Pad to 32 bytes.
			int pad_bytes = rounded_pool_bytes - pool_bytes;
			while ( pad_bytes )
			{
				pGDFile->Write( (const char *)&zero, 1, false );
				pad_bytes--;
			}
		}
		first = false;

		// Object header.
		uint32 nm = (uint32)num_meshes;
		uint16 type = (uint16)object->m_BillboardType;
		uint16 nv = (uint16)g_u_num_skin_pos;	//num_verts;
		uint8 ns = (uint8)singleLists;
		uint8 na = (uint8)addLists;

		pGDFile->Write( (const char *)&nm, 2, true );
		pGDFile->Write( (const char *)&type, 2, true );
		pGDFile->Write( (const char *)&skinBytes, 4, true );
		pGDFile->Write( (const char *)&nv, 2, true );
		pGDFile->Write( (const char *)&doubleLists, 2, true );
		pGDFile->Write( (const char *)&ns, 1, true );		// Can be a byte assuming no more than 256 bones.
		pGDFile->Write( (const char *)&na, 1, true );       // Can be a byte assuming no more than 256 bones. 
		pGDFile->Write( (const char *)&boneidx, 2, true );



		pGDFile->Write( (const char *)&object->m_BillboardOrigin[0], 4, true );
		pGDFile->Write( (const char *)&object->m_BillboardOrigin[1], 4, true );
		pGDFile->Write( (const char *)&object->m_BillboardOrigin[2], 4, true );
		pGDFile->Write( (const char *)&zero, 4, true );
//		pGDFile->Write( (const char *)&object->m_PivotPos[0], 4, true );
//		pGDFile->Write( (const char *)&object->m_PivotPos[1], 4, true );
//		pGDFile->Write( (const char *)&object->m_PivotPos[2], 4, true );
//		pGDFile->Write( (const char *)&zero, 4, true );
		pGDFile->Write( (const char *)&object->m_PivotAxis[0], 4, true );
		pGDFile->Write( (const char *)&object->m_PivotAxis[1], 4, true );
		pGDFile->Write( (const char *)&object->m_PivotAxis[2], 4, true );
		pGDFile->Write( (const char *)&zero, 4, true );

//		// Calculate bounding sphere for entire object.
//		float _min[3];
//		float _max[3];
//		_min[0] = _min[1] = _min[2] = 9999999.0f;
//		_max[0] = _max[1] = _max[2] = -9999999.0f;
//		for( int m = 0; m < num_meshes; ++m )
//		{
//			p_mesh		= object->m_MeshList.m_Meshes[0][m];
//
//			// Go through each mesh adding new vertices.
//			int v = 0;
//			while ( p_mesh->m_VertStrip[v].m_Index )
//			{
//				unsigned short num = p_mesh->m_VertStrip[v].m_Index;
//				v++;
//
//				for ( int vv = 0; vv < num; vv++ )
//				{
//					unsigned short idx = p_mesh->m_VertStrip[v+vv].m_Index;
//
//					NxVertex* vert = object->m_Verts + idx;
//
//					for( int a = 0; a < 3; ++a )
//					{
//						if ( vert->m_Pos[a] < _min[a] ) _min[a] = vert->m_Pos[a];
//						if ( vert->m_Pos[a] > _max[a] ) _max[a] = vert->m_Pos[a];
//					}
//				}
//				v += num;
//			}	
//		}
//
//		// Calculate bounding sphere.
//		float center[3], diag[3];
//		float diag_length = 0.0f;
//		for( int a = 0; a < 3; ++a )
//		{
//			center[a] = ( _max[a] + _min[a] ) / 2;
//			diag[a] = ( _max[a] - _min[a] );
//			diag_length += ( diag[a] * diag[a] );
//		}
//		diag_length = sqrtf( diag_length );
//		float radius = diag_length / 2.0f;
//
////		pGDFile->Write( (const char *)&center[0], 4, true );
////		pGDFile->Write( (const char *)&center[1], 4, true );
////		pGDFile->Write( (const char *)&center[2], 4, true );
////		pGDFile->Write( (const char *)&radius, 4, true );
//
		pGDFile->Write( (const char *)&obs[(i*4)+0], 4, true );
		pGDFile->Write( (const char *)&obs[(i*4)+1], 4, true );
		pGDFile->Write( (const char *)&obs[(i*4)+2], 4, true );
		pGDFile->Write( (const char *)&obs[(i*4)+3], 4, true );



//		printf( "\nOld OBB: %8.3f %8.3f %8.3f %8.3f", center[0], center[1], center[2], radius );
//		printf( "\nOBB: %8.3f %8.3f %8.3f %8.3f", obs[(i*4)+0], obs[(i*4)+1], obs[(i*4)+2], obs[(i*4)+3] );

//		if ( object->m_BillboardType > 0 )
//		{
//			printf( "\nBillboard type: %d", object->m_BillboardType );
//			printf( "\nBillboard origin: %8.3f %8.3f %8.3f", object->m_BillboardOrigin[0], object->m_BillboardOrigin[1], object->m_BillboardOrigin[2] );
//			printf( "\nBillboard pos:    %8.3f %8.3f %8.3f", object->m_PivotPos[0], object->m_PivotPos[1], object->m_PivotPos[2] );
//			printf( "\nBillboard axis:   %8.3f %8.3f %8.3f", object->m_PivotAxis[0], object->m_PivotAxis[1], object->m_PivotAxis[2] );
//		}


#if 0
		// Scan through single weight list and see if any meshes are single weight only.
		uint32 single_mesh_matrix[256];
		int num_single_mesh_matrix = 0;

		if( object->m_Flags & NxObject::mSKINNED )
		{
			int total_single = 0;
			int total_multi = 0;
			int _total_single = 0;
			int _total_multi = 0;
			for( int m = 0; m < num_meshes; ++m )
			{
				p_mesh		= object->m_MeshList.m_Meshes[0][m];
	//			p_material	= m_scene->GetMaterial( p_mesh->m_MatChecksum );

				int num_single = 0;
				int num_multi = 0;
				int single_matrix = -1;
				bool multi_matrix = false;


				int v = 0;
				int micro = 0;
				while ( p_mesh->m_VertStrip[v].m_Index )
				{
					unsigned short num = p_mesh->m_VertStrip[v].m_Index;
					v++;

					int _num_single = 0;
					int _num_multi = 0;
					int _single_matrix = -1;
					bool _multi_matrix = false;

					for ( int vv = 0; vv < num; vv++ )
					{
						unsigned int index = p_mesh->m_VertStrip[v+vv].m_Index;

						bool single = false;

						// See if this index has 1 weight or not.
						skinSingle *	pS = (skinSingle *)pSingleHead; 
						while ( pS )
						{
		//					pGDFile->Write( (const char *)&pS->count, 4, true );
		//					pGDFile->Write( (const char *)&pS->matrix, 4, true );

							// Write vertex/normal pairs.
							for ( int lp = 0; lp < pS->count; lp++ )
							{
								if ( pS->pIndex[lp]  == pRemapIndex[index] )
								{
									if ( num_single )
									{
										if ( single_matrix != pS->matrix )
										{
											multi_matrix = true;
										}
									}
									else
									{
										// Setup matrix.
										single_matrix = pS->matrix;
									}

									if ( _num_single )
									{
										if ( _single_matrix != pS->matrix )
										{
											_multi_matrix = true;
										}
									}
									else
									{
										// Setup matrix.
										_single_matrix = pS->matrix;
									}

									single = true;
									break;
								}


		//						pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 0], 4, true );
		//						pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 1], 4, true );
		//						pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 2], 4, true );
		//						pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 3], 4, true );
		//						pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 4], 4, true );
		//						pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 5], 4, true );
							}
							// Next array.
							pS = (skinSingle *)pS->pNext;
						}
						if ( single )
						{
							num_single++;
							_num_single++;
						}
						else
						{
							num_multi++;
							_num_multi++;
						}
					}

					char mat[16];
					if ( !_multi_matrix && _num_multi == 0 )
					{
						sprintf( mat, "1mat %d", _single_matrix );
						_total_single += _num_single;

						// Flag indices as single weight.
//						for ( int vv = 0; vv < num; vv++ )
//						{
//							p_mesh->m_VertStrip[v+vv].m_Index |= ( 0x80000000 | ( _single_matrix << 23 ) );
//						}

						// Add matrix to list of single weight mesh matrices.
						bool found = false;
						for ( int mm = 0; mm < num_single_mesh_matrix; mm++ )
						{
							if ( single_mesh_matrix[mm] == _single_matrix )
							{
								found = true;
								break;
							}
						}
						if ( !found )
						{
							single_mesh_matrix[num_single_mesh_matrix] = _single_matrix;
							num_single_mesh_matrix++;
						}

//						// Need to create a new mesh, copy verts from original and delete from original.
//						p_mesh		= object->m_MeshList.m_Meshes[0][m];
//
//						AppendMesh( NxMesh* mesh, int lod = 0 );
//
//						NxMesh* new_mesh;
//
//						new_mesh = new NxMesh( p_mesh->m_MatChecksum );
//						new_mesh->m_Object =  p_mesh->m_Object;
//						new_mesh->m_ShadowFlags = mesh_shadow_flags;
//						m_MeshList.AppendMesh( new_mesh );
//
//
//						unsigned long	m_MatChecksum;
//						FlagType		m_ShadowFlags;
//						int				m_NumStripVerts;
//						NxStripVert*	m_VertStrip;
//						int				m_Topology[vMAX_FACES][3];
//						int				m_NumFaces;	
//						class NxObject*	m_Object;
//						int				m_Flags;
//
//						object->m_MeshList.AppendMesh( new_mesh );
					}
					else
					{
						sprintf( mat, "" );
						_total_multi += _num_single + _num_multi; 
					}
					printf( "\n    Micro %2d: Single: %4d Multi: %4d %s", micro, _num_single, _num_multi, mat );

					micro++;

					v += num;
				}			

				if ( !multi_matrix && num_multi == 0 )
				{
					total_single += num_single;
				}
				else
				{
					total_multi += num_single + num_multi;
				}

				char mat[16];
				if ( !multi_matrix && num_multi == 0 )
				{
					sprintf( mat, "1mat %d", single_matrix );
				}
				else
				{
					sprintf( mat, "" );

				}
				printf( "\nMesh %2d: Single: %4d Multi: %4d %s", m, num_single, num_multi, mat );
			}			
			printf( "\nMesh  Total: %4d Single: %4d Multi: %4d", total_single + total_multi, total_single, total_multi );
			printf( "\nMicro Total: %4d Single: %4d Multi: %4d", _total_single + _total_multi, _total_single, _total_multi );
		}

		printf( "\nNum extra meshes: %d", num_single_mesh_matrix );
		for ( int mm = 0; mm < num_single_mesh_matrix; mm++ )
		{
			printf( "\n    Mesh %2d: Matrix %2d", mm, single_mesh_matrix[mm] );
		}
		printf( "\n" );

		// Need to see if any CAS flags match modified verts & reassign to new mesh index.
#endif



#if 1
//			if ( m == 0 )
//			{
				// Single weight lists (if present)
				if( object->m_Flags & NxObject::mSKINNED )
				{
					skinSingle *	pS;

					// Now, write out each list in turn.
					pS = (skinSingle *)pSingleHead;
	//				int fpos = pOutputFile->TellPos();
					while ( pS )
					{
						int lp;
						// Write list header.
						//if ( pD->count <= 1 ) printf( "\nDouble list, %3d verts, mat %2d %2d", pD->count, pD->matrix0, pD->matrix1 );
						pGDFile->Write( (const char *)&pS->count, 4, true );
						pGDFile->Write( (const char *)&pS->matrix, 4, true );

						// Write vertex/normal pairs.
						for ( lp = 0; lp < pS->count; lp++ )
						{
							short px = (short)(pS->pPosNormal[(lp * 6) + 0] * (float)POS_MUL);
							short py = (short)(pS->pPosNormal[(lp * 6) + 1] * (float)POS_MUL);
							short pz = (short)(pS->pPosNormal[(lp * 6) + 2] * (float)POS_MUL);
							short nx = (short)(pS->pPosNormal[(lp * 6) + 3] * (float)NORM_MUL);
							short ny = (short)(pS->pPosNormal[(lp * 6) + 4] * (float)NORM_MUL);
							short nz = (short)(pS->pPosNormal[(lp * 6) + 5] * (float)NORM_MUL);
							pGDFile->Write( (const char *)&px, 2, true );
							pGDFile->Write( (const char *)&py, 2, true );
							pGDFile->Write( (const char *)&pz, 2, true );
							pGDFile->Write( (const char *)&nx, 2, true );
							pGDFile->Write( (const char *)&ny, 2, true );
							pGDFile->Write( (const char *)&nz, 2, true );

							// XXXXXXXXXXXXXXX
							NxVertex * vert = pS->ppVertex[lp];
							if ( vert->m_MeshScalingWeight[0] != 0.0f )
							{
								Utils::Assert( mp_weight_map_vertices != NULL, "weight map verts were uninitialized" );
			//					Utils::Assert( m_num_weight_map_vertices == skinned_vertex_index, "weight map index mismatch" );

								NxVertex* pVertex = &mp_weight_map_vertices[m_num_weight_map_vertices];
								*pVertex = *vert;
								m_num_weight_map_vertices++;
							}


//							pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 0], 4, true );
//							pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 1], 4, true );
//							pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 2], 4, true );
//							pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 3], 4, true );
//							pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 4], 4, true );
//							pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 5], 4, true );
						}
						// Next array.
						pS = (skinSingle *)pS->pNext;
					}
	//				fpos = pOutputFile->TellPos() - fpos;
	//				printf( "\nDifference: actual: %d calc: %d", fpos, bytes );

				}
				// Double weight lists (if present)
				if( object->m_Flags & NxObject::mSKINNED )
				{
					skinDouble *	pD;

					// Now, write out each list in turn.
					pD = (skinDouble *)pDoubleHead;
	//				int fpos = pOutputFile->TellPos();
					while ( pD )
					{
						if ( pD->count )
						{
							int lp;
							// Write list header.
							int mtx = pD->matrix0 | ( pD->matrix1 << 8 );
							//if ( pD->count <= 1 ) printf( "\nDouble list, %3d verts, mat %2d %2d", pD->count, pD->matrix0, pD->matrix1 );
							pGDFile->Write( (const char *)&pD->count, 4, true );
							pGDFile->Write( (const char *)&mtx, 4, true );

							// Write vertex/normal pairs.
							for ( lp = 0; lp < pD->count; lp++ )
							{
								short px = (short)(pD->pPosNormal[(lp * 6) + 0] * (float)POS_MUL);
								short py = (short)(pD->pPosNormal[(lp * 6) + 1] * (float)POS_MUL);
								short pz = (short)(pD->pPosNormal[(lp * 6) + 2] * (float)POS_MUL);
								short nx = (short)(pD->pPosNormal[(lp * 6) + 3] * (float)NORM_MUL);
								short ny = (short)(pD->pPosNormal[(lp * 6) + 4] * (float)NORM_MUL);
								short nz = (short)(pD->pPosNormal[(lp * 6) + 5] * (float)NORM_MUL);
								pGDFile->Write( (const char *)&px, 2, true );
								pGDFile->Write( (const char *)&py, 2, true );
								pGDFile->Write( (const char *)&pz, 2, true );
								pGDFile->Write( (const char *)&nx, 2, true );
								pGDFile->Write( (const char *)&ny, 2, true );
								pGDFile->Write( (const char *)&nz, 2, true );

//								pGDFile->Write( (const char *)&pD->pPosNormal[(lp * 6) + 0], 4, true );
//								pGDFile->Write( (const char *)&pD->pPosNormal[(lp * 6) + 1], 4, true );
//								pGDFile->Write( (const char *)&pD->pPosNormal[(lp * 6) + 2], 4, true );
//								pGDFile->Write( (const char *)&pD->pPosNormal[(lp * 6) + 3], 4, true );
//								pGDFile->Write( (const char *)&pD->pPosNormal[(lp * 6) + 4], 4, true );
//								pGDFile->Write( (const char *)&pD->pPosNormal[(lp * 6) + 5], 4, true );
								// XXXXXXXXXXXXXXX
								NxVertex * vert = pD->ppVertex[lp];
								if ( vert->m_MeshScalingWeight[0] != 0.0f )
								{
									Utils::Assert( mp_weight_map_vertices != NULL, "weight map verts were uninitialized" );
				//					Utils::Assert( m_num_weight_map_vertices == skinned_vertex_index, "weight map index mismatch" );

									NxVertex* pVertex = &mp_weight_map_vertices[m_num_weight_map_vertices];
									*pVertex = *vert;
									m_num_weight_map_vertices++;
								}
							}

							for ( lp = 0; lp < pD->count; lp++ )
							{
								short w0 = (short)(pD->pWeight[(lp * 2) + 0] * (float)WEIGHT_MUL);
								short w1 = (short)(pD->pWeight[(lp * 2) + 1] * (float)WEIGHT_MUL);
								pGDFile->Write( (const char *)&w0, 2, true );
								pGDFile->Write( (const char *)&w1, 2, true );
//								pGDFile->Write( (const char *)&pD->pWeight[(lp * 2) + 0], 4, true );
//								pGDFile->Write( (const char *)&pD->pWeight[(lp * 2) + 1], 4, true );
							}
						}
						// Next array.
						pD = (skinDouble *)pD->pNext;
					}
	//				fpos = pOutputFile->TellPos() - fpos;
	//				printf( "\nDifference: actual: %d calc: %d", fpos, bytes );

				}
				// Single add weight lists (if present)
				if( object->m_Flags & NxObject::mSKINNED )
				{
					skinAdd* pS;

					// Write out the single add lists.
					pS = (skinAdd *)pAddHead;
	//				int fpos = pOutputFile->TellPos();
					while ( pS )
					{
						int lp;
						pGDFile->Write( (const char *)&pS->count, 4, true );
						pGDFile->Write( (const char *)&pS->matrix, 4, true );
						for ( lp = 0; lp < pS->count; lp++ )
						{
							short px = (short)(pS->pPosNormal[(lp * 6) + 0] * (float)POS_MUL);
							short py = (short)(pS->pPosNormal[(lp * 6) + 1] * (float)POS_MUL);
							short pz = (short)(pS->pPosNormal[(lp * 6) + 2] * (float)POS_MUL);
							short nx = (short)(pS->pPosNormal[(lp * 6) + 3] * (float)NORM_MUL);
							short ny = (short)(pS->pPosNormal[(lp * 6) + 4] * (float)NORM_MUL);
							short nz = (short)(pS->pPosNormal[(lp * 6) + 5] * (float)NORM_MUL);
							pGDFile->Write( (const char *)&px, 2, true );
							pGDFile->Write( (const char *)&py, 2, true );
							pGDFile->Write( (const char *)&pz, 2, true );
							pGDFile->Write( (const char *)&nx, 2, true );
							pGDFile->Write( (const char *)&ny, 2, true );
							pGDFile->Write( (const char *)&nz, 2, true );

//							pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 0], 4, true );
//							pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 1], 4, true );
//							pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 2], 4, true );
//							pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 3], 4, true );
//							pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 4], 4, true );
//							pGDFile->Write( (const char *)&pS->pPosNormal[(lp * 6) + 5], 4, true );
						}
						for ( lp = 0; lp < pS->count; lp++ ) {
							short w = (short)(pS->pWeight[lp] * (float)WEIGHT_MUL);
							pGDFile->Write( (const char *)&w, 2, true );
//							pGDFile->Write( (const char *)&pS->pWeight[lp], 4, true );
						}
						for ( lp = 0; lp < pS->count; lp++ ) {
							pGDFile->Write( (const char *)&pS->pIndex[lp], 2, true );
						}
//						if ( pS->count & 1 )
//						{
//							pGDFile->Write( (const char *)&zero, 2, true );
//						}
						pS = (skinAdd *)pS->pNext;
					}
	//				fpos = pOutputFile->TellPos() - fpos;
	//				printf( "\nDifference: actual: %d calc: %d", fpos, bytes );
				}
				while ( padBytes )
				{
					pGDFile->Write( (const char *)&zero, 1, false );
					padBytes--;
				}
//			}
#endif



		// Delete skin arrays.

		// Single weight lists (if present)
		if( object->m_Flags & NxObject::mSKINNED )
		{
			skinSingle *	pS;

			pS = (skinSingle *)pSingleHead;
			while ( pS )
			{
				if ( pS->count ) delete pS->pPosNormal;
				if ( pS->count ) delete pS->pIndex;
				if ( pS->count ) delete pS->ppVertex;
				skinSingle * pDel = pS;
				pS = (skinSingle *)pS->pNext;
				delete pDel;
			}
		}
		// Double weight lists (if present)
		if( object->m_Flags & NxObject::mSKINNED )
		{
			skinDouble *	pD;

			pD = (skinDouble *)pDoubleHead;
			while ( pD )
			{
				if ( pD->count ) delete pD->pPosNormal;
				if ( pD->count ) delete pD->pWeight;
				if ( pD->count ) delete pD->pIndex;
				if ( pD->count ) delete pD->ppVertex;
				skinDouble * pDel = pD;
				pD = (skinDouble *)pD->pNext;
				delete pDel;
			}
		}
		// Single add weight lists (if present)
		if( object->m_Flags & NxObject::mSKINNED )
		{
			skinAdd* pS;

			pS = (skinAdd *)pAddHead;
			while ( pS )
			{
				if ( pS->count ) delete pS->pPosNormal;
				if ( pS->count ) delete pS->pWeight;
				if ( pS->count ) delete pS->pIndex;
				skinAdd * pDel = pS;
				pS = (skinAdd *)pS->pNext;
				delete pDel;
			}
		}

//		if ( object->m_Flags & NxObject::mVCWIBBLE )
//		{
//			printf( "\n!!!OBJECT WIBBLE" );
//		}

		// Output display list for each mesh.
		for( int m = 0; m < num_meshes; ++m )
		{
			p_mesh		= object->m_MeshList.m_Meshes[0][m];
			p_material	= m_scene->GetMaterial( p_mesh->m_MatChecksum );

			// Set number of texture passes.
			tex_passes = 0;
			if( object->m_Flags & NxObject::mTEXTURED )
			{
				if( p_material )
				{
					tex_passes = p_material->m_NumPasses;
				}
			}

			// Setup GD object.
			GDLObj	dl;
			GXVtxDescList desc[32];		// More than enough entries...
			int dcount = 0;

			uint16 inum = 0;
			uint8 icoloff = 1;
			uint8 correctable = 0;
			
//			u16 p_pos_offset;
//			u16 p_clr_offset;
//			u16 p_tex_offset[4];
			u16 num_pos = num_verts;
			u16 num_clr = num_verts;
			u16 num_tex = num_verts;
			
			// Add positions.
			desc[dcount].attr = GX_VA_POS;
			desc[dcount].type = GX_INDEX16;
			dcount++;

			// Add normals.
			if( object->m_Flags & NxObject::mNORMALS )
			{
				desc[dcount].attr = GX_VA_NRM;
				desc[dcount].type = GX_INDEX16;
				dcount++;
				icoloff++;
			}

			// Add colors.
			if( object->m_Flags & NxObject::mCOLORED )
			{
				desc[dcount].attr = GX_VA_CLR0;
				desc[dcount].type = GX_INDEX16;
				dcount++;

				if ( p_material->m_grassify )
//				if ( worst >= WORST_TOL )
				{
					// Add color texture.
					desc[dcount].attr = GX_VA_CLR1;
					desc[dcount].type = GX_INDEX16;
					dcount++;
					correctable = 1;
				}
			}

			// Add textures.
			int ttt = 0;
			for( tc = 0; tc < tex_passes; ++tc )
			{
				if ( p_material->m_Passes[tc].m_MappingMode == vMAPPING_ENVIRONMENT ) continue;
				unsigned int TexChecksum = p_material->m_Passes[tc].GetTextureChecksum( Utils::vPLATFORM_NGC );
				if ( GetTextureByChecksum( TexChecksum ) == 0 ) continue;

				desc[dcount].attr = (GXAttr)(((int)GX_VA_TEX0)+ttt);
				desc[dcount].type = GX_INDEX16;
				dcount++;
				ttt++;
			}

			// Terminate list.
			desc[dcount].attr = GX_VA_NULL;
			desc[dcount].type = GX_NONE;

			u32 stride = dcount;

			// Setup GD object and initialize format/buffers.
			GDInitGDLObj( &dl, gdbuffer, GD_SIZE );
			GDSetCurrent( &dl );
			GDSetVtxDescv( desc );

//			p_pos_offset = GDGetCurrOffset() + CP_DATA_OFFSET;
//			GDSetArrayRaw( GX_VA_POS, 0, 12 );		// NULL pos to be patched at runtime, stride of 12.
//
//			p_clr_offset = 0;
//			if( object->m_Flags & NxObject::mCOLORED )
//			{
//				p_clr_offset = GDGetCurrOffset() + CP_DATA_OFFSET;
//				GDSetArrayRaw( GX_VA_CLR0, 0, 4 );		// NULL pos to be patched at runtime, stride of 4.
//			}
//
//			p_tex_offset[0] = 0;
//			p_tex_offset[1] = 0;
//			p_tex_offset[2] = 0;
//			p_tex_offset[3] = 0;
//			for( tc = 0; tc < tex_passes; ++tc )
//			{
//				p_tex_offset[tc] = GDGetCurrOffset() + CP_DATA_OFFSET;
//				GDSetArrayRaw( (GXAttr)(((int)GX_VA_TEX0)+tc), 0, 8 );		// NULL pos to be patched at runtime, stride of 8.
//			}
//
			// Parse stripped mesh and issue GD drawing commands.
			int p_min = 65536;
			int p_max = 0;
			int c_min = 65536;
			int c_max = 0;
			int t_min[4] = { 65536, 65536, 65536, 65536 };
			int t_max[4] = { 0, 0, 0, 0 }; 
			int p_indices = 0;
			int c_indices = 0;
			int t_indices[4] = { 0, 0, 0, 0 };

			int v = 0;
			int index;
			uint32 index_list_offset = GDGetCurrOffset();



			// See if array base needs to be something other than 0.
			float boty = ( 65536.0f * 8.0f );
			int idx_min = 65536*2;
			int idx_max = 0;
			int idx_base = 0;
			while ( p_mesh->m_VertStrip[v].m_Index )
			{
				unsigned short num = p_mesh->m_VertStrip[v].m_Index;
				v++;
	
				for ( int vv = 0; vv < num; vv++ )
				{
					unsigned short idx;
					NxVertex* vert;

					// Position index.
					if( !(object->m_Flags & NxObject::mSKINNED) )
					{
						idx = p_mesh->m_VertStrip[v+vv].m_Index;
						vert = object->m_Verts + idx;
						index = get_pos( vert->m_Pos[0], vert->m_Pos[1], vert->m_Pos[2], vert->m_WeightedIndex[5] );
						if ( index < idx_min ) idx_min = index;
						if ( index > idx_max ) idx_max = index;
						if ( vert->m_Pos[1] < boty ) boty = vert->m_Pos[1];
					}
				}

				v += num;
			}
			if ( idx_max >= 65535 )
			{
				if ( ( idx_max - idx_min ) >= 65535 )
				{
					printf( "Cannot create DL with indices more than 65535 apart: %d", ( idx_max - idx_min ) );
					exit( 1234 );
				}
				idx_base = idx_min;
			}


			v = 0;
			while ( p_mesh->m_VertStrip[v].m_Index )
			{
				unsigned short num = p_mesh->m_VertStrip[v].m_Index;
				v++;
	
//				if( object->m_Flags & NxObject::mSKINNED )
//				{
//					GDBegin( GX_TRIANGLESTRIP, GX_VTXFMT1, num );
//				}
//				else
//				{
					switch ( p_mesh->m_Topology[NxMesh::vMAX_FACES-1][2] )
					{
						default:
						case 2:
							GDBegin( GX_TRIANGLESTRIP, GX_VTXFMT2, num );
							break;
						case 3:
							GDBegin( GX_TRIANGLESTRIP, GX_VTXFMT3, num );
							break;
						case 4:
							GDBegin( GX_TRIANGLESTRIP, GX_VTXFMT4, num );
							break;
						case 5:
							GDBegin( GX_TRIANGLESTRIP, GX_VTXFMT5, num );
							break;
						case 6:
							GDBegin( GX_TRIANGLESTRIP, GX_VTXFMT6, num );
							break;
						case 7:
							GDBegin( GX_TRIANGLESTRIP, GX_VTXFMT7, num );
							break;
					}
//				}

				unsigned int last_color = 0;
				for ( int vv = 0; vv < num; vv++ )
				{
					unsigned short idx;
					NxVertex* vert;


					// Position index.
					if( object->m_Flags & NxObject::mSKINNED )
					{
						idx = p_mesh->m_VertStrip[v+vv].m_Index;
						vert = object->m_Verts + idx;

						float x = vert->m_Pos[0];
						float y = vert->m_Pos[1];
						float z = vert->m_Pos[2];
						float nx = vert->m_Normal[0];
						float ny = vert->m_Normal[1];
						float nz = vert->m_Normal[2];
						float w0 = ( vert->m_NumWeights >= 1 ) ? vert->m_Weight[0] : 0.0f;
						float w1 = ( vert->m_NumWeights >= 2 ) ? vert->m_Weight[1] : 0.0f;
						float w2 = ( vert->m_NumWeights >= 3 ) ? vert->m_Weight[2] : 0.0f;
						int i0 = ( vert->m_NumWeights >= 1 ) ? vert->m_WeightedIndex[0] : 0; 
						int i1 = ( vert->m_NumWeights >= 2 ) ? vert->m_WeightedIndex[1] : 0; 
						int i2 = ( vert->m_NumWeights >= 3 ) ? vert->m_WeightedIndex[2] : 0; 

						int ridx = get_skin_pos( x, y, z, nx, ny, nz, w0, w1, w2, i0, i1, i2 );
						index = pRemapIndex[ridx];
//						printf( "\nSkin Remap: %2d %2d %2d %4d %4d %4d", i0, i1, i2, idx, ridx, index );
					}
					else
					{
						idx = p_mesh->m_VertStrip[v+vv].m_Index;
						vert = object->m_Verts + idx;
						index = get_pos( vert->m_Pos[0], vert->m_Pos[1], vert->m_Pos[2], vert->m_WeightedIndex[5] );
					}
					GDPosition1x16( ( index - idx_base ) );
					inum++;
					if ( index < p_min ) p_min = index;
					if ( index > p_max ) p_max = index;
					p_indices++;

					// Normal index.
					if( object->m_Flags & NxObject::mNORMALS )
					{
						if( !(object->m_Flags & NxObject::mSKINNED) )
						{
							// Calculate intersection of ray and sphere.
							// Realtime Rendering Second Edition, page 571.
							float ix = 0.0f;
							float iy = 0.0f;
							float iz = 0.0f;

							float ox = vert->m_Pos[0];
							float oy = vert->m_Pos[1];
							float oz = vert->m_Pos[2];
							float dx = vert->m_Normal[0];
							float dy = vert->m_Normal[1];
							float dz = vert->m_Normal[2];
//							float cx = obs[(i*4)+0];
//							float cy = obs[(i*4)+1];
//							float cz = obs[(i*4)+2];
							float r = obs[(i*4)+3] + ( 12.0f * 10.0f );		// 10 feet reflection.
							float cx = mbs[(ob_mesh*4)+0];
							float cy = mbs[(ob_mesh*4)+1];
							float cz = mbs[(ob_mesh*4)+2];
//							float r = mbs[(ob_mesh*4)+3] + ( 12.0f * 10.0f );		// 10 feet reflection.

							float lx = cx - ox;
							float ly = cy - oy;
							float lz = cz - oz;

							float s = ( lx * dx ) + ( ly * dy ) + ( lz * dz );

							float l2 = ( lx * lx ) + ( ly * ly ) + ( lz * lz );
							float r2 = r * r;

							float t = 0.0f;
							if ( !( ( s < 0.0f ) && ( l2 > r2 ) ) )
							{
								float m2 = l2 - ( s * s );

								if ( !( m2 > r2 ) )
								{
									float q = sqrtf( r2 - m2 );

									if ( l2 > r2 )
									{
										t = s - q;
									}
									else
									{
										t = s + q;
									}
									ix = ox + ( t * dx );
									iy = oy + ( t * dy );
									iz = oz + ( t * dz );
								}
							}

							// Calculate new normal (center of circle to intersection point).
							float nx = ix - cx;
							float ny = iy - cy;
							float nz = iz - cz;
							float len = sqrtf( ( nx * nx ) + ( ny * ny ) + ( nz * nz ) );
							float rlen = 1.0f / len;
							nx = nx * rlen;
							ny = ny * rlen;
							nz = nz * rlen;

////							s16 nx16 = (s16)( nx * (float)NORM_MUL );
////							s16 ny16 = (s16)( ny * (float)NORM_MUL );
////							s16 nz16 = (s16)( nz * (float)NORM_MUL );
//
//							s16 nx16 = (s16)( vert->m_Normal[0] * (float)NORM_MUL );
//							s16 ny16 = (s16)( vert->m_Normal[1] * (float)NORM_MUL );
//							s16 nz16 = (s16)( vert->m_Normal[2] * (float)NORM_MUL );
//
//							if ( get_nrm( nx16, ny16, nz16 ) == -1 )
//							{
//								printf( "\n*********** Bogus normal(?)" );
////								add_nrm( nx16, ny16, nz16 );
//							}

							if ( ( index = get_nrm( nx, ny, nz ) ) == -1 )
							{
								printf( "\n*********** Bogus normal(?) %8.3f %8.3f %8.3f object %d of %d", nx, ny, nz, i, num_objects );
//								add_nrm( nx, ny, nz );
							}
//							g_num_nrm++;

//							index = get_nrm( vert->m_Normal[0], vert->m_Normal[1], vert->m_Normal[2] );
						}
						GDNormal1x16( index );
					}

					// Color index.
					if( object->m_Flags & NxObject::mCOLORED )
					{
						if ( !(object->m_Flags & NxObject::mVCWIBBLE) || ( (object->m_Flags & NxObject::mVCWIBBLE) && vert->m_WibbleIndex == 0 ) )
						{
							// Use regular index to main pool.
							unsigned char r = (unsigned char) (( vert->m_Color[0] * 128.0f ) + 0.5f );
							unsigned char g = (unsigned char) (( vert->m_Color[1] * 128.0f ) + 0.5f );
							unsigned char b = (unsigned char) (( vert->m_Color[2] * 128.0f ) + 0.5f );
							unsigned char a = (unsigned char) (( vert->m_Color[3] * 128.0f ) + 0.5f );

							unsigned int color = ( r << 24 ) | ( g << 16 ) | ( b << 8 ) | a;

							index = get_col( color ) + g_wibble_cols;
						}
						else
						{
 //   						printf( "\n!!!WIBBLE!!! %d %d", ( vert->m_WibbleIndex - 1 ),  p_material->m_grassLayers );
							index = ( vert->m_WibbleIndex - 1 ) + p_material->m_grassLayers;
						}

						GDColor1x16( index );
						if ( p_material->m_grassify )
//						if ( worst >= WORST_TOL )
						{
							color2++;
							GDColor1x16( index );
						}
						if ( index < c_min ) c_min = index;
						if ( index > c_max ) c_max = index;
						c_indices++;
					}

					// Texture indices.
					for( tc = 0; tc < tex_passes; ++tc )
					{
						if ( p_material->m_Passes[tc].m_MappingMode == vMAPPING_ENVIRONMENT ) continue;
						unsigned int TexChecksum = p_material->m_Passes[tc].GetTextureChecksum( Utils::vPLATFORM_NGC );
						if ( GetTextureByChecksum( TexChecksum ) == 0 ) continue;

						short u, v;
						switch ( p_mesh->m_Topology[NxMesh::vMAX_FACES-1][2] )
						{
							default:
							case 2:
								u = (short)vert->m_TexCoord[tc][0];
								v = (short)vert->m_TexCoord[tc][1];
								break;
							case 3:
								u = (short)( vert->m_TexCoord[tc][0] * 4.0f );
								v = (short)( vert->m_TexCoord[tc][1] * 4.0f );
								break;
							case 4:
								u = (short)( vert->m_TexCoord[tc][0] * 16.0f );
								v = (short)( vert->m_TexCoord[tc][1] * 16.0f );
								break;
							case 5:
								u = (short)( vert->m_TexCoord[tc][0] * 64.0f );
								v = (short)( vert->m_TexCoord[tc][1] * 64.0f );
								break;
							case 6:
								u = (short)( vert->m_TexCoord[tc][0] * 256.0f );
								v = (short)( vert->m_TexCoord[tc][1] * 256.0f );
								break;
							case 7:
								u = (short)( vert->m_TexCoord[tc][0] * 1024.0f );
								v = (short)( vert->m_TexCoord[tc][1] * 1024.0f );
								break;
						}

						index = get_uv( u, v );
						GDTexCoord1x16( index );
						if ( index < t_min[tc] ) t_min[tc] = index;
						if ( index > t_max[tc] ) t_max[tc] = index;
						t_indices[tc]++;
					}
				}
				v += num;

				GDEnd();
			}
//			GDPadCurr32();
			GDFlushCurrToMem();

			if ( ( p_max - p_min ) < 255 )
			{
				g_p_indices8 += p_indices;
			}
			else
			{
				g_p_indices16 += p_indices;
			}

			if ( ( c_max - c_min ) < 255 )
			{
				g_c_indices8 += c_indices;
			}
			else
			{
				g_c_indices16 += c_indices;
			}

			for( tc = 0; tc < tex_passes; ++tc )
			{
				if ( ( t_max[tc] - t_min[tc] ) < 255 )
				{
					g_t_indices8 += t_indices[tc];
				}
				else
				{
					g_t_indices16 += t_indices[tc];
				}
			}

			// Header:
			// unsigned int size in bytes.
			// unsigned int material checksum.
			// unsigned int pos offset.
			// unsigned int clr offset.
			// unsigned int tex0 offset.
			// unsigned int tex1 offset.
			// unsigned int tex2 offset.
			// unsigned int tex3 offset.
			int size = ( GDGetCurrOffset() + 31 ) & ~31;

//			printf( "Output mesh: %d bytes\n", size );

//			// Calculate bounding sphere.
//			float _min[3];
//			float _max[3];
//			_min[0] = _min[1] = _min[2] = 9999999.0f;
//			_max[0] = _max[1] = _max[2] = -9999999.0f;
//
//			{
//				int v = 0;
//				while ( p_mesh->m_VertStrip[v].m_Index )
//				{
//					unsigned short num = p_mesh->m_VertStrip[v].m_Index;
//					v++;
//	
//					for ( int vv = 0; vv < num; vv++ )
//					{
//						unsigned short idx = p_mesh->m_VertStrip[v+vv].m_Index;
//	
//						NxVertex* vert = object->m_Verts + idx;
//	
//						for( int a = 0; a < 3; ++a )
//						{
//							if ( vert->m_Pos[a] < _min[a] ) _min[a] = vert->m_Pos[a];
//							if ( vert->m_Pos[a] > _max[a] ) _max[a] = vert->m_Pos[a];
//						}
//					}
//					v += num;
//				}
//			}
//
//			float center[3], diag[3];
//			float diag_length = 0.0f;
//			for( int a = 0; a < 3; ++a )
//			{
//				center[a] = ( _max[a] + _min[a] ) / 2;
//				diag[a] = ( _max[a] - _min[a] );
//				diag_length += ( diag[a] * diag[a] );
//			}
//			diag_length = sqrtf( diag_length );
//			float radius = diag_length / 2.0f;
//
//			printf( "\n    Old MeshBB: %8.3f %8.3f %8.3f %8.3f", center[0], center[1], center[2], radius );
//			printf( "\n        MeshBB: %8.3f %8.3f %8.3f %8.3f", mbs[(ob_mesh*4)+0], mbs[(ob_mesh*4)+1], mbs[(ob_mesh*4)+2], mbs[(ob_mesh*4)+3] );

			// Header.

			pGDFile->Write( (const char *)&size, 4, true );
			pGDFile->Write( (const char *)&p_mesh->m_MatChecksum, 4, true );
			pGDFile->Write( (const char *)&object->m_Flags, 4, true );
			pGDFile->Write( (const char *)&object->m_Checksum, 4, true );

			pGDFile->Write( (const char *)&mbs[(ob_mesh*4)+0], 4, true );
			pGDFile->Write( (const char *)&mbs[(ob_mesh*4)+1], 4, true );
			pGDFile->Write( (const char *)&mbs[(ob_mesh*4)+2], 4, true );
			pGDFile->Write( (const char *)&mbs[(ob_mesh*4)+3], 4, true );
			ob_mesh++;

			uint16 ioffset = (uint16)index_list_offset;
			uint16 istride = (uint16)stride;
			uint32 meshflags = (uint32)p_mesh->m_Flags | (uint32)p_mesh->m_ShadowFlags;

			pGDFile->Write( (const char *)&zero, 4, true );					// pointer to object header
			pGDFile->Write( (const char *)&ioffset, 2, true );				// Offset to index data.
			pGDFile->Write( (const char *)&istride, 2, true );				// Index stride.
			pGDFile->Write( (const char *)&inum, 2, true );					// Number of indices.
			pGDFile->Write( (const char *)&icoloff, 1, true );				// Color offset.
			pGDFile->Write( (const char *)&correctable, 1, true );			// Mesh is correctable?
			pGDFile->Write( (const char *)&m, 4, true );					// Local mesh index
			pGDFile->Write( (const char *)&size, 4, true );					// Original size (for CAS rebuliding)
			pGDFile->Write( (const char *)&boty, 4, true );
			pGDFile->Write( (const char *)&idx_base, 4, true );
			pGDFile->Write( (const char *)&meshflags, 4, true );

//			printf( "\nskin bytes %d %d %d %d", skinBytes, singleBytes, doubleBytes, addBytes );

//			pGDFile->Write( (const char *)&p_pos_offset, 2, true );
//			pGDFile->Write( (const char *)&p_clr_offset, 2, true );
//			pGDFile->Write( (const char *)&p_tex_offset[0], 2, true );
//			pGDFile->Write( (const char *)&p_tex_offset[1], 2, true );
//			pGDFile->Write( (const char *)&p_tex_offset[2], 2, true );
//			pGDFile->Write( (const char *)&p_tex_offset[3], 2, true );
//			pGDFile->Write( (const char *)&num_pos, 2, true );
//			pGDFile->Write( (const char *)&num_clr, 2, true );
//			pGDFile->Write( (const char *)&num_tex, 2, true );
//			pGDFile->Write( (const char *)&stride, 2, true );

			// Display list.
			pGDFile->Write( (const char *)gdbuffer, GDGetCurrOffset(), false );
			
			// Pad to 32 bytes.
			int pad_bytes = size - GDGetCurrOffset();
			while ( pad_bytes )
			{
				pGDFile->Write( (const char *)&zero, 1, false );
				pad_bytes--;
			}

//			printf( "\ndl size %d", size );




			// Build the CAS flags for this mesh.
			if(( object->m_Flags & NxObject::mSKINNED ) && ( num_verts >= 3 ))
			{
				int v = 0;
				while ( p_mesh->m_VertStrip[v].m_Index )
				{
					unsigned short num = p_mesh->m_VertStrip[v].m_Index;
					v++;

					unsigned int index0 = p_mesh->m_VertStrip[v+0].m_Index;
					unsigned int index1 = p_mesh->m_VertStrip[v+1].m_Index;

					for ( int vv = 2; vv < num; vv++ )
					{
						unsigned int index2 = p_mesh->m_VertStrip[v+vv].m_Index;

						// Only bother checking if this is a non-degenerate tri.
						if(( index0 != index1 ) && ( index0 != index2 ) && ( index1 != index2 ))
						{
							unsigned long cas_face_flags = p_mesh->FindCASFaceFlags( index0, index1, index2 );
							if( cas_face_flags > 0 )
							{
								// Store the mesh number and the three indices.
								if( !object->AddCASData( cas_face_flags, ( m << 16 ) | pRemapIndex[pShadowRemap[index0]], ( pRemapIndex[pShadowRemap[index1]] << 16 ) | pRemapIndex[pShadowRemap[index2]] ))
								{
									printf( "ERROR: Increase number of cas data from %d!\n", NxObject::vMAXCASDATA );
									return false;
								}
							}
						}
						index0 = index1;
						index1 = index2;
					}
					v += num;
				}			
			}

















		}
		if ( pRemapIndex ) delete pRemapIndex;
		if ( pRemapVertex ) delete pRemapVertex;
		if ( pShadowRemap ) delete pShadowRemap;

	}
	printf( "Counts: No correction: %d Correction: %d\n", no_correct_count, correct_count );
	


//	printf( "\nIndex report:" );
//	printf( "\nPositions: %5d 16 bit, %5d 8 bit, %5d total", g_p_indices16, g_p_indices8, g_p_indices16 + g_p_indices8 );
//	printf( "\nColors:    %5d 16 bit, %5d 8 bit, %5d total", g_c_indices16, g_c_indices8, g_c_indices16 + g_c_indices8 );
//	printf( "\nUVs:       %5d 16 bit, %5d 8 bit, %5d total", g_t_indices16, g_t_indices8, g_t_indices16 + g_t_indices8 );



	printf( "\nVertex data output: %d pos, %d col, %d uv %d nrm (%d,%d,%d,%d)", g_u_num_pos, g_u_num_col, g_u_num_uv, g_u_num_nrm, g_num_pos, g_num_col, g_num_uv, g_num_nrm );




//		// Write out GD display list.
//		for( int m = 0; m < num_meshes; ++m )
//		{
//			NxMesh * p_mesh = object->m_MeshList.m_Meshes[0][m];
//
//			// Prepare for GD export.
//			int tex_passes = 0;
//			if( object->m_Flags & NxObject::mTEXTURED )
//			{
//				NxMaterial * p_material = m_scene->GetMaterial( p_mesh->m_MatChecksum );
//				if( p_material )
//				{
//					if( p_material->m_NumPasses > tex_passes )
//					{
//						tex_passes = p_material->m_NumPasses;
//					}
//				}
//			}
//
//			// GD tests...
//#define GD_SIZE (1024*1024)
//			GDLObj	dl;
//			static char	gdbuffer[GD_SIZE];
//			GXVtxDescList desc[32];		// More than enough entries...
//			int dcount = 0;
//			u16 p_pos_offset;
//			u16 p_clr_offset;
//			u16 p_tex_offset[4];
//			u16 num_pos = num_verts;
//			u16 num_clr = num_verts;
//			u16 num_tex = num_verts;
//			
//			// Add positions.
//			desc[dcount].attr = GX_VA_POS;
//			desc[dcount].type = GX_INDEX16;
//			dcount++;
//
//			// Add colors.
//			if( object->m_Flags & NxObject::mCOLORED )
//			{
//				desc[dcount].attr = GX_VA_CLR0;
//				desc[dcount].type = GX_INDEX16;
//				dcount++;
//			}
//
//			// Add textures.
//			if( object->m_Flags & NxObject::mTEXTURED )
//			{
//				for ( int tc = 0; tc < tex_passes; tc++ )
//				{
//					desc[dcount].attr = (GXAttr)(((int)GX_VA_TEX0)+tc);
//					desc[dcount].type = GX_INDEX16;
//					dcount++;
//				}
//			}
//
//			// Terminate list.
//			desc[dcount].attr = GX_VA_NULL;
//			desc[dcount].type = GX_NONE;
//			dcount++;
//
//			// Setup GD object and initialize format/buffers.
//			GDInitGDLObj( &dl, gdbuffer, GD_SIZE );
//			GDSetCurrent( &dl );
//			GDSetVtxDescv( desc );
//
//			p_pos_offset = GDGetCurrOffset() + CP_DATA_OFFSET;
//			GDSetArrayRaw( GX_VA_POS, 0, 12 );		// NULL pos to be patched at runtime, stride of 12.
//
//			if( object->m_Flags & NxObject::mCOLORED )
//			{
//				p_clr_offset = GDGetCurrOffset() + CP_DATA_OFFSET;
//				GDSetArrayRaw( GX_VA_CLR0, 0, 4 );		// NULL pos to be patched at runtime, stride of 4.
//			}
//
//			p_tex_offset[0] = 0;
//			p_tex_offset[1] = 0;
//			p_tex_offset[2] = 0;
//			p_tex_offset[3] = 0;
//			if( object->m_Flags & NxObject::mTEXTURED )
//			{
//				for ( int tc = 0; tc < tex_passes; tc++ )
//				{
//					p_tex_offset[tc] = GDGetCurrOffset() + CP_DATA_OFFSET;
//					GDSetArrayRaw( (GXAttr)(((int)GX_VA_TEX0)+tc), 0, 8 );		// NULL pos to be patched at runtime, stride of 8.
//				}
//			}
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
////			// Checksum of the material for this mesh.
////			unsigned long mat_checksum = mesh->m_MatChecksum;
////
////			mesh->m_Flags |= mesh->m_ShadowFlags;			
////			mesh->SetWibbleFlags();
////			
////			// Write out the flags which describe the object's properties
//////			pOutputFile->Write((const char*) &mesh->m_Flags, sizeof( int ));
////			writeBig32( pOutputFile, &mesh->m_Flags );
////
////			float center[3];
////			float diag[3];
////			float diag_length = 0;
////			for( int i0 = 0; i0 < 3; i0++ )
////			{
////				center[i0] = ( object->m_BoundingBox.m_Max[i0] + object->m_BoundingBox.m_Min[i0] ) / 2;
////				diag[i0] = ( object->m_BoundingBox.m_Max[i0] - object->m_BoundingBox.m_Min[i0] );
////				diag_length += ( diag[i0] * diag[i0] );
////			}
////			diag_length = sqrtf( diag_length );
////			float radius = diag_length / 2.0f;
//////			pOutputFile->Write((const char*) &center, 3 * sizeof( float ));
//////			pOutputFile->Write((const char*) &radius, sizeof( float ));
////			writeBig32( pOutputFile, &center[0] );
////			writeBig32( pOutputFile, &center[1] );
////			writeBig32( pOutputFile, &center[2] );
////			writeBig32( pOutputFile, &radius );
////
////
////			// How many vertices in this strip.
////			int num_verts = mesh->m_NumStripVerts;
//////			pOutputFile->Write((const char*) &num_verts, sizeof( int ));
////			writeBig32( pOutputFile, &num_verts );
////			
//			int v = 0;
//			while ( p_mesh->m_VertStrip[v].m_Index )
//			{
//				unsigned short num = p_mesh->m_VertStrip[v].m_Index;
//				v++;
//	
//				GDBegin( GX_TRIANGLESTRIP, GX_VTXFMT0, num );
//
//				for ( int vv = 0; vv < num; vv++ )
//				{
//					unsigned short idx = pRemapIndex[p_mesh->m_VertStrip[v+vv].m_Index];
//
//					// Position index.
//					GDPosition1x16( idx );
//
//					// Color index.
//					if( object->m_Flags & NxObject::mCOLORED )
//					{
//						GDColor1x16( idx );
//					}
//
//					// Texture indices.
//					if( object->m_Flags & NxObject::mTEXTURED )
//					{
//						for ( int tc = 0; tc < tex_passes; tc++ )
//						{
//							GDTexCoord1x16( idx );
//						}
//					}
//				}
//				v += num;
//
//				GDEnd();
//			}	
//			GDFlushCurrToMem();
//
//			// Header:
//			// unsigned int size in bytes.
//			// unsigned int material checksum.
//			// unsigned int pos offset.
//			// unsigned int clr offset.
//			// unsigned int tex0 offset.
//			// unsigned int tex1 offset.
//			// unsigned int tex2 offset.
//			// unsigned int tex3 offset.
//			int size = ( GDGetCurrOffset() + 31 ) & ~31;
//			unsigned int zbuffer[8] = { 0, 0, 0, 0, 0, 0, 0, 0 };
//
////			printf( "\nDLSize: %4d (%2d), %3d, %3d", GDGetCurrOffset(), size - GDGetCurrOffset(), p_pos_offset, p_clr_offset );
//
//			// Header.
//			u16 dummy = 0;
//			pGDFile->Write( (const char *)&size, 4, true );
//			pGDFile->Write( (const char *)&p_mesh->m_MatChecksum, 4, true );
//			pGDFile->Write( (const char *)&tex_passes, 4, true );
//			pGDFile->Write( (const char *)&p_pos_offset, 2, true );
//			pGDFile->Write( (const char *)&p_clr_offset, 2, true );
//			pGDFile->Write( (const char *)&p_tex_offset[0], 2, true );
//			pGDFile->Write( (const char *)&p_tex_offset[1], 2, true );
//			pGDFile->Write( (const char *)&p_tex_offset[2], 2, true );
//			pGDFile->Write( (const char *)&p_tex_offset[3], 2, true );
//			pGDFile->Write( (const char *)&num_pos, 2, true );
//			pGDFile->Write( (const char *)&num_clr, 2, true );
//			pGDFile->Write( (const char *)&num_tex, 2, true );
//			pGDFile->Write( (const char *)&dummy, 2, true );
//
//			// Display list.
//			pGDFile->Write( (const char *)gdbuffer, GDGetCurrOffset(), false );
//			if ( (size - GDGetCurrOffset()) ) pGDFile->Write( (const char *)zbuffer, size - GDGetCurrOffset(), false );
//		}
//
//
//
//
//
////		unsigned int size = GDGetCurrLength();
////		pGDFile->Write( (const char *)&size, 4, true );
////		pGDFile->Write( (const char *)GDGetCurrStart(), size, false );
//
////		writeBig16( pGDFile, &idx );
//	}	
// 
//	

//	// Write out hierarchy data, if any
//	int num_hierarchy_objects = m_scene->m_Model.nBones;
//	assert(num_hierarchy_objects < 256);
//	writeBig32( pOutputFile, &num_hierarchy_objects );
//
//	for (uint8 bone_idx = 0; bone_idx < num_hierarchy_objects; bone_idx++) {
//		uint32 cur_checksum = m_scene->m_Model.bones[bone_idx].crc;
//		uint32 parent_checksum;
//		NxObject *p_cur_object = m_scene->FindObject(cur_checksum);
//		int16 parent_index = -1;
//		//NxObject *p_parent_object = NULL;
//
//		assert(p_cur_object);
//		parent_checksum = p_cur_object->m_ParentCRC;
//		if (parent_checksum)
//		{
//			//p_parent_object = m_scene->FindObject(parent_checksum);
//			//assert(p_parent_object);
//		
//			// Find parent index
//			for (int i = 0; i < num_hierarchy_objects; i++)
//			{
//				if (parent_checksum == m_scene->m_Model.bones[i].crc)
//				{
//					parent_index = i;
//					break;
//				}
//			}
//
//			assert(parent_index >= 0);
//		}
//
//		// Write the data
//		writeBig32( pOutputFile, &cur_checksum );
//		writeBig32( pOutputFile, &parent_checksum );
//		writeBig16( pOutputFile, &parent_index );
//		pOutputFile->Write((const char*) &bone_idx, sizeof( char ));
//
//		// Padding
//		uint32 pad = 0;
//		pOutputFile->Write((const char*) &pad, sizeof( char ));
//		pOutputFile->Write((const char*) &pad, sizeof( int ));
//
//		// Write the matrix
//		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[0] );
//		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[1] );
//		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[2] );
//		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[3] );
//		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[4] );
//		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[5] );
//		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[6] );
//		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[7] );
//		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[8] );
//		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[9] );
//		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[10] );
//		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[11] );
//		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[12] );
//		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[13] );
//		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[14] );
//		writeBig32( pOutputFile, &((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[15] );
//
//#if 0
//		printf("Bone %d\n", bone_idx);
//		printf("Checksum %x\n", cur_checksum);
//		printf("Parent Checksum %x\n", parent_checksum);
//		printf("Parent Index %x\n", parent_index);
//		Mth::Matrix mat = m_scene->m_Model.bones[bone_idx].mat;
//		printf("[ %f %f %f %f]\n", mat[0][0], mat[0][1], mat[0][2], mat[0][3]);
//		printf("[ %f %f %f %f]\n", mat[1][0], mat[1][1], mat[1][2], mat[1][3]);
//		printf("[ %f %f %f %f]\n", mat[2][0], mat[2][1], mat[2][2], mat[2][3]);
//		printf("[ %f %f %f %f]\n", mat[3][0], mat[3][1], mat[3][2], mat[3][3]);
//#endif
//	}

	// Write out hierarchy data, if any
	int num_hierarchy_objects = m_scene->m_Model.nBones;
	assert(num_hierarchy_objects < 256);
	pGDFile->Write( (const char *)&num_hierarchy_objects, 4, true );

	for (uint8 bone_idx = 0; bone_idx < num_hierarchy_objects; bone_idx++) {
		uint32 cur_checksum = m_scene->m_Model.bones[bone_idx].crc;
		uint32 parent_checksum;
		NxObject *p_cur_object = m_scene->FindObject(cur_checksum);
		int16 parent_index = -1;
		//NxObject *p_parent_object = NULL;

		assert(p_cur_object);
		parent_checksum = p_cur_object->m_ParentCRC;
		if (parent_checksum)
		{
			//p_parent_object = m_scene->FindObject(parent_checksum);
			//assert(p_parent_object);
		
			// Find parent index
			for (int i = 0; i < num_hierarchy_objects; i++)
			{
				if (parent_checksum == m_scene->m_Model.bones[i].crc)
				{
					parent_index = i;
					break;
				}
			}

			assert(parent_index >= 0);
		}

		// Write the data
		pGDFile->Write( (const char *)&cur_checksum, 4, true );
		pGDFile->Write( (const char *)&parent_checksum, 4, true );
		pGDFile->Write( (const char *)&parent_index, 2, true );
		pGDFile->Write( (const char *)&bone_idx, 1, true );

		// Padding
		uint32 pad = 0;
		pGDFile->Write( (const char *)&pad, 1, true );
		pGDFile->Write( (const char *)&pad, 4, true );

		// Write the matrix
		pGDFile->Write( (const char *)&((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[0] , 4, true );
		pGDFile->Write( (const char *)&((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[1] , 4, true );
		pGDFile->Write( (const char *)&((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[2] , 4, true );
		pGDFile->Write( (const char *)&((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[3] , 4, true );
		pGDFile->Write( (const char *)&((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[4] , 4, true );
		pGDFile->Write( (const char *)&((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[5] , 4, true );
		pGDFile->Write( (const char *)&((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[6] , 4, true );
		pGDFile->Write( (const char *)&((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[7] , 4, true );
		pGDFile->Write( (const char *)&((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[8] , 4, true );
		pGDFile->Write( (const char *)&((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[9] , 4, true );
		pGDFile->Write( (const char *)&((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[10], 4, true );
		pGDFile->Write( (const char *)&((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[11], 4, true );
		pGDFile->Write( (const char *)&((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[12], 4, true );
		pGDFile->Write( (const char *)&((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[13], 4, true );
		pGDFile->Write( (const char *)&((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[14], 4, true );
		pGDFile->Write( (const char *)&((unsigned int *)&m_scene->m_Model.bones[bone_idx].mat)[15], 4, true );

#if 0
		printf("Bone %d\n", bone_idx);
		printf("Checksum %x\n", cur_checksum);
		printf("Parent Checksum %x\n", parent_checksum);
		printf("Parent Index %x\n", parent_index);
		Mth::Matrix mat = m_scene->m_Model.bones[bone_idx].mat;
		printf("[ %f %f %f %f]\n", mat[0][0], mat[0][1], mat[0][2], mat[0][3]);
		printf("[ %f %f %f %f]\n", mat[1][0], mat[1][1], mat[1][2], mat[1][3]);
		printf("[ %f %f %f %f]\n", mat[2][0], mat[2][1], mat[2][2], mat[2][3]);
		printf("[ %f %f %f %f]\n", mat[3][0], mat[3][1], mat[3][2], mat[3][3]);
#endif
	}

	if ( obs ) delete obs;
	if ( mbs ) delete mbs;

	int lp;
	for ( lp = 0; lp < total_mesh_groups; lp++ )
	{
		if ( pp_mesh[lp]->verts ) delete pp_mesh[lp]->verts;
		if ( pp_mesh[lp]->faces ) delete pp_mesh[lp]->faces;
		delete pp_mesh[lp];
		delete mesh_matrix[lp];
	}
	if ( pp_mesh ) delete pp_mesh;
	if ( mesh_matrix ) delete mesh_matrix;
	if ( num_mesh ) delete num_mesh;

	if ( mesh->verts ) delete mesh->verts;
	if ( mesh->faces ) delete mesh->faces;
	if ( mesh ) delete mesh;

//	if ( num_objects )
//	{
//		delete [] p_object_remap;
//		delete [] added;
//	}

	printf( "\nNum 2nd color indices: %d", color2 );

	return true;
}

bool GameCubeConverter::SaveMaterials( IoUtils::CVirtualOutputFile* pOutputFile )
{
	Lst::Search< NxMaterial > sh;
	NxMaterial* material;

	int num_materials = m_scene->m_Materials.CountItems();
//	pOutputFile->Write((const char*) &num_materials, sizeof( int ));
	writeBig32( pOutputFile, &num_materials );
	for( material = sh.FirstItem( m_scene->m_Materials ); material;	material = sh.NextItem())
	{
		int		num_sequences, mmag, mmin;
		__int64	equation;

		// Write out material checksum.
//		pOutputFile->Write((const char*) &material->m_Checksum, sizeof( unsigned long ));
		writeBig32( pOutputFile, &material->m_Checksum );

		// Write out how many passes this material contains.
//		pOutputFile->Write((const char*) &material->m_NumPasses, sizeof( unsigned long ));
		writeBig32( pOutputFile, &material->m_NumPasses );
		
		// Write out the alpha cutoff value.
//		pOutputFile->Write((const char*)&material->m_AlphaCutoff, sizeof( int ));
		writeBig32( pOutputFile, &material->m_AlphaCutoff );
		//printf( "Alpha cutoff: %d\n", material->m_AlphaCutoff );

		// Write out the sorted flag.
//		pOutputFile->Write((const char*)&material->m_Sorted, sizeof( bool ));
		writeBig32( pOutputFile, &material->m_Sorted );
		
		// Write out the draw order.
//		pOutputFile->Write((const char*)&material->m_DrawOrder, sizeof( float ));
		writeBig32( pOutputFile, &material->m_DrawOrder );
		
		// Write out the backface cull flag.
//		pOutputFile->Write((const char*)&material->m_TwoSided, sizeof( bool ));
		writeBig32( pOutputFile, &material->m_TwoSided );

		// Write out the grassify information.
//		writeBig32( pOutputFile, &material->m_grassify );
//		if( material->m_grassify )
//		{
//			writeBig32( pOutputFile, &material->m_grassHeight );
//			writeBig32( pOutputFile, &material->m_grassLayers );
//		}
//
		// Write out the texture checksum and flags of each pass (and collate texture flags at the same time).		
		for( int p = 0; p < material->m_NumPasses; ++p )
		{
			unsigned long tex_checksum;

			tex_checksum = material->m_Passes[p].GetTextureChecksum( Utils::vPLATFORM_NGC );
//			pOutputFile->Write((const char*) &material->m_Passes[p].m_TexChecksum[Utils::vPLATFORM_NGC], sizeof( unsigned long ));
			writeBig32( pOutputFile, &tex_checksum );
		
			int flags = 0;
			if( tex_checksum != 0 )
			{
				flags |= NxMaterial::mTEXTURED;
			}
			if( material->m_Passes[p].m_MappingMode == vMAPPING_ENVIRONMENT )
			{
				flags |= NxMaterial::mENVIRONMENT;
			}
			if( material->m_Passes[p].m_UVWibbleEnabled )
			{
				flags |= NxMaterial::mUV_WIBBLE;
			}
			if( material->m_GroupFlags & NxMaterial::mGROUP_TRANSPARENT )
			{
				flags |= NxMaterial::mTRANSPARENT;
			}
			if(( p == 0 ) && ( material->m_WibbleSequences.CountItems() > 0 ))
			{
				flags |= NxMaterial::mVC_WIBBLE;
			}
			if( material->m_Passes[p].m_Flags & NxMaterialPass::COLOR_LOCKED )
			{
				// Hmm, really should be using a per-pass flag here.
				flags |= 0x80;
			}

			// For now, everything is smooth.
			flags |= NxMaterial::mSMOOTH;
//			pOutputFile->Write((const char*)&flags, sizeof( int ));
			writeBig32( pOutputFile, &flags );

			// Write out ngc alpha-blending params.
			equation = GetBlendParameters( material->m_Passes[p].m_BlendMode, material->m_Passes[p].m_FixedAlpha );
//			pOutputFile->Write((const char*)&equation, sizeof( __int64 ));
			writeBig64( pOutputFile, &equation );
			
//			pOutputFile->Write((const char*)&material->m_Passes[p].m_AddressModeU, sizeof( int ));
//			pOutputFile->Write((const char*)&material->m_Passes[p].m_AddressModeV, sizeof( int ));
			writeBig32( pOutputFile, &material->m_Passes[p].m_AddressModeU );
			writeBig32( pOutputFile, &material->m_Passes[p].m_AddressModeV );
			
			// Write out surface properties of the material
//			pOutputFile->Write((const char*)&material->m_Passes[p].m_Diffuse[0], sizeof( float ));
//			pOutputFile->Write((const char*)&material->m_Passes[p].m_Diffuse[1], sizeof( float ));
//			pOutputFile->Write((const char*)&material->m_Passes[p].m_Diffuse[2], sizeof( float ));
//			pOutputFile->Write((const char*)&material->m_Passes[p].m_Specular[0], sizeof( float ));
//			pOutputFile->Write((const char*)&material->m_Passes[p].m_Specular[1], sizeof( float ));
//			pOutputFile->Write((const char*)&material->m_Passes[p].m_Specular[2], sizeof( float ));
//			pOutputFile->Write((const char*)&material->m_Passes[p].m_Ambient[0], sizeof( float ));
//			pOutputFile->Write((const char*)&material->m_Passes[p].m_Ambient[1], sizeof( float ));
//			pOutputFile->Write((const char*)&material->m_Passes[p].m_Ambient[2], sizeof( float ));

			writeBig32( pOutputFile, &material->m_Passes[p].m_Color[0] );
			writeBig32( pOutputFile, &material->m_Passes[p].m_Color[1] );
			writeBig32( pOutputFile, &material->m_Passes[p].m_Color[2] );
//			writeBig32( pOutputFile, &material->m_Passes[p].m_Diffuse[0] );
//			writeBig32( pOutputFile, &material->m_Passes[p].m_Diffuse[1] );
//			writeBig32( pOutputFile, &material->m_Passes[p].m_Diffuse[2] );
			writeBig32( pOutputFile, &material->m_Passes[p].m_Specular[0] );
			writeBig32( pOutputFile, &material->m_Passes[p].m_Specular[1] );
			writeBig32( pOutputFile, &material->m_Passes[p].m_Specular[2] );
			writeBig32( pOutputFile, &material->m_Passes[p].m_Ambient[0] );
			writeBig32( pOutputFile, &material->m_Passes[p].m_Ambient[1] );
			writeBig32( pOutputFile, &material->m_Passes[p].m_Ambient[2] );
		
			// Write out UV wibble params
			if( flags & NxMaterial::mUV_WIBBLE )
			{
//				pOutputFile->Write((const char*)&material->m_Passes[p].m_UVel, sizeof( float ));
//				pOutputFile->Write((const char*)&material->m_Passes[p].m_VVel, sizeof( float ));
//				pOutputFile->Write((const char*)&material->m_Passes[p].m_UFrequency, sizeof( float ));
//				pOutputFile->Write((const char*)&material->m_Passes[p].m_VFrequency, sizeof( float ));
//				pOutputFile->Write((const char*)&material->m_Passes[p].m_UAmplitude, sizeof( float ));
//				pOutputFile->Write((const char*)&material->m_Passes[p].m_VAmplitude, sizeof( float ));
//				pOutputFile->Write((const char*)&material->m_Passes[p].m_UPhase, sizeof( float ));
//				pOutputFile->Write((const char*)&material->m_Passes[p].m_VPhase, sizeof( float ));
				writeBig32( pOutputFile, &material->m_Passes[p].m_UVel );
				writeBig32( pOutputFile, &material->m_Passes[p].m_VVel );
				writeBig32( pOutputFile, &material->m_Passes[p].m_UFrequency );
				writeBig32( pOutputFile, &material->m_Passes[p].m_VFrequency );
				writeBig32( pOutputFile, &material->m_Passes[p].m_UAmplitude );
				writeBig32( pOutputFile, &material->m_Passes[p].m_VAmplitude );
				writeBig32( pOutputFile, &material->m_Passes[p].m_UPhase );
				writeBig32( pOutputFile, &material->m_Passes[p].m_VPhase );
			}
		
			// Write out VC wibble sequences
			if(( p == 0 ) && ( flags & NxMaterial::mVC_WIBBLE ))
			{
				num_sequences = material->m_WibbleSequences.CountItems();
//				pOutputFile->Write((const char*) &num_sequences, sizeof( int ));
				writeBig32( pOutputFile, &num_sequences );

				if( num_sequences > 0 )
				{
					Lst::Search< VCWibbleSequence > sh;
					VCWibbleSequence *p_sequence;

					for( p_sequence = sh.FirstItem( material->m_WibbleSequences ); p_sequence; p_sequence = sh.NextItem())
					{
//						int num_keys = p_sequence->m_NumFrames;
////						pOutputFile->Write((const char*)&num_keys, sizeof( int ));
//						writeBig32( pOutputFile, &num_keys );

						writeBig32( pOutputFile, &p_sequence->m_NumFrames );
						writeBig32( pOutputFile, &p_sequence->m_Phase );
						
						for( int k = 0; k < p_sequence->m_NumFrames; ++k )
						{
							int time = p_sequence->m_WibbleFrames[k].m_Time;
//							pOutputFile->Write((const char*)&time, sizeof( int ));
							writeBig32( pOutputFile, &time );

							unsigned int color;

							color	= (unsigned int)( p_sequence->m_WibbleFrames[k].m_Color[0] * 128.0f );
							color	|= ((unsigned int)( p_sequence->m_WibbleFrames[k].m_Color[1] * 128.0f )) << 8;
							color	|= ((unsigned int)( p_sequence->m_WibbleFrames[k].m_Color[2] * 128.0f )) << 16;
							color	|= ((unsigned int)( p_sequence->m_WibbleFrames[k].m_Color[3] * 128.0f )) << 24;
							
//							pOutputFile->Write((const char*)&color, sizeof( unsigned int ));
							writeBig32( pOutputFile, &color );
						}
					}
				}
			}
		
			// Write out MMAG and MMIN		
			mmag = (int) material->m_Passes[p].m_MagFilteringMode;
			mmin = (int) material->m_Passes[p].m_MinFilteringMode;
//			pOutputFile->Write((const char*) &mmag, sizeof( int ));
//			pOutputFile->Write((const char*) &mmin, sizeof( int ));
			writeBig32( pOutputFile, &mmag );
			writeBig32( pOutputFile, &mmin );

			// Write out K and L		
//			pOutputFile->Write((const char*) &material->m_Passes[p].m_MipMapK, sizeof( float ));
//			pOutputFile->Write((const char*) &material->m_Passes[p].m_MipMapK, sizeof( float ));
			writeBig32( pOutputFile, &material->m_Passes[p].m_MipMapK );
			writeBig32( pOutputFile, &material->m_Passes[p].m_MipMapK );
//			pOutputFile->Write((const char*) &material->m_Passes[p].m_MipMapL, sizeof( float ));
		}
	}
	return true;
}


unsigned int GameCubeConverter::CalculateMaterialBytes2( void )
{
	Lst::Search< NxMaterial > sh;
	NxMaterial* material;

	unsigned int Bytes = 0;

	g_wibble_cols = 0;

	for( material = sh.FirstItem( m_scene->m_Materials ); material;	material = sh.NextItem())
	{
		unsigned short	NumPasses	= (unsigned short)material->m_NumPasses;
		unsigned short	VCCount		= material->m_WibbleSequences.CountItems();

		// Header.
		Bytes += 32;

		// Per pass header data.
		Bytes += 32 * material->m_NumPasses;

		// Per pass uv wibble data.
		for( int p = 0; p < material->m_NumPasses; ++p )
		{
			// Write out UV wibble params
			if( material->m_Passes[p].m_UVWibbleEnabled )
			{
				Bytes += 32;
			}
		}

		// VC Wibble.
		if( VCCount )
		{
			Lst::Search< VCWibbleSequence > sh;
			VCWibbleSequence *p_sequence;

			//Bytes += (4*2);

			// Allocate & assign wibble space.
			material->m_grassLayers = g_wibble_cols;
			g_wibble_cols += VCCount;

			for( p_sequence = sh.FirstItem( material->m_WibbleSequences ); p_sequence; p_sequence = sh.NextItem())
			{
				Bytes += (4*2);

				for( int k = 0; k < p_sequence->m_NumFrames; ++k )
				{
					Bytes += (4*2);
				}
			}
		}
	}

	return Bytes;
}

bool GameCubeConverter::SaveMaterials2( IoUtils::CVirtualOutputFile* pGDFile, bool skinned )
{
	Lst::Search< NxMaterial > sh;
	NxMaterial* material;
	int p;
	const int zero = 0;

	// Build unique display lists.
	void *			p_dl[2048];
	int				dl_size[2048];
//	int				tevs[2048];
//	int				texgens[2048];

//	NxMaterial *	p_u_mat[2048];
	uint16			num_u_mat = 0;

	uint8			use_dl[4096];		// Track which materials use which DL

	void *			p_tex_dl[4096];		// Texture DL.
	int				tex_dl_size[4096];
	int16			dl_tex_off[4096][4];
	int16			dl_alpha_off[4096][4];

	int size;

	int cur_mat;
//	bool matched;

	for( cur_mat = 0, material = sh.FirstItem( m_scene->m_Materials ); material; cur_mat++, material = sh.NextItem() )
	{
		// Need to construct header & pass information for DL builder.
		NxNgc::sMaterialHeader		mat;
		NxNgc::sMaterialPassHeader	pass[4];

		{
			mat.m_passes = (uint8)material->m_NumPasses;

			mat.m_alpha_cutoff = (uint8)material->m_AlphaCutoff;
			mat.m_alpha_cutoff = mat.m_alpha_cutoff >= 128 ? 255 : mat.m_alpha_cutoff * 2;

			mat.m_flags = 0;
			mat.m_flags |= material->m_Sorted	? (1<<0) : 0;
			mat.m_flags |= material->m_TwoSided	? (1<<1) : 0;
			mat.m_flags |= material->m_OneSided	? (1<<2) : 0;
			// 3, 4 & 5 are used at runtime.
			mat.m_flags |= material->m_grassify ? (1<<6) : 0;
			mat.m_flags |= ( material->m_Passes[0].m_Flags & NxMaterialPass::UNLIT ) ? (1<<7) : 0;

			mat.m_shininess = material->m_SpecularPower;

			mat.m_specular_color.r = (u8)((material->m_SpecularColor[0] * 128.0f) + 0.5f);
			mat.m_specular_color.g = (u8)((material->m_SpecularColor[1] * 128.0f) + 0.5f);
			mat.m_specular_color.b = (u8)((material->m_SpecularColor[2] * 128.0f) + 0.5f);
			mat.m_specular_color.a = 255;

//			printf( "\nMat: %3d: Pass: %d", cur_mat, material->m_NumPasses );

//			if ( ( cur_mat == 532 ) || ( cur_mat == 148 ) ) printf( "\nMat %4d: Pass: %d", cur_mat, material->m_NumPasses );
		}

		for ( int p = 0; p < material->m_NumPasses; p++ )
		{
			unsigned int TexChecksum = material->m_Passes[p].GetTextureChecksum( Utils::vPLATFORM_NGC );
			__int64 equation = GetBlendParameters( material->m_Passes[p].m_BlendMode, material->m_Passes[p].m_FixedAlpha );

			pass[p].m_texture.p_data = GetTextureByChecksum( TexChecksum );

			pass[p].m_flags = 0;
			if( TexChecksum != 0 )														pass[p].m_flags |= (1<<0);
			if( material->m_Passes[p].m_MappingMode == vMAPPING_ENVIRONMENT )   		pass[p].m_flags |= (1<<1);
			if( material->m_Passes[p].m_UVWibbleEnabled )								pass[p].m_flags |= (1<<2);
			if( material->m_GroupFlags & NxMaterial::mGROUP_TRANSPARENT )				pass[p].m_flags |= (1<<3);
			if( material->m_Passes[p].m_Flags & NxMaterialPass::COLOR_LOCKED )			pass[p].m_flags |= (1<<4);
			if( material->m_Passes[p].m_AddressModeU )									pass[p].m_flags |= (1<<5);
			if( material->m_Passes[p].m_AddressModeV )									pass[p].m_flags |= (1<<6);
			if( material->m_Passes[p].m_Flags & NxMaterialPass::IGNORE_VERTEX_ALPHA )	pass[p].m_flags |= (1<<7);

			pass[p].m_filter = ( material->m_Passes[p].m_MagFilteringMode << 4 ) | material->m_Passes[p].m_MagFilteringMode;

			pass[p].m_blend_mode = (unsigned char)equation;

			pass[p].m_alpha_fix = (unsigned char)material->m_Passes[p].m_FixedAlpha; 

			float k = material->m_Passes[p].m_MipMapK + 8.0f;
			if( k > 0.0f ) k = 0.0f;
			pass[p].m_k = (short)( k * ((float)(1<<8)) );
//			printf( "\nPass %d: Mip K %8.3f", p, material->m_Passes[p].m_MipMapK );

			pass[p].m_color.r = (u8)((material->m_Passes[p].m_Color[0] * 255.0f) + 0.5f);
			pass[p].m_color.g = (u8)((material->m_Passes[p].m_Color[1] * 255.0f) + 0.5f);
			pass[p].m_color.b = (u8)((material->m_Passes[p].m_Color[2] * 255.0f) + 0.5f);
			pass[p].m_color.a = 255;	//(u8)material->m_Passes[p].m_FixedAlpha;

//			if ( ( cur_mat == 532 ) || ( cur_mat == 148 ) ) printf( "\n          Pass %d: RGBA %02x %02x %02x %02x Flags: %02x Check: %08x Addr: %08x", p, pass[p].m_color.r, pass[p].m_color.g, pass[p].m_color.b, pass[p].m_color.a, pass[p].m_flags, TexChecksum, (uint32)pass[p].m_texture.p_data );
		
//			printf( " Pass %d: Blend: %2d", p, pass[p].m_blend_mode );

			// Check for illegal blend modes.
			if ( p == 0 )
			{
				if ( pass[p].m_blend_mode == vBLEND_MODE_BLEND_PREVIOUS_MASK )
				{
					pass[p].m_blend_mode = vBLEND_MODE_BLEND_FIXED;
					pass[p].m_alpha_fix = 255;
				}
				if ( pass->m_blend_mode == vBLEND_MODE_BLEND_INVERSE_PREVIOUS_MASK )
				{
					pass[p].m_blend_mode = vBLEND_MODE_BLEND_FIXED;
					pass[p].m_alpha_fix = 0;
				}
			}
		}

//		// Construct the blend DL.
//		memset( gdbuffer, 0, GD_SIZE );
//		GX::begin( gdbuffer, GD_SIZE );
//		NxNgc::multi_mesh( &mat, pass, true, false );
//		size = GX::end();
//
//		// See if this matches an already constructed one.
//		matched = false;
//		for ( int lp = 0; lp < num_u_mat; lp++ )
//		{
//			if ( size == dl_size[lp] )
//			{
//				bool same = true;
//				for ( int cc = 0; cc < size; cc++ )
//				{
//					if ( ((char*)gdbuffer)[cc] != ((char*)p_dl[lp])[cc] )
//					{
//						same = false;
//						break;
//					}
//				}
//				if ( same )
//				{
//					matched = true;
//					use_dl[cur_mat] = (uint8)lp;
//					break;
//				}
//			}
//		}
//
//		if ( !matched )
//		{
//			p_dl[num_u_mat] = new char[size];
//			memcpy( p_dl[num_u_mat], gdbuffer, size );
//			dl_size[num_u_mat] = size;
//	
//			use_dl[cur_mat] = (uint8)num_u_mat;
//			num_u_mat++;
//		}
		use_dl[cur_mat] = 0;

		// Always construct the texture DL.
		memset( gdbuffer, 0, GD_SIZE );
		GX::begin( gdbuffer, GD_SIZE );
//		NxNgc::multi_mesh( &mat, pass, true/*false*/, true, material->m_grassify, ( skinned ? false : true ) );
		NxNgc::multi_mesh( &mat, pass, true/*false*/, true, false, ( skinned ? false : true ) );
		size = GX::end();

//		material->m_water = false;
//		if ( g_num_tex >= 8 )
//		{
//			// Need to reload color texture after this material.
//			material->m_water = true;
//		}
//
//		// Too many textures! Redo without grassify.
//		if ( material->m_grassify && ( g_num_tex >= 8 ) )
//		{
//			material->m_grassify = false;
//			memset( gdbuffer, 0, GD_SIZE );
//			GX::begin( gdbuffer, GD_SIZE );
//			NxNgc::multi_mesh( &mat, pass, true/*false*/, true, material->m_grassify, ( skinned ? false : true ) );
//			size = GX::end();
//		}

		p_tex_dl[cur_mat] = new char[size];
		memcpy( p_tex_dl[cur_mat], gdbuffer, size );
		tex_dl_size[cur_mat] = size;

		dl_tex_off[cur_mat][0] = g_tex_off[0];
		dl_tex_off[cur_mat][1] = g_tex_off[1];
		dl_tex_off[cur_mat][2] = g_tex_off[2];
		dl_tex_off[cur_mat][3] = g_tex_off[3];

		dl_alpha_off[cur_mat][0] = g_alpha_off[0];
		dl_alpha_off[cur_mat][1] = g_alpha_off[1];
		dl_alpha_off[cur_mat][2] = g_alpha_off[2];
		dl_alpha_off[cur_mat][3] = g_alpha_off[3];

//		printf( "\nTex Off: %3d %3d %3d %3d Alpha Off: %3d %3d %3d %3d %08x %08x %08x %08x %d", g_tex_off[0], g_tex_off[1], g_tex_off[2], g_tex_off[3], g_alpha_off[0], g_alpha_off[1], g_alpha_off[2], g_alpha_off[3], pass[0].m_texture.checksum, pass[1].m_texture.checksum, pass[2].m_texture.checksum, pass[3].m_texture.checksum, mat.m_passes );
	}

	printf( "\nBlend Mode DLs: %d ...", num_u_mat );

	int num_tex_dl = cur_mat;

	// Calculate number of vc wibbles.
	// Calculate number of uv wibbles.
	// Calculate number of pass structures.
	uint16 vc_wibbles = 0;
	uint16 uv_wibbles = 0;
	uint16 pass_items = 0;
	for( cur_mat = 0, material = sh.FirstItem( m_scene->m_Materials ); material; cur_mat++, material = sh.NextItem() )
	{
		unsigned short	VCCount		= material->m_WibbleSequences.CountItems();

		// VC wibbles.
		if( VCCount )
		{
			Lst::Search< VCWibbleSequence > sh;
			VCWibbleSequence *p_sequence;

			for( p_sequence = sh.FirstItem( material->m_WibbleSequences ); p_sequence; p_sequence = sh.NextItem())
			{
				++vc_wibbles;
			}
		}

		// UV wibbles.
		for( p = 0; p < material->m_NumPasses; ++p )
		{
			if( material->m_Passes[p].m_UVWibbleEnabled )
			{
				++uv_wibbles;
			}
		}

		// Pass items.
		pass_items += material->m_NumPasses;
	}

	// Finish writing main header.
	pGDFile->Write( (const char *)&num_u_mat,			2, true );
	pGDFile->Write( (const char *)&vc_wibbles,			2, true );
	pGDFile->Write( (const char *)&uv_wibbles,			2, true );
	pGDFile->Write( (const char *)&pass_items,			2, true );
//	printf( "\nunique mats: %d", num_u_mat );

//	// Write display lists.
//	for ( int mat = 0; mat < num_u_mat; mat++ )
//	{
//		pGDFile->Write( (const char *)&dl_size[mat],	4, true );
//		pGDFile->Write( (const char *)&tevs[mat],		4, true );
//		pGDFile->Write( (const char *)&texgens[mat],	4, true );
//		pGDFile->Write( (const char *)&zero,			4, true );
//		pGDFile->Write( (const char *)&zero,			4, true );
//		pGDFile->Write( (const char *)&zero,			4, true );
//		pGDFile->Write( (const char *)&zero,			4, true );
//		pGDFile->Write( (const char *)&zero,			4, true );
//	}

	// Write blend display list sizes.
	for ( int mat = 0; mat < num_u_mat; mat++ )
	{
		pGDFile->Write( (const char *)&dl_size[mat],	4, true );
		pGDFile->Write( (const char *)&zero,			4, true );
	}
	// Write texture display list sizes. Note: same count as num_materials.
	for ( int tex = 0; tex < num_tex_dl; tex++ )
	{
//		printf( "\nTexDL Size; %d %d", tex, tex_dl_size[tex] );
		pGDFile->Write( (const char *)&tex_dl_size[tex],	4, true );
		pGDFile->Write( (const char *)&zero,				4, true );

		pGDFile->Write( (const char *)&dl_tex_off[tex][0],		2, true );
		pGDFile->Write( (const char *)&dl_tex_off[tex][1],		2, true );
		pGDFile->Write( (const char *)&dl_tex_off[tex][2],		2, true );
		pGDFile->Write( (const char *)&dl_tex_off[tex][3],		2, true );
		pGDFile->Write( (const char *)&dl_alpha_off[tex][0],	2, true );
		pGDFile->Write( (const char *)&dl_alpha_off[tex][1],	2, true );
		pGDFile->Write( (const char *)&dl_alpha_off[tex][2],	2, true );
		pGDFile->Write( (const char *)&dl_alpha_off[tex][3],	2, true );
	}

	// Pad to 32 bytes.
	int bytes = ( num_u_mat * 8 ) + ( num_tex_dl * ( 6 * 4 ) );
	int rounded_bytes = ( bytes + 31 ) & ~31;
	int pad_bytes = rounded_bytes - bytes;
	while ( pad_bytes )
	{
		pGDFile->Write( (const char *)&zero, 1, false );
		pad_bytes--;
	}

	// Write blend display lists.
	for ( int mat = 0; mat < num_u_mat; mat++ )
	{
		pGDFile->Write( (const char *)p_dl[mat], dl_size[mat], false );
		delete p_dl[mat];
	}

	// Write texture display lists.
	for ( int tex = 0; tex < num_tex_dl; tex++ )
	{
		pGDFile->Write( (const char *)p_tex_dl[tex], tex_dl_size[tex], false );
		delete p_tex_dl[tex];
	}

	// Write vc wibble data.
	for( cur_mat = 0, material = sh.FirstItem( m_scene->m_Materials ); material; cur_mat++, material = sh.NextItem() )
	{
		unsigned short	VCCount		= material->m_WibbleSequences.CountItems();

		// Write out vertex color wibble data.
		if( VCCount )
		{
			Lst::Search< VCWibbleSequence > sh;
			VCWibbleSequence *p_sequence;

//			pGDFile->Write( (const char *)&VCCount,					4, true );
//			pGDFile->Write( (const char *)&material->m_grassLayers,	4, true );

			for( p_sequence = sh.FirstItem( material->m_WibbleSequences ); p_sequence; p_sequence = sh.NextItem())
			{
				pGDFile->Write( (const char *)&p_sequence->m_NumFrames,	4, true );
				pGDFile->Write( (const char *)&p_sequence->m_Phase,		4, true );

				for( int k = 0; k < p_sequence->m_NumFrames; ++k )
				{
					pGDFile->Write( (const char *)&p_sequence->m_WibbleFrames[k].m_Time, 4, true );

					uint8 r = (uint8)( p_sequence->m_WibbleFrames[k].m_Color[0] / 2.0f );
					uint8 g = (uint8)( p_sequence->m_WibbleFrames[k].m_Color[1] / 2.0f );
					uint8 b = (uint8)( p_sequence->m_WibbleFrames[k].m_Color[2] / 2.0f );
					uint8 a = (uint8)( p_sequence->m_WibbleFrames[k].m_Color[3] / 2.0f );
					pGDFile->Write( (const char *)&r, 1, false );
					pGDFile->Write( (const char *)&g, 1, false );
					pGDFile->Write( (const char *)&b, 1, false );
					pGDFile->Write( (const char *)&a, 1, false );
				}
			}
		}
	}

	// Write material headers.
	uint16 pass_item = 0;
	for( cur_mat = 0, material = sh.FirstItem( m_scene->m_Materials ); material; cur_mat++, material = sh.NextItem() )
	{
		unsigned int	Checksum	= material->m_Checksum;
		unsigned int	NameCheck	= material->m_materialName;
		unsigned char	NumPasses	= (unsigned char)material->m_NumPasses;
		unsigned char	AlphaCutoff	= (unsigned char)material->m_AlphaCutoff;
		unsigned char	Flags		= 0;
		float			DrawOrder	= material->m_DrawOrder;
		unsigned short	VCCount		= material->m_WibbleSequences.CountItems();
		unsigned short	SkipBytes	= 0;
		float			shininess	= material->m_SpecularPower;
		unsigned int	SpecCol		= (((u8)((material->m_SpecularColor[0] * 128.0f) + 0.5f))<<24) |
									  (((u8)((material->m_SpecularColor[1] * 128.0f) + 0.5f))<<16) |
									  (((u8)((material->m_SpecularColor[2] * 128.0f) + 0.5f))<< 8) |
									  255;
		unsigned int	ZBias		= material->m_BasePass;

		// Set Flags.
		Flags |= material->m_Sorted		? (1<<0) : 0;
		Flags |= material->m_TwoSided	? (1<<1) : 0;
		Flags |= material->m_OneSided	? (1<<2) : 0;
		// 3, 4 & 5 are used at runtime.
		Flags |= material->m_water ? (1<<5) : 0;
		Flags |= material->m_grassify ? (1<<6) : 0;
		Flags |= ( material->m_Passes[0].m_Flags & NxMaterialPass::UNLIT ) ? (1<<7) : 0;

		// Write out Material header.		
		uint16 mat_no = (uint16)cur_mat;
		pGDFile->Write( (const char *)&Checksum,		4, true );
		pGDFile->Write( (const char *)&NumPasses,		1, true );
		pGDFile->Write( (const char *)&AlphaCutoff,		1, true );
		pGDFile->Write( (const char *)&Flags,			1, true );
		pGDFile->Write( (const char *)&use_dl[cur_mat],	1, true );
		pGDFile->Write( (const char *)&DrawOrder,		4, true );
		pGDFile->Write( (const char *)&pass_item,		2, true );
		pGDFile->Write( (const char *)&mat_no,			2, true );
		pGDFile->Write( (const char *)&shininess,		4, true );
		pGDFile->Write( (const char *)&SpecCol,			4, true );
		pGDFile->Write( (const char *)&NameCheck,		4, true );
		pGDFile->Write( (const char *)&ZBias,			4, true );

//		printf( "\nMaterial: %4d: Draw Order: %8.3f", cur_mat, DrawOrder );
		// 32 bytes.

		pass_item += material->m_NumPasses;
	}

	// Write uv wibble data.
	int wib = 0;
	for( cur_mat = 0, material = sh.FirstItem( m_scene->m_Materials ); material; cur_mat++, material = sh.NextItem() )
	{
		for( p = 0; p < material->m_NumPasses; ++p )
		{
			// Write out UV wibble params
			if( material->m_Passes[p].m_UVWibbleEnabled )
			{
				pGDFile->Write( (const char *)&material->m_Passes[p].m_UVel,		4, true );
				pGDFile->Write( (const char *)&material->m_Passes[p].m_VVel,		4, true );
				pGDFile->Write( (const char *)&material->m_Passes[p].m_UFrequency,	4, true );
				pGDFile->Write( (const char *)&material->m_Passes[p].m_VFrequency,	4, true );
				pGDFile->Write( (const char *)&material->m_Passes[p].m_UAmplitude,	4, true );
				pGDFile->Write( (const char *)&material->m_Passes[p].m_VAmplitude,	4, true );
				pGDFile->Write( (const char *)&material->m_Passes[p].m_UPhase,		4, true );
				pGDFile->Write( (const char *)&material->m_Passes[p].m_VPhase,		4, true );
//				printf( "\nWibble %3d: (%6.3f,%6.3f) (%6.3f,%6.3f) (%6.3f,%6.3f) (%6.3f,%6.3f)",
//					wib,
//					material->m_Passes[p].m_UVel,      
//					material->m_Passes[p].m_VVel,      
//					material->m_Passes[p].m_UFrequency,
//					material->m_Passes[p].m_VFrequency,
//					material->m_Passes[p].m_UAmplitude,
//					material->m_Passes[p].m_VAmplitude,
//					material->m_Passes[p].m_UPhase,    
//					material->m_Passes[p].m_VPhase
//				);
//				wib++;
			}
		}
	}

	// Write pass data.
	int current_uv_wibble = 0;
	for( cur_mat = 0, material = sh.FirstItem( m_scene->m_Materials ); material; cur_mat++, material = sh.NextItem() )
	{
//		printf( "\nMat: %4d", cur_mat );
		for( p = 0; p < material->m_NumPasses; ++p )
		{
			__int64 equation = GetBlendParameters( material->m_Passes[p].m_BlendMode, material->m_Passes[p].m_FixedAlpha );

			unsigned int	TexChecksum	= material->m_Passes[p].GetTextureChecksum( Utils::vPLATFORM_NGC );
			unsigned char	Flags		= 0;
			unsigned char	Filter		= ( material->m_Passes[p].m_MagFilteringMode << 4 ) | material->m_Passes[p].m_MagFilteringMode;
			unsigned char	BlendMode	= (unsigned char)equation;
			unsigned char	AlphaFix	= (unsigned char)material->m_Passes[p].m_FixedAlpha;
			unsigned int	MatCol		= (((u8)((material->m_Passes[p].m_Color[0] * 255.0f) + 0.5f))<<24) |
										  (((u8)((material->m_Passes[p].m_Color[1] * 255.0f) + 0.5f))<<16) |
										  (((u8)((material->m_Passes[p].m_Color[2] * 255.0f) + 0.5f))<< 8) |
										  255;	//(u8)material->m_Passes[p].m_FixedAlpha;

			float			MipK		= material->m_Passes[p].m_MipMapK + 8.0f;
			float			uEnv		= material->m_Passes[p].m_EnvTileU;
			float			vEnv		= material->m_Passes[p].m_EnvTileV;

			// Set Flags.
			if( TexChecksum != 0 )														Flags |= (1<<0);
			if( material->m_Passes[p].m_MappingMode == vMAPPING_ENVIRONMENT )   		Flags |= (1<<1);
			if( material->m_Passes[p].m_UVWibbleEnabled )								Flags |= (1<<2);
			if( material->m_GroupFlags & NxMaterial::mGROUP_TRANSPARENT )				Flags |= (1<<3);
			if( material->m_Passes[p].m_Flags & NxMaterialPass::COLOR_LOCKED )			Flags |= (1<<4);
			if( material->m_Passes[p].m_AddressModeU )									Flags |= (1<<5);
			if( material->m_Passes[p].m_AddressModeV )									Flags |= (1<<6);
			if( material->m_Passes[p].m_Flags & NxMaterialPass::IGNORE_VERTEX_ALPHA )	Flags |= (1<<7);
		
			int32 uv_wibble = -1;
			if( material->m_Passes[p].m_UVWibbleEnabled )
			{
				uv_wibble = current_uv_wibble;
				current_uv_wibble++;
			}

			if( MipK > 0.0f ) MipK = 0.0f;
			short k = (short)( MipK * ((float)(1<<8)) );

			short u = (short)( uEnv * ((float)(1<<12)) );
			short v = (short)( vEnv * ((float)(1<<12)) );

			short mat0 = (1<12);

			// Check for illegal blend modes.
			if ( p == 0 )
			{
				if ( BlendMode == vBLEND_MODE_BLEND_PREVIOUS_MASK )
				{
					BlendMode = vBLEND_MODE_BLEND_FIXED;
					AlphaFix = 255;
				}
				if ( BlendMode == vBLEND_MODE_BLEND_INVERSE_PREVIOUS_MASK )
				{
					BlendMode = vBLEND_MODE_BLEND_FIXED;
					AlphaFix = 0;
				}
			}
			// Write out pass header.
			pGDFile->Write( (const char *)&TexChecksum,	4, true );
			pGDFile->Write( (const char *)&Flags,		1, true );
			pGDFile->Write( (const char *)&Filter,		1, true );
			pGDFile->Write( (const char *)&BlendMode,	1, true );
			pGDFile->Write( (const char *)&AlphaFix,	1, true );
			pGDFile->Write( (const char *)&uv_wibble,	4, true );
			pGDFile->Write( (const char *)&MatCol,		4, true );

			pGDFile->Write( (const char *)&k,			2, true );
			pGDFile->Write( (const char *)&u,			2, true );
			pGDFile->Write( (const char *)&v,			2, true );
			pGDFile->Write( (const char *)&zero,		1, true );
			pGDFile->Write( (const char *)&zero,		1, true );
			pGDFile->Write( (const char *)&mat0,		2, true );
			pGDFile->Write( (const char *)&zero,		2, true );
			pGDFile->Write( (const char *)&zero,		2, true );
			pGDFile->Write( (const char *)&zero,		2, true );

//			pGDFile->Write( (const char *)&MipK,		4, true );
//			pGDFile->Write( (const char *)&uEnv,		4, true );
//			pGDFile->Write( (const char *)&vEnv,		4, true );
//			pGDFile->Write( (const char *)&zero,		4, true );

//			printf( " (%08x %08x %08x)", (int)equation, (int)(equation >> 32), material->m_Passes[p].m_FixedAlpha );
		}
	}

	return true;
}

bool	GameCubeConverter::SaveScene( char* path )
{
	bool success = false;
	
//	IoUtils::CVirtualOutputFile theOutputFile;
	IoUtils::CVirtualOutputFile theGDFile;

//	// 10-meg buffer
//	theOutputFile.Init(10*1024*1024);
//
//	int version;
//	
//	printf( "Scene...." );
// 
	// Sets alpha/holes vars.
	SetAlpha();
//
//	version = vNGC_MATERIAL_VERSION_NUMBER;
////	theOutputFile.Write((const char*) &version, sizeof( int ));
//	writeBig32( &theOutputFile, &version );
//	version = vNGC_MESH_VERSION_NUMBER;
////	theOutputFile.Write((const char*) &version, sizeof( int ));
//	writeBig32( &theOutputFile, &version );
//	version = vNGC_VERTEX_VERSION_NUMBER;
////	theOutputFile.Write((const char*) &version, sizeof( int ));
//	writeBig32( &theOutputFile, &version );
//
//	if( SaveMaterials( &theOutputFile ) == false )
//	{
//		goto save_error;
//	}
//
//	if( SaveGeometry( &theOutputFile ) == false )
//	{
//		goto save_error;
//	}

	printf( "GD...." );

	char gd_path[256];
	sprintf( gd_path, "%s", path );

	theGDFile.Init(10*1024*1024);

	if( SaveGeometry2( &theGDFile ) == false )
	{
		goto save_error;
	}
//	// break the lock, if necessary
//	SetFileAttributes( path, FILE_ATTRIBUTE_NORMAL );
//	if ( !theOutputFile.Save( path ) )
//	{
//		goto save_error;
//	}

	SetFileAttributes( gd_path, FILE_ATTRIBUTE_NORMAL );
	if ( !theGDFile.Save( gd_path ) )
	{
		goto save_error;
	}

	success = true;

save_error:

	return success;
}

/*>*******************************(*)*******************************<*/
// switch tuple and byte order within 16-bit words of an s3-packed tile
// to match hw.
// 1) switch 2-bit tuple order within bytes
//    from ( 0,1,2,3 ) to ( 3,2,1,0 ).
// 2) leave byte order within the word as is.
/*>*******************************(*)*******************************<*/
void GameCubeConverter::TCFixCMPWord( unsigned short* data )
{
	unsigned short tmp;


	tmp = *data;

	// reverse tuple order within bytes
	*data = ( (tmp & 0x3 )   << 6 ) |
			( (tmp & 0xC )   << 2 ) |
			( (tmp & 0x30)   >> 2 ) |
			( (tmp & 0xC0)   >> 6 ) |

            ( (tmp & 0x300 ) << 6 ) |
			( (tmp & 0xC00 ) << 2 ) |
			( (tmp & 0x3000) >> 2 ) |
			( (tmp & 0xC000) >> 6 ) ;
}

/*>*******************************(*)*******************************<*/
// reverse the byte order within a block of bytes.
// do this only if TPL_BIG_END is defined
/*>*******************************(*)*******************************<*/ 
void GameCubeConverter::TCFixEndian( unsigned char* src, unsigned int numBytes )
{

	unsigned char  tmp[8];  // large enough to hold a double
	unsigned int max, i;


//    TCAssertMsg( (numBytes <= 8), "TCFixEndian: numBytes > 8\n" );

	if( (numBytes == 0) || (numBytes == 1) )
	{
		return;
	}
					
	max = numBytes - 1;
	for(i=0; i< numBytes; i++)
	{
		tmp[(max - i)] = src[i];	
	}
	
	for(i=0; i< numBytes; i++)
	{
		src[i] = tmp[i];
	}
}

/*>*******************************(*)*******************************<*/ 
// TCPackTile_CMP
//
// pack a 2x2 tile block, each tile of 4x4 texels, into a single 
// 32B dst tile note: this assumes s3 algorithm pads out to a minimum 
// block size of 4x4 texels
/*>*******************************(*)*******************************<*/ 
void GameCubeConverter::TCPackTile_CMP ( char * pData, int width, int height, unsigned int tileX, unsigned int tileY, unsigned short* dstPtr)
{
	unsigned int  x, y;
	unsigned short* srcPtr;
	unsigned short  tmp;
	unsigned int  srcTileOffset;
	unsigned int  subTileRows, subRowShorts;    // number of s3 4x4 tiles
	unsigned int  srcPadWidth, srcPadHeight;
	unsigned short* buffPtr;

	// set the padded size of the s3 source image out to a 4-texel boundary
	srcPadWidth  = ( (width  + 3) >> 2 );
	srcPadHeight = ( (height + 3) >> 2 );

	// number of bytes in a single row of 4x4 texel source tiles
	srcTileOffset = srcPadWidth * 8;

	// number of 4x4 (source) tile rows to copy ( will be 1 or 2 )
	subTileRows = 2;
	if( (srcPadHeight - tileY) < 2 )
		subTileRows = 1;

	// number of 4x4 tile cols to copy translated into number of short values
	// ( will be 4 or 8 )
	subRowShorts = 8;
	if( (srcPadWidth - tileX) < 2 )
		subRowShorts = 4;

	for( y=0; y < subTileRows; y++ )
	{
		srcPtr  = (unsigned short*)( (unsigned char*)(pData) + ((tileY + y) * srcTileOffset) + (tileX*8) ); 
		buffPtr = ( dstPtr + (y * 8) );        // 16 bytes per subRow = 8 shorts

		// process one or both 4x4 row tiles at once- 4 short each
		for( x=0; x < subRowShorts; x++ )
		{			
			switch( x )
			{

			// color table entries - switch bytes within a 16-bit world only
			case 0:	
			case 1:
			case 4:
			case 5:
				tmp = *srcPtr++;
				TCFixEndian( (unsigned char*)(&tmp), 2 );
				*buffPtr++ = tmp;
				break;
			
			// 2-bit color tuples;
			// reverse tuple order within bytes of a word
			case 2:
			case 3:
			case 6:
			case 7:
				tmp = *srcPtr++;
				TCFixCMPWord( &tmp );
				*buffPtr++ = tmp;
				break;

			} // end switch
		} // end for( subRowShorts )			
	} // end for( subTileRows )
}

/*>*******************************(*)*******************************<*/ 
// TCWriteTplImage_CMP
//
/*>*******************************(*)*******************************<*/ 
void GameCubeConverter::FixCompressedTexture ( char * pData, int width, int height, char * pFixed )
{
	unsigned int tileRow, tileCol;
	unsigned int srcTileRows, srcTileCols;
	unsigned short* dstPtr;

	// each source tile is 4x4 texels, 8B
	srcTileRows   = ((height + 3) >> 2);
	srcTileCols   = ((width  + 3) >> 2);

	dstPtr = (unsigned short*)(pFixed);

	// each dst tile is 2x2 source tiles, so move by 2 each iteration
	for(tileRow = 0; tileRow < srcTileRows; tileRow += 2 )
	{
		for(tileCol = 0; tileCol < srcTileCols; tileCol += 2 )
		{
			TCPackTile_CMP( pData, width, height, tileCol, tileRow, dstPtr );
			dstPtr += 16; // 32B per dst tile, short ptr
		}
	}
}

NxTexture*	p_alpha_texture[4096];
int			alpha_size[4096][3];
int			alpha_match[4096][3];
int num_alpha_textures = 0;

int tex_xref[4096];
int xref_tex[4096];
int invalid = 0;
int tex_idx[4096];

void GameCubeConverter::SetAlpha( void )
{
	bool success = false;

	int i;

	// Scan to find how much alpha reduction is possible.
	int tt;
	int tt2;

//	printf( "\nNum tex %d", m_num_textures );
	for( i = 0; i < m_num_textures; ++i )
	{
		NxTexture* p_texture = &m_textures[i];
		
		// Skip invalid textures.
		if( ( p_texture->m_Checksum == vINVALID_CHECKSUM ) ||
			( p_texture->m_PlatFlags & GetPlatformFlags()) == 0 )
		{
			continue;
		}		
		
		// Make sure this texture is in a format we can deal with on NGC.
		p_texture->ConvertTo32BitPixelFormat();
		p_texture->Convert32BitRGBAPixelFormatTo32BitBGRAPixelFormat();
		
		// See if we have meaningful alpha or not.
		int meaningful_alpha = 0;
		int has_holes = 0;
		int m;
		//for( m = 0; m <= p_texture->m_MipLevels; ++m )
		m = 0;
		{
			int lp;
				
			unsigned int * pTex = (unsigned int *)p_texture->m_TexelData[m];
			for ( lp = 0; lp < ( p_texture->m_Width[m] * p_texture->m_Height[m] ); lp++ )
			{
				int alpha = ( ( pTex[lp] >> 24 ) & 255 );
				if ( ( alpha > 0 ) && ( alpha < 255 ) )
				{
					meaningful_alpha = 1;
				}
				if ( alpha == 0 )
				{
					has_holes = 1;
				}
			}
		}

		// Special case: Scuff/scar textures are defaulted to 0 pixel/0 alpha.
		// If we find a texture with nothing at all meaningful, we need to set it to meaningful alpha
		// so that replacement will work correctly.
		int detail = 0;
		for( m = 0; m <= p_texture->m_MipLevels; ++m )
		{
			int lp;
				
			unsigned int * pTex = (unsigned int *)p_texture->m_TexelData[m];
			for ( lp = 0; lp < ( p_texture->m_Width[m] * p_texture->m_Height[m] ); lp++ )
			{
				int alpha = ( ( pTex[lp] >> 24 ) & 255 );
				if ( alpha == 0 ) continue;
				if ( pTex[lp] & 0x00ffffff )
				{
					detail = 1;
					break;
				}
				if ( ( alpha > 0 ) && ( alpha < 255 ) )
				{
					detail = 1;
					break;
				}
			}
		}
		if ( !detail )
		{
//			printf( "\nFound one!!!" );
			meaningful_alpha = 1;
		}

		p_texture->m_PaletteFormat = meaningful_alpha | ( has_holes << 1 );
	}

//	printf( "\nScanning alpha maps" );
	num_alpha_textures = 0;
	Lst::Search< NxMaterial > sh;
	int cur_mat;
	NxMaterial* material;
	for( cur_mat = 0, material = sh.FirstItem( m_scene->m_Materials ); material; cur_mat++, material = sh.NextItem() )
	{
//		printf( "." );
		for( int p = 0; p < material->m_NumPasses; ++p )
		{
			unsigned int TexChecksum = material->m_Passes[p].GetTextureChecksum( Utils::vPLATFORM_NGC );
			NxTexture* p_tex = GetTextureByChecksum( TexChecksum );
			if ( !p_tex ) continue;
			int meaningful_alpha = p_tex->m_PaletteFormat & 1;

			if ( meaningful_alpha )
			{
				bool found = false;
				for ( tt = 0; tt < num_alpha_textures; tt++ )
				{
					if ( p_alpha_texture[tt] == p_tex )
					{
						found = true;
						break;
					}
				}
				if ( !found )
				{
					int orig_width = p_tex->m_Width[0];
					int orig_height = p_tex->m_Height[0];
					int padded_width = ( orig_width + 7 ) & ~7;
					int padded_height = ( orig_height + 7 ) & ~7;

					alpha_size[num_alpha_textures][0] = padded_width;
					alpha_size[num_alpha_textures][1] = padded_height;
					alpha_size[num_alpha_textures][2] = p_tex->m_MipLevels;

					alpha_match[num_alpha_textures][0] = -2;
					alpha_match[num_alpha_textures][1] = -2;
					alpha_match[num_alpha_textures][2] = 0;		// Parent

//					printf( "\nChecksum: %08x %s", TexChecksum, p_tex->m_Name );
		
					// See if this texture is locked from being combined with others.
					char *crc[] =
					{
						"SJ_TB_Logo_Ricta_10.png",
						"SJ_TB_Logo_Vans_02.png",
						"SJ_TB_Logo_Krux_07.png",
                        "FL_TW_sign_fire_lane.png",
						"FL_TW_sign_florida_wt_plaza01.png",
                        "FL_TW_metal_grate02.png",
		
						NULL
					};
		
					// look for the texture with that checksum
					char buffer[256];
					static int modifiers[] = { 1, 2, 3, 4, 2 * 3, 3 * 4, 2 * 4, 2 * 3 * 4, -1 };
					for ( int cc = 0; crc[cc] != NULL; cc++ )
					{
						// Create automip checksum.
						strcpy( buffer, crc[cc] );
						char * p = strstr( buffer, ".png" );
						sprintf( p, "_auto32m0.png" );
		
						for (int idx = 0; modifiers[idx] > 0; idx++)
						{
							uint32 calc_checksum = GenerateCRC( crc[cc] ) * modifiers[idx];
							uint32 calc_checksum_a = GenerateCRC( buffer ) * modifiers[idx];
		
							if ( ( p_tex->m_Checksum == calc_checksum ) || ( p_tex->m_Checksum == calc_checksum_a ) )
							{
								printf( "\nFound Texture to exclude from alpha merging: %s", crc[cc] );
								alpha_size[num_alpha_textures][0] = 2048 + 1 + cc;
								alpha_size[num_alpha_textures][1] = 2048 + 1 + cc;
							}
						}                                                                                                                                                                   alpha_match[num_alpha_textures][0] = -2; 
					}

					p_alpha_texture[num_alpha_textures] = p_tex;
					num_alpha_textures++;
				}
			}
		}
	}

//	printf( "\nAlpha textures: %d", num_alpha_textures );

//	int abytes = 0;
	for ( tt = 0; tt < num_alpha_textures; tt++ )
	{
		if ( alpha_match[tt][0] == -2 )
		{
			int matches = 0;
			for ( tt2 = 0; tt2 < num_alpha_textures; tt2++ )
			{
				if ( tt == tt2 ) continue;
				if ( alpha_match[tt2][0] != -2 ) continue;

				if ( ( alpha_size[tt][0] == alpha_size[tt2][0] ) && ( alpha_size[tt][1] == alpha_size[tt2][1] ) && ( alpha_size[tt][2] >= alpha_size[tt2][2] ) )
				{
					alpha_match[tt][matches] = tt2;
					alpha_match[tt2][0] = tt;
					alpha_match[tt2][1] = tt;
					matches++;
					alpha_match[tt2][2] = matches;		// Child (1=red child, 2=blue child)
					if ( matches == 2 ) break;
				}
			}
		}

//		printf( "\nTex %4d: Matches: %4d %4d (%d) - %3d %3d %d", tt, alpha_match[tt][0], alpha_match[tt][1], alpha_match[tt][2], alpha_size[tt][0], alpha_size[tt][1], alpha_size[tt][2] );

//		abytes += p_alpha_texture[tt]->m_Width[0] * p_alpha_texture[tt]->m_Height[0];
	}
////	printf( "\nBytes: %d", abytes );

	// Grrr - count how many invalid textures - these will not be saved out.
	invalid = 0;
	int tex = 0;
	for( i = 0; i < m_num_textures; ++i )
	{
		if( ( m_textures[i].m_Checksum == vINVALID_CHECKSUM ) ||
			( m_textures[i].m_PlatFlags & GetPlatformFlags()) == 0 )
		{
			++invalid;
			tex_idx[i] = -1;
		}
		else
		{
			tex_idx[i] = tex;
			tex++;
		}
	}
	
	for( i = 0; i < m_num_textures; ++i )
	{
		NxTexture* p_texture = &m_textures[i];
		
		// Find alpha index.
		int a_idx = 0;
		for ( a_idx = 0; a_idx < num_alpha_textures; a_idx++ )
		{
			if ( p_alpha_texture[a_idx] == p_texture ) break;
		}
		tex_xref[i] = a_idx;
		xref_tex[a_idx] = i;
	}

	for( i = 0; i < m_num_textures; ++i )
	{
		NxTexture* p_texture = &m_textures[i];
		
		// Find alpha index.
		int a_idx = tex_xref[i];

		// Skip invalid textures.
		if( ( p_texture->m_Checksum == vINVALID_CHECKSUM ) ||
			( p_texture->m_PlatFlags & GetPlatformFlags()) == 0 )
		{
			continue;
		}		
		
		int meaningful_alpha = p_texture->m_PaletteFormat & 1;

		int channel = 0;
		int index = 0;
		if ( meaningful_alpha )
		{
			if ( !num_alpha_textures || ( alpha_match[a_idx][2] == 0 ) )
			{
			}
			else
			{
				// Not the master, work out the reference.
				// 0 = alpha map
				// 2 = (1=red, 2=blue)
				int a_idx = tex_xref[i];
				channel = alpha_match[a_idx][2];
				index = tex_idx[xref_tex[alpha_match[a_idx][0]]];
			}
		}
		p_texture->m_PaletteFormat |= ( channel << 8 ) | ( index << 16 );
	}
}

bool	GameCubeConverter::SaveTextureDictionary( char* path, char* usg_path )
{
	unsigned int * p32r = new unsigned int[512 * 512];
	unsigned int * p32g = new unsigned int[512 * 512];
	unsigned int * p32b = new unsigned int[512 * 512];
	char * pfix = new char[512*512];
	char * ppix = new char[512 * 512 * 4];

	int abytes = 0;
	int new_abytes = 0;
//	return true;

	bool success = false;

	int		i, version, texture_levels;

	IoUtils::CVirtualOutputFile theOutputFile;
	theOutputFile.Init(10*1024*1024);

	printf( "Texture Dictionary.... " );

	// Write dictionary version.
	version = vNGC_TEXTURE_VERSION_NUMBER;
//	theOutputFile.Write((const char*) &version, sizeof( int ));
	writeBig32( &theOutputFile, &version );

	// Write number of textures.
	int num_textures = m_num_textures - invalid;
//	theOutputFile.Write((const char*)&num_textures, sizeof( int ));
	writeBig32( &theOutputFile, &num_textures );

	// Recurse through textures, writing details per texture.
	int uncompressed = 0;
	int compressed = 0;
	int compressedalpha = 0;
	for( i = 0; i < m_num_textures; ++i )
	{
		NxTexture* p_texture = &m_textures[i];
		
		// Find alpha index.
		int a_idx = tex_xref[i];

		// Skip invalid textures.
		if( ( p_texture->m_Checksum == vINVALID_CHECKSUM ) ||
			( p_texture->m_PlatFlags & GetPlatformFlags()) == 0 )
		{
			continue;
		}		

//		// Make sure this texture is in a format we can deal with on NGC.
//		p_texture->ConvertTo32BitPixelFormat();
//		p_texture->Convert32BitRGBAPixelFormatTo32BitBGRAPixelFormat();
		
		// Write out texture checksum.
//		theOutputFile.Write((const char*) &p_texture->m_Checksum,				sizeof( unsigned long ));
		writeBig32( &theOutputFile, &p_texture->m_Checksum );

		// Write out level 0 width and height.
//		theOutputFile.Write((const char *) &p_texture->m_Width[0],				sizeof( int ));
//		theOutputFile.Write((const char *) &p_texture->m_Height[0],				sizeof( int ));
		writeBig32( &theOutputFile, &p_texture->m_Width[0] );
		writeBig32( &theOutputFile, &p_texture->m_Height[0] );

		// Write out number of MIP maps.
		// The member m_MipLevels is 0 for no levels *other* than the base texture.
		texture_levels = p_texture->m_MipLevels + 1;
//		theOutputFile.Write((const char *)&texture_levels,						sizeof( int ));
		writeBig32( &theOutputFile, &texture_levels );
		
		// Write out texel depth.
//		texel_depth =	( p_texture->m_PixelFormat == NxTexture::v4_BIT ) ? 4 :
//						(( p_texture->m_PixelFormat == NxTexture::v8_BIT ) ? 8 :
//						(( p_texture->m_PixelFormat == NxTexture::v16_BIT ) ? 16 :
//						(( p_texture->m_PixelFormat == NxTexture::v32_BIT ) ? 32 : 0 )));
//		theOutputFile.Write((const char *) &texel_depth,							sizeof( int ));
//		writeBig32( &theOutputFile, &texel_depth );

		// Write out palette depth.
//		palette_depth = ( p_texture->m_PaletteFormat == NxTexture::v16_BIT ) ? 16 :
//						(( p_texture->m_PaletteFormat == NxTexture::v24_BIT ) ? 24 :
//						(( p_texture->m_PaletteFormat == NxTexture::v32_BIT ) ? 32 : 0 ));
//		theOutputFile.Write((const char *) &palette_depth,						sizeof( int ));
//		writeBig32( &theOutputFile, &palette_depth );

		// Write out DXT compression type.
//		dxt_compression_type = 0;
//		theOutputFile.Write((const char *) &dxt_compression_type,				sizeof( int ));
//		writeBig32( &theOutputFile, &dxt_compression_type );

		// Write out palette size.
//		theOutputFile.Write((const char *) &p_texture->m_TotalPaletteDataSize,	sizeof( int ));
//		writeBig32( &theOutputFile, &p_texture->m_TotalPaletteDataSize );

		// See if we have meaningful alpha or not.
		int meaningful_alpha = p_texture->m_PaletteFormat & 1;
		int has_holes = ( p_texture->m_PaletteFormat >> 1 ) & 1;

//		printf( "\nTexture: %s", p_texture->m_Name );

//		CS_NH_scar_armR.png
//CS_NH_scar_armL.png
//CS_NH_scar_legL.png
//CS_NH_scar_legR.png

		int is_compressed = 1;	//( p_texture->m_Flags & NxTexture::mCOMPRESS_NGC ) ? 1 : 0;
		int texture_format = 0;
		int passes = 1;

		if ( is_compressed )
		{
			if ( meaningful_alpha )
			{
				if ( !num_alpha_textures || ( alpha_match[a_idx][2] == 0 ) )
				{
//					printf( "\nmAlpha %d %d %d %d %d", alpha_match[a_idx][0], alpha_match[a_idx][1], alpha_match[a_idx][2], xref_tex[alpha_match[a_idx][0]], tex_idx[xref_tex[alpha_match[a_idx][0]]] );
					texture_format = 1;	// Compressed, intensity alpha
					compressedalpha++;
					passes = 2;
				}
				else
				{
					// Not the master, work out the reference.
					// 0 = alpha map
					// 2 = (1=red, 2=blue)
					int a_idx = tex_xref[i];
//					printf( "\ncAlpha %d %d %d %d %d", alpha_match[a_idx][0], alpha_match[a_idx][1], alpha_match[a_idx][2], xref_tex[alpha_match[a_idx][0]], tex_idx[xref_tex[alpha_match[a_idx][0]]] );
					texture_format = 1 | ( alpha_match[a_idx][2] << 8 ) | ( tex_idx[xref_tex[alpha_match[a_idx][0]]] << 16 );	// Compressed, intensity alpha + texture idx + channel
					passes = 1;
				}
			}
			else
			{
				texture_format = 0;	// Compressed, 1bit alpha
				compressed++;
				passes = 1;
			}
		}
		else
		{
			texture_format = 2;	// 32-bit Uncompressed
			uncompressed++;
			passes = 1;
		}
//		printf( "\nTex %4d: Alpha %d %d", i, alpha_match[a_idx][2], xref_tex[alpha_match[a_idx][0]] );


		writeBig32( &theOutputFile, &texture_format );
		writeBig32( &theOutputFile, &has_holes );

		texture_format = texture_format & 3;

		printf( "%04d/%04d\b\b\b\b\b\b\b\b\b", i, m_num_textures );

		// The member m_MipLevels is 0 for no levels *other* than the base texture.
		for( int ta = 0; ta < passes; ta++ )
		{
			int check = 0;
//			if (( strcmp( p_texture->m_Name, "\\\\Bruce\\Qqq\\sk4\\Levels\\SkateShop\\TEX\\ss_cw_wall_dirt2.png" ) == 0 ) ||
//				( strcmp( p_texture->m_Name, "\\\\Bruce\\Qqq\\sk4\\Levels\\SkateShop\\TEX\\ss_cw_wall_highlite.png" ) == 0 ) ||
//				( strcmp( p_texture->m_Name, "\\\\Bruce\\Qqq\\sk4\\Levels\\SkateShop\\TEX\\ss_cw_wall_dirt.png" ) == 0 ) )
//			{
//				texture_format = 2;	// 32-bit Uncompressed

//			for ( int chan = 0; chan < 4; chan++ )
//			{
//				printf( "\nTexture output: %s (%dx%d) %d", p_texture->m_Name, p_texture->m_Width[0], p_texture->m_Height[0], chan );
//
//				unsigned int * p32 = (unsigned int*)p_texture->m_TexelData[0];
//				for ( int yy = 0; yy < p_texture->m_Height[0]; yy++ )
//				{
//					printf( "\n" );
//					for ( int xx = 0; xx < p_texture->m_Width[0]; xx++ )
//					{
//						printf( "%02x", ( p32[xx+(yy*p_texture->m_Width[0])] >> (8*chan) ) & 255 );
//					}
//				}
//			}

//				printf( "\nMips: %d", p_texture->m_MipLevels );
//				check = 1;
//			}
			for( int m = 0; m <= p_texture->m_MipLevels; ++m )
			{
				int test = 0;
				if ( ( check == 1 ) && ( m == 0 ) ) test = 1;
				int lp;
				// Get the original size
				int orig_width = p_texture->m_Width[m];
				int orig_height = p_texture->m_Height[m];
					
				// Calculate the padded width & height.
	//			int padded_width = ( orig_width + 3 ) & ~3;
	//			int padded_height = ( orig_height + 3 ) & ~3;

				// Round the smallest mip size to 8x8 & scale back up to largest mip.
	//			int padded_width = ( ( ( orig_width >> ( p_texture->m_MipLevels - m ) ) + 7 ) & ~7 ) << ( p_texture->m_MipLevels - m );
	//			int padded_height = ( ( ( orig_height >> ( p_texture->m_MipLevels - m ) ) + 7 ) & ~7 ) << ( p_texture->m_MipLevels - m );
				int padded_width;
				int padded_height;
				padded_width = ( orig_width + 7 ) & ~7;
				padded_height = ( orig_height + 7 ) & ~7;

//				printf( "\nTexture %d, %dx%d", i, padded_width, padded_height );


				// Convert to NGC-format.
				unsigned int * pTex = (unsigned int *)p_texture->m_TexelData[m];
				unsigned int * p32 = p32g;	//(unsigned int *)malloc ( padded_width * padded_height * 4 );
				// Pad width/height.
				memset( p32, 0, padded_width * padded_height * 4 );
				for ( lp = 0; lp < padded_height; lp++ )
				{
					memcpy( &p32[padded_width * lp], &pTex[p_texture->m_Width[m] * lp], padded_width * 4 );
				}

				// If alpha & at least 1 extra map, setup optional 2nd & 3rd map.
				unsigned int * rp32 = NULL;
				unsigned int * bp32 = NULL;
				if ( ( ta == 1 ) && meaningful_alpha && num_alpha_textures && ( a_idx != num_alpha_textures ) )
				{
					if ( alpha_match[a_idx][0] > -2 )
					{
						NxTexture* p_red = &m_textures[xref_tex[alpha_match[a_idx][0]]];

						if ( p_red->m_MipLevels >= m )
						{
							unsigned int * rpTex = (unsigned int *)p_red->m_TexelData[m];
							rp32 = p32r;	//(unsigned int *)malloc ( padded_width * padded_height * 4 );
							// Pad width/height.
							memset( rp32, 0, padded_width * padded_height * 4 );
							for ( lp = 0; lp < padded_height; lp++ )
							{
								memcpy( &rp32[padded_width * lp], &rpTex[p_red->m_Width[m] * lp], padded_width * 4 );
							}
						}
					}
					if ( alpha_match[a_idx][1] > -2 )
					{
						NxTexture* p_blue = &m_textures[xref_tex[alpha_match[a_idx][1]]];

						if ( p_blue->m_MipLevels >= m )
						{
							unsigned int * bpTex = (unsigned int *)p_blue->m_TexelData[m];
							bp32 = p32b;		//(unsigned int *)malloc ( padded_width * padded_height * 4 );
							// Pad width/height.
							memset( bp32, 0, padded_width * padded_height * 4 );
							for ( lp = 0; lp < padded_height; lp++ )
							{
								memcpy( &bp32[padded_width * lp], &bpTex[p_blue->m_Width[m] * lp], padded_width * 4 );
							}
						}
					}
				}

				// Do texture manipulation here.
				if ( test ) printf( "\nFormat: %d", texture_format );
				switch ( texture_format )
				{
					case 0:		// Compressed, 1 bit alpha
					case 1:		// Compressed, 2nd alpha map
						if ( ta == 0 )
						{
							// Set alpha to 0 or 255.
							for ( lp = 0; lp < ( padded_width * padded_height ); lp++ )
							{
								int alpha = ( ( p32[lp] >> 24 ) & 255 );
								if ( alpha > 0 )
								{
									p32[lp] = ( p32[lp] & 0x00ffffff ) | 0xff000000;
								}
								else
								{
									p32[lp] = ( p32[lp] & 0x00ffffff );
								}
							}
						}
						else
						{
							// Set green to alpha.
							for ( lp = 0; lp < ( padded_width * padded_height ); lp++ )
							{
								int alpha = ( ( p32[lp] >> 24 ) & 255 );
								p32[lp] = ( alpha << 8 ) | 0xff000000;

								if ( rp32 )
								{
									alpha = ( ( rp32[lp] >> 24 ) & 255 );
									p32[lp] = p32[lp] | ( alpha << 0 );
								}
								if ( bp32 )
								{
									alpha = ( ( bp32[lp] >> 24 ) & 255 );
									p32[lp] = p32[lp] | ( alpha << 16 );
								}
							}
						}
						break;
					case 2:		// 32-bit Uncompressed
						// Convert back to ABGR format.
						for ( lp = 0; lp < ( padded_width * padded_height ); lp++ )
						{
							int a = ( ( p32[lp] >> 24 ) & 255 );
							int b = ( ( p32[lp] >> 16 ) & 255 );
							int g = ( ( p32[lp] >> 8 ) & 255 );
							int r = ( ( p32[lp] >> 0 ) & 255 );

							p32[lp] = ( a << 24 ) | ( r << 16 ) | ( g << 8 ) | b;
						}
						break;
					default:
						printf( "!!!Illegal texture format!!! " );
						break;
				}

				// Write out texture.
				switch ( texture_format )
				{
					case 0:		// Compressed, 1 bit alpha
					case 1:		// Compressed, intensity alpha
						{
							// Grab another buffer to hold the DXT compressed version of the texture.
							unsigned int *pPixelData32	= (unsigned int *)ppix;		//new unsigned int[(padded_width * padded_height)];
							gpCompressedData			= (unsigned char*)pPixelData32;

							CompressionOptions compression_options;
							compression_options.bBinaryAlpha			= 1;								// Zero or one.
							compression_options.bMipMapsInImage			= false;							// mip have been loaded in during read
							compression_options.MipMapType				= dNoMipMaps;						// dNoMipMaps, dUseExistingMipMaps, dGenerateMipMaps
							compression_options.bNormalMap				= false;							// only renormalize MIP maps
							compression_options.bDuDvMap				= false;							// Is a DuDv map
							compression_options.bAlphaBorder			= false;							// make an alpha border
							compression_options.bBorder					= false;							// make a color border
							compression_options.bFade					= false;							// fade to color over MIP maps
							compression_options.bFadeAlpha				= false;							// fade to color over MIP maps
							compression_options.bDitherColor			= true;								// enable dithering during 16 bit conversion
							compression_options.TextureType				= dTextureType2D;					// regular decal, cube or volume: dTextureType2D, dTextureTypeCube, dTextureTypeImage
							compression_options.TextureFormat			= dDXT1a;	// dDXT1, dDXT1a, dDXT3, dDXT5, d4444, d1555, d565, d8888, d888, d555
							compression_options.bSwapRGB				= false;
									
							gDXTBytesWritten = 0;
							
							HRESULT hr = nvDXTcompress( (unsigned char*)( p32 ),							// pointer to data (24 or 32 bit)
														padded_width,										// width in texels
														padded_height,										// height in texels
														padded_width * 4,									// pitch
														&compression_options,
														4,													// depth: 3 or 4
														NULL );												// callback for generated levels

							if ( test ) printf( "\nResult: %d", hr );

							int compressed_size = gDXTBytesWritten;
							char * pFixed = pfix;		//(char *)malloc( compressed_size );
							FixCompressedTexture ( (char *)pPixelData32, padded_width, padded_height, pFixed );
//							free( pPixelData32 );

							writeBig32( &theOutputFile, &compressed_size );
							theOutputFile.Write((const char*)pFixed, compressed_size );

							if ( ( texture_format == 1 ) && ( ta == 0 ) ) abytes += compressed_size;
							if ( ( texture_format == 1 ) && ( ta == 1 ) ) new_abytes += compressed_size;

//							free( pFixed );
//							free( p16 );
//							free( p32 );
//							if ( rp32 ) free( rp32 );
//							if ( bp32 ) free( bp32 );
						}
						break;
					case 2:		// 32-bit Uncompressed
						{
							// Reorder in blocks.
							unsigned short * p16 = (unsigned short *)p32r;	//malloc ( padded_width * padded_height * 4 );
							for ( lp = 0; lp < padded_height; lp += 4 ) {
								for ( int lp2 = 0; lp2 < padded_width; lp2 += 4 ) {
									p16[ 0+(lp2*8)+(lp*padded_width*2)] = ( ( p32[0+(padded_width*0)+lp2+(lp*padded_width)] << 8 ) & 0x0000ff00 ) | ( ( p32[0+(padded_width*0)+lp2+(lp*padded_width)] >> 24 ) & 0x000000ff );
									p16[ 1+(lp2*8)+(lp*padded_width*2)] = ( ( p32[1+(padded_width*0)+lp2+(lp*padded_width)] << 8 ) & 0x0000ff00 ) | ( ( p32[1+(padded_width*0)+lp2+(lp*padded_width)] >> 24 ) & 0x000000ff );
									p16[ 2+(lp2*8)+(lp*padded_width*2)] = ( ( p32[2+(padded_width*0)+lp2+(lp*padded_width)] << 8 ) & 0x0000ff00 ) | ( ( p32[2+(padded_width*0)+lp2+(lp*padded_width)] >> 24 ) & 0x000000ff );
									p16[ 3+(lp2*8)+(lp*padded_width*2)] = ( ( p32[3+(padded_width*0)+lp2+(lp*padded_width)] << 8 ) & 0x0000ff00 ) | ( ( p32[3+(padded_width*0)+lp2+(lp*padded_width)] >> 24 ) & 0x000000ff );
									p16[ 4+(lp2*8)+(lp*padded_width*2)] = ( ( p32[0+(padded_width*1)+lp2+(lp*padded_width)] << 8 ) & 0x0000ff00 ) | ( ( p32[0+(padded_width*1)+lp2+(lp*padded_width)] >> 24 ) & 0x000000ff );
									p16[ 5+(lp2*8)+(lp*padded_width*2)] = ( ( p32[1+(padded_width*1)+lp2+(lp*padded_width)] << 8 ) & 0x0000ff00 ) | ( ( p32[1+(padded_width*1)+lp2+(lp*padded_width)] >> 24 ) & 0x000000ff );
									p16[ 6+(lp2*8)+(lp*padded_width*2)] = ( ( p32[2+(padded_width*1)+lp2+(lp*padded_width)] << 8 ) & 0x0000ff00 ) | ( ( p32[2+(padded_width*1)+lp2+(lp*padded_width)] >> 24 ) & 0x000000ff );
									p16[ 7+(lp2*8)+(lp*padded_width*2)] = ( ( p32[3+(padded_width*1)+lp2+(lp*padded_width)] << 8 ) & 0x0000ff00 ) | ( ( p32[3+(padded_width*1)+lp2+(lp*padded_width)] >> 24 ) & 0x000000ff );
									p16[ 8+(lp2*8)+(lp*padded_width*2)] = ( ( p32[0+(padded_width*2)+lp2+(lp*padded_width)] << 8 ) & 0x0000ff00 ) | ( ( p32[0+(padded_width*2)+lp2+(lp*padded_width)] >> 24 ) & 0x000000ff );
									p16[ 9+(lp2*8)+(lp*padded_width*2)] = ( ( p32[1+(padded_width*2)+lp2+(lp*padded_width)] << 8 ) & 0x0000ff00 ) | ( ( p32[1+(padded_width*2)+lp2+(lp*padded_width)] >> 24 ) & 0x000000ff );
									p16[10+(lp2*8)+(lp*padded_width*2)] = ( ( p32[2+(padded_width*2)+lp2+(lp*padded_width)] << 8 ) & 0x0000ff00 ) | ( ( p32[2+(padded_width*2)+lp2+(lp*padded_width)] >> 24 ) & 0x000000ff );
									p16[11+(lp2*8)+(lp*padded_width*2)] = ( ( p32[3+(padded_width*2)+lp2+(lp*padded_width)] << 8 ) & 0x0000ff00 ) | ( ( p32[3+(padded_width*2)+lp2+(lp*padded_width)] >> 24 ) & 0x000000ff );
									p16[12+(lp2*8)+(lp*padded_width*2)] = ( ( p32[0+(padded_width*3)+lp2+(lp*padded_width)] << 8 ) & 0x0000ff00 ) | ( ( p32[0+(padded_width*3)+lp2+(lp*padded_width)] >> 24 ) & 0x000000ff );
									p16[13+(lp2*8)+(lp*padded_width*2)] = ( ( p32[1+(padded_width*3)+lp2+(lp*padded_width)] << 8 ) & 0x0000ff00 ) | ( ( p32[1+(padded_width*3)+lp2+(lp*padded_width)] >> 24 ) & 0x000000ff );
									p16[14+(lp2*8)+(lp*padded_width*2)] = ( ( p32[2+(padded_width*3)+lp2+(lp*padded_width)] << 8 ) & 0x0000ff00 ) | ( ( p32[2+(padded_width*3)+lp2+(lp*padded_width)] >> 24 ) & 0x000000ff );
									p16[15+(lp2*8)+(lp*padded_width*2)] = ( ( p32[3+(padded_width*3)+lp2+(lp*padded_width)] << 8 ) & 0x0000ff00 ) | ( ( p32[3+(padded_width*3)+lp2+(lp*padded_width)] >> 24 ) & 0x000000ff );

									p16[16+(lp2*8)+(lp*padded_width*2)] = ( ( p32[0+(padded_width*0)+lp2+(lp*padded_width)] >> 8 ) & 0x0000ff00 ) | ( ( p32[0+(padded_width*0)+lp2+(lp*padded_width)] >> 8 ) & 0x000000ff );
									p16[17+(lp2*8)+(lp*padded_width*2)] = ( ( p32[1+(padded_width*0)+lp2+(lp*padded_width)] >> 8 ) & 0x0000ff00 ) | ( ( p32[1+(padded_width*0)+lp2+(lp*padded_width)] >> 8 ) & 0x000000ff );
									p16[18+(lp2*8)+(lp*padded_width*2)] = ( ( p32[2+(padded_width*0)+lp2+(lp*padded_width)] >> 8 ) & 0x0000ff00 ) | ( ( p32[2+(padded_width*0)+lp2+(lp*padded_width)] >> 8 ) & 0x000000ff );
									p16[19+(lp2*8)+(lp*padded_width*2)] = ( ( p32[3+(padded_width*0)+lp2+(lp*padded_width)] >> 8 ) & 0x0000ff00 ) | ( ( p32[3+(padded_width*0)+lp2+(lp*padded_width)] >> 8 ) & 0x000000ff );
									p16[20+(lp2*8)+(lp*padded_width*2)] = ( ( p32[0+(padded_width*1)+lp2+(lp*padded_width)] >> 8 ) & 0x0000ff00 ) | ( ( p32[0+(padded_width*1)+lp2+(lp*padded_width)] >> 8 ) & 0x000000ff );
									p16[21+(lp2*8)+(lp*padded_width*2)] = ( ( p32[1+(padded_width*1)+lp2+(lp*padded_width)] >> 8 ) & 0x0000ff00 ) | ( ( p32[1+(padded_width*1)+lp2+(lp*padded_width)] >> 8 ) & 0x000000ff );
									p16[22+(lp2*8)+(lp*padded_width*2)] = ( ( p32[2+(padded_width*1)+lp2+(lp*padded_width)] >> 8 ) & 0x0000ff00 ) | ( ( p32[2+(padded_width*1)+lp2+(lp*padded_width)] >> 8 ) & 0x000000ff );
									p16[23+(lp2*8)+(lp*padded_width*2)] = ( ( p32[3+(padded_width*1)+lp2+(lp*padded_width)] >> 8 ) & 0x0000ff00 ) | ( ( p32[3+(padded_width*1)+lp2+(lp*padded_width)] >> 8 ) & 0x000000ff );
									p16[24+(lp2*8)+(lp*padded_width*2)] = ( ( p32[0+(padded_width*2)+lp2+(lp*padded_width)] >> 8 ) & 0x0000ff00 ) | ( ( p32[0+(padded_width*2)+lp2+(lp*padded_width)] >> 8 ) & 0x000000ff );
									p16[25+(lp2*8)+(lp*padded_width*2)] = ( ( p32[1+(padded_width*2)+lp2+(lp*padded_width)] >> 8 ) & 0x0000ff00 ) | ( ( p32[1+(padded_width*2)+lp2+(lp*padded_width)] >> 8 ) & 0x000000ff );
									p16[26+(lp2*8)+(lp*padded_width*2)] = ( ( p32[2+(padded_width*2)+lp2+(lp*padded_width)] >> 8 ) & 0x0000ff00 ) | ( ( p32[2+(padded_width*2)+lp2+(lp*padded_width)] >> 8 ) & 0x000000ff );
									p16[27+(lp2*8)+(lp*padded_width*2)] = ( ( p32[3+(padded_width*2)+lp2+(lp*padded_width)] >> 8 ) & 0x0000ff00 ) | ( ( p32[3+(padded_width*2)+lp2+(lp*padded_width)] >> 8 ) & 0x000000ff );
									p16[28+(lp2*8)+(lp*padded_width*2)] = ( ( p32[0+(padded_width*3)+lp2+(lp*padded_width)] >> 8 ) & 0x0000ff00 ) | ( ( p32[0+(padded_width*3)+lp2+(lp*padded_width)] >> 8 ) & 0x000000ff );
									p16[29+(lp2*8)+(lp*padded_width*2)] = ( ( p32[1+(padded_width*3)+lp2+(lp*padded_width)] >> 8 ) & 0x0000ff00 ) | ( ( p32[1+(padded_width*3)+lp2+(lp*padded_width)] >> 8 ) & 0x000000ff );
									p16[30+(lp2*8)+(lp*padded_width*2)] = ( ( p32[2+(padded_width*3)+lp2+(lp*padded_width)] >> 8 ) & 0x0000ff00 ) | ( ( p32[2+(padded_width*3)+lp2+(lp*padded_width)] >> 8 ) & 0x000000ff );
									p16[31+(lp2*8)+(lp*padded_width*2)] = ( ( p32[3+(padded_width*3)+lp2+(lp*padded_width)] >> 8 ) & 0x0000ff00 ) | ( ( p32[3+(padded_width*3)+lp2+(lp*padded_width)] >> 8 ) & 0x000000ff );
								}
							}

							// Write out level n size.
							int size = padded_width * padded_height * 4;
							writeBig32( &theOutputFile, &size );

							theOutputFile.Write((const char*)p16, size );

//							free( p16 );
//							free( p32 );

//							printf( "\nWrote uncompressed texture: %s (%dx%d)", p_texture->m_Name, padded_width, padded_height );
						}

						break;
					default:
						printf( "!!!Illegal texture format!!! " );
						break;
				}
			}
		}
	}

	delete p32r;
	delete p32g;
	delete p32b;
	delete pfix;

	printf( "%dc %da %du (%d alpha bytes %d new)", compressed, compressedalpha, uncompressed, abytes, new_abytes );

	// break the lock, if necessary
	SetFileAttributes( path, FILE_ATTRIBUTE_NORMAL );
	if ( !theOutputFile.Save( path ) )
	{
		goto save_error;
	}

	success = true;

save_error:
	return success;
}

bool GameCubeConverter::SaveCASFlags( char* path )
{
	// Exit if this is not a CAS object.
	NxObject *object = get_cas_object();
	if( !object )
	{
		return false;
	}

	IoUtils::CVirtualOutputFile theOutputFile;
	theOutputFile.Init(1*1024*1024);
	
	int version;	

	printf( "CAS flags...." );

	version = vNGC_CASFLAGS_VERSION_NUMBER;
//	theOutputFile.Write((const char*) &version, sizeof( int ));
	writeBig32( &theOutputFile, &version );

	unsigned int removalMask = 0;
	if ( object->m_Flags & NxObject::mHASCASREMOVEFLAGS )
	{
		removalMask = object->m_CASRemoveFlags;
	}
//	theOutputFile.Write((const char*) &removalMask, sizeof( int ));
	writeBig32( &theOutputFile, &removalMask );

//	theOutputFile.Write((const char*) &object->m_NumCASData, sizeof( int ));
	writeBig32( &theOutputFile, &object->m_NumCASData );

	for ( int i = 0; i < object->m_NumCASData; i++ )
	{
//		theOutputFile.Write((const char*) &object->mp_CASData[i].m_Mask,		sizeof( unsigned long ));
//		theOutputFile.Write((const char*) &object->mp_CASData[i].m_Data,		sizeof( unsigned long ));
//		theOutputFile.Write((const char*) &object->mp_CASData[i].m_Data1,	sizeof( unsigned long ));
		writeBig32( &theOutputFile, &object->mp_CASData[i].m_Mask );
		writeBig32( &theOutputFile, &object->mp_CASData[i].m_Data );
		writeBig32( &theOutputFile, &object->mp_CASData[i].m_Data1 );
	}

	// break the lock, if necessary
	SetFileAttributes( path, FILE_ATTRIBUTE_NORMAL );
	if ( !theOutputFile.Save( path ) )
	{
		return false;
	}

	return true;
}

bool	GameCubeConverter::SaveWeightMap( char* path )
{
	NxObject* object = get_cas_object();

	if( !object )
	{
		// Not a create-a-skater object.
		return false;
	}

	if( !m_weight_map_loaded )
	{
		return false;
	}

	IoUtils::CVirtualOutputFile theOutputFile;
	theOutputFile.Init( 1 * 1024 * 1024 );

	printf( "Mesh scaling weight map...." );

	int version = vNGC_WEIGHTMAP_VERSION_NUMBER;
	theOutputFile.Write((const char*)&version, sizeof( int ), true);

	Utils::Assert( mp_weight_map_vertices != NULL, "weight map vertices uninitialized?" );

	NxVertex* pVertices = mp_weight_map_vertices;
	int numVertices = m_num_weight_map_vertices;

	theOutputFile.Write((const char*)&numVertices, sizeof( int ), true);

	for( int i = 0; i < numVertices; i++ )
	{
		NxVertex* pVertex = &pVertices[i];
		theOutputFile.Write((const char*) &pVertex->m_MeshScalingWeight[0], sizeof( float ), true);
		theOutputFile.Write((const char*) &pVertex->m_MeshScalingWeight[1], sizeof( float ), true);
		theOutputFile.Write((const char*) &pVertex->m_MeshScalingWeight[2], sizeof( float ), true);
	}

	for( int i = 0; i < numVertices; i++ )
	{
		NxVertex* pVertex = &pVertices[i];
		theOutputFile.Write((const char*) &pVertex->m_MeshScalingWeightedIndex[0], sizeof( unsigned char ), true);
		theOutputFile.Write((const char*) &pVertex->m_MeshScalingWeightedIndex[1], sizeof( unsigned char ), true);
		theOutputFile.Write((const char*) &pVertex->m_MeshScalingWeightedIndex[2], sizeof( unsigned char ), true);
	}

	// break the lock, if necessary
	SetFileAttributes( path, FILE_ATTRIBUTE_NORMAL );
	if ( !theOutputFile.Save( path ) )
	{
		return false;
	}

	return true;
}

int		GameCubeConverter::GetPlatformFlags( void )
{
	if( gTextureOverride )
	{
		return( 1 << gTextureOverrideMapping[Utils::vPLATFORM_NGC] );
	}

	return mPLAT_NGC;
}

__int64	GameCubeConverter::GetBlendParameters( int blend_mode, int fixed )
{
	BlendModes mode;
	__int64 equation, fixed_val;
//	int a, b, c, d;	
	
	// Gloss map unsupported (assume diffuse) aml
	if (blend_mode == vBLEND_MODE_GLOSS_MAP)
		blend_mode = vBLEND_MODE_DIFFUSE;

	mode = (BlendModes) blend_mode;
//	equation = 0;	

	fixed_val	= fixed << 32;	
	equation	= mode | ( fixed_val << 32 );
	
/*	switch( mode )
	{
		case vBLEND_MODE_DIFFUSE:				// ( 0 - 0 ) * 0 + Src
			a = vPARAM_ZERO;
			b = vPARAM_ZERO;
			c = vPARAM_DST;
			d = vPARAM_SRC;
			break;
		case vBLEND_MODE_ADD:					// ( Src - 0 ) * Src + Dst
			a = vPARAM_SRC;
			b = vPARAM_ZERO;
			c = vPARAM_SRC;
			d = vPARAM_DST;
			break;
		case vBLEND_MODE_ADD_FIXED:				// ( Src - 0 ) * Fixed + Dst
			a = vPARAM_SRC;
			b = vPARAM_ZERO;
			c = vPARAM_FIXED;
			d = vPARAM_DST;
			break;
		case vBLEND_MODE_SUBTRACT:				// ( 0 - Src ) * Src + Dst
			a = vPARAM_ZERO;
			b = vPARAM_SRC;
			c = vPARAM_SRC;
			d = vPARAM_DST;
			break;
		case vBLEND_MODE_SUB_FIXED:				// ( 0 - Src ) * Fixed + Dst
			a = vPARAM_ZERO;
			b = vPARAM_SRC;
			c = vPARAM_FIXED;
			d = vPARAM_DST;
			break;
		case vBLEND_MODE_BLEND:					// ( Src * Dst ) * Src + Dst	
			a = vPARAM_SRC;
			b = vPARAM_DST;
			c = vPARAM_SRC;
			d = vPARAM_DST;
			break;
		case vBLEND_MODE_BLEND_FIXED:			// ( Src * Dst ) * Fixed + Dst	
			a = vPARAM_SRC;
			b = vPARAM_DST;
			c = vPARAM_FIXED;
			d = vPARAM_DST;
			break;
		case vBLEND_MODE_MODULATE:				// ( Dst - 0 ) * Src + 0
			a = vPARAM_DST;
			b = vPARAM_ZERO;
			c = vPARAM_SRC;
			d = vPARAM_ZERO;
			break;
		case vBLEND_MODE_MODULATE_FIXED:			// ( Dst - 0 ) * Fixed + 0	
			a = vPARAM_DST;
			b = vPARAM_ZERO;
			c = vPARAM_FIXED;
			d = vPARAM_ZERO;
			break;
		case vBLEND_MODE_BRIGHTEN:				// ( Dst - 0 ) * Src + Dst
			a = vPARAM_DST;
			b = vPARAM_ZERO;
			c = vPARAM_SRC;
			d = vPARAM_DST;
			break;
		case vBLEND_MODE_BRIGHTEN_FIXED:			// ( Dst - 0 ) * Fixed + Dst	
			a = vPARAM_DST;
			b = vPARAM_ZERO;
			c = vPARAM_FIXED;
			d = vPARAM_DST;
			break;
		case vBLEND_MODE_ADD_PREVIOUS_ALPHA:	// ( Src - 0 ) * Dst + Src
			a = vPARAM_SRC;
			b = vPARAM_ZERO;
			c = vPARAM_DST;
			d = vPARAM_SRC;
	}

	fixed_val = fixed;
	fixed_val <<= 32;

	equation = a | ( b << 2 ) | ( c << 4 ) | ( d << 6 ) | fixed_val;
*/
		
	return equation;
}




