#ifndef __IMAGE_QUANT_H__
#define __IMAGE_QUANT_H__

#include "imagedata.h"

/* caching weights at every node improves performance at expense of memory */
#define CACHEWEIGHTSx

/****************************************************************************
 Global Types
 */

typedef struct
{
	unsigned char	red;	
	unsigned char	green;
	unsigned char	blue;
	unsigned char	alpha;
} NxRgbaColor;

typedef struct
{
	unsigned char	red;	
	unsigned char	green;	
	unsigned char	blue;
} NxRgbColor;

typedef struct
{
	float	red;
	float	green;
	float	blue;
	float	alpha;
} NxColorReal;

typedef struct
{
	NxRgbaColor col0;	/* min value, inclusive */
	NxRgbaColor col1;	/* max value, exclusive */
} box;



#ifdef CACHEWEIGHTS
typedef struct OctNode OctNode;
#else
typedef union OctNode OctNode;
#endif

typedef struct LeafNode LeafNode;
struct LeafNode
{
	float weight;
	NxColorReal ac;
	float m2;
	unsigned char palIndex;
};

typedef struct BranchNode BranchNode;
struct BranchNode
{
	OctNode *dir[16];
};

#ifdef CACHEWEIGHTS
struct OctNode
#else
union OctNode
#endif
{
	LeafNode   Leaf;
	BranchNode Branch;
};

/* working data */
typedef struct
{
	box *Mcube;
	float *Mvv;
	OctNode *root;	
}  NxPalQuant;

/****************************************************************************
 Function prototypes
 */

//bool NxPalQuantInit(NxPalQuant *pq);
//void NxPalQuantTerm(NxPalQuant *pq);

//void NxPalQuantAddImage(NxPalQuant *pq, NxTexture *img, float weight);
//int NxPalQuantResolvePalette(unsigned char *palette, int maxcols, NxPalQuant *pq, int pbpp);
void NxQuantizeImage( ImageData* dst_image, ImageData* src_image, int max_colors );

//void NxPalQuantMatchImage(unsigned char *dstpixels, int dststride, int dstdepth, 
				     //NxPalQuant* pq, NxTexture* texture);

//bool NxPalettizeMips( NxTexture** mips, int levels );


#endif	// __IMAGE_QUANT_H__