// ADOBE SYSTEMS INCORPORATED
// Copyright  1993 - 2002 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this 
// file in accordance with the terms of the Adobe license agreement
// accompanying it.  If you have received this file from a source
// other than Adobe, then your use, modification, or distribution
// of it requires the prior written permission of Adobe.
//-------------------------------------------------------------------
/*
	File: WinFileUtils.h


	Header file for Windows file utilities.
*/

#ifndef __WinFileUtils_H__
#define __WinFileUtils_H__

#include "PITypes.h"
#include "PIUtilities.h"

/***************************************************************/

#if MSWindows
typedef	HFILE	FileHandle;
typedef Handle	AliasHandle;
typedef struct
	{	
	char fileName [256];
	} SFReply;

OSErr FSWrite(HFILE refNum, long *count, void *buffPtr);
#endif

#if Macintosh
#include <StandardFile.h>
#include <LowMem.h>
// On Macintosh systems, FileHandle is a typedef for RefNum
typedef short	FileHandle;
#endif

/***************************************************************/

Boolean PISetSaveDirectory (Handle alias, Str255 s, 
				   Boolean query,
				   short *rVRefNum);
				   
Boolean TestAndStoreResult (short *res, OSErr result);
#define TSR(x) TestAndStoreResult (&gResult, x)

Boolean TestAndStoreCancel (short *res, Boolean tocancel);
#define TSC(x) TestAndStoreCancel (&gResult, x)

Boolean PICreateFile (Str255 filename, 
					  short vRefNum,
					  const ResType creator,
					  const ResType type, 
					  FileHandle *fRefNum,
					  short *result);

Boolean PICloseFile (Str255 filename, 
					 short vRefNum,
					 FileHandle fRefNum, 
					 Boolean sameNames,
					 Boolean *dirty, 
					 AliasHandle *alias,
					 short *result);

void PICloseAndOpenWD(const short vRefNum, const long dirID, short *rVRefNum);

/***************************************************************/

#endif /* __WinFileUtils_H__ */
