#include "stdafx.h"
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <process.h>
#include <time.h>
#include <fstream.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "c:\skate4\code\gel\scripting\tokens.h"

typedef unsigned char uint8;
typedef unsigned int uint32;

using namespace Script;

struct SProfileItem
{
public:
	uint32	m_profileName;
	uint32	m_partChecksum;
	uint32	m_descChecksum;
	int		m_randomized;
};

SProfileItem	g_ProfileItemList[1024];
int				g_numProfileItems = 0;

void OutputProfileItems( iostream& outStream )
{
	for ( int i = 0; i < g_numProfileItems; i++ )
	{
		SProfileItem* pItem = &g_ProfileItemList[i];

		char msg[1024];

		sprintf( msg, "0x%08x 0x%08x 0x%08x %d",
			pItem->m_profileName, 
			pItem->m_partChecksum,
			pItem->m_descChecksum,
			pItem->m_randomized );

		outStream << msg << endl;
	}
}

SProfileItem* GetCurrentProfileItem()
{
	return &g_ProfileItemList[g_numProfileItems];
}

// This is so that skiptoken.cpp can be #included.
#define Dbg_MsgAssert( _c, _params )	Assert( _c, _params )

void Assert(int condition, char *pMessage, ...)
{
	char pad[128];
	
	if (condition) return;
	
	va_list args;
	
	va_start( args, pMessage );
	vsprintf( pad, pMessage, args);
	va_end( args );

	printf("ERROR: ");
	printf( pad );
	printf("\n");
	exit(1);
}

struct S4Bytes
{
    union
    {
        uint32 Checksum;
        int i;
        float f;
    };
};

#define MAXDIRBUFCHARS 256
char InFileName[MAXDIRBUFCHARS+1];
char OutFileName[MAXDIRBUFCHARS+1];
char RootDirName[MAXDIRBUFCHARS+1];

#define PLATFORM_PS2	0
#define PLATFORM_XBOX	1
#define PLATFORM_NGC	2
int g_platform = PLATFORM_PS2;

// Gets a 4 bytes from pLong, which may not be long word aligned.
static S4Bytes Get4Bytes(uint8 *pLong)
{
    S4Bytes FourBytes;
    FourBytes.i=(pLong[0])|(pLong[1]<<8)|(pLong[2]<<16)|(pLong[3]<<24);
    return FourBytes;
}

#include <c:/skate4/code/gel/scripting/skiptoken.cpp>

bool TestExistence(char *filename)
{
	struct stat testStatBuf;
	int returnCode;
	
	// see if DFF exists, and output its name if so
	returnCode = stat(filename, &testStatBuf);
	return (returnCode != -1);
}

uint32 g_currentProfileName = 0;
uint32 g_currentPartChecksum = 0;

// should be able to handle aliases as well

int main(int argc, char* argv[])
{
	if ( argc < 4 )
	{
		printf("\n");
		printf("PedProfileLister.exe, %s %s\n",__DATE__,__TIME__);
		printf("Parameter 1: full path name of input file of QB file, incl. extension\n");
		printf("Parameter 2: full path name of output file of TXT file, incl. extension\n");
		printf("Parameter 3: project root (for example, 'c:\\skate4')\n");
		printf("Parameter 4: (optional) -p<platform> where x = Xbox, g = Gamecube, p = PS2 (default)\n");
		exit(1);
	}

	Assert(( argc == 4 ) || ( argc == 5 ), "Too many arguments." );

	strcpy(InFileName, argv[1]);
	strcpy(OutFileName, argv[2]);
	strcpy(RootDirName, argv[3]);

	// Remove any trailing slash from the end of rootdirname
	if ( RootDirName[ strlen(RootDirName)-1 ] == '\\' || RootDirName[ strlen(RootDirName)-1 ] == '/' )
	{
		RootDirName[ strlen(RootDirName)-1 ] = 0;
	}

	// Handle optional platform param.
	if( argc == 5 )
	{
		if(( argv[4][0] == '-' ) && ( argv[4][1] == 'p' ))
		{
			if( argv[4][2] == 'x' )
			{
				g_platform = PLATFORM_XBOX;
				printf("Switching to Xbox platform\n");
			}
			else if( argv[4][2] == 'g' )
			{
				g_platform = PLATFORM_NGC;
				printf("Switching to Gamecube platform\n");
			}
		}
	}

	ifstream qb(InFileName, ios::in | ios::binary | ios::nocreate);
	if (!qb)
		Assert(0, "couldn't open file %s\n", InFileName);
	qb.seekg(0, ios::end);
	int qb_size = qb.tellg();
	qb.seekg(0, ios::beg);
	char *qbBuf = new char[qb_size];
	qb.read(qbBuf, qb_size);
	qb.close();

	fstream out(OutFileName, ios::app);
	if (!out.is_open())
		Assert(0, "couldn't open file %s\n", OutFileName);
	
	uint8 *pToken = (uint8 *) qbBuf;
	
	int arrayContext = 0;
	int structContext = 0;

	// Scan through the qb file. (iniskater.qb)
	while (*pToken!=ESCRIPTTOKEN_ENDOFFILE)
	{
		if (*pToken==ESCRIPTTOKEN_STARTSTRUCT )
		{
			if ( structContext == 0 )
			{
				g_currentProfileName = *(uint32*)(pToken-5);
			}
			else if ( structContext == 1 )
			{
				// initialize the struct
				SProfileItem* pItem = GetCurrentProfileItem();
				pItem->m_profileName = g_currentProfileName;
				pItem->m_partChecksum = *(uint32*)(pToken-5);
				pItem->m_descChecksum = 0;
				pItem->m_randomized = false;
			}

//			printf( "Found struct, level %d\n", structContext );
			structContext++;
		}
		else if (*pToken==ESCRIPTTOKEN_ENDSTRUCT )
		{
			structContext--;
//			printf( "End struct, level %d\n", structContext );
			if ( structContext == 1 )
			{
				g_numProfileItems++;
			}
		}
		else if (*pToken==ESCRIPTTOKEN_NAME)
		{
			if ( structContext == 2 )
			{
				SProfileItem* pItem = GetCurrentProfileItem();
				if ( *(uint32*)(pToken+1) == 0xd81c03b0 ) // randomized_desc_id
				{
					pItem->m_randomized = true;
				}
				else if ( *(uint32*)(pToken+1) == 0x4bb2084e ) // desc_id  
				{
					pItem->m_descChecksum= *(uint32*)(pToken+7);
				}
			}
		}
		else if (*pToken==ESCRIPTTOKEN_STRING )
		{
#if 0
			char *pName=(char *)(pToken+5);
			// pName is now a pointer to the file name

			char msg[512];
			strcpy( msg, pName );
			for ( uint32 i = 0; i < strlen(msg); i++ )
			{
				// convert to lower case
				if ( msg[i] >= 'A' && msg[i] <= 'Z' )
				{
					msg[i] = msg[i] - 'A' + 'a';
				}
			}
			
			char* pExt;
			if ( pExt = strstr( msg, ".skin" ) )
			{
				SCASItem* pItem = GetCurrentCASItem();
				pItem->m_partChecksum = g_currentArrayName;

//				printf( "Found SKIN: %s\n", msg );
				char filename1[512];

				if( g_platform == PLATFORM_NGC )
				{
					sprintf( filename1, "%s\\ndata\\%s", RootDirName, msg );
				}
				else
				{
					sprintf( filename1, "%s\\data\\%s", RootDirName, msg );
				}

				strcpy( pItem->m_skinFileName, filename1 );

				// replace SKN with TEX
				pExt[0] = '.';
				pExt[1] = 't';
				pExt[2] = 'e';
				pExt[3] = 'x';
				pExt[4] = 0;

				if( g_platform == PLATFORM_XBOX )
				{
					// TEX becomes TXX on Xbox.
					pExt[2] = 'x';
				}

//				printf( "Found TEX: %s\n", msg );
				if( g_platform == PLATFORM_NGC )
				{
					sprintf( filename1, "%s\\ndata\\%s", RootDirName, msg );
				}
				else
				{
					sprintf( filename1, "%s\\data\\%s", RootDirName, msg );
				}

				strcpy( pItem->m_texFileName, filename1 );
			}
#endif
		}
		pToken=SkipToken(pToken);
	}

	OutputProfileItems( out );

	out.close();

	return 0;
}